/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.packaging.mime.Header;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.InternetHeaders;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeBodyPart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimePartDataSource;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeUtility;
import com.sun.xml.internal.messaging.saaj.packaging.mime.util.ASCIIUtility;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.internal.messaging.saaj.util.FinalArrayList;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEPart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;

public class AttachmentPartImpl
extends AttachmentPart {
    protected static final Logger log = Logger.getLogger("com.sun.xml.internal.messaging.saaj.soap", "com.sun.xml.internal.messaging.saaj.soap.LocalStrings");
    private final MimeHeaders headers = new MimeHeaders();
    private MimeBodyPart rawContent = null;
    private DataHandler dataHandler = null;
    private MIMEPart mimePart = null;

    public AttachmentPartImpl() {
    }

    public AttachmentPartImpl(MIMEPart mIMEPart) {
        this.mimePart = mIMEPart;
        List<? extends com.sun.xml.internal.org.jvnet.mimepull.Header> list = mIMEPart.getAllHeaders();
        for (com.sun.xml.internal.org.jvnet.mimepull.Header header : list) {
            this.headers.addHeader(header.getName(), header.getValue());
        }
    }

    @Override
    public int getSize() throws SOAPException {
        if (this.mimePart != null) {
            try {
                return this.mimePart.read().available();
            }
            catch (IOException iOException) {
                return -1;
            }
        }
        if (this.rawContent == null && this.dataHandler == null) {
            return 0;
        }
        if (this.rawContent != null) {
            try {
                return this.rawContent.getSize();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0573.soap.attachment.getrawbytes.ioexception", new String[]{exception.getLocalizedMessage()});
                throw new SOAPExceptionImpl("Raw InputStream Error: " + exception);
            }
        }
        ByteOutputStream byteOutputStream = new ByteOutputStream();
        try {
            this.dataHandler.writeTo(byteOutputStream);
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "SAAJ0501.soap.data.handler.err", new String[]{iOException.getLocalizedMessage()});
            throw new SOAPExceptionImpl("Data handler error: " + iOException);
        }
        return byteOutputStream.size();
    }

    @Override
    public void clearContent() {
        if (this.mimePart != null) {
            this.mimePart.close();
            this.mimePart = null;
        }
        this.dataHandler = null;
        this.rawContent = null;
    }

    @Override
    public Object getContent() throws SOAPException {
        try {
            if (this.mimePart != null) {
                return this.mimePart.read();
            }
            if (this.dataHandler != null) {
                return this.getDataHandler().getContent();
            }
            if (this.rawContent != null) {
                return this.rawContent.getContent();
            }
            log.severe("SAAJ0572.soap.no.content.for.attachment");
            throw new SOAPExceptionImpl("No data handler/content associated with this attachment");
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "SAAJ0575.soap.attachment.getcontent.exception", exception);
            throw new SOAPExceptionImpl(exception.getLocalizedMessage());
        }
    }

    @Override
    public void setContent(Object object, String string) throws IllegalArgumentException {
        if (this.mimePart != null) {
            this.mimePart.close();
            this.mimePart = null;
        }
        DataHandler dataHandler = new DataHandler(object, string);
        this.setDataHandler(dataHandler);
    }

    @Override
    public DataHandler getDataHandler() throws SOAPException {
        if (this.mimePart != null) {
            return new DataHandler(new DataSource(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return AttachmentPartImpl.this.mimePart.read();
                }

                @Override
                public OutputStream getOutputStream() throws IOException {
                    throw new UnsupportedOperationException("getOutputStream cannot be supported : You have enabled LazyAttachments Option");
                }

                @Override
                public String getContentType() {
                    return AttachmentPartImpl.this.mimePart.getContentType();
                }

                @Override
                public String getName() {
                    return "MIMEPart Wrapper DataSource";
                }
            });
        }
        if (this.dataHandler == null) {
            if (this.rawContent != null) {
                return new DataHandler(new MimePartDataSource(this.rawContent));
            }
            log.severe("SAAJ0502.soap.no.handler.for.attachment");
            throw new SOAPExceptionImpl("No data handler associated with this attachment");
        }
        return this.dataHandler;
    }

    @Override
    public void setDataHandler(DataHandler dataHandler) throws IllegalArgumentException {
        if (this.mimePart != null) {
            this.mimePart.close();
            this.mimePart = null;
        }
        if (dataHandler == null) {
            log.severe("SAAJ0503.soap.no.null.to.dataHandler");
            throw new IllegalArgumentException("Null dataHandler argument to setDataHandler");
        }
        this.dataHandler = dataHandler;
        this.rawContent = null;
        log.log(Level.FINE, "SAAJ0580.soap.set.Content-Type", new String[]{dataHandler.getContentType()});
        this.setMimeHeader("Content-Type", dataHandler.getContentType());
    }

    @Override
    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    @Override
    public void removeMimeHeader(String string) {
        this.headers.removeHeader(string);
    }

    @Override
    public String[] getMimeHeader(String string) {
        return this.headers.getHeader(string);
    }

    @Override
    public void setMimeHeader(String string, String string2) {
        this.headers.setHeader(string, string2);
    }

    @Override
    public void addMimeHeader(String string, String string2) {
        this.headers.addHeader(string, string2);
    }

    @Override
    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    @Override
    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.headers.getMatchingHeaders(stringArray);
    }

    @Override
    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    boolean hasAllHeaders(MimeHeaders mimeHeaders) {
        if (mimeHeaders != null) {
            Iterator iterator = mimeHeaders.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                String[] stringArray = this.headers.getHeader(mimeHeader.getName());
                boolean bl = false;
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!mimeHeader.getValue().equalsIgnoreCase(stringArray[i])) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    MimeBodyPart getMimePart() throws SOAPException {
        try {
            if (this.mimePart != null) {
                return new MimeBodyPart(this.mimePart);
            }
            if (this.rawContent != null) {
                AttachmentPartImpl.copyMimeHeaders(this.headers, this.rawContent);
                return this.rawContent;
            }
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(this.dataHandler);
            AttachmentPartImpl.copyMimeHeaders(this.headers, mimeBodyPart);
            return mimeBodyPart;
        }
        catch (Exception exception) {
            log.severe("SAAJ0504.soap.cannot.externalize.attachment");
            throw new SOAPExceptionImpl("Unable to externalize attachment", exception);
        }
    }

    public static void copyMimeHeaders(MimeHeaders mimeHeaders, MimeBodyPart mimeBodyPart) throws SOAPException {
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            try {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                mimeBodyPart.setHeader(mimeHeader.getName(), mimeHeader.getValue());
            }
            catch (Exception exception) {
                log.severe("SAAJ0505.soap.cannot.copy.mime.hdr");
                throw new SOAPExceptionImpl("Unable to copy MIME header", exception);
            }
        }
    }

    public static void copyMimeHeaders(MimeBodyPart mimeBodyPart, AttachmentPartImpl attachmentPartImpl) throws SOAPException {
        try {
            FinalArrayList finalArrayList = mimeBodyPart.getAllHeaders();
            int n = finalArrayList.size();
            for (int i = 0; i < n; ++i) {
                Header header = (Header)finalArrayList.get(i);
                if (header.getName().equalsIgnoreCase("Content-Type")) continue;
                attachmentPartImpl.addMimeHeader(header.getName(), header.getValue());
            }
        }
        catch (Exception exception) {
            log.severe("SAAJ0506.soap.cannot.copy.mime.hdrs.into.attachment");
            throw new SOAPExceptionImpl("Unable to copy MIME headers into attachment", exception);
        }
    }

    @Override
    public void setBase64Content(InputStream inputStream, String string) throws SOAPException {
        if (this.mimePart != null) {
            this.mimePart.close();
            this.mimePart = null;
        }
        this.dataHandler = null;
        InputStream inputStream2 = null;
        try {
            inputStream2 = MimeUtility.decode(inputStream, "base64");
            InternetHeaders internetHeaders = new InternetHeaders();
            internetHeaders.setHeader("Content-Type", string);
            ByteOutputStream byteOutputStream = new ByteOutputStream();
            byteOutputStream.write(inputStream2);
            this.rawContent = new MimeBodyPart(internetHeaders, byteOutputStream.getBytes(), byteOutputStream.getCount());
            this.setMimeHeader("Content-Type", string);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "SAAJ0578.soap.attachment.setbase64content.exception", exception);
            throw new SOAPExceptionImpl(exception.getLocalizedMessage());
        }
        finally {
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {
                throw new SOAPException(iOException);
            }
        }
    }

    @Override
    public InputStream getBase64Content() throws SOAPException {
        InputStream inputStream;
        if (this.mimePart != null) {
            inputStream = this.mimePart.read();
        } else if (this.rawContent != null) {
            try {
                inputStream = this.rawContent.getInputStream();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0579.soap.attachment.getbase64content.exception", exception);
                throw new SOAPExceptionImpl(exception.getLocalizedMessage());
            }
        } else if (this.dataHandler != null) {
            try {
                inputStream = this.dataHandler.getInputStream();
            }
            catch (IOException iOException) {
                log.severe("SAAJ0574.soap.attachment.datahandler.ioexception");
                throw new SOAPExceptionImpl("DataHandler error" + iOException);
            }
        } else {
            log.severe("SAAJ0572.soap.no.content.for.attachment");
            throw new SOAPExceptionImpl("No data handler/content associated with this attachment");
        }
        int n = 1024;
        if (inputStream != null) {
            try {
                int n2;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
                OutputStream outputStream = MimeUtility.encode(byteArrayOutputStream, "base64");
                byte[] byArray = new byte[n];
                while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
                    outputStream.write(byArray, 0, n2);
                }
                outputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                return byteArrayInputStream;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0579.soap.attachment.getbase64content.exception", exception);
                throw new SOAPExceptionImpl(exception.getLocalizedMessage());
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        log.log(Level.SEVERE, "SAAJ0572.soap.no.content.for.attachment");
        throw new SOAPExceptionImpl("No data handler/content associated with this attachment");
    }

    @Override
    public void setRawContent(InputStream inputStream, String string) throws SOAPException {
        if (this.mimePart != null) {
            this.mimePart.close();
            this.mimePart = null;
        }
        this.dataHandler = null;
        try {
            InternetHeaders internetHeaders = new InternetHeaders();
            internetHeaders.setHeader("Content-Type", string);
            ByteOutputStream byteOutputStream = new ByteOutputStream();
            byteOutputStream.write(inputStream);
            this.rawContent = new MimeBodyPart(internetHeaders, byteOutputStream.getBytes(), byteOutputStream.getCount());
            this.setMimeHeader("Content-Type", string);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "SAAJ0576.soap.attachment.setrawcontent.exception", exception);
            throw new SOAPExceptionImpl(exception.getLocalizedMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new SOAPException(iOException);
            }
        }
    }

    @Override
    public void setRawContentBytes(byte[] byArray, int n, int n2, String string) throws SOAPException {
        if (this.mimePart != null) {
            this.mimePart.close();
            this.mimePart = null;
        }
        if (byArray == null) {
            throw new SOAPExceptionImpl("Null content passed to setRawContentBytes");
        }
        this.dataHandler = null;
        try {
            InternetHeaders internetHeaders = new InternetHeaders();
            internetHeaders.setHeader("Content-Type", string);
            this.rawContent = new MimeBodyPart(internetHeaders, byArray, n, n2);
            this.setMimeHeader("Content-Type", string);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "SAAJ0576.soap.attachment.setrawcontent.exception", exception);
            throw new SOAPExceptionImpl(exception.getLocalizedMessage());
        }
    }

    @Override
    public InputStream getRawContent() throws SOAPException {
        if (this.mimePart != null) {
            return this.mimePart.read();
        }
        if (this.rawContent != null) {
            try {
                return this.rawContent.getInputStream();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0577.soap.attachment.getrawcontent.exception", exception);
                throw new SOAPExceptionImpl(exception.getLocalizedMessage());
            }
        }
        if (this.dataHandler != null) {
            try {
                return this.dataHandler.getInputStream();
            }
            catch (IOException iOException) {
                log.severe("SAAJ0574.soap.attachment.datahandler.ioexception");
                throw new SOAPExceptionImpl("DataHandler error" + iOException);
            }
        }
        log.severe("SAAJ0572.soap.no.content.for.attachment");
        throw new SOAPExceptionImpl("No data handler/content associated with this attachment");
    }

    @Override
    public byte[] getRawContentBytes() throws SOAPException {
        if (this.mimePart != null) {
            try {
                InputStream inputStream = this.mimePart.read();
                return ASCIIUtility.getBytes(inputStream);
            }
            catch (IOException iOException) {
                log.log(Level.SEVERE, "SAAJ0577.soap.attachment.getrawcontent.exception", iOException);
                throw new SOAPExceptionImpl(iOException);
            }
        }
        if (this.rawContent != null) {
            try {
                InputStream inputStream = this.rawContent.getInputStream();
                return ASCIIUtility.getBytes(inputStream);
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0577.soap.attachment.getrawcontent.exception", exception);
                throw new SOAPExceptionImpl(exception);
            }
        }
        if (this.dataHandler != null) {
            try {
                InputStream inputStream = this.dataHandler.getInputStream();
                return ASCIIUtility.getBytes(inputStream);
            }
            catch (IOException iOException) {
                log.severe("SAAJ0574.soap.attachment.datahandler.ioexception");
                throw new SOAPExceptionImpl("DataHandler error" + iOException);
            }
        }
        log.severe("SAAJ0572.soap.no.content.for.attachment");
        throw new SOAPExceptionImpl("No data handler/content associated with this attachment");
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    static {
        try {
            CommandMap commandMap = CommandMap.getDefaultCommandMap();
            if (!(commandMap instanceof MailcapCommandMap)) {
                throw new SOAPExceptionImpl("Default CommandMap is not a MailcapCommandMap");
            }
            MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)commandMap;
            String string = ";;x-java-content-handler=";
            mailcapCommandMap.addMailcap("text/xml" + string + "com.sun.xml.internal.messaging.saaj.soap.XmlDataContentHandler");
            mailcapCommandMap.addMailcap("application/xml" + string + "com.sun.xml.internal.messaging.saaj.soap.XmlDataContentHandler");
            mailcapCommandMap.addMailcap("application/fastinfoset" + string + "com.sun.xml.internal.messaging.saaj.soap.FastInfosetDataContentHandler");
            mailcapCommandMap.addMailcap("image/*" + string + "com.sun.xml.internal.messaging.saaj.soap.ImageDataContentHandler");
            mailcapCommandMap.addMailcap("text/plain" + string + "com.sun.xml.internal.messaging.saaj.soap.StringDataContentHandler");
        }
        catch (Throwable throwable) {
            log.log(Level.SEVERE, "SAAJ0508.soap.cannot.register.handlers", throwable);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable.getLocalizedMessage());
        }
    }
}

