/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.attr.Target;
import iaik.x509.attr.TargetException;
import iaik.x509.attr.Targets;
import java.util.Enumeration;
import java.util.Vector;

public class TargetInformation
extends V3Extension {
    private Vector a = new Vector();
    public static final ObjectID oid = new ObjectID("2.5.29.55", "TargetInformation");

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.isEmpty()) {
            stringBuffer.append("This TargetInformation does not contain any Targets.");
        } else {
            int n2 = this.a.size();
            if (bl) {
                stringBuffer.append("Target list contains " + n2 + " Targets object(s):\n");
                int n3 = 1;
                Enumeration enumeration = this.a.elements();
                while (enumeration.hasMoreElements()) {
                    if (n3 > 1) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append("Targets " + n3++ + ":\n");
                    Util.printIndented(((Targets)enumeration.nextElement()).toString(true), true, stringBuffer);
                }
            } else {
                stringBuffer.append("Target list contains " + n2 + " Targets object(s).");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        Enumeration enumeration = this.a.elements();
        try {
            while (enumeration.hasMoreElements()) {
                sEQUENCE.addComponent(((Targets)enumeration.nextElement()).toASN1Object());
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException("Cannot create ASN.1 Targets: " + codingException.getMessage());
        }
        return sEQUENCE;
    }

    public void setTargets(Targets[] targetsArray) {
        this.a.removeAllElements();
        if (targetsArray != null) {
            int n2 = 0;
            while (n2 < targetsArray.length) {
                this.a.addElement(targetsArray[n2]);
                ++n2;
            }
        }
    }

    public void setTargetElements(Target[] targetArray) {
        this.a.removeAllElements();
        if (targetArray != null) {
            Targets targets = new Targets();
            targets.setTargets(targetArray);
            this.a.addElement(targets);
        }
    }

    public boolean removeTargets(Targets targets) {
        return this.a.removeElement(targets);
    }

    public boolean removeTargetElement(Target target) {
        boolean bl = false;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Targets targets = (Targets)enumeration.nextElement();
            if (!targets.removeTarget(target)) continue;
            bl = true;
            if (targets.size() != 0) continue;
            this.a.removeElement(targets);
        }
        return bl;
    }

    public void removeAllTargets() {
        this.a.removeAllElements();
    }

    public int numberOfTargets() {
        return this.a.size();
    }

    public int numberOfTargetElements() {
        return this.getTargetElements().length;
    }

    public boolean isTargetFor(Object object) throws TargetException {
        boolean bl = false;
        Target[] targetArray = this.getTargetElements();
        if (targetArray.length == 0) {
            bl = true;
        } else {
            TargetException targetException = null;
            int n2 = 0;
            while (n2 < targetArray.length) {
                try {
                    if (targetArray[n2].isTargetFor(object)) {
                        bl = true;
                        break;
                    }
                }
                catch (TargetException targetException2) {
                    targetException = targetException2;
                }
                ++n2;
            }
            if (!bl && targetException != null) {
                throw targetException;
            }
        }
        return bl;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new X509ExtensionException("Invalid ASN.1 type (" + aSN1Object.getAsnType().getName() + ") of TargetInformation extension; must be a SEQUENCE!");
        }
        this.a.removeAllElements();
        try {
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                this.a.addElement(new Targets(aSN1Object.getComponentAt(n2)));
                ++n2;
            }
            return;
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException("Error parsing Targets object: " + codingException.getMessage());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public Targets[] getTargets() {
        Object[] objectArray = new Targets[this.a.size()];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public Target[] getTargetElements() {
        Object object;
        Vector<Target> vector = new Vector<Target>();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            object = (Targets)enumeration.nextElement();
            Target[] targetArray = ((Targets)object).getTargets();
            int n2 = 0;
            while (n2 < targetArray.length) {
                vector.addElement(targetArray[n2]);
                ++n2;
            }
        }
        object = new Target[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public boolean containsTargetElement(Target target) {
        boolean bl = false;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Targets targets = (Targets)enumeration.nextElement();
            if (!targets.containsTarget(target)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean addTargetElement(Target target) {
        boolean bl = false;
        if (target != null && !this.containsTargetElement(target)) {
            Targets targets;
            if (this.a.isEmpty()) {
                targets = new Targets();
                this.a.addElement(targets);
            } else {
                targets = (Targets)this.a.elementAt(0);
            }
            bl = targets.addTarget(target);
        }
        return bl;
    }
}

