/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;

public class GCMParameterSpec
implements AlgorithmParameterSpec {
    private byte[] c;
    private int b;
    private byte[] a;
    private byte[] d;

    public void setMacLength(int n2) throws InvalidAlgorithmParameterException {
        if ((n2 < 12 || n2 > 16) && n2 != 4 && n2 != 8) {
            throw new InvalidAlgorithmParameterException("Invalid MAC length - valid length values: 4,8,12,13,14,15,16 bytes!");
        }
        this.b = n2;
    }

    public byte[] getNonce() {
        return this.a;
    }

    public int getMacLength() {
        return this.b;
    }

    public byte[] getMac() {
        return this.c;
    }

    public byte[] getAAD() {
        return this.d;
    }

    private GCMParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) throws InvalidAlgorithmParameterException {
        this.d = byArray;
        this.a = byArray2;
        this.c = byArray3;
        this.b = n2;
        if ((this.c == null || this.c.length == 0) && this.b == -1) {
            this.b = 12;
            return;
        }
        if (this.b == -1) {
            this.b = this.c.length;
        }
        if ((this.b < 12 || this.b > 16) && this.b != 4 && this.b != 8) {
            throw new InvalidAlgorithmParameterException("Invalid MAC length - valid length values: 4,8,12,13,14,15,16 bytes!");
        }
    }

    public GCMParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3) throws InvalidAlgorithmParameterException {
        this(byArray, byArray2, byArray3, -1);
    }

    public GCMParameterSpec(byte[] byArray, byte[] byArray2, int n2) throws InvalidAlgorithmParameterException {
        this(byArray, byArray2, null, n2);
    }

    public GCMParameterSpec(byte[] byArray, byte[] byArray2) throws InvalidAlgorithmParameterException {
        this(byArray, byArray2, null, -1);
    }

    public GCMParameterSpec() throws InvalidAlgorithmParameterException {
        this(null, null, null, -1);
    }
}

