/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.security.random.SecRandom;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class CCMParameterSpec
implements AlgorithmParameterSpec {
    private long c;
    private int b;
    private byte[] a;
    private byte[] d;

    public void setMacLength(int n2) throws InvalidAlgorithmParameterException {
        this.b = n2;
        if (n2 < 4 || n2 > 16) {
            throw new InvalidAlgorithmParameterException("Specified MAC-length not between 4 and 16 bytes!");
        }
    }

    public void setInputLength(long l2) throws InvalidAlgorithmParameterException {
        this.c = l2;
        if (l2 < 0L) {
            throw new InvalidAlgorithmParameterException("invalid value for inputLength");
        }
        long l3 = (long)(Math.pow(2.0, 8 * (15 - this.a.length)) - 1.0);
        if (l2 - (long)this.b > l3) {
            throw new InvalidAlgorithmParameterException("parameter inputLength or nonce too long");
        }
    }

    public byte[] getNonce() {
        return this.a;
    }

    public int getMacLength() {
        return this.b;
    }

    public long getInputLength() {
        return this.c;
    }

    public byte[] getAssociatedData() {
        return this.d;
    }

    public CCMParameterSpec(byte[] byArray, byte[] byArray2, int n2) throws Exception {
        this(-1L, byArray, byArray2, n2);
    }

    public CCMParameterSpec(long l2, byte[] byArray, byte[] byArray2, int n2) throws InvalidAlgorithmParameterException {
        this.d = byArray;
        this.a = byArray2;
        this.b = n2;
        this.c = l2;
        if (this.a == null || this.a.length == 0) {
            this.a = this.c > -1L ? (this.c < Integer.MAX_VALUE ? new byte[11] : new byte[7]) : new byte[7];
            SecureRandom secureRandom = SecRandom.getDefault();
            secureRandom.nextBytes(this.a);
        } else if (this.a.length < 7 || this.a.length > 13) {
            throw new InvalidAlgorithmParameterException("nonce length not between 7 and 13 bytes!");
        }
        if (this.c != -1L) {
            if (this.c < -1L) {
                throw new InvalidAlgorithmParameterException("invalid value for inputLength");
            }
            long l3 = (long)(Math.pow(2.0, 8 * (15 - this.a.length)) - 1.0);
            if (this.c - (long)this.b > l3) {
                throw new InvalidAlgorithmParameterException("parameter inputLength or nonce too long");
            }
        }
        if (this.b == -1) {
            this.b = 12;
            return;
        }
        if (this.b < 4 || this.b > 16) {
            throw new InvalidAlgorithmParameterException("Specified MAC-length not between 4 and 16 bytes!");
        }
    }

    public CCMParameterSpec(long l2, byte[] byArray, byte[] byArray2) throws Exception {
        this(l2, byArray, byArray2, -1);
    }

    public CCMParameterSpec() throws Exception {
        this(-1L, null, null, -1);
    }
}

