/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.EncryptedContentInfo;
import iaik.pkcs.pkcs7.EncryptedDataStream;
import iaik.utils.InternalErrorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class EncryptedData
extends EncryptedDataStream
implements Content {
    static /* synthetic */ Class b;
    private EncryptedContentInfo a;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        stringBuffer.append("EncryptedContentInfo:\n");
        stringBuffer.append(this.a.toString());
        return stringBuffer.toString();
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        this.a.setBlockSize(n2);
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        sEQUENCE.addComponent(new INTEGER(this.version));
        sEQUENCE.addComponent(this.a.toASN1Object());
        return sEQUENCE;
    }

    public void setupCipher(char[] cArray) throws InvalidKeyException, InvalidParameterSpecException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        AlgorithmID algorithmID = this.a.getContentEncryptionAlgorithm();
        AlgorithmParameters algorithmParameters = algorithmID.getAlgorithmParameters("PBE");
        Object t2 = algorithmParameters.getParameterSpec(b != null ? b : (b = EncryptedData.a("javax.crypto.spec.PBEParameterSpec")));
        Key key = this.a(cArray, this.a.getContentEncryptionAlgorithm());
        this.a.setupCipher(key, (AlgorithmParameterSpec)t2);
    }

    public void setupCipher(AlgorithmID algorithmID, char[] cArray, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            AlgorithmParameterSpec algorithmParameterSpec = this.a(algorithmID, n2);
            Key key = this.a(cArray, algorithmID);
            this.a.setupCipher(algorithmID, key, algorithmParameterSpec);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalErrorException(invalidAlgorithmParameterException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InternalErrorException(invalidParameterSpecException);
        }
    }

    public InputStream getInputStream() {
        return this.a.getInputStream();
    }

    public Object getEncryptedContentInfo() {
        return this.a;
    }

    public byte[] getEncoded() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    public byte[] getContent() {
        return this.a.getContent();
    }

    public void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = ((DerInputStream)inputStream).readSequence();
        this.version = derInputStream.readInteger().intValue();
        this.a = new EncryptedContentInfo();
        this.a.decode(derInputStream);
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode(aSN1Object)));
            return;
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public EncryptedData(byte[] byArray) {
        this();
        this.a = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
    }

    public EncryptedData(InputStream inputStream) throws PKCSParsingException, IOException {
        this();
        this.decode(inputStream);
    }

    public EncryptedData(EncryptedContentInfo encryptedContentInfo) {
        this();
        this.a = encryptedContentInfo;
    }

    public EncryptedData(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
    }

    protected EncryptedData() {
        this.block_size = -1;
    }
}

