/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs10;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs10.CertRequest;
import iaik.utils.Util;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Vector;

public class CertificateRequest
implements CertRequest,
Serializable {
    static /* synthetic */ Class h;
    private byte[] g;
    private boolean f;
    private Attribute[] j;
    private byte[] d;
    private AlgorithmID c;
    private PublicKey e;
    private Name b;
    private int a;
    private ASN1 i;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.a();
        this.i.writeTo(outputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.toByteArray());
    }

    public boolean verify(String string) throws SignatureException {
        this.a();
        try {
            Signature signature = this.c.getSignatureInstance(string);
            byte[] byArray = this.i.getFirstObject();
            signature.initVerify(this.e);
            signature.update(byArray);
            return signature.verify(this.d);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.getMessage());
        }
    }

    public boolean verify() throws SignatureException {
        return this.verify(null);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        if (this.b != null) {
            stringBuffer.append("Subject: " + this.b + "\n");
        }
        if (this.e != null) {
            stringBuffer.append(this.e.toString());
        }
        if (this.c != null) {
            stringBuffer.append("Signature algorithm: " + this.c + "\n");
        }
        stringBuffer.append("\n");
        if (this.j != null && this.j.length > 0) {
            if (bl) {
                int n2 = 0;
                while (n2 < this.j.length) {
                    stringBuffer.append("Attribute " + (n2 + 1) + ": ");
                    stringBuffer.append(this.j[n2]);
                    stringBuffer.append("\n");
                    ++n2;
                }
            } else {
                stringBuffer.append("Attributes: yes\n");
            }
        }
        stringBuffer.append("Fingerprint (MD5)  : " + Util.toString(this.getFingerprint()) + "\n");
        stringBuffer.append("Fingerprint (SHA-1): " + Util.toString(this.getFingerprintSHA()) + "\n");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] toByteArray() {
        this.a();
        return this.i.toByteArray();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Object object;
        if (privateKey == null) {
            throw new SignatureException("Cannot sign this request. No algorithm specified!");
        }
        if (algorithmID == null) {
            throw new InvalidKeyException("Cannot sign this request. No private key specified!");
        }
        this.c = algorithmID;
        Signature signature = this.c.getSignatureInstance(string);
        signature.initSign(privateKey);
        try {
            if (!AlgorithmID.getDoNotIncludeParameters(this.c) && !this.c.hasParameters() && (object = signature.getParameter("")) != null && object instanceof AlgorithmParameters) {
                this.c.setAlgorithmParameters((AlgorithmParameters)object);
            }
        }
        catch (Exception exception) {}
        try {
            object = this.b();
            signature.update(DerCoder.encode((ASN1Object)object));
            this.d = signature.sign();
            BIT_STRING bIT_STRING = new BIT_STRING(this.d);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)object);
            sEQUENCE.addComponent(this.c.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.i = new ASN1(sEQUENCE);
            this.d();
            this.e();
            return;
        }
        catch (CodingException codingException) {
            throw new SignatureException("Cann't sign CertRequest!");
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.sign(algorithmID, privateKey, null);
    }

    private void e() {
        this.f = false;
    }

    public void setSignature(AlgorithmID algorithmID, byte[] byArray) throws SignatureException {
        if (algorithmID == null) {
            throw new SignatureException("Cannot sign this request. No signature algorithm specified!");
        }
        if (byArray == null) {
            throw new SignatureException("Cannot sign this request. No signature value specified!");
        }
        this.c = algorithmID;
        this.d = byArray;
        try {
            ASN1Object aSN1Object = this.b();
            BIT_STRING bIT_STRING = new BIT_STRING(this.d);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.c.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.i = new ASN1(sEQUENCE);
            this.d();
            this.e();
            return;
        }
        catch (CodingException codingException) {
            throw new SignatureException("Cann't sign CertRequest!");
        }
    }

    private void d() {
        this.f = true;
        this.g = null;
    }

    public void setAttributes(Attribute[] attributeArray) {
        this.j = attributeArray;
        this.d();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        try {
            this.i = new ASN1(objectInputStream);
            this.c();
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to restore CertificateRequest: " + codingException.toString());
        }
        catch (PKCSParsingException pKCSParsingException) {
            throw new IOException("Unable to restore CertificateRequest: " + pKCSParsingException.toString());
        }
    }

    public int getVersion() {
        return this.a;
    }

    public Name getSubject() {
        return this.b;
    }

    public AlgorithmID getSignatureAlgorithmID() {
        return this.c;
    }

    public PublicKey getPublicKey() {
        return this.e;
    }

    public byte[] getFingerprintSHA() {
        if (this.g == null) {
            try {
                this.g = this.getFingerprint("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Algorithm SHA not available: " + noSuchAlgorithmException.toString());
            }
        }
        return this.g;
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        this.a();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(this.i.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprint() {
        this.a();
        return this.i.fingerprint();
    }

    public byte[] getCertificateRequestInfo() throws PKCSException {
        try {
            if (this.i != null && this.i.toByteArray() != null) {
                return this.i.getFirstObject();
            }
            return DerCoder.encode(this.b());
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
    }

    public Attribute[] getAttributes(ObjectID objectID) {
        Object[] objectArray;
        if (this.j == null) {
            return null;
        }
        Vector<Attribute> vector = new Vector<Attribute>();
        int n2 = 0;
        while (n2 < this.j.length) {
            objectArray = this.j[n2];
            if (objectArray.getType().equals(objectID)) {
                vector.addElement(this.j[n2]);
            }
            ++n2;
        }
        if (vector.isEmpty()) {
            return null;
        }
        objectArray = new Attribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Attribute[] getAttributes() {
        return this.j;
    }

    public AttributeValue getAttributeValue(ObjectID objectID) throws PKCSException {
        Attribute attribute = this.getAttribute(objectID);
        if (attribute != null) {
            try {
                return attribute.getAttributeValue();
            }
            catch (CodingException codingException) {
                throw new PKCSException("Cannot decode attribute " + objectID.getName() + ": " + codingException.getMessage());
            }
        }
        return null;
    }

    public Attribute getAttribute(ObjectID objectID) {
        if (this.j == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.j.length) {
            if (this.j[n2].getType().equals(objectID)) {
                return this.j[n2];
            }
            ++n2;
        }
        return null;
    }

    private void c() throws PKCSParsingException {
        try {
            ASN1Object aSN1Object = this.i.getComponentAt(0);
            this.c = new AlgorithmID(this.i.getComponentAt(1));
            ASN1Object aSN1Object2 = this.i.getComponentAt(2);
            this.d = (byte[])((BIT_STRING)aSN1Object2).getValue();
            this.a = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
            this.b = new Name(aSN1Object.getComponentAt(1));
            try {
                this.e = PublicKeyInfo.getPublicKey(aSN1Object.getComponentAt(2));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PKCSParsingException("Unable to create PublicKey: " + invalidKeyException.toString());
            }
            if (aSN1Object.countComponents() > 3) {
                ASN1Object aSN1Object3 = aSN1Object.getComponentAt(3);
                ((CON_SPEC)aSN1Object3).forceImplicitlyTagged(ASN.SEQUENCE);
                if (aSN1Object3.getAsnType().getTag() == 0) {
                    this.j = (Attribute[])ASN.parseSequenceOf((ASN1Object)aSN1Object3.getValue(), h != null ? h : (h = CertificateRequest.a("iaik.asn1.structures.Attribute")));
                } else {
                    throw new PKCSParsingException("Unknown context specific tag: " + aSN1Object3.getAsnType().getTag());
                }
            }
            this.i.clearASN1Object();
            this.e();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new PKCSParsingException("Certificate request format error: " + runtimeException.toString());
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.toString());
        }
    }

    private ASN1Object b() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(this.a));
        sEQUENCE.addComponent(this.b.toASN1Object());
        sEQUENCE.addComponent(DerCoder.decode(this.e.getEncoded()));
        if (this.j != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, ASN.createSetOf(this.j), true));
        } else {
            sEQUENCE.addComponent(new CON_SPEC(0, new SET(), true));
        }
        return sEQUENCE;
    }

    private void a() {
        if (this.f) {
            throw new RuntimeException("Cannot perform operation, certificate has to be signed first");
        }
    }

    public void addAttribute(Attribute attribute) {
        if (this.j == null) {
            this.j = new Attribute[]{attribute};
            return;
        }
        Attribute[] attributeArray = new Attribute[this.j.length + 1];
        System.arraycopy(this.j, 0, attributeArray, 0, this.j.length);
        attributeArray[this.j.length] = attribute;
        this.j = attributeArray;
        this.d();
    }

    public CertificateRequest(byte[] byArray) throws PKCSParsingException {
        try {
            this.i = new ASN1(byArray);
            this.c();
            return;
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.toString());
        }
    }

    public CertificateRequest(PublicKey publicKey, Name name) throws InvalidKeyException {
        this.e = publicKey;
        this.b = name;
        this.d();
        this.a = 0;
    }

    public CertificateRequest(InputStream inputStream) throws PKCSParsingException, IOException {
        try {
            this.i = new ASN1(inputStream);
            this.c();
            return;
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.toString());
        }
    }
}

