/*
 * Decompiled with CFR 0.152.
 */
package iaik.iso.iso9796;

import iaik.asn1.structures.AlgorithmID;
import iaik.iso.iso9796.ISO9796P2S2S3ParameterSpec;
import iaik.iso.iso9796.ISO9796P2Signature;
import iaik.iso.iso9796.RawISO9796P2S2S3ParameterSpec;
import iaik.pkcs.pkcs1.MGF1;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public abstract class ISO9796P2S2S3Signature
extends ISO9796P2Signature {
    private int c;
    byte[] a;
    int b;
    protected MaskGenerationAlgorithm mgfEngine_;

    protected void reset(BigInteger bigInteger) {
        super.reset(bigInteger);
        if (this.mgfEngine_ != null) {
            this.mgfEngine_.reset();
        }
    }

    int a() {
        return ISO9796P2S2S3Signature.calculateCapacity(this.g, this.j * 8, this.b * 8, this.k) - this.c;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        int n2;
        Object object;
        ((ISO9796P2Signature)this).b = null;
        if (this.mgfEngine_ == null) {
            throw new NullPointerException("Cannot verify signature. MGF engine must not be null!");
        }
        if (this.g == 0) {
            throw new IllegalStateException("Length of public parameter not set");
        }
        byte[] byArray2 = this.a(byArray);
        if (byArray2.length * 8 != this.g && (byArray2[0] & 0x80) != 0) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid signature. Sr not k-1 bits long.");
        }
        int n3 = byArray2.length - 1;
        int n4 = 1;
        if (byArray2[n3] == -52) {
            if (byArray2[--n3] != this.h) {
                object = this.a(byArray2[n4]);
                if (object == null) {
                    CryptoUtils.zeroBlock(byArray2);
                    throw new SignatureException("Invalid hash id. Expected " + Util.toString(this.h));
                }
                this.hashEngine_ = object;
            }
            n4 = 2;
        } else if (byArray2[n3] != -68) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid trailer byte. Expected 0xBC or 0xCC.");
        }
        if (this.hashEngine_ == null) {
            CryptoUtils.zeroBlock(byArray2);
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (((ISO9796P2Signature)this).c != null) {
            object = ((ISO9796P2Signature)this).c.digest();
            this.hashEngine_.reset();
        } else {
            object = this.hashEngine_.digest();
        }
        int n5 = ((Object)object).length;
        if ((n3 -= n5) <= this.b + 2) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid formatted signature string!");
        }
        this.mgfEngine_.mask(byArray2, n3, n5, n3, byArray2, 0);
        byArray2[0] = (byte)(byArray2[0] & 0x7F);
        int n6 = 0;
        while (n6 < n3 && byArray2[n6] == 0) {
            ++n6;
        }
        if (n6 == n3) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid padding!");
        }
        if (byArray2[n6] != 1) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid border byte. Expected 0x01!");
        }
        int n7 = n3 - this.b;
        if ((n2 = n7 - ++n6) < 0) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid padding!");
        }
        if (this.r != null && !CryptoUtils.equalsBlock(byArray2, n6, this.r, 0, n2)) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid message recovery.");
        }
        ((ISO9796P2Signature)this).b = new byte[n2];
        System.arraycopy(byArray2, n6, ((ISO9796P2Signature)this).b, 0, n2);
        byte[] byArray3 = new byte[8];
        CryptoUtils.spreadIntsToBytes(new int[]{n2 * 8}, 0, byArray3, 4, 1);
        this.hashEngine_.update(byArray3);
        if (n2 > 0) {
            this.hashEngine_.update(((ISO9796P2Signature)this).b);
        }
        this.hashEngine_.update((byte[])object);
        if (this.b > 0) {
            this.hashEngine_.update(byArray2, n7, this.b);
        }
        byte[] byArray4 = this.hashEngine_.digest();
        boolean bl = CryptoUtils.equalsBlock(byArray2, n3, byArray4, 0, n5);
        CryptoUtils.zeroBlock(byArray2);
        if (!bl) {
            CryptoUtils.zeroBlock(((ISO9796P2Signature)this).b);
            ((ISO9796P2Signature)this).b = null;
        }
        this.reset(null);
        return bl;
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        ((ISO9796P2Signature)this).b = null;
        if (this.hashEngine_ == null && ((ISO9796P2Signature)this).c == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.r == null) {
            this.b();
        }
        if (((ISO9796P2Signature)this).c == null) {
            if (this.s < this.r.length) {
                int n4 = Math.min(this.r.length - this.s, n3);
                System.arraycopy(byArray, n2, this.r, this.s, n4);
                this.s += n4;
                int n5 = n3 - n4;
                if (n5 > 0) {
                    this.hashEngine_.update(byArray, n2 + n4, n5);
                }
            } else {
                this.hashEngine_.update(byArray, n2, n3);
            }
            this.d += n3;
            return;
        }
        ((ISO9796P2Signature)this).c.update(byArray, n2, n3);
    }

    protected void engineUpdate(byte by) {
        ((ISO9796P2Signature)this).b = null;
        if (this.hashEngine_ == null && ((ISO9796P2Signature)this).c == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.r == null) {
            this.b();
        }
        if (((ISO9796P2Signature)this).c != null) {
            ((ISO9796P2Signature)this).c.update(by);
            return;
        }
        ++this.d;
        if (this.s < this.r.length) {
            this.r[this.s++] = by;
            return;
        }
        this.hashEngine_.update(by);
    }

    protected byte[] engineSign() throws SignatureException {
        Object object;
        if (this.hashEngine_ == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.mgfEngine_ == null) {
            throw new NullPointerException("MGF engine must not be null!");
        }
        if (this.r == null) {
            this.b();
        }
        ((ISO9796P2Signature)this).b = null;
        byte[] byArray = new byte[8];
        CryptoUtils.spreadIntsToBytes(new int[]{this.s * 8}, 0, byArray, 4, 1);
        byte[] byArray2 = this.a;
        if (byArray2 == null && this.b > 0) {
            byArray2 = new byte[this.b];
            object = this.getSecureRandom();
            ((SecureRandom)object).nextBytes(byArray2);
        }
        if (((ISO9796P2Signature)this).c != null) {
            object = ((ISO9796P2Signature)this).c.digest();
            this.hashEngine_.reset();
        } else {
            object = this.hashEngine_.digest();
        }
        this.hashEngine_.update(byArray);
        if (this.s > 0) {
            this.hashEngine_.update(this.r, 0, this.s);
        }
        this.hashEngine_.update((byte[])object);
        byte[] byArray3 = this.b > 0 ? this.hashEngine_.digest(byArray2) : this.hashEngine_.digest();
        int n2 = byArray3.length;
        int n3 = (this.g + 7) / 8;
        byte[] byArray4 = new byte[n3];
        int n4 = n3 - 1;
        int n5 = 1;
        if (this.k) {
            byArray4[n4] = -52;
            byArray4[--n4] = this.h;
            n5 = 2;
        } else {
            byArray4[n4] = -68;
        }
        if (n3 < 1 + this.s + this.b + n2 + n5) {
            CryptoUtils.zeroBlock(byArray3);
            CryptoUtils.zeroBlock(byArray4);
            throw new SignatureException("Modulus too short!");
        }
        System.arraycopy(byArray3, 0, byArray4, n4 -= n2, n2);
        if (this.b > 0) {
            System.arraycopy(byArray2, 0, byArray4, n4 -= byArray2.length, this.b);
        }
        System.arraycopy(this.r, 0, byArray4, n4 -= this.s, this.s);
        byArray4[--n4] = 1;
        this.mgfEngine_.mask(byArray3, 0, n2, byArray4.length - n2 - n5, byArray4, 0);
        CryptoUtils.zeroBlock(byArray3);
        byArray4[0] = (byte)(byArray4[0] & 0x7F);
        byte[] byArray5 = this.b(byArray4);
        this.reset(null);
        CryptoUtils.zeroBlock(byArray4);
        return byArray5;
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        byte[] byArray;
        if (!(algorithmParameterSpec instanceof ISO9796P2S2S3ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Parameters must be a ISO9796P2S2S3ParameterSpec!");
        }
        super.engineSetParameter(algorithmParameterSpec);
        ISO9796P2S2S3ParameterSpec iSO9796P2S2S3ParameterSpec = (ISO9796P2S2S3ParameterSpec)algorithmParameterSpec;
        MaskGenerationAlgorithm maskGenerationAlgorithm = iSO9796P2S2S3ParameterSpec.getMGFEngine();
        if (maskGenerationAlgorithm != null) {
            if (this.l && !this.mgfEngine_.getAlgorithm().equalsIgnoreCase(maskGenerationAlgorithm.getAlgorithm())) {
                throw new InvalidAlgorithmParameterException("Invalid mgf engine parameter (" + maskGenerationAlgorithm.getAlgorithm() + "). Expected " + this.mgfEngine_.getAlgorithm() + ".");
            }
            this.mgfEngine_ = maskGenerationAlgorithm;
        }
        if ((byArray = iSO9796P2S2S3ParameterSpec.getSalt()) != null) {
            this.b = byArray.length;
        } else {
            int n2 = iSO9796P2S2S3ParameterSpec.getSaltLength();
            if (n2 > -1) {
                this.b = n2;
            }
        }
        this.a = byArray;
        this.c = iSO9796P2S2S3ParameterSpec.getCMinus();
        if (algorithmParameterSpec instanceof RawISO9796P2S2S3ParameterSpec) {
            RawISO9796P2S2S3ParameterSpec rawISO9796P2S2S3ParameterSpec = (RawISO9796P2S2S3ParameterSpec)algorithmParameterSpec;
            this.a(rawISO9796P2S2S3ParameterSpec.getMr(), rawISO9796P2S2S3ParameterSpec.getMsgLen(), rawISO9796P2S2S3ParameterSpec.a());
        }
    }

    public static int calculateCapacity(int n2, int n3, boolean bl) {
        throw new IllegalStateException("Method not supported. Use calculateCapacity(modLen, hashLen, saltLen, explicit)!");
    }

    public static int calculateCapacity(int n2, int n3, int n4, boolean bl) {
        int n5 = n2 - n3 - n4 - (bl ? 16 : 8) - 2;
        if (n5 < 7) {
            throw new IllegalArgumentException("Invalid capacity (" + n5 + "). Must be >= 7!");
        }
        return n5;
    }

    protected ISO9796P2S2S3Signature(String string, int n2, byte by) {
        super(string, n2, by);
        this.c = 0;
        this.b = n2;
    }

    protected ISO9796P2S2S3Signature(String string) {
        super(string);
        this.mgfEngine_ = new MGF1((AlgorithmID)AlgorithmID.sha1.clone(), this.hashEngine_);
        this.c = 0;
        this.b = 20;
    }
}

