/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.provider;

import iaik.security.ecc.util.Utils;
import java.security.Provider;
import java.security.Security;

public final class ECCProvider
extends Provider {
    private static boolean COMMERCIAL_VERSION;
    private static final double VERSION = 2.1;
    private static final String[] SUPPORTED_ALGORITHMS;
    private static final String NAME = "IAIK_ECC";
    private static final String INFO = "Support for ECDSA and ECDH";
    private static final String[] ALGORITHM_CLASSES;

    static {
        ALGORITHM_CLASSES = new String[]{"iaik.security.ecc.ecdsa.ECDSASignature", "iaik.security.ecc.ecdsa.RawECDSA", "iaik.security.ecc.ecdsa.ECDSAKeyPairGeneratorImpl", "iaik.security.ecc.ecdsa.ECDSAKeyFactory", "ECDSA", "ECDSA", "ECDSA", "ECDSA", "iaik.security.ecc.ecdh.ECDH", "iaik.security.ecc.ecdh.ECDHwithCofactor"};
        SUPPORTED_ALGORITHMS = new String[]{"Signature.ECDSA", "Signature.RawECDSA", "KeyPairGenerator.ECDSA", "KeyFactory.ECDSA", "Alg.Alias.Signature.ecdsa-with-SHA1", "Alg.Alias.Signature.SHA1withECDSA", "Alg.Alias.Signature.1.2.840.10045.4.1", "Alg.Alias.KeyFactory.1.2.840.10045.2.1", "KeyAgreement.ECDH", "KeyAgreement.ECDHwithCofactor"};
        COMMERCIAL_VERSION = false;
        if (!COMMERCIAL_VERSION) {
            String[] stringArray = new String[]{"***                                                                       ***", "***                    Welcome to the IAIK ECC Library                    ***", "***                       ECC Provider version 2.1                        ***", "***                                                                       ***", "*** This version of IAIK ECC is licensed for educational and research use ***", "*** and evaluation only. Commercial use of this software is prohibited.   ***", "*** For details please see http://jcewww.iaik.at/sales/licences/.         ***", "*** This message does not appear in the registered commercial version.    ***", "***                                                                       ***", ""};
            int n = 0;
            while (n < stringArray.length) {
                System.err.println(stringArray[n]);
                ++n;
            }
        }
    }

    private void addProtocols() {
        int n = 0;
        while (n < SUPPORTED_ALGORITHMS.length) {
            this.put(SUPPORTED_ALGORITHMS[n], ALGORITHM_CLASSES[n]);
            ++n;
        }
    }

    public ECCProvider(boolean bl) {
        super(NAME, 2.1, INFO);
        this.addProtocols();
        Utils.setSpeedUpsEnabled(bl);
    }

    public ECCProvider() {
        super(NAME, 2.1, INFO);
        this.addProtocols();
    }

    public static void addAsProvider(boolean bl) {
        Security.addProvider(new ECCProvider(bl));
    }

    public static void addAsProvider() {
        Security.addProvider(new ECCProvider());
    }
}

