/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.field;

import iaik.security.ecc.math.field.Field;
import iaik.security.ecc.math.field.FieldException;
import iaik.security.ecc.math.field.PrimeField;
import iaik.security.ecc.math.field.Value;
import java.math.BigInteger;

public class FieldElement
implements Cloneable {
    protected Value value_;
    protected Field field_;

    void setValue(Value value) {
        this.value_ = value;
    }

    Value getValue() {
        return this.value_;
    }

    public byte[] toByteArray() {
        int n = this.field_.getSize().bitLength();
        int n2 = n % 8;
        n /= 8;
        if (n2 > 0) {
            ++n;
        }
        return this.value_.toByteArray(n);
    }

    public BigInteger toBigInt() {
        return this.value_.toBigInt();
    }

    public String toString() {
        return "\nField: " + this.field_.toString() + "\nValue: " + this.value_.toString();
    }

    public boolean testBit(int n) {
        return this.value_.testBit(n);
    }

    public FieldElement sub(FieldElement fieldElement) {
        FieldElement fieldElement2 = (FieldElement)fieldElement.clone();
        fieldElement2.negate();
        this.field_.add(this, fieldElement2);
        return this;
    }

    public FieldElement square() {
        this.field_.square(this);
        return this;
    }

    public FieldElement negate() {
        this.field_.negate(this);
        return this;
    }

    public FieldElement multiply(FieldElement fieldElement) {
        this.field_.multiply(this, fieldElement);
        return this;
    }

    public boolean isZero() {
        return this.value_.isZero();
    }

    public boolean isOne() {
        return this.value_.isOne();
    }

    public FieldElement invert() {
        this.field_.invert(this);
        return this;
    }

    public FieldElement half() {
        ((PrimeField)this.field_).half(this);
        return this;
    }

    public int hashCode() {
        return this.field_.hashCode() + this.value_.hashCode();
    }

    public Field getField() {
        return this.field_;
    }

    public boolean equals(Object object) {
        FieldElement fieldElement;
        if (object instanceof FieldElement && this.field_.equals((fieldElement = (FieldElement)object).getField())) {
            return this.value_.equals(((FieldElement)object).value_);
        }
        return false;
    }

    public FieldElement divide(FieldElement fieldElement) {
        FieldElement fieldElement2 = (FieldElement)fieldElement.clone();
        fieldElement2.invert();
        this.field_.multiply(this, fieldElement2);
        return this;
    }

    public Object clone() {
        FieldElement fieldElement = new FieldElement((Value)this.value_.clone(), this.field_);
        return fieldElement;
    }

    public FieldElement add(FieldElement fieldElement) {
        this.field_.add(this, fieldElement);
        return this;
    }

    FieldElement(Value value, Field field) {
        this.value_ = value;
        this.field_ = field;
    }

    public static FieldElement sub(FieldElement fieldElement, FieldElement fieldElement2) {
        FieldElement fieldElement3 = (FieldElement)fieldElement.clone();
        fieldElement3.sub(fieldElement2);
        return fieldElement3;
    }

    public static FieldElement square(FieldElement fieldElement) {
        FieldElement fieldElement2 = (FieldElement)fieldElement.clone();
        fieldElement2.square();
        return fieldElement2;
    }

    public static FieldElement negate(FieldElement fieldElement) {
        FieldElement fieldElement2 = (FieldElement)fieldElement.clone();
        fieldElement2.negate();
        return fieldElement2;
    }

    public static FieldElement multiply(FieldElement fieldElement, FieldElement fieldElement2) {
        FieldElement fieldElement3 = (FieldElement)fieldElement.clone();
        fieldElement3.multiply(fieldElement2);
        return fieldElement3;
    }

    public static FieldElement[] invertSimultaneous(FieldElement[] fieldElementArray) {
        FieldElement[] fieldElementArray2 = new FieldElement[fieldElementArray.length];
        FieldElement[] fieldElementArray3 = new FieldElement[fieldElementArray.length];
        fieldElementArray2[0] = (FieldElement)fieldElementArray[0].clone();
        int n = 1;
        while (n < fieldElementArray.length) {
            fieldElementArray2[n] = FieldElement.multiply(fieldElementArray2[n - 1], fieldElementArray[n]);
            ++n;
        }
        FieldElement fieldElement = (FieldElement)fieldElementArray2[fieldElementArray.length - 1].clone();
        fieldElement.invert();
        int n2 = fieldElementArray.length - 1;
        while (n2 >= 1) {
            fieldElementArray3[n2] = FieldElement.multiply(fieldElement, fieldElementArray2[n2 - 1]);
            fieldElement = FieldElement.multiply(fieldElement, fieldElementArray[n2]);
            --n2;
        }
        fieldElementArray3[0] = fieldElement;
        return fieldElementArray3;
    }

    public static FieldElement invert(FieldElement fieldElement) {
        FieldElement fieldElement2 = (FieldElement)fieldElement.clone();
        fieldElement2.invert();
        return fieldElement2;
    }

    public static FieldElement divide(FieldElement fieldElement, FieldElement fieldElement2) throws FieldException {
        FieldElement fieldElement3 = (FieldElement)fieldElement.clone();
        fieldElement3.divide(fieldElement2);
        return fieldElement3;
    }

    public static FieldElement add(FieldElement fieldElement, FieldElement fieldElement2) {
        FieldElement fieldElement3 = (FieldElement)fieldElement.clone();
        fieldElement3.add(fieldElement2);
        return fieldElement3;
    }
}

