/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.ecgroup;

import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.ecgroup.EllipticCurveImpl;
import iaik.security.ecc.math.ecgroup.ProjectiveCoordinate;
import iaik.security.ecc.math.field.BinaryField;
import iaik.security.ecc.math.field.Constants;
import iaik.security.ecc.math.field.Field;
import iaik.security.ecc.math.field.FieldElement;
import java.math.BigInteger;

class BinaryProjectiveCurve
extends EllipticCurveImpl {
    protected FieldElement c_ = null;

    public boolean useAffine() {
        return false;
    }

    public void multiply(ECPoint eCPoint, BigInteger bigInteger) {
        if (eCPoint.isInfinity()) {
            return;
        }
        if (this.order_ != null && bigInteger.compareTo(this.order_) >= 0) {
            bigInteger = bigInteger.mod(this.order_);
        }
        ECPoint eCPoint2 = (ECPoint)eCPoint.clone();
        switch (bigInteger.signum()) {
            case 0: {
                eCPoint.setInfinity();
            }
            case -1: {
                bigInteger = bigInteger.negate();
                eCPoint.invert();
            }
            case 1: {
                eCPoint2.invert();
            }
        }
        ECPoint eCPoint3 = (ECPoint)eCPoint.clone();
        BigInteger bigInteger2 = bigInteger.multiply(Constants.BIG_THREE);
        int n = bigInteger2.bitLength() - 2;
        while (n > 0) {
            eCPoint3.doublePoint();
            if (bigInteger2.testBit(n) && !bigInteger.testBit(n)) {
                eCPoint3.addPoint(eCPoint);
            }
            if (!bigInteger2.testBit(n) && bigInteger.testBit(n)) {
                eCPoint3.addPoint(eCPoint2);
            }
            --n;
        }
        if (eCPoint3.isInfinity()) {
            eCPoint.setInfinity();
        } else {
            ProjectiveCoordinate projectiveCoordinate = (ProjectiveCoordinate)eCPoint3.getCoordinates();
            ProjectiveCoordinate projectiveCoordinate2 = (ProjectiveCoordinate)eCPoint.getCoordinates();
            eCPoint.getCoordinates().setX(eCPoint3.getCoordinates().getX());
            eCPoint.getCoordinates().setY(eCPoint3.getCoordinates().getY());
            projectiveCoordinate2.setZ(projectiveCoordinate.getZ());
        }
    }

    public void invert(ECPoint eCPoint) {
        if (eCPoint.isInfinity()) {
            return;
        }
        FieldElement fieldElement = (FieldElement)eCPoint.getCoordinates().getX().clone();
        eCPoint.getCoordinates().setY(fieldElement.multiply(((ProjectiveCoordinate)eCPoint.getCoordinates()).getZ()).add(eCPoint.getCoordinates().getY()));
    }

    public Field getField() {
        return this.field_;
    }

    public void doublePoint(ECPoint eCPoint) {
        if (eCPoint.isInfinity()) {
            return;
        }
        if (this.c_ == null) {
            this.c_ = (FieldElement)this.b_.clone();
            int n = ((BinaryField)this.a_.getField()).getOrder();
            int n2 = 1;
            while (n2 <= n - 2) {
                this.c_ = this.c_.square();
                ++n2;
            }
        }
        FieldElement fieldElement = (FieldElement)eCPoint.getCoordinates().getX().clone();
        FieldElement fieldElement2 = (FieldElement)eCPoint.getCoordinates().getY().clone();
        FieldElement fieldElement3 = (FieldElement)((ProjectiveCoordinate)eCPoint.getCoordinates()).getZ().clone();
        FieldElement fieldElement4 = (FieldElement)this.c_.clone();
        fieldElement2 = fieldElement2.multiply(fieldElement3);
        fieldElement3 = fieldElement3.square();
        fieldElement4 = fieldElement4.multiply(fieldElement3);
        fieldElement3 = fieldElement3.multiply(fieldElement);
        fieldElement2 = fieldElement2.add(fieldElement3);
        fieldElement4 = fieldElement4.add(fieldElement);
        fieldElement4 = fieldElement4.square();
        fieldElement4 = fieldElement4.square();
        fieldElement = fieldElement.square();
        fieldElement2 = fieldElement2.add(fieldElement);
        fieldElement2 = fieldElement2.multiply(fieldElement4);
        fieldElement = fieldElement.square();
        fieldElement = fieldElement.multiply(fieldElement3);
        fieldElement2 = fieldElement2.add(fieldElement);
        fieldElement = fieldElement4;
        eCPoint.getCoordinates().setX(fieldElement);
        eCPoint.getCoordinates().setY(fieldElement2);
        ((ProjectiveCoordinate)eCPoint.getCoordinates()).setZ(fieldElement3);
    }

    public void addPoint(ECPoint eCPoint, ECPoint eCPoint2) {
        if (eCPoint2.equals(eCPoint)) {
            if (eCPoint.isInfinity()) {
                return;
            }
            this.doublePoint(eCPoint);
            return;
        }
        if (eCPoint.isInfinity()) {
            Coordinate coordinate = (Coordinate)eCPoint2.getCoordinates().clone();
            eCPoint.setCoordinates(coordinate);
            eCPoint.unsetInfinity();
            return;
        }
        FieldElement fieldElement = (FieldElement)eCPoint.getCoordinates().getX().clone();
        FieldElement fieldElement2 = (FieldElement)eCPoint.getCoordinates().getY().clone();
        FieldElement fieldElement3 = (FieldElement)((ProjectiveCoordinate)eCPoint.getCoordinates()).getZ().clone();
        FieldElement fieldElement4 = (FieldElement)eCPoint2.getCoordinates().getX().clone();
        FieldElement fieldElement5 = (FieldElement)eCPoint2.getCoordinates().getY().clone();
        FieldElement fieldElement6 = (FieldElement)((ProjectiveCoordinate)eCPoint2.getCoordinates()).getZ().clone();
        FieldElement fieldElement7 = null;
        FieldElement fieldElement8 = null;
        FieldElement fieldElement9 = null;
        if (!this.a_.isZero()) {
            fieldElement9 = (FieldElement)this.a_.clone();
        }
        if (!((ProjectiveCoordinate)eCPoint2.getCoordinates()).getZ().isOne()) {
            fieldElement6 = (FieldElement)((ProjectiveCoordinate)eCPoint2.getCoordinates()).getZ().clone();
            fieldElement7 = FieldElement.square(fieldElement6);
            fieldElement = fieldElement.multiply(fieldElement7);
            fieldElement7 = fieldElement7.multiply(fieldElement6);
            fieldElement2 = fieldElement2.multiply(fieldElement7);
        }
        fieldElement7 = FieldElement.square(fieldElement3);
        fieldElement8 = FieldElement.multiply(fieldElement4, fieldElement7);
        fieldElement = fieldElement.add(fieldElement8);
        fieldElement7 = fieldElement7.multiply(fieldElement3);
        fieldElement8 = FieldElement.multiply(fieldElement5, fieldElement7);
        fieldElement2 = fieldElement2.add(fieldElement8);
        if (fieldElement.isZero()) {
            eCPoint.setInfinity();
            return;
        }
        fieldElement4 = fieldElement4.multiply(fieldElement2);
        fieldElement3 = fieldElement3.multiply(fieldElement);
        fieldElement5 = fieldElement5.multiply(fieldElement3);
        fieldElement4 = fieldElement4.add(fieldElement5);
        fieldElement5 = FieldElement.square(fieldElement3);
        fieldElement7 = FieldElement.multiply(fieldElement4, fieldElement5);
        if (!((ProjectiveCoordinate)eCPoint2.getCoordinates()).getZ().isOne()) {
            fieldElement3 = fieldElement3.multiply(fieldElement6);
        }
        fieldElement4 = FieldElement.add(fieldElement2, fieldElement3);
        fieldElement2 = fieldElement2.multiply(fieldElement4);
        fieldElement5 = FieldElement.square(fieldElement);
        fieldElement = fieldElement.multiply(fieldElement5);
        if (!this.a_.isZero()) {
            fieldElement8 = FieldElement.square(fieldElement3);
            fieldElement9 = fieldElement9.multiply(fieldElement8);
            fieldElement = fieldElement.add(fieldElement9);
        }
        fieldElement = fieldElement.add(fieldElement2);
        fieldElement4 = fieldElement4.multiply(fieldElement);
        fieldElement2 = FieldElement.add(fieldElement4, fieldElement7);
        eCPoint.getCoordinates().setX(fieldElement);
        eCPoint.getCoordinates().setY(fieldElement2);
        ((ProjectiveCoordinate)eCPoint.getCoordinates()).setZ(fieldElement3);
    }

    BinaryProjectiveCurve(FieldElement fieldElement, FieldElement fieldElement2, BigInteger bigInteger) {
        this.a_ = fieldElement;
        this.b_ = fieldElement2;
        this.field_ = fieldElement.getField();
        this.order_ = bigInteger;
    }
}

