/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.DefaultSDSEncodeListener;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SDSEncodeListener;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.SigningTime;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;

public class SDSEncodeListenerDemo {
    X509Certificate[] certificates;
    PrivateKey user2_sign_pk;
    X509Certificate user2_sign;
    PrivateKey user1_sign_pk;
    X509Certificate user1_sign;
    byte[] message;

    public void start() {
        try {
            byte[] byArray = null;
            System.out.println("\nImplicit SignedDataStream demo [create]:\n");
            byte[] byArray2 = this.createSignedDataStream(this.message, 1);
            System.out.println("\nImplicit SignedDataStream demo [write again]:\n");
            byArray2 = this.getSignedDataStream(byArray2, null, true);
            System.out.println("\nImplicit SignedDataStream demo [parse]:\n");
            byArray = this.getSignedDataStream(byArray2, null, false);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray));
            System.out.println("\nExplicit SignedDataStream demo [create]:\n");
            byArray2 = this.createSignedDataStream(this.message, 2);
            System.out.println("\nExplicit SignedDataStream demo [write again]:\n");
            byArray2 = this.getSignedDataStream(byArray2, this.message, true);
            System.out.println("\nExplicit SignedDataStream demo [parse]:\n");
            byArray = this.getSignedDataStream(byArray2, this.message, false);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            DemoUtil.initDemos();
            new SDSEncodeListenerDemo().start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.in.read();
    }

    public byte[] getSignedDataStream(byte[] byArray, byte[] byArray2, boolean bl) throws NoSuchAlgorithmException, IOException, CMSException {
        X509Certificate x509Certificate;
        SignerInfo signerInfo;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SignedDataStream signedDataStream = null;
        if (byArray2 == null) {
            signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream);
        } else {
            signerInfo = new SignerInfo[]{AlgorithmID.sha1, AlgorithmID.md5};
            signedDataStream = new SignedDataStream((InputStream)new ByteArrayInputStream(byArray2), (AlgorithmID[])signerInfo);
        }
        if (bl) {
            Object object;
            Object object2;
            CMSContentType cMSContentType;
            signerInfo = new SignerInfo((CertificateIdentifier)new IssuerAndSerialNumber(this.user2_sign), AlgorithmID.md5, this.user2_sign_pk);
            Attribute[] attributeArray = new Attribute[2];
            try {
                cMSContentType = new CMSContentType(ObjectID.cms_data);
                attributeArray[0] = new Attribute((AttributeValue)cMSContentType);
                object2 = new SigningTime();
                attributeArray[1] = new Attribute((AttributeValue)object2);
            }
            catch (Exception exception) {
                throw new CMSException("Error creating attribute: " + exception.toString());
            }
            signerInfo.setSignedAttributes(attributeArray);
            cMSContentType = new DefaultSDSEncodeListener();
            cMSContentType.setDigestAlgorithms(new AlgorithmID[]{AlgorithmID.md5});
            cMSContentType.setSignerInfos(new SignerInfo[]{signerInfo});
            cMSContentType.setCertificates(new Certificate[]{this.user2_sign});
            if (byArray2 == null) {
                cMSContentType.setOutputStream((OutputStream)byteArrayOutputStream);
                signedDataStream.setSDSEncodeListener((SDSEncodeListener)cMSContentType);
            } else {
                signedDataStream.setSDSEncodeListener((SDSEncodeListener)cMSContentType);
                object2 = signedDataStream.getInputStream();
                object = new StreamCopier((InputStream)object2, (OutputStream)byteArrayOutputStream);
                object.copyStream();
                signedDataStream.decode((InputStream)byteArrayInputStream);
            }
            signedDataStream.setBlockSize(2048);
            object2 = new ByteArrayOutputStream();
            signedDataStream.writeTo((OutputStream)object2);
            object = byteArrayOutputStream.toByteArray();
            System.out.println("Content: " + new String((byte[])object));
            return ((ByteArrayOutputStream)object2).toByteArray();
        }
        signerInfo = signedDataStream.getInputStream();
        byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier((InputStream)signerInfo, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        if (byArray2 != null) {
            signedDataStream.decode((InputStream)byteArrayInputStream);
        }
        System.out.println("SignedData contains the following signer information:");
        SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                CMSContentType cMSContentType;
                x509Certificate = signedDataStream.verify(n);
                System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                SigningTime signingTime = (SigningTime)signerInfoArray[n].getSignedAttributeValue(ObjectID.signingTime);
                if (signingTime != null) {
                    System.out.println("This message has been signed at " + signingTime.get());
                }
                if ((cMSContentType = (CMSContentType)signerInfoArray[n].getSignedAttributeValue(ObjectID.contentType)) != null) {
                    System.out.println("The content has CMS content type " + cMSContentType.get().getName());
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedDataStream.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                throw new CMSException(signatureException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            x509Certificate = signedDataStream.verify(this.user1_sign);
            System.out.println("Signature OK from signer: " + signedDataStream.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user1_sign.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        try {
            x509Certificate = signedDataStream.verify(this.user2_sign);
            System.out.println("Signature OK from signer: " + signedDataStream.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user2_sign.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createSignedDataStream(byte[] byArray, int n) throws IOException, CMSException {
        Object object;
        Object object2;
        System.out.println("Create a new message signed by user 1:");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream, n);
        try {
            signedDataStream.setSDSEncodeListener((SDSEncodeListener)new DefaultSDSEncodeListener());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        signedDataStream.setCertificates((Certificate[])this.certificates);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1_sign);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.sha1, this.user1_sign_pk);
        Attribute[] attributeArray = new Attribute[2];
        try {
            object2 = new CMSContentType(ObjectID.cms_data);
            attributeArray[0] = new Attribute((AttributeValue)object2);
            object = new SigningTime();
            attributeArray[1] = new Attribute((AttributeValue)object);
        }
        catch (Exception exception) {
            throw new CMSException("Error creating attribute: " + exception.toString());
        }
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedDataStream.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        signedDataStream.setBlockSize(2048);
        if (n == 2) {
            int n2;
            object2 = signedDataStream.getInputStream();
            object = new byte[1024];
            while ((n2 = ((InputStream)object2).read((byte[])object)) > 0) {
            }
        }
        object2 = new ByteArrayOutputStream();
        signedDataStream.writeTo((OutputStream)object2);
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    public SDSEncodeListenerDemo() {
        System.out.println();
        System.out.println("****************************************************************************************");
        System.out.println("*                              SDSEncodeListenerDemo demo                              *");
        System.out.println("*  (shows how to use a SDSEncodeListener for the CMS SignedDataStream implementation)  *");
        System.out.println("****************************************************************************************");
        System.out.println();
        this.message = "This is a test of the CMS implementation!".getBytes();
        this.certificates = CMSKeyStore.getCertificateChain(0, 1);
        this.user1_sign = this.certificates[0];
        this.user1_sign_pk = CMSKeyStore.getPrivateKey(0, 1);
        this.user2_sign = CMSKeyStore.getCertificateChain(0, 2)[0];
        this.user2_sign_pk = CMSKeyStore.getPrivateKey(0, 2);
    }
}

