/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SignedData;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.cms.SubjectKeyID;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.SigningTime;
import iaik.pkcs.pkcs1.MGF1ParameterSpec;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class PssSignedData {
    PrivateKey issuer1_pk;
    Certificate[] user1Certs;
    Certificate[] certs;
    Certificate[] certificates;
    PrivateKey user2_pk;
    X509Certificate user2;
    PrivateKey user1_pk;
    X509Certificate user1;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("Stream implementation demos (RSA-PPS signing)");
            System.out.println("=============================================");
            System.out.println("\nImplicit SignedDataStream demo [create]:\n");
            byte[] byArray3 = this.createSignedDataStream(byArray, 1);
            System.out.println("\nImplicit SignedDataStream demo [parse]:\n");
            byArray2 = this.getSignedDataStream(byArray3, null);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit SignedDataStream demo [create]:\n");
            byArray3 = this.createSignedDataStream(byArray, 2);
            System.out.println("\nExplicit SignedDataStream demo [parse]:\n");
            byArray2 = this.getSignedDataStream(byArray3, byArray);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demos (RSA-PPS signing)");
            System.out.println("===================================================");
            System.out.println("\nImplicit CMS SignedData demo [create]:\n");
            byArray3 = this.createSignedData(byArray, 1);
            System.out.println("\nImplicit CMS SignedData demo [parse]:\n");
            byArray2 = this.getSignedData(byArray3, null);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit CMS SignedData demo [create]:\n");
            byArray3 = this.createSignedData(byArray, 2);
            System.out.println("\nExplicit CMS SignedData demo [parse]:\n");
            byArray2 = this.getSignedData(byArray3, byArray);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new PssSignedData().start();
        System.in.read();
    }

    public byte[] getSignedDataStream(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        X509Certificate x509Certificate;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream);
        if (signedDataStream.getMode() == 2) {
            signedDataStream.setInputStream((InputStream)new ByteArrayInputStream(byArray2));
        }
        InputStream inputStream = signedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        System.out.println("SignedData contains the following signer information:");
        SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                CMSContentType cMSContentType;
                x509Certificate = signedDataStream.verify(n);
                System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                SigningTime signingTime = (SigningTime)signerInfoArray[n].getSignedAttributeValue(ObjectID.signingTime);
                if (signingTime != null) {
                    System.out.println("This message has been signed at " + signingTime.get());
                }
                if ((cMSContentType = (CMSContentType)signerInfoArray[n].getSignedAttributeValue(ObjectID.contentType)) != null) {
                    System.out.println("The content has CMS content type " + cMSContentType.get().getName());
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedDataStream.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                throw new CMSException(signatureException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            signedDataStream.verify(this.user1);
            System.out.println("Signature OK from signer: " + this.user1.getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user1.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        try {
            x509Certificate = signedDataStream.verify(this.user2);
            System.out.println("Signature OK from signer: " + signedDataStream.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user2.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getSignedData(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        X509Certificate x509Certificate;
        SignedData signedData = new SignedData((InputStream)new ByteArrayInputStream(byArray));
        if (signedData.getMode() == 2) {
            signedData.setContent(byArray2);
        }
        System.out.println("SignedData contains the following signer information:");
        SignerInfo[] signerInfoArray = signedData.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                CMSContentType cMSContentType;
                x509Certificate = signedData.verify(n);
                System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                SigningTime signingTime = (SigningTime)signerInfoArray[n].getSignedAttributeValue(ObjectID.signingTime);
                if (signingTime != null) {
                    System.out.println("This message has been signed at " + signingTime.get());
                }
                if ((cMSContentType = (CMSContentType)signerInfoArray[n].getSignedAttributeValue(ObjectID.contentType)) != null) {
                    System.out.println("The content has CMS content type " + cMSContentType.get().getName());
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedData.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                throw new CMSException(signatureException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            x509Certificate = signedData.verify(this.user1);
            System.out.println("Signature OK from signer: " + signedData.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user1.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        try {
            x509Certificate = signedData.verify(this.user2);
            System.out.println("Signature OK from signer: " + signedData.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user2.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        return signedData.getContent();
    }

    public byte[] createSignedDataStream(byte[] byArray, int n) throws IOException, CMSException {
        int n2;
        Object object;
        Object object2;
        System.out.print("Create a new message signed by user 1 :");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream, n);
        signedDataStream.setCertificates(this.certificates);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.sha1, (AlgorithmID)AlgorithmID.rsassaPss.clone(), this.user1_pk);
        Attribute[] attributeArray = new Attribute[2];
        try {
            object2 = new CMSContentType(ObjectID.cms_data);
            attributeArray[0] = new Attribute((AttributeValue)object2);
            object = new SigningTime();
            attributeArray[1] = new Attribute((AttributeValue)object);
        }
        catch (Exception exception) {
            throw new CMSException("Error creating attribute: " + exception.toString());
        }
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedDataStream.addSignerInfo(signerInfo);
            object2 = AlgorithmID.sha512;
            object = (AlgorithmID)AlgorithmID.mgf1.clone();
            n2 = 64;
            AlgorithmID algorithmID = null;
            try {
                algorithmID = this.createPssAlgorithmID((AlgorithmID)object2, (AlgorithmID)object, n2);
            }
            catch (Exception exception) {
                throw new CMSException("Error creating PSS parameters: " + exception.toString());
            }
            signerInfo = new SignerInfo((CertificateIdentifier)new SubjectKeyID(this.user2), (AlgorithmID)object2, algorithmID, this.user2_pk);
            signedDataStream.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CMSException("Cannot create SubjectKeyID for user2 : " + x509ExtensionException.getMessage());
        }
        if (n == 2) {
            object2 = signedDataStream.getInputStream();
            object = new byte[1024];
            while ((n2 = ((InputStream)object2).read((byte[])object)) > 0) {
            }
        }
        object2 = new ByteArrayOutputStream();
        signedDataStream.writeTo((OutputStream)object2, 2048);
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    public byte[] createSignedData(byte[] byArray, int n) throws CMSException {
        SigningTime signingTime;
        CMSContentType cMSContentType;
        System.out.println("Create a new message signed by user 1 :");
        SignedData signedData = new SignedData(byArray, n);
        signedData.setCertificates(this.certificates);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.sha1, (AlgorithmID)AlgorithmID.rsassaPss.clone(), this.user1_pk);
        Attribute[] attributeArray = new Attribute[2];
        try {
            cMSContentType = new CMSContentType(ObjectID.cms_data);
            attributeArray[0] = new Attribute((AttributeValue)cMSContentType);
            signingTime = new SigningTime();
            attributeArray[1] = new Attribute((AttributeValue)signingTime);
        }
        catch (Exception exception) {
            throw new CMSException("Error creating attribute: " + exception.toString());
        }
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedData.addSignerInfo(signerInfo);
            cMSContentType = AlgorithmID.sha512;
            signingTime = (AlgorithmID)AlgorithmID.mgf1.clone();
            int n2 = 64;
            AlgorithmID algorithmID = null;
            try {
                algorithmID = this.createPssAlgorithmID((AlgorithmID)cMSContentType, (AlgorithmID)signingTime, n2);
            }
            catch (Exception exception) {
                throw new CMSException("Error creating PSS parameters: " + exception.toString());
            }
            signerInfo = new SignerInfo((CertificateIdentifier)new SubjectKeyID(this.user2), (AlgorithmID)cMSContentType, algorithmID, this.user2_pk);
            signedData.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CMSException("Cannot create SubjectKeyID for user2 : " + x509ExtensionException.getMessage());
        }
        return signedData.getEncoded();
    }

    public AlgorithmID createPssAlgorithmID(AlgorithmID algorithmID, AlgorithmID algorithmID2, int n) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        AlgorithmID algorithmID3 = (AlgorithmID)AlgorithmID.rsassaPss.clone();
        algorithmID2.setParameter(algorithmID.toASN1Object());
        RSAPssParameterSpec rSAPssParameterSpec = new RSAPssParameterSpec(algorithmID, algorithmID2, n);
        MessageDigest messageDigest = algorithmID.getMessageDigestInstance("IAIK");
        rSAPssParameterSpec.setHashEngine(messageDigest);
        MaskGenerationAlgorithm maskGenerationAlgorithm = algorithmID2.getMaskGenerationAlgorithmInstance("IAIK");
        MGF1ParameterSpec mGF1ParameterSpec = new MGF1ParameterSpec(algorithmID);
        mGF1ParameterSpec.setHashEngine(messageDigest);
        maskGenerationAlgorithm.setParameters((AlgorithmParameterSpec)mGF1ParameterSpec);
        rSAPssParameterSpec.setMGFEngine(maskGenerationAlgorithm);
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = AlgorithmParameters.getInstance("RSASSA-PSS", "IAIK");
            algorithmParameters.init((AlgorithmParameterSpec)rSAPssParameterSpec);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("RSA-PSS implementation of provider IAIK not available!");
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException("Cannot init PSS params: " + invalidParameterSpecException.getMessage());
        }
        algorithmID3.setAlgorithmParameters(algorithmParameters);
        return algorithmID3;
    }

    public PssSignedData() throws IOException {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                             PssSignedData demo                                 *");
        System.out.println("* (shows the usage of the CMS SignedData type with the RSA PSS signature scheme) *");
        System.out.println("**********************************************************************************");
        System.out.println();
        this.user1Certs = CMSKeyStore.getCertificateChain(0, 1);
        this.user1 = (X509Certificate)this.user1Certs[0];
        this.user1_pk = CMSKeyStore.getPrivateKey(0, 1);
        this.user2 = CMSKeyStore.getCertificateChain(0, 2)[0];
        this.user2_pk = CMSKeyStore.getPrivateKey(0, 2);
        this.certs = this.user1Certs;
        this.certificates = new Certificate[this.certs.length + 1];
        System.arraycopy(this.certs, 0, this.certificates, 0, this.certs.length);
        this.certificates[this.certs.length] = this.user2;
    }
}

