/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.enc.dom;

import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.enc.ToBeEncryptedXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMToBeEncryptedXML
implements ToBeEncryptedXML {
    private CanonicalizationMethod canonMethod_;
    private NodeList content_;
    private String encoding_;
    private String mimeType_;
    private String type_;

    public String getType() {
        return this.type_;
    }

    public NodeList getNodeList() {
        return this.content_;
    }

    public String getMimeType() {
        return this.mimeType_;
    }

    public String getEncoding() {
        return this.encoding_;
    }

    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.canonMethod_;
    }

    public DOMToBeEncryptedXML(NodeList nodeList, CanonicalizationMethod canonicalizationMethod) {
        if (nodeList == null) {
            throw new NullPointerException("Argument 'content' must not be null.");
        }
        this.type_ = "http://www.w3.org/2001/04/xmlenc#Content";
        this.content_ = nodeList;
        this.canonMethod_ = canonicalizationMethod;
    }

    public DOMToBeEncryptedXML(Element element, CanonicalizationMethod canonicalizationMethod) {
        if (element == null) {
            throw new NullPointerException("Argument 'element' must not be null.");
        }
        this.type_ = "http://www.w3.org/2001/04/xmlenc#Element";
        this.content_ = new SingletonNodeList(element);
        this.canonMethod_ = canonicalizationMethod;
    }

    private static class SingletonNodeList
    implements NodeList {
        protected Node node_;

        public Node item(int n) {
            return n == 0 ? this.node_ : null;
        }

        public int getLength() {
            return 1;
        }

        public SingletonNodeList(Node node) {
            this.node_ = node;
        }
    }
}

