/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.settings;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.jrockit.jfr.settings.EventDefault;
import oracle.jrockit.jfr.settings.EventSetting;
import oracle.jrockit.jfr.settings.JSONElement;
import oracle.jrockit.jfr.settings.JSONMember;
import oracle.jrockit.jfr.settings.StringParse;

@Deprecated
public class EventDefaultSet {
    private final List<EventDefault> defaults = new ArrayList<EventDefault>();

    public EventDefaultSet(Reader reader) throws URISyntaxException, IOException, ParseException {
        JSONElement jSONElement = JSONElement.parse(reader);
        LinkedList<URI> linkedList = new LinkedList<URI>();
        this.add(linkedList, jSONElement);
    }

    public EventDefaultSet(String string, boolean bl) throws URISyntaxException, IOException, ParseException {
        JSONElement jSONElement = JSONElement.parse(string);
        LinkedList<URI> linkedList = new LinkedList<URI>();
        this.add(linkedList, jSONElement);
    }

    public EventDefaultSet(File file) throws IOException, URISyntaxException, ParseException {
        this(new FileReader(file));
    }

    public EventDefaultSet(String string) throws IOException, URISyntaxException, ParseException {
        this(new File(string));
    }

    public EventDefaultSet(Collection<EventDefault> collection) {
        for (EventDefault eventDefault : collection) {
            this.add(eventDefault);
        }
    }

    public EventDefaultSet(EventDefault ... eventDefaultArray) {
        this(Arrays.asList(eventDefaultArray));
    }

    public EventSetting get(URI uRI) {
        return this.get(uRI.toString());
    }

    public EventSetting get(String string) {
        for (int i = this.defaults.size(); i > 0; --i) {
            EventDefault eventDefault = this.defaults.get(i - 1);
            if (!eventDefault.matches(string)) continue;
            return eventDefault.getSetting();
        }
        return null;
    }

    public List<EventDefault> getAll() {
        return Collections.unmodifiableList(this.defaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(LinkedList<URI> linkedList, JSONElement jSONElement) throws URISyntaxException, IOException {
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (jSONElement.isObject()) {
            for (Object object : jSONElement) {
                String string = ((JSONMember)object).getName();
                JSONElement jSONElement2 = ((JSONMember)object).getValue();
                if (jSONElement2.isValue()) {
                    if (linkedList.isEmpty()) {
                        throw new IllegalArgumentException("Syntax error: " + object);
                    }
                    if ((string = string.toLowerCase()).equals("enable")) {
                        bl = jSONElement2.booleanValue();
                    } else if (string.equals("disable")) {
                        bl = !jSONElement2.booleanValue();
                    } else if (string.equals("stacktrace")) {
                        bl2 = jSONElement2.booleanValue();
                    } else if (string.equals("threshold")) {
                        l = StringParse.nanos(jSONElement2.stringValue());
                    } else if (string.equals("period")) {
                        l2 = StringParse.nanos(jSONElement2.stringValue()) / 1000000L;
                    } else {
                        throw new IllegalArgumentException("Bad value " + object);
                    }
                    ++n;
                    continue;
                }
                URI uRI = new URI(string);
                if (!uRI.isAbsolute()) {
                    if (linkedList.isEmpty()) {
                        if (!uRI.toString().startsWith("*")) {
                            throw new URISyntaxException(string, "Invalid URI : " + uRI);
                        }
                    } else {
                        URI uRI2 = linkedList.getLast();
                        if (!uRI2.toString().endsWith("/")) {
                            uRI = new URI(uRI2.toString() + "/");
                        }
                        uRI = uRI2.resolve(string);
                    }
                }
                try {
                    linkedList.add(uRI);
                    this.add(linkedList, jSONElement2);
                }
                finally {
                    linkedList.removeLast();
                }
            }
            if (n > 0) {
                Object object;
                assert (!linkedList.isEmpty());
                EventSetting eventSetting = new EventSetting(0, bl, bl2, l, l2);
                object = linkedList.getLast();
                this.add((URI)object, eventSetting);
            }
        } else {
            if (jSONElement.isValue()) {
                throw new InternalError();
            }
            if (jSONElement.isArray()) {
                throw new IllegalArgumentException("Syntax error: " + jSONElement);
            }
        }
    }

    private void add(URI uRI, EventSetting eventSetting) {
        this.add(new EventDefault(uRI, eventSetting));
    }

    private void add(EventDefault eventDefault) {
        this.defaults.add(eventDefault);
    }

    public static EventDefaultSet find(String string) throws IOException, URISyntaxException, ParseException {
        String string2 = System.getProperty("user.dir");
        for (int i = 0; i < 2; ++i) {
            File file = new File(string2, string);
            if (file.exists()) {
                return new EventDefaultSet(file);
            }
            if (!string.endsWith(".jfs")) {
                file = new File(string2, string + ".jfs");
            }
            if (file.exists()) {
                return new EventDefaultSet(file);
            }
            string2 = System.getProperty("hotspot.gamma.dir");
            if (string2 == null) break;
        }
        return new EventDefaultSet(string);
    }
}

