/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.events;

import com.oracle.jrockit.jfr.DataType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.events.JavaEventDescriptor;
import oracle.jrockit.jfr.events.ValueDescriptor;

@Deprecated
public class JavaProducerDescriptor
implements ProducerDescriptor {
    private final int id;
    private final List<JavaEventDescriptor> events;
    private final Collection<? extends EventDescriptor> publicEvents;
    private final String name;
    private final String description;
    private final URI uri;
    private final ByteBuffer binaryDescriptor;

    public JavaProducerDescriptor(int n, String string, String string2, URI uRI, List<JavaEventDescriptor> list, Map<String, StringConstantPool> map) {
        this.id = n;
        this.events = list;
        this.name = string;
        this.description = string2;
        this.uri = uRI;
        this.binaryDescriptor = this.createBinaryDescriptor(map);
        this.publicEvents = Collections.unmodifiableCollection(list);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Collection<? extends EventDescriptor> getEvents() {
        return this.publicEvents;
    }

    @Override
    public ByteBuffer getBinaryDescriptor() {
        return this.binaryDescriptor;
    }

    @Override
    public long writeCheckPoint(FileChannel fileChannel, long l) {
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer createBinaryDescriptor(Map<String, StringConstantPool> map) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.events.size() * 200 + map.size() * 50);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.id);
            dataOutputStream.writeUTF(this.name);
            dataOutputStream.writeUTF(this.description);
            dataOutputStream.writeUTF(this.uri.toString());
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n = 0;
            for (JavaEventDescriptor iterator : this.events) {
                for (ValueDescriptor valueDescriptor : iterator.getValues()) {
                    String string = valueDescriptor.getRelationKey();
                    if (string == null || hashMap.containsKey(string)) continue;
                    hashMap.put(string, ++n);
                    arrayList.add(string);
                }
            }
            dataOutputStream.writeInt(hashMap.size());
            for (String string : arrayList) {
                dataOutputStream.writeUTF(string);
            }
            int n2 = 0;
            if (!map.isEmpty()) {
                ++n2;
            }
            dataOutputStream.writeInt(n2 += this.events.size());
            for (JavaEventDescriptor javaEventDescriptor : this.events) {
                int n3 = javaEventDescriptor.getValues().length;
                dataOutputStream.writeInt(n3);
                for (ValueDescriptor valueDescriptor : javaEventDescriptor.getValues()) {
                    dataOutputStream.writeUTF(valueDescriptor.getId());
                    dataOutputStream.writeUTF(valueDescriptor.getName());
                    dataOutputStream.writeUTF(valueDescriptor.getDescription());
                    dataOutputStream.write(valueDescriptor.getTransition().value());
                    DataType dataType = valueDescriptor.getDataType();
                    int n4 = valueDescriptor.getContentTypeOrdinal();
                    if (dataType == DataType.STRING && valueDescriptor.getConstantPool() != null && map.containsKey(valueDescriptor.getConstantPool())) {
                        dataType = DataType.INTEGER;
                        n4 = map.get(valueDescriptor.getConstantPool()).getConstantIndex();
                    }
                    dataOutputStream.write(dataType.ordinal());
                    dataOutputStream.writeInt(n4);
                    String string = valueDescriptor.getRelationKey();
                    if (string == null) {
                        dataOutputStream.writeInt(0);
                    } else {
                        dataOutputStream.writeInt((Integer)hashMap.get(string));
                    }
                    dataOutputStream.writeInt(0);
                }
            }
            if (!map.isEmpty()) {
                dataOutputStream.writeInt(1);
                dataOutputStream.writeUTF("utf");
                dataOutputStream.writeUTF("String");
                dataOutputStream.writeUTF("");
                dataOutputStream.write(0);
                dataOutputStream.write(DataType.UTF8.ordinal());
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
            }
            dataOutputStream.writeInt(this.events.size());
            boolean bl = false;
            for (EventDescriptor eventDescriptor : this.events) {
                void var8_15;
                dataOutputStream.writeInt(eventDescriptor.getId());
                dataOutputStream.writeUTF(eventDescriptor.getName());
                dataOutputStream.writeUTF(eventDescriptor.getDescription());
                dataOutputStream.writeUTF(eventDescriptor.getPath());
                dataOutputStream.writeBoolean(eventDescriptor.hasStartTime());
                dataOutputStream.writeBoolean(eventDescriptor.hasThread());
                dataOutputStream.writeBoolean(eventDescriptor.hasStackTrace());
                dataOutputStream.writeBoolean(eventDescriptor.isRequestable());
                dataOutputStream.writeInt((int)(++var8_15));
                dataOutputStream.writeInt(0);
            }
            dataOutputStream.writeInt(map.size());
            for (Map.Entry<String, StringConstantPool> entry : map.entrySet()) {
                String string = entry.getKey();
                StringConstantPool stringConstantPool = entry.getValue();
                dataOutputStream.writeInt(stringConstantPool.getConstantIndex());
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeUTF("");
                dataOutputStream.write(DataType.INTEGER.ordinal());
                dataOutputStream.writeInt(this.events.size());
            }
            dataOutputStream.flush();
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return ByteBuffer.wrap(byArray);
        }
        catch (IOException iOException) {
            throw (InternalError)new InternalError("Could not create descriptors").initCause(iOException);
        }
    }
}

