#!/usr/bin/env python

"""
This script builds a list of minor code values from the omniORB
minorCode.h header.
"""

# This code should work with Python 1.5.2, for people using the
# minimal omnipython distribution.

import sys, re, os.path

def main(argv):
    if len(argv) != 3:
        sys.stderr.write("Usage: %s <source> <dest>\n" %
                         os.path.basename(sys.argv[0]))
        sys.exit(1)

    _, source, dest = argv

    pattern = re.compile(r"^code\( ([^ \t,]+)[ \t]*,[ \t]*([^ ]+)")

    try:
        sfile = open(source, "r")
        dfile = open(dest, "w")

        dfile.write("""\
# minorCodes.py -- generated by makeminors.py

def OMNIORBMinorCode(c):
    return 0x41540000 | c

def OMGMinorCode(c):
    return 0x4f4d0000 | c

""")
        for line in sfile.readlines():
            match = pattern.match(line)
            if match is not None:
                name, value = match.groups()

                if value[:17] == "OMNIORBMinorCode_":
                    value = "OMNIORBMinorCode(%s)" % value[17:]

                dfile.write('%s = %s\n' % (name, value))

        dfile.write("""\
""")

    except Exception, ex:
        sys.stderr.write("Error: %s\n" % ex)
        sys.exit(1)


if __name__ == "__main__":
    main(sys.argv)
