﻿//
// Patterns.cs
//
// Authors:
//	Marek Safar  <marek.safar@gmail.com>
//
// Copyright (C) 2012 Xamarin Inc (http://www.xamarin.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System.Collections.Generic;

namespace Mono.Tools.LocaleBuilder
{
	static class Patterns
	{
		static readonly Dictionary<int, string[][]> DateTime2 = new Dictionary<int, string[][]> {
			{ 0x0001, new [] { new[] { "dd/MM/yy", "dd/MM/yyyy" }, new[] { "dd/MMMM/yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0002, new [] { new[] { "d.M.yyyy 'г.'", "dd.M.yyyy 'г.'", "d.MM.yyyy 'г.'", "dd.MM.yyyy 'г.'" }, new[] { "dd MMMM yyyy 'г.'", "d MMMM yyyy 'г.'", "dddd, dd MMMM yyyy 'г.'", "dddd, d MMMM yyyy 'г.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy 'г.'" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0003, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM 'de' yyyy", "d MMMM 'de' yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0004, new [] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy/MM/dd", "yyyy-MM-dd", "yyyy.MM.dd", "yy/M/d", "yy-M-d", "yy.M.d", "yy/MM/dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'M'月'd'日', dddd", "dddd, yyyy'年'M'月'd'日'", "yyyy年MMMd日", "yyyy年MMMd日, dddd" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" }, new[] { "yyyy'年'M'月'", "yyyy'年'MMM", "yyyy'年'MMMM", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "M月d日" } } },
			{ 0x0005, new [] { new[] { "dd.MM.yyyy", "d. M. yyyy" }, new[] { "dddd d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0006, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd", "yyyy MM dd" }, new[] { "d. MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0007, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd", "dd. MMM. yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. MMM. yyyy" }, new[] { "HH:mm", "HH:mm' Uhr'" }, new[] { "HH:mm:ss", "HH:mm:ss' Uhr'" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0008, new [] { new[] { "d/M/yyyy", "dd/MM/yyyy", "d/M/yy", "dd/MM/yy", "dd/MMM/yyyy", "yyyy-MM-dd" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0009, new [] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM d, yyyy", "MMMM d, yyyy", "dddd, d MMMM, yyyy", "d MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x000a, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yy", "d/M/yy", "d-M-yy", "dd-MM-yy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, d' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm", "H.mm", "HH.mm", "HH'H'mm" }, new[] { "H:mm:ss", "HH:mm:ss", "H.mm.ss", "HH.mm.ss", "HH'H'mm.ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d 'de' MMMM" } } },
			{ 0x000b, new [] { new[] { "d.M.yyyy" }, new[] { "dddd d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "H.mm" }, new[] { "H.mm.ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { "." }, new[] { "d. MMMM" } } },
			{ 0x000c, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy", "d MMM yy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x000d, new [] { new[] { "dd/MM/yyyy", "dd MMMM yyyy", "dd/MM/yy", "dd/MMMM/yyyy", "dd-MM-yy", "dd-MM-yyyy", "dd-MMMM-yyyy", "yyyy-MM-dd", "dd 'ב'MMMM yyyy", "dd MMM yy" }, new[] { "dddd dd MMMM yyyy", "dd MMMM yyyy", "dddd dd 'ב'MMMM yyyy", "ddd dd 'ב'MMMM yyyy", "dd 'ב'MMMM yyyy" }, new[] { "HH:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "hh:mm:ss tt" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x000e, new [] { new[] { "yyyy. MM. dd.", "yyyy. MMM d." }, new[] { "yyyy. MMMM d., dddd", "yyyy. MMMM d." }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "yyyy. MMMM" }, new[] { ". " }, new[] { ":" }, new[] { "MMMM d." } } },
			{ 0x000f, new [] { new[] { "d.M.yyyy", "d. MMM yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0010, new [] { new[] { "dd/MM/yyyy", "dd/MMM/yyyy", "dd/MM/yy", "dd.M.yy", "d/M/yy" }, new[] { "dddd d MMMM yyyy", "d-MMM-yy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0011, new [] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yy/M/d", "yyyy/M/d", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'", "yyyy'年'M'月'd'日 'dddd", "yyyy'年'MM'月'dd'日 'dddd", "yyyy'年'MMM'月'd'日'", "yyyy'年'MMM'月'd'日 'dddd", "yyyy'年'MMMMd'日'", "yyyy'年'MMMMd'日 'dddd" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" }, new[] { "yyyy'年'M'月'", "yyyy'年'MMM'月'", "yyyy'年'MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "M月d日" } } },
			{ 0x0012, new [] { new[] { "yyyy-MM-dd", "yy-MM-dd", "yy-M-d", "yyyy-M-d" }, new[] { "yyyy'년' M'월' d'일' dddd", "yyyy'년' M'월' d'일'", "yy'년' M'월' d'일' dddd", "yy'년' M'월' d'일'", "yyyy'년' MM'월' dd'일' dddd", "yyyy'년' MM'월' dd'일'", "yyyy'년 'MMM'월 'd'일 'dddd", "yyyy'년 'MMM'월 'd'일'", "yyyy'년 'MMMM d'일 'dddd", "yyyy'년 'MMMM d'일'" }, new[] { "tt h:mm", "tt hh:mm", "H:mm", "HH:mm" }, new[] { "tt h:mm:ss", "tt hh:mm:ss", "H:mm:ss", "HH:mm:ss" }, new[] { "yyyy'년' M'월'", "yyyy'년' MMM'월'", "yyyy'년' MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "M월 d일" } } },
			{ 0x0013, new [] { new[] { "d-M-yyyy", "d-M-yy", "dd-MM-yy", "dd/MM/yy", "dd.MM.yy", "dd.MMM.yyyy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d-MMM-yy", "d MMMM yyyy", "d MMM yy" }, new[] { "HH:mm", "H:mm", "H.mm", "HH.mm' uur'", "HH:mm' uur'" }, new[] { "HH:mm:ss", "H:mm:ss", "HH.mm.ss' uur'", "HH:mm:ss' uur'" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0014, new [] { new[] { "dd.MM.yyyy", "d. MMM yyyy" }, new[] { "dddd d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "HH.mm" }, new[] { "HH.mm.ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { "." }, new[] { "d.MMMM." } } },
			{ 0x0015, new [] { new[] { "dd.MM.yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0016, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yyyy", "d/M/yy", "dd-MM-yy", "dd-MM-yyyy", "d-M-yy", "d-M-yyyy", "dd.MM.yy", "dd.MM.yyyy", "dd.MMM.yyyy", "d.M.yy", "d.M.yyyy", "yyyy-MM-dd" }, new[] { "dddd, d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d 'de' MMMM" } } },
			{ 0x0017, new [] { new[] { "dd-MM-yyyy" }, new[] { "dddd, 'ils' d 'da' MMMM yyyy", "d 'da' MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0018, new [] { new[] { "dd.MM.yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0019, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd-MM-yyyy", "dd/MM/yy" }, new[] { "d MMMM yyyy 'г.'", "dd MMMM yyyy 'г.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x001a, new [] { new[] { "d.M.yyyy.", "d.M.yy.", "d. M. yyyy.", "dd.MM.yyyy.", "d. M. yy.", "dd.MM.yy.", "dd. MM. yy.", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy.", "dd. MMMM yyyy.", "dddd, d. MMMM yyyy." }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x001b, new [] { new[] { "dd.MM.yyyy", "d. M. yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x001c, new [] { new[] { "d.M.yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x001d, new [] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "'den 'd MMMM yyyy", "dddd' den 'd MMMM yyyy" }, new[] { "HH:mm", "H:mm", "'kl 'H:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "'kl 'H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "'den 'd MMMM" } } },
			{ 0x001e, new [] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "dd/MM/yyyy", "d MMM yyyy", "dd MMM yyyy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "ddd d MMMM yyyy", "'วัน'dddd'ที่' d MMMM gg yyyy" }, new[] { "H:mm", "HH:mm", "h:mm tt", "hh:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "h:mm:ss tt", "hh:mm:ss tt" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x001f, new [] { new[] { "d.MM.yyyy", "d MMM yyyy" }, new[] { "d MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0020, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0021, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm" }, new[] { "HH.mm.ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { "." }, new[] { "d MMMM" } } },
			{ 0x0022, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy' р.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy' р.'" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0023, new [] { new[] { "dd.MM.yy" }, new[] { "d MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy г." }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0024, new [] { new[] { "d. MM. yyyy", "d. MMM yyyy" }, new[] { "dddd, dd. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { ". " }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0025, new [] { new[] { "dd.MM.yyyy", "d. MMM yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm.ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0026, new [] { new[] { "dd.MM.yyyy", "yyyy. 'gada' d. MMM" }, new[] { "dddd, yyyy. 'gada' d. MMMM", "yyyy. 'gada' d. MMMM" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy. 'g'. MMMM" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0027, new [] { new[] { "yyyy-MM-dd" }, new[] { "yyyy 'm'. MMMM d 'd'., dddd", "yyyy 'm'. MMMM d 'd'." }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0028, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd-MM-yyyy", "dd/MM/yy" }, new[] { "d MMMM yyyy' с.'", "dd MMMM yyyy' с.'" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0029, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x002a, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd-MM-yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x002b, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d/MM/yyyy", "dd/MM/yyyy", "d/MMM/yyyy", "dd/MMM/yyyy", "yyyy-MM-dd" }, new[] { "d MMMM, yyyy", "dddd, d MMMM yyyy", "dddd, dd MMMM yyyy", "dd MMMM yyyy", "d-MMM-yyyy", "dd-MMM-yyyy", "ddd, d-MMMM-yyyy", "ddd, dd-MMMM-yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x002c, new [] { new[] { "dd.MM.yyyy", "d MMM yyyy" }, new[] { "d MMMM yyyy, dddd", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x002d, new [] { new[] { "yyyy/MM/dd", "yyyy MMM d" }, new[] { "yyyy('e')'ko' MMMM d, dddd", "yyyy('e')'ko' MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy('e')'ko' MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x002e, new [] { new[] { "d.M.yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "H:mm 'hodź'." }, new[] { "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x002f, new [] { new[] { "dd.M.yyyy" }, new[] { "dddd, dd MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy 'г'." }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0030, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0031, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0032, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0033, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0034, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0035, new [] { new[] { "M/d/yyyy", "MMM d, yyyy" }, new[] { "dddd, MMMM d, yyyy", "MMMM d, yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0036, new [] { new[] { "yyyy-MM-dd", "dd MMM yyyy" }, new[] { "dddd, dd MMMM yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0037, new [] { new[] { "dd.MM.yyyy", "d MMM, yyyy" }, new[] { "dddd, dd MMMM, yyyy", "d MMMM, yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0038, new [] { new[] { "dd-MM-yyyy" }, new[] { "dddd dd MMMM yyyy", "d. MMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0039, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x003a, new [] { new[] { "dd/MM/yyyy", "dd MMM yyyy" }, new[] { "dddd, d 'ta'’ MMMM yyyy", "d 'ta'’ MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM 'ta'’ yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d 'ta'’ MMMM" } } },
			{ 0x003b, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x003c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x003d, new [] { new[] { "dd/MM/yyyy", "dטן MMM yyyy" }, new[] { "dddd, dטן MMMM yyyy", "dטן MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d בMMMM" } } },
			{ 0x003e, new [] { new[] { "d/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x003f, new [] { new[] { "dd/MM/yyyy", "yyyy, dd-MMM" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0040, new [] { new[] { "d-MMM yy" }, new[] { "dd-MMMM yyyy'-ж.'" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy'-ж.'" }, new[] { "-" }, new[] { ":" }, new[] { "d-MMMM" } } },
			{ 0x0041, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0042, new [] { new[] { "dd.MM.yy 'ý.'", "dd.MM.yyyy" }, new[] { "yyyy'-nji ýylyň 'd'-nji 'MMMM" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "yyyy 'ý.' MMMM" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0043, new [] { new[] { "yyyy/MM/dd", "yyyy MMM d" }, new[] { "dddd, yyyy MMMM dd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0044, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd", "dd MMMM yyyy' ел'" }, new[] { "dd MMMM yyyy' ел'" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy", "MMMM yyyy' ел'" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0045, new [] { new[] { "dd-MM-yy", "d-M-yy", "dd-MM-yyyy", "dd-MM-yy", "dd-MM-yyyy" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm", "H.mm", "tt hh.mm", "tt h.mm" }, new[] { "HH.mm.ss", "H.mm.ss", "tt hh.mm.ss", "tt h.mm.ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { "." }, new[] { "d MMMM" } } },
			{ 0x0046, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "tt hh:mm", "tt h:mm", "H:mm", "HH:mm" }, new[] { "tt hh:mm:ss", "tt h:mm:ss", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0047, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0048, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0049, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x004a, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x004b, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x004c, new [] { new[] { "dd-MM-yy", "d-M-yy", "dd.MM.yy", "d.M.yy" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm", "H.mm", "tt hh.mm", "tt h.mm" }, new[] { "HH.mm.ss", "H.mm.ss", "tt hh.mm.ss", "tt h.mm.ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { "." }, new[] { "MMMM dd" } } },
			{ 0x004d, new [] { new[] { "dd-MM-yyyy" }, new[] { "yyyy,MMMM dd, dddd" }, new[] { "tt h:mm", "tt hh:mm", "H:mm" }, new[] { "tt h:mm:ss", "tt hh:mm:ss", "H:mm:ss" }, new[] { "MMMM,yy", "MMMM,yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x004e, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x004f, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0050, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "dddd, yyyy 'оны' MM 'сарын' d", "yyyy 'оны' MM 'сарын' d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0051, new [] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd", "yy-M-d", "yy/M/d", "yy.M.d" }, new[] { "yyyy'ལོའི་ཟླ' M'ཚེས' d", "yyyy'ལོའི་ཟླ' M'ཚེས' d dddd", "yyyyལོའི་ཟླ MMM d", "yyyyལོའི་ཟླ MMM d dddd" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy'ལོའི་ཟླ་' M", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "ཟླ་Mཚེས་d" } } },
			{ 0x0052, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0053, new [] { new[] { "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "ddd d MMMM yyyy" }, new[] { "H:mm" }, new[] { "HH:mm:ss" }, new[] { "'ខែ' MM 'ឆ្នាំ' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0054, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd ທີ d MMMM gg yyyy", "d MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0055, new [] { new[] { "dd-MM-yyyy", "d MMM yyyy" }, new[] { "dddd၊ dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0056, new [] { new[] { "dd/MM/yyyy", "d MMM, yyyy" }, new[] { "dddd dd MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0057, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0058, new [] { new[] { "dd/MM/yyyy" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0059, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dddd, dd MMMM, yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x005a, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x005b, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "tt h.mm", "HH:mm" }, new[] { "tt h.mm.ss", "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { "." }, new[] { "MMMM d" } } },
			{ 0x005c, new [] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd,yyyy", "MMMM dd,yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x005d, new [] { new[] { "d/MM/yyyy", "d/M/yy", "yy-MM-dd", "dd/MM/yyyy", "yy-MM-dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, dd MMMM, yyyy", "ddd, MMMM dd,yyyy", "MMMM dd,yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x005e, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x005f, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0060, new [] { new[] { "M/d/yyyy", "MMM d, yyyy" }, new[] { "dddd, MMMM d, yyyy", "MMMM d, yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0061, new [] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM,yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0062, new [] { new[] { "dd-MM-yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0063, new [] { new[] { "yyyy/M/d", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dddd d MMMM yyyy" }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0064, new [] { new[] { "M/d/yyyy", "MMM d, yyyy" }, new[] { "dddd, MMMM d, yyyy", "MMMM d, yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0065, new [] { new[] { "dd/MM/yy" }, new[] { "ddd, yyyy MMMM dd" }, new[] { "HH:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "hh:mm:ss tt" }, new[] { "yyyy, MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x0066, new [] { new[] { "d/M/yyyy" }, new[] { "dddd, MMMM dd, yyyy" }, new[] { "h:mmt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x0067, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0068, new [] { new[] { "d/M/yyyy", "d MMM, yyyy" }, new[] { "dddd, d MMMM, yyyy", "d MMMM, yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0069, new [] { new[] { "d/M/yyyy" }, new[] { "dddd, MMMM dd, yyyy" }, new[] { "h:mmt", "H:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x006a, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x006b, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d 'de' MMMM" } } },
			{ 0x006c, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x006d, new [] { new[] { "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy 'й'" }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x006e, new [] { new[] { "dd.MM.yy", "dd/MM/yy", "dd-MM-yy" }, new[] { "d. MMMM yyyy", "dd. MMMMyyyy", "dddd, d. MMMM yyyy", "dddd, dd. MMMM yyyy", "dddd,' den 'd. MMMM yyyy", "dddd,' den 'dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm", "H.mm", "H.mm' Auer'" }, new[] { "HH:mm:ss", "H:mm:ss' Auer'", "HH:mm:ss' Auer'" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd. MMMM" } } },
			{ 0x006f, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd", "yyyy MM dd" }, new[] { "MMMM d'.-at, 'yyyy", "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d'.-at'" } } },
			{ 0x0070, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0071, new [] { new[] { "d/M/yyyy" }, new[] { "dddd, MMMM dd, yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x0072, new [] { new[] { "dd/MM/yyyy", "dd-MMM-yyyy" }, new[] { "dddd, MMMM d, yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0073, new [] { new[] { "dd/MM/yyyy", "dd-MMM-yyyy" }, new[] { "dddd፡ dd MMMM መዓልቲ yyyy gg", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0074, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd-MM-yyyy", "dd-MM-yy" }, new[] { "dddd, dd MMMM, yyyy", "dddd, d MMMM, yyyy", "dd/MMMM/yyyy", "d/MMMM/yyyy", "dd MMMM, yyyy", "d MMMM, yyyy" }, new[] { "HH:mm", "H:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "H:mm:ss", "hh:mm:ss tt" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0075, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0076, new [] { new[] { "dd/MM/yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "H:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x0077, new [] { new[] { "dd/MM/yyyy", "dd-MMM-yyyy" }, new[] { "dddd, MMMM dd, yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0078, new [] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd" }, new[] { "yyyy'ꈎ' M'ꆪ' d'ꑍ'", "dddd, yyyy'ꈎ' M'ꆪ' d'ꑍ'", "yyyy'ꈎ' M'ꆪ' d'ꑍ', dddd", "yyyyꈎ MMM dꑍ", "dddd, yyyyꈎ MMM dꑍ" }, new[] { "tt h:mm", "H:mm", "HH:mm" }, new[] { "tt h:mm:ss", "H:mm:ss", "HH:mm:ss" }, new[] { "yyyy'ꈎ' M'ꆪ'", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "M’ ꆪ’d’ ꑍ’" } } },
			{ 0x0079, new [] { new[] { "d-M-yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy", "d MMM yy", "d-MMM-yy" }, new[] { "H:mm", "HH:mm", "H.mm", "HH.mm' uur'", "HH:mm' uur'" }, new[] { "H:mm:ss", "HH:mm:ss", "H:mm", "H.mm", "HH.mm.ss' uur'", "HH:mm:ss' uur'" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x007a, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "dd/MM/yy", "d/M/yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d 'de' MMMM" } } },
			{ 0x007c, new [] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x007e, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0080, new [] { new[] { "yyyy-M-d", "yyyy.M.d", "yyyy-MM-dd", "yyyy.MM.dd" }, new[] { "yyyy-'يىل' d-MMMM", "yyyy-'يىل' d-MMMM dddd", "yyyy-'يىلى' MMM'نىڭ' d'-كۈنى'", "yyyy-'يىلى' MMM'نىڭ' d'-كۈنى' dddd", "yyyy-M-d dddd" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" }, new[] { "yyyy-'يىلى' MMMM", "yyyy MMMM", "yyyy.M" }, new[] { "-" }, new[] { ":" }, new[] { "d-MMMM" } } },
			{ 0x0081, new [] { new[] { "dd/MM/yyyy", "d/MM/yy", "dd/MM/yy", "d.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, dd MMMM, yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yy", "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0082, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy" }, new[] { "dddd d MMMM' de 'yyyy", "d MMMM' de 'yyyy" }, new[] { "HH' h 'mm" }, new[] { "HH.mm.ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { "." }, new[] { "d MMMM" } } },
			{ 0x0083, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM' di u 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d' di 'MMMM" } } },
			{ 0x0084, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0085, new [] { new[] { "dd.MM.yyyy", "d.M.yyyy", "yyyy-MM-dd", "yyyy MM d", "dd yyyy MM d" }, new[] { "dddd, yyyy 'с.' MMMM d 'күнэ'", "yyyy 'с.' MMMM d 'күнэ'", "dddd, MMMM d 'күнэ' yyyy 'с.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "yyyy 'с.' MMMM" }, new[] { "." }, new[] { ":" }, new[] { "MMMM d күнэ" } } },
			{ 0x0086, new [] { new[] { "dd/MM/yyyy", "d/MM/yyyy" }, new[] { "dddd, dd' rech 'MMMM' rech 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM' rech 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d' rech 'MMMM" } } },
			{ 0x0087, new [] { new[] { "yyyy/MM/dd", "yyyy MMM d" }, new[] { "dddd, yyyy MMMM dd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0088, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x008c, new [] { new[] { "yyyy/M/d", "yyyy-MM-dd" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "H:mm" }, new[] { "h:mm:ss tt", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0091, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d'mh' MMMM yyyy", "d'mh' MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d'mh' MMMM" } } },
			{ 0x0092, new [] { new[] { "yyyy/MM/dd" }, new[] { "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0401, new [] { new[] { "dd/MM/yy", "dd/MM/yyyy" }, new[] { "dd/MMMM/yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0402, new [] { new[] { "d.M.yyyy 'г.'", "dd.M.yyyy 'г.'", "d.MM.yyyy 'г.'", "dd.MM.yyyy 'г.'" }, new[] { "dd MMMM yyyy 'г.'", "d MMMM yyyy 'г.'", "dddd, dd MMMM yyyy 'г.'", "dddd, d MMMM yyyy 'г.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy 'г.'" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0403, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM 'de' yyyy", "d MMMM 'de' yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0404, new [] { new[] { "yyyy/M/d", "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'", "yyyy年MMMd日", "dddd yyyy年MMMd日" }, new[] { "tt hh:mm", "tt h:mm", "HH:mm", "H:mm" }, new[] { "tt hh:mm:ss", "tt h:mm:ss", "HH:mm:ss", "H:mm:ss" }, new[] { "yyyy'年'M'月'", "yyyy'年'MMM", "yyyy'年'MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "M月d日" } } },
			{ 0x0405, new [] { new[] { "dd.MM.yyyy", "d. M. yyyy" }, new[] { "dddd d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0406, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd", "yyyy MM dd" }, new[] { "d. MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0407, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd", "dd. MMM. yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. MMM. yyyy" }, new[] { "HH:mm", "HH:mm' Uhr'" }, new[] { "HH:mm:ss", "HH:mm:ss' Uhr'" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0408, new [] { new[] { "d/M/yyyy", "dd/MM/yyyy", "d/M/yy", "dd/MM/yy", "dd/MMM/yyyy", "yyyy-MM-dd" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0409, new [] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM d, yyyy", "MMMM d, yyyy", "dddd, d MMMM, yyyy", "d MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x040b, new [] { new[] { "d.M.yyyy" }, new[] { "dddd d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "H.mm" }, new[] { "H.mm.ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { "." }, new[] { "d. MMMM" } } },
			{ 0x040c, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy", "d MMM yy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x040d, new [] { new[] { "dd/MM/yyyy", "dd MMMM yyyy", "dd/MM/yy", "dd/MMMM/yyyy", "dd-MM-yy", "dd-MM-yyyy", "dd-MMMM-yyyy", "yyyy-MM-dd", "dd 'ב'MMMM yyyy", "dd MMM yy" }, new[] { "dddd dd MMMM yyyy", "dd MMMM yyyy", "dddd dd 'ב'MMMM yyyy", "ddd dd 'ב'MMMM yyyy", "dd 'ב'MMMM yyyy" }, new[] { "HH:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "hh:mm:ss tt" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x040e, new [] { new[] { "yyyy. MM. dd.", "yyyy. MMM d." }, new[] { "yyyy. MMMM d., dddd", "yyyy. MMMM d." }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "yyyy. MMMM" }, new[] { ". " }, new[] { ":" }, new[] { "MMMM d." } } },
			{ 0x040f, new [] { new[] { "d.M.yyyy", "d. MMM yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0410, new [] { new[] { "dd/MM/yyyy", "dd/MMM/yyyy", "dd/MM/yy", "dd.M.yy", "d/M/yy" }, new[] { "dddd d MMMM yyyy", "d-MMM-yy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0411, new [] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yy/M/d", "yyyy/M/d", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'", "yyyy'年'M'月'd'日 'dddd", "yyyy'年'MM'月'dd'日 'dddd", "yyyy'年'MMM'月'd'日'", "yyyy'年'MMM'月'd'日 'dddd", "yyyy'年'MMMMd'日'", "yyyy'年'MMMMd'日 'dddd" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" }, new[] { "yyyy'年'M'月'", "yyyy'年'MMM'月'", "yyyy'年'MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "M月d日" } } },
			{ 0x0412, new [] { new[] { "yyyy-MM-dd", "yy-MM-dd", "yy-M-d", "yyyy-M-d" }, new[] { "yyyy'년' M'월' d'일' dddd", "yyyy'년' M'월' d'일'", "yy'년' M'월' d'일' dddd", "yy'년' M'월' d'일'", "yyyy'년' MM'월' dd'일' dddd", "yyyy'년' MM'월' dd'일'", "yyyy'년 'MMM'월 'd'일 'dddd", "yyyy'년 'MMM'월 'd'일'", "yyyy'년 'MMMM d'일 'dddd", "yyyy'년 'MMMM d'일'" }, new[] { "tt h:mm", "tt hh:mm", "H:mm", "HH:mm" }, new[] { "tt h:mm:ss", "tt hh:mm:ss", "H:mm:ss", "HH:mm:ss" }, new[] { "yyyy'년' M'월'", "yyyy'년' MMM'월'", "yyyy'년' MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "M월 d일" } } },
			{ 0x0413, new [] { new[] { "d-M-yyyy", "d-M-yy", "dd-MM-yy", "dd/MM/yy", "dd.MM.yy", "dd.MMM.yyyy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d-MMM-yy", "d MMMM yyyy", "d MMM yy" }, new[] { "HH:mm", "H:mm", "H.mm", "HH.mm' uur'", "HH:mm' uur'" }, new[] { "HH:mm:ss", "H:mm:ss", "HH.mm.ss' uur'", "HH:mm:ss' uur'" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0414, new [] { new[] { "dd.MM.yyyy", "d. MMM yyyy" }, new[] { "dddd d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "HH.mm" }, new[] { "HH.mm.ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { "." }, new[] { "d.MMMM." } } },
			{ 0x0415, new [] { new[] { "dd.MM.yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0416, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yyyy", "d/M/yy", "dd-MM-yy", "dd-MM-yyyy", "d-M-yy", "d-M-yyyy", "dd.MM.yy", "dd.MM.yyyy", "dd.MMM.yyyy", "d.M.yy", "d.M.yyyy", "yyyy-MM-dd" }, new[] { "dddd, d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d 'de' MMMM" } } },
			{ 0x0417, new [] { new[] { "dd-MM-yyyy" }, new[] { "dddd, 'ils' d 'da' MMMM yyyy", "d 'da' MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0418, new [] { new[] { "dd.MM.yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0419, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd-MM-yyyy", "dd/MM/yy" }, new[] { "d MMMM yyyy 'г.'", "dd MMMM yyyy 'г.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x041a, new [] { new[] { "d.M.yyyy.", "d.M.yy.", "d. M. yyyy.", "dd.MM.yyyy.", "d. M. yy.", "dd.MM.yy.", "dd. MM. yy.", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy.", "dd. MMMM yyyy.", "dddd, d. MMMM yyyy." }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x041b, new [] { new[] { "dd.MM.yyyy", "d. M. yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x041c, new [] { new[] { "d.M.yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x041d, new [] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "'den 'd MMMM yyyy", "dddd' den 'd MMMM yyyy" }, new[] { "HH:mm", "H:mm", "'kl 'H:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "'kl 'H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "'den 'd MMMM" } } },
			{ 0x041e, new [] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "dd/MM/yyyy", "d MMM yyyy", "dd MMM yyyy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "ddd d MMMM yyyy", "'วัน'dddd'ที่' d MMMM gg yyyy" }, new[] { "H:mm", "HH:mm", "h:mm tt", "hh:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "h:mm:ss tt", "hh:mm:ss tt" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x041f, new [] { new[] { "d.MM.yyyy", "d MMM yyyy" }, new[] { "d MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0420, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0421, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm" }, new[] { "HH.mm.ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { "." }, new[] { "d MMMM" } } },
			{ 0x0422, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy' р.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy' р.'" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0423, new [] { new[] { "dd.MM.yy" }, new[] { "d MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy г." }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0424, new [] { new[] { "d. MM. yyyy", "d. MMM yyyy" }, new[] { "dddd, dd. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { ". " }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0425, new [] { new[] { "dd.MM.yyyy", "d. MMM yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm.ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0426, new [] { new[] { "dd.MM.yyyy", "yyyy. 'gada' d. MMM" }, new[] { "dddd, yyyy. 'gada' d. MMMM", "yyyy. 'gada' d. MMMM" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy. 'g'. MMMM" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0427, new [] { new[] { "yyyy-MM-dd" }, new[] { "yyyy 'm'. MMMM d 'd'., dddd", "yyyy 'm'. MMMM d 'd'." }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0428, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd-MM-yyyy", "dd/MM/yy" }, new[] { "d MMMM yyyy' с.'", "dd MMMM yyyy' с.'" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0429, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x042a, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd-MM-yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x042b, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d/MM/yyyy", "dd/MM/yyyy", "d/MMM/yyyy", "dd/MMM/yyyy", "yyyy-MM-dd" }, new[] { "d MMMM, yyyy", "dddd, d MMMM yyyy", "dddd, dd MMMM yyyy", "dd MMMM yyyy", "d-MMM-yyyy", "dd-MMM-yyyy", "ddd, d-MMMM-yyyy", "ddd, dd-MMMM-yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x042c, new [] { new[] { "dd.MM.yyyy", "d MMM yyyy" }, new[] { "d MMMM yyyy, dddd", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x042d, new [] { new[] { "yyyy/MM/dd", "yyyy MMM d" }, new[] { "yyyy('e')'ko' MMMM d, dddd", "yyyy('e')'ko' MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy('e')'ko' MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x042e, new [] { new[] { "d.M.yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "H:mm 'hodź'." }, new[] { "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x042f, new [] { new[] { "dd.M.yyyy" }, new[] { "dddd, dd MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy 'г'." }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0430, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0431, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0432, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0433, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0434, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0435, new [] { new[] { "M/d/yyyy", "MMM d, yyyy" }, new[] { "dddd, MMMM d, yyyy", "MMMM d, yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0436, new [] { new[] { "yyyy-MM-dd", "dd MMM yyyy" }, new[] { "dddd, dd MMMM yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0437, new [] { new[] { "dd.MM.yyyy", "d MMM, yyyy" }, new[] { "dddd, dd MMMM, yyyy", "d MMMM, yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0438, new [] { new[] { "dd-MM-yyyy" }, new[] { "dddd dd MMMM yyyy", "d. MMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0439, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x043a, new [] { new[] { "dd/MM/yyyy", "dd MMM yyyy" }, new[] { "dddd, d 'ta'’ MMMM yyyy", "d 'ta'’ MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM 'ta'’ yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d 'ta'’ MMMM" } } },
			{ 0x043b, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x043d, new [] { new[] { "dd/MM/yyyy", "dטן MMM yyyy" }, new[] { "dddd, dטן MMMM yyyy", "dטן MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d בMMMM" } } },
			{ 0x043e, new [] { new[] { "d/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x043f, new [] { new[] { "dd/MM/yyyy", "yyyy, dd-MMM" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0440, new [] { new[] { "d-MMM yy" }, new[] { "dd-MMMM yyyy'-ж.'" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy'-ж.'" }, new[] { "-" }, new[] { ":" }, new[] { "d-MMMM" } } },
			{ 0x0441, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0442, new [] { new[] { "dd.MM.yy 'ý.'", "dd.MM.yyyy" }, new[] { "yyyy'-nji ýylyň 'd'-nji 'MMMM" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "yyyy 'ý.' MMMM" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0443, new [] { new[] { "yyyy/MM/dd", "yyyy MMM d" }, new[] { "dddd, yyyy MMMM dd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0444, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd", "dd MMMM yyyy' ел'" }, new[] { "dd MMMM yyyy' ел'" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy", "MMMM yyyy' ел'" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0445, new [] { new[] { "dd-MM-yy", "d-M-yy", "dd-MM-yyyy", "dd-MM-yy", "dd-MM-yyyy" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm", "H.mm", "tt hh.mm", "tt h.mm" }, new[] { "HH.mm.ss", "H.mm.ss", "tt hh.mm.ss", "tt h.mm.ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { "." }, new[] { "d MMMM" } } },
			{ 0x0446, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "tt hh:mm", "tt h:mm", "H:mm", "HH:mm" }, new[] { "tt hh:mm:ss", "tt h:mm:ss", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0447, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0448, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0449, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x044a, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x044b, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x044c, new [] { new[] { "dd-MM-yy", "d-M-yy", "dd.MM.yy", "d.M.yy" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm", "H.mm", "tt hh.mm", "tt h.mm" }, new[] { "HH.mm.ss", "H.mm.ss", "tt hh.mm.ss", "tt h.mm.ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { "." }, new[] { "MMMM dd" } } },
			{ 0x044d, new [] { new[] { "dd-MM-yyyy" }, new[] { "yyyy,MMMM dd, dddd" }, new[] { "tt h:mm", "tt hh:mm", "H:mm" }, new[] { "tt h:mm:ss", "tt hh:mm:ss", "H:mm:ss" }, new[] { "MMMM,yy", "MMMM,yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x044e, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x044f, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0450, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "dddd, yyyy 'оны' MM 'сарын' d", "yyyy 'оны' MM 'сарын' d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0451, new [] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd", "yy-M-d", "yy/M/d", "yy.M.d" }, new[] { "yyyy'ལོའི་ཟླ' M'ཚེས' d", "yyyy'ལོའི་ཟླ' M'ཚེས' d dddd", "yyyyལོའི་ཟླ MMM d", "yyyyལོའི་ཟླ MMM d dddd" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy'ལོའི་ཟླ་' M", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "ཟླ་Mཚེས་d" } } },
			{ 0x0452, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0453, new [] { new[] { "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "ddd d MMMM yyyy" }, new[] { "H:mm" }, new[] { "HH:mm:ss" }, new[] { "'ខែ' MM 'ឆ្នាំ' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0454, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd ທີ d MMMM gg yyyy", "d MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0455, new [] { new[] { "dd-MM-yyyy", "d MMM yyyy" }, new[] { "dddd၊ dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0456, new [] { new[] { "dd/MM/yyyy", "d MMM, yyyy" }, new[] { "dddd dd MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0457, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0458, new [] { new[] { "dd/MM/yyyy" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0459, new [] { new[] { "dd/MM/yyyy" }, new[] { "dd MMMM yyyy", "d MMMM yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x045a, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x045b, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "tt h.mm", "HH:mm" }, new[] { "tt h.mm.ss", "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { "." }, new[] { "MMMM d" } } },
			{ 0x045c, new [] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd,yyyy", "MMMM dd,yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x045d, new [] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd,MMMM dd,yyyy", "MMMM dd,yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM,yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x045e, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x045f, new [] { new[] { "d/M/yyyy", "dd/MM/yyyy" }, new[] { "dddd، d MMMM، yyyy", "d MMMM، yyyy" }, new[] { "H:mm", "h:mm tt" }, new[] { "HH:mm:ss", "h:mm:ss tt" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0460, new [] { new[] { "M/d/yyyy", "MMM d, yyyy" }, new[] { "dddd, MMMM d, yyyy", "MMMM d, yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0461, new [] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM,yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0462, new [] { new[] { "dd-MM-yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0463, new [] { new[] { "yyyy/M/d", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dddd d MMMM yyyy" }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0464, new [] { new[] { "M/d/yyyy", "MMM d, yyyy" }, new[] { "dddd, MMMM d, yyyy", "MMMM d, yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0465, new [] { new[] { "dd/MM/yy" }, new[] { "ddd, yyyy MMMM dd" }, new[] { "HH:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "hh:mm:ss tt" }, new[] { "yyyy, MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x0466, new [] { new[] { "d/M/yyyy" }, new[] { "dddd, MMMM dd, yyyy" }, new[] { "h:mmt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x0467, new [] { new[] { "d/M/yyyy", "dd/MM/yyyy" }, new[] { "dddd, MMMM dd, yyyy", "dddd d MMMM yyyy" }, new[] { "h:mmt", "H:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0468, new [] { new[] { "d/M/yyyy", "d MMM, yyyy" }, new[] { "dddd, d MMMM, yyyy", "d MMMM, yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0469, new [] { new[] { "d/M/yyyy" }, new[] { "dddd, MMMM dd, yyyy" }, new[] { "h:mmt", "H:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x046a, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x046b, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d 'de' MMMM" } } },
			{ 0x046c, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x046d, new [] { new[] { "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy 'й'" }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x046e, new [] { new[] { "dd.MM.yy", "dd/MM/yy", "dd-MM-yy" }, new[] { "d. MMMM yyyy", "dd. MMMMyyyy", "dddd, d. MMMM yyyy", "dddd, dd. MMMM yyyy", "dddd,' den 'd. MMMM yyyy", "dddd,' den 'dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm", "H.mm", "H.mm' Auer'" }, new[] { "HH:mm:ss", "H:mm:ss' Auer'", "HH:mm:ss' Auer'" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd. MMMM" } } },
			{ 0x046f, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd", "yyyy MM dd" }, new[] { "MMMM d'.-at, 'yyyy", "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d'.-at'" } } },
			{ 0x0470, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0471, new [] { new[] { "d/M/yyyy" }, new[] { "dddd, MMMM dd, yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x0472, new [] { new[] { "dd/MM/yyyy", "dd-MMM-yyyy" }, new[] { "dddd, MMMM d, yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0473, new [] { new[] { "dd/MM/yyyy", "dd-MMM-yyyy" }, new[] { "dddd፣ dd MMMM መዓልቲ yyyy gg", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0474, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd-MM-yyyy", "dd-MM-yy" }, new[] { "dddd, dd MMMM, yyyy", "dddd, d MMMM, yyyy", "dd/MMMM/yyyy", "d/MMMM/yyyy", "dd MMMM, yyyy", "d MMMM, yyyy" }, new[] { "HH:mm", "H:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "H:mm:ss", "hh:mm:ss tt" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0475, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0476, new [] { new[] { "dd/MM/yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "H:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x0477, new [] { new[] { "dd/MM/yyyy", "dd-MMM-yyyy" }, new[] { "dddd, MMMM dd, yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0478, new [] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd" }, new[] { "yyyy'ꈎ' M'ꆪ' d'ꑍ'", "dddd, yyyy'ꈎ' M'ꆪ' d'ꑍ'", "yyyy'ꈎ' M'ꆪ' d'ꑍ', dddd", "yyyyꈎ MMM dꑍ", "dddd, yyyyꈎ MMM dꑍ" }, new[] { "tt h:mm", "H:mm", "HH:mm" }, new[] { "tt h:mm:ss", "H:mm:ss", "HH:mm:ss" }, new[] { "yyyy'ꈎ' M'ꆪ'", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "M’ ꆪ’d’ ꑍ’" } } },
			{ 0x0479, new [] { new[] { "d-M-yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy", "d MMM yy", "d-MMM-yy" }, new[] { "H:mm", "HH:mm", "H.mm", "HH.mm' uur'", "HH:mm' uur'" }, new[] { "H:mm:ss", "HH:mm:ss", "H:mm", "H.mm", "HH.mm.ss' uur'", "HH:mm:ss' uur'" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x047a, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "dd/MM/yy", "d/M/yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d 'de' MMMM" } } },
			{ 0x047c, new [] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x047e, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0480, new [] { new[] { "yyyy-M-d", "yyyy.M.d", "yyyy-MM-dd", "yyyy.MM.dd" }, new[] { "yyyy-'يىل' d-MMMM", "yyyy-'يىل' d-MMMM dddd", "yyyy-'يىلى' MMM'نىڭ' d'-كۈنى'", "yyyy-'يىلى' MMM'نىڭ' d'-كۈنى' dddd", "yyyy-M-d dddd" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" }, new[] { "yyyy-'يىلى' MMMM", "yyyy MMMM", "yyyy.M" }, new[] { "-" }, new[] { ":" }, new[] { "d-MMMM" } } },
			{ 0x0481, new [] { new[] { "dd/MM/yyyy", "d/MM/yy", "dd/MM/yy", "d.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, dd MMMM, yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yy", "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0482, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy" }, new[] { "dddd d MMMM' de 'yyyy", "d MMMM' de 'yyyy" }, new[] { "HH' h 'mm" }, new[] { "HH.mm.ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { "." }, new[] { "d MMMM" } } },
			{ 0x0483, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM' di u 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d' di 'MMMM" } } },
			{ 0x0484, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0485, new [] { new[] { "dd.MM.yyyy", "d.M.yyyy", "yyyy-MM-dd", "yyyy MM d", "dd yyyy MM d" }, new[] { "dddd, yyyy 'с.' MMMM d 'күнэ'", "yyyy 'с.' MMMM d 'күнэ'", "dddd, MMMM d 'күнэ' yyyy 'с.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "yyyy 'с.' MMMM" }, new[] { "." }, new[] { ":" }, new[] { "MMMM d күнэ" } } },
			{ 0x0486, new [] { new[] { "dd/MM/yyyy", "d/MM/yyyy" }, new[] { "dddd, dd' rech 'MMMM' rech 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM' rech 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d' rech 'MMMM" } } },
			{ 0x0487, new [] { new[] { "yyyy/MM/dd", "yyyy MMM d" }, new[] { "dddd, yyyy MMMM dd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0488, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x048c, new [] { new[] { "yyyy/M/d", "yyyy-MM-dd" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "H:mm" }, new[] { "h:mm:ss tt", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0491, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d'mh' MMMM yyyy", "d'mh' MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d'mh' MMMM" } } },
			{ 0x0492, new [] { new[] { "yyyy/MM/dd" }, new[] { "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0801, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0803, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM 'de' yyyy", "d MMMM 'de' yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0804, new [] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy/MM/dd", "yyyy-MM-dd", "yyyy.MM.dd", "yy/M/d", "yy-M-d", "yy.M.d", "yy/MM/dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'M'月'd'日', dddd", "dddd, yyyy'年'M'月'd'日'", "yyyy年MMMd日", "yyyy年MMMd日, dddd" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" }, new[] { "yyyy'年'M'月'", "yyyy'年'MMM", "yyyy'年'MMMM", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "M月d日" } } },
			{ 0x0807, new [] { new[] { "dd.MM.yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd.MMMM." } } },
			{ 0x0809, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy", "dddd, d MMMM yyyy", "dddd, dd MMMM yyyy" }, new[] { "HH:mm", "H:mm", "hh:mm tt", "h:mm tt" }, new[] { "HH:mm:ss", "H:mm:ss", "hh:mm:ss tt", "h:mm:ss tt" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x080a, new [] { new[] { "dd/MM/yyyy", "dd/MMM/yyyy", "dd/MM/yy", "d/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d 'de' MMMM" } } },
			{ 0x080c, new [] { new[] { "dd-MM-yy", "dd/MM/yyyy", "dd/MM/yy", "dd-MM-yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0810, new [] { new[] { "dd.MM.yyyy", "d-MMM-yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM.yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd.MMMM" } } },
			{ 0x0813, new [] { new[] { "d/MM/yyyy", "d/MM/yy", "dd-MM-yy", "dd.MM.yy", "dd.MMM.yyyy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "dd-MMM-yy", "d MMMM yyyy", "dd MMM yy" }, new[] { "H:mm", "HH:mm", "H.mm' u.'" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0814, new [] { new[] { "dd.MM.yyyy", "d. MMM yyyy" }, new[] { "dddd d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0816, new [] { new[] { "dd/MM/yyyy", "dd.MM.yyyy", "dd-MM-yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy/MM/dd", "yyyy.MM.dd", "yyyy-MM-dd", "yy/MM/dd", "yy.MM.dd", "yy-MM-dd" }, new[] { "d' de 'MMMM' de 'yyyy", "dddd, d' de 'MMMM' de 'yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d 'de' MMMM" } } },
			{ 0x0818, new [] { new[] { "dd.MM.yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0819, new [] { new[] { "dd.MM.yyyy", "d MMM yyyy 'г'." }, new[] { "dddd, d MMMM yyyy 'г'.", "d MMMM yyyy 'г'." }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd.MMMM" } } },
			{ 0x081d, new [] { new[] { "dd-MM-yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0820, new [] { new[] { "d/M/yy", "d MMM, yyyy" }, new[] { "dddd, d MMMM, yyyy", "d MMMM, yyyy" }, new[] { "h:mm tt", "H:mm" }, new[] { "h:mm:ss tt", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x082c, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x082e, new [] { new[] { "d. M. yyyy", "d. M. yy", "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. M. yyyy" }, new[] { "HH:mm", "H:mm", "H:mm' góź.'", "'zeger 'H:mm" }, new[] { "HH:mm:ss", "H:mm:ss' góź.'", "'zeger 'H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { ". " }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x0832, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x083b, new [] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "dddd, MMMM d'. b. 'yyyy", "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d'. b.'" } } },
			{ 0x083c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x083e, new [] { new[] { "d/MM/yyyy", "d MMM yyyy" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0843, new [] { new[] { "yyyy/MM/dd", "yyyy MMM d" }, new[] { "dddd, yyyy MMMM dd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0845, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm", "H.mm", "tt hh.mm", "tt h.mm" }, new[] { "HH.mm.ss", "H.mm.ss", "tt hh.mm.ss", "tt h.mm.ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { "." }, new[] { "dd MMMM" } } },
			{ 0x0846, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "h.mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h.mm.ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { "." }, new[] { "dd MMMM" } } },
			{ 0x0849, new [] { new[] { "d-M-yyyy", "d MMM, yyyy" }, new[] { "dddd, d MMMM, yyyy", "d MMMM, yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0850, new [] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd", "yy-M-d", "yy/M/d", "yy.M.d", "yy/MM/dd" }, new[] { "yyyyᠣᠨ MMMM dᠡᠳᠦᠷ᠂ dddd", "yyyyᠣᠨ MMMM dᠡᠳᠦᠷ" }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "yyyyᠣᠨ MMMM", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dᠡᠳᠦᠷ" } } },
			{ 0x0859, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dddd, dd MMMM, yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x085d, new [] { new[] { "d/MM/yyyy", "d/M/yy", "yy-MM-dd", "dd/MM/yyyy", "yy-MM-dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, dd MMMM, yyyy", "ddd, MMMM dd,yyyy", "MMMM dd,yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x085f, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0860, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dddd, MMMM dd, yyyy" }, new[] { "H:mm", "h:mmt" }, new[] { "HH:mm:ss", "H:mm:ss", "h.mm.ss tt", "hh:mm:ss tt" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0861, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "yyyy MMMM d, dddd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x0867, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x086b, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d 'de' MMMM" } } },
			{ 0x0873, new [] { new[] { "dd/MM/yyyy", "dd-MMM-yyyy" }, new[] { "dddd፡ dd MMMM መዓልቲ yyyy gg", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0c01, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x0c04, new [] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/M/d", "yy/MM/dd", "yyyy/M/d", "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'", "yyyy年MMMd日", "yyyy年MMMd日, dddd" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "yyyy'年'M'月'", "yyyy'年'MMM", "yyyy'年'MMMM", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "M月d日" } } },
			{ 0x0c07, new [] { new[] { "dd.MM.yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd.MMMM." } } },
			{ 0x0c09, new [] { new[] { "d/MM/yyyy", "d/MM/yy", "d/M/yy", "d/M/yyyy", "dd/MM/yy", "dd/MM/yyyy", "dd-MMM-yy", "dd-MMMM-yyyy", "yyyy-MM-dd", "yy/MM/dd", "yyyy/MM/dd" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0c0a, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yy", "d/M/yy", "d-M-yy", "dd-MM-yy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, d' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm", "H.mm", "HH.mm", "HH'H'mm" }, new[] { "H:mm:ss", "HH:mm:ss", "H.mm.ss", "HH.mm.ss", "HH'H'mm.ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d 'de' MMMM" } } },
			{ 0x0c0c, new [] { new[] { "yyyy-MM-dd", "yy-MM-dd", "dd-MM-yy", "yy MM dd", "dd/MM/yy", "dd/MMM/yyyy" }, new[] { "d MMMM yyyy", "d MMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x0c3b, new [] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dddd', 'MMMM d'. b. 'yyyy", "MMMM d'. b. 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "MMMM d'. b.'" } } },
			{ 0x0c50, new [] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd", "yy-M-d", "yy/M/d", "yy.M.d", "yy/MM/dd" }, new[] { "yyyyᠣᠨ MMMM dᠡᠳᠦᠷ᠂ dddd", "yyyyᠣᠨ MMMM dᠡᠳᠦᠷ" }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "yyyyᠣᠨ MMMM", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dᠡᠳᠦᠷ" } } },
			{ 0x0c51, new [] { new[] { "yyyy-MM-dd", "སྤྱི་ལོ་yyyy ཟླ་MMM ཚེས་dd" }, new[] { "dddd, སྤྱི་ལོ་yyyy MMMM ཚེས་dd", "སྤྱི་ལོ་yyyy MMMM ཚེས་ dd" }, new[] { "ཆུ་ཚོད་ h སྐར་མ་ mm tt", "HH:mm" }, new[] { "ཆུ་ཚོད་h:mm:ss tt", "HH:mm:ss" }, new[] { "yyyy སྤྱི་ཟླ་MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "སྤྱི་MMMM ཚེ་d" } } },
			{ 0x0c6b, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, d MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x1000, new [] { new[] { "dd/MM/yyyy", "dd-MMM-yyyy" }, new[] { "dddd, MMMM dd, yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x1001, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x1004, new [] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/M/d", "yy/MM/dd", "yyyy/M/d", "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'", "yyyy年MMMd日", "dddd yyyy年MMMd日" }, new[] { "tt h:mm", "tt hh:mm", "H:mm", "HH:mm" }, new[] { "tt h:mm:ss", "tt hh:mm:ss", "H:mm:ss", "HH:mm:ss" }, new[] { "yyyy'年'M'月'", "yyyy'年'MMM", "yyyy'年'MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "M月d日" } } },
			{ 0x1007, new [] { new[] { "dd.MM.yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd.MMMM." } } },
			{ 0x1009, new [] { new[] { "yyyy-MM-dd", "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "yy-MM-dd", "M/dd/yy", "dd-MMM-yy", "dd-MMM-yyyy", "yyyy-MM-dd" }, new[] { "MMMM d, yyyy", "dddd, MMMM dd, yyyy", "MMMM-dd-yy", "d-MMM-yy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x100a, new [] { new[] { "d/MM/yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x100c, new [] { new[] { "dd.MM.yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM.yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd.MMMM" } } },
			{ 0x101a, new [] { new[] { "dd.MM.yyyy.", "d. MMM yyyy." }, new[] { "dddd, d. MMMM yyyy.", "d. MMMM yyyy." }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x103b, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dddd, MMMM d'. b. 'yyyy", "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm" }, new[] { "HH:mm:ss", "H:mm:ss", "HH.mm.ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "MMMM d'. b.'" } } },
			{ 0x105f, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd", "dd.MMM.yyyy" }, new[] { "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy", "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x1401, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "hh:mm:ss tt" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x1404, new [] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/M/d", "yy/MM/dd", "yyyy/M/d", "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "dddd yyyy'年'M'月'd'日'", "dddd yyyy MM dd", "yyyy MM dd", "yyyy年MMMd日", "dddd yyyy年MMMd日" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "yyyy'年'M'月'", "yyyy'年'MMM", "yyyy'年'MMMM", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "M月d日" } } },
			{ 0x1407, new [] { new[] { "dd.MM.yyyy" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd.MMMM." } } },
			{ 0x1409, new [] { new[] { "d/MM/yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d/MMMM" } } },
			{ 0x140a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x140c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x141a, new [] { new[] { "dd.MM.yyyy.", "dd. MMM. yyyy." }, new[] { "dddd, dd. MMMM yyyy.", "dd. MMMM yyyy." }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x143b, new [] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "dddd, MMMM d'. b. 'yyyy", "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d'. b.'" } } },
			{ 0x1801, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "hh:mm:ss tt" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x1809, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "h:mm tt" }, new[] { "HH:mm:ss", "h:mm:ss tt" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d/MMMM" } } },
			{ 0x180a, new [] { new[] { "MM/dd/yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM/dd" } } },
			{ 0x180c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x181a, new [] { new[] { "d.M.yyyy.", "dd.MM.yyyy." }, new[] { "dddd, dd. MMMM yyyy.", "dd. MMMM yyyy." }, new[] { "HH:mm", "HH.mm" }, new[] { "HH:mm:ss", "HH.mm.ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x183b, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dddd, MMMM d'. b. 'yyyy", "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "MMMM d'. b.'" } } },
			{ 0x1c01, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "hh:mm:ss tt" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x1c09, new [] { new[] { "yyyy/MM/dd", "dd MMM yyyy" }, new[] { "dddd, dd MMMM yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x1c0a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x1c0c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x1c1a, new [] { new[] { "d.M.yyyy.", "dd.MM.yyyy." }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x1c3b, new [] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "dddd, MMMM d'. b. 'yyyy", "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d'. b.'" } } },
			{ 0x2001, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x2009, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d/MMMM" } } },
			{ 0x200a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x200c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x201a, new [] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "." }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x203b, new [] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. p. 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "MMMM d'. p. '" } } },
			{ 0x2401, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x2409, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yy", "d/M/yyyy", "dd/M/yy", "d/MM/yyyy", "d/M/yy" }, new[] { "dddd, dd MMMM yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy", "dddd, d MMMM yyyy", "d MMMM yyyy", "dddd d MMMM yyyy", "d MMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "hh:mm tt", "h:mm tt" }, new[] { "HH:mm:ss", "H:mm:ss", "HH.mm.ss", "H.mm.ss", "hh:mm:ss tt", "h:mm:ss tt" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x240a, new [] { new[] { "d/MM/yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x240c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x241a, new [] { new[] { "d.M.yyyy.", "dd.MM.yyyy." }, new[] { "dddd, dd. MMMM yyyy.", "dd. MMMM yyyy." }, new[] { "HH.mm" }, new[] { "HH.mm.ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { "." }, new[] { "d. MMMM" } } },
			{ 0x243b, new [] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. p. 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "MMMM d'. p. '" } } },
			{ 0x2801, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x2809, new [] { new[] { "dd/MM/yyyy", "dd-MMM-yyyy" }, new[] { "dddd, dd MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x280a, new [] { new[] { "d/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x280c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x281a, new [] { new[] { "dd.MM.yyyy." }, new[] { "d. MMMM yyyy.", "dd. MMMM yyyy.", "dddd, d. MMMM yyyy." }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x2c01, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x2c09, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x2c0a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM-yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x2c0c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x2c1a, new [] { new[] { "d.M.yyyy.", "dd.MM.yyyy." }, new[] { "dddd, dd. MMMM yyyy.", "dd. MMMM yyyy." }, new[] { "HH.mm" }, new[] { "HH.mm.ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { "." }, new[] { "d. MMMM" } } },
			{ 0x3001, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x3009, new [] { new[] { "d/M/yyyy", "dd MMM,yyyy" }, new[] { "dddd, dd MMMM yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x300a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x300c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x301a, new [] { new[] { "d.M.yyyy.", "d.M.yy.", "d. M. yyyy.", "dd.MM.yyyy.", "d. M. yy.", "dd.MM.yy.", "dd. MM. yy.", "yyyy-MM-dd." }, new[] { "d. MMMM yyyy.", "dd. MMMM yyyy.", "dddd, d. MMMM yyyy." }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x3401, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x3409, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x340a, new [] { new[] { "dd-MM-yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM-yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x340c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x3801, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x3809, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy" }, new[] { "dd MMMM yyyy", "dddd, dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x380a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm tt", "h:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "hh:mm:ss tt", "h:mm:ss tt" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x380c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x3c01, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x3c09, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d/MMMM" } } },
			{ 0x3c0a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x3c0c, new [] { new[] { "dd/MM/yyyy", "d MMM yyyy" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x4001, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x4009, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "H:mm:ss", "h.mm.ss tt", "hh:mm:ss tt" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x400a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x4409, new [] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dddd, d MMMM, yyyy", "d MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy", "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x440a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x4809, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x480a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd dd 'de' MMMM 'de' yyyy", "dd 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x4c0a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x500a, new [] { new[] { "MM/dd/yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM/yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM/dd" } } },
			{ 0x540a, new [] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM' de 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x580a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x5c0a, new [] { new[] { "d/M/yyyy", "d MMM yyyy" }, new[] { "dddd, d 'de' MMMM 'de' yyyy", "d 'de' MMMM 'de' yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM 'de' yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd-MMMM" } } },
			{ 0x641a, new [] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "." }, new[] { ":" }, new[] { "MMMM dd" } } },
			{ 0x681a, new [] { new[] { "dd.MM.yyyy.", "dd. MMM. yyyy." }, new[] { "dddd, dd. MMMM yyyy.", "dd. MMMM yyyy." }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x6c1a, new [] { new[] { "dd.MM.yyyy." }, new[] { "d. MMMM yyyy.", "dd. MMMM yyyy.", "dddd, d. MMMM yyyy." }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x701a, new [] { new[] { "d.M.yyyy.", "dd.MM.yyyy." }, new[] { "dddd, dd. MMMM yyyy.", "dd. MMMM yyyy." }, new[] { "HH.mm" }, new[] { "HH.mm.ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { "." }, new[] { "d. MMMM" } } },
			{ 0x703b, new [] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. p. 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "MMMM d'. p. '" } } },
			{ 0x742c, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x743b, new [] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. p. 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "MMMM d'. p. '" } } },
			{ 0x7804, new [] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy/MM/dd", "yyyy-MM-dd", "yyyy.MM.dd", "yy/M/d", "yy-M-d", "yy.M.d", "yy/MM/dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'M'月'd'日', dddd", "dddd, yyyy'年'M'月'd'日'", "yyyy年MMMd日", "yyyy年MMMd日, dddd" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" }, new[] { "yyyy'年'M'月'", "yyyy'年'MMM", "yyyy'年'MMMM", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "M月d日" } } },
			{ 0x7814, new [] { new[] { "dd.MM.yyyy", "d. MMM yyyy" }, new[] { "dddd d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x781a, new [] { new[] { "dd.MM.yyyy.", "dd. MMM. yyyy." }, new[] { "dddd, dd. MMMM yyyy.", "dd. MMMM yyyy." }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x782c, new [] { new[] { "dd.MM.yyyy", "d MMM yyyy" }, new[] { "d MMMM yyyy, dddd", "d MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x783b, new [] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "dddd, MMMM d'. b. 'yyyy", "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d'. b.'" } } },
			{ 0x7843, new [] { new[] { "yyyy/MM/dd", "yyyy MMM d" }, new[] { "dddd, yyyy MMMM dd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x7850, new [] { new[] { "yyyy-MM-dd", "yyyy MMM d" }, new[] { "dddd, yyyy 'оны' MM 'сарын' d", "yyyy 'оны' MM 'сарын' d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x785d, new [] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd,MMMM dd,yyyy", "MMMM dd,yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM,yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x785f, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd", "dd.MMM.yyyy" }, new[] { "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy", "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x7c04, new [] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/M/d", "yy/MM/dd", "yyyy/M/d", "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'", "yyyy年MMMd日", "yyyy年MMMd日, dddd" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "yyyy'年'M'月'", "yyyy'年'MMM", "yyyy'年'MMMM", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "M月d日" } } },
			{ 0x7c14, new [] { new[] { "dd.MM.yyyy", "d. MMM yyyy" }, new[] { "dddd d. MMMM yyyy", "d. MMMM yyyy" }, new[] { "HH.mm" }, new[] { "HH.mm.ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { "." }, new[] { "d.MMMM." } } },
			{ 0x7c1a, new [] { new[] { "d.M.yyyy.", "dd.MM.yyyy." }, new[] { "dddd, dd. MMMM yyyy.", "dd. MMMM yyyy." }, new[] { "HH.mm" }, new[] { "HH.mm.ss" }, new[] { "MMMM yyyy." }, new[] { "." }, new[] { "." }, new[] { "d. MMMM" } } },
			{ 0x7c28, new [] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd-MM-yyyy", "dd/MM/yy" }, new[] { "d MMMM yyyy' с.'", "dd MMMM yyyy' с.'" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "." }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x7c2e, new [] { new[] { "d. M. yyyy", "d. M. yy", "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. M. yyyy" }, new[] { "HH:mm", "H:mm", "H:mm' góź.'", "'zeger 'H:mm" }, new[] { "HH:mm:ss", "H:mm:ss' góź.'", "'zeger 'H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { ". " }, new[] { ":" }, new[] { "d. MMMM" } } },
			{ 0x7c3b, new [] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "dddd, MMMM d'. b. 'yyyy", "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "MMMM d'. b.'" } } },
			{ 0x7c43, new [] { new[] { "yyyy/MM/dd", "yyyy MMM d" }, new[] { "dddd, yyyy MMMM dd", "yyyy MMMM d" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "yyyy MMMM" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x7c46, new [] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "h.mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h.mm.ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { "." }, new[] { "dd MMMM" } } },
			{ 0x7c50, new [] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd", "yy-M-d", "yy/M/d", "yy.M.d", "yy/MM/dd" }, new[] { "yyyyᠣᠨ MMMM dᠡᠳᠦᠷ᠂ dddd", "yyyyᠣᠨ MMMM dᠡᠳᠦᠷ" }, new[] { "H:mm" }, new[] { "H:mm:ss" }, new[] { "yyyyᠣᠨ MMMM", "yyyy.M" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM dᠡᠳᠦᠷ" } } },
			{ 0x7c59, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dddd, dd MMMM, yyyy", "dd MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x7c5c, new [] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd,yyyy", "MMMM dd,yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x7c5d, new [] { new[] { "d/MM/yyyy", "d/M/yy", "yy-MM-dd", "dd/MM/yyyy", "yy-MM-dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, dd MMMM, yyyy", "ddd, MMMM dd,yyyy", "MMMM dd,yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x7c5f, new [] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "-" }, new[] { ":" }, new[] { "d MMMM" } } },
			{ 0x7c67, new [] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm" }, new[] { "HH:mm:ss", "H:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "dd MMMM" } } },
			{ 0x7c68, new [] { new[] { "d/M/yyyy", "d MMM, yyyy" }, new[] { "dddd, d MMMM, yyyy", "d MMMM, yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" }, new[] { "MMMM yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "MMMM d" } } },
			{ 0x7c86, new [] { new[] { "dd/MM/yyyy", "d/MM/yyyy" }, new[] { "dddd, dd' rech 'MMMM' rech 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "h:mm tt", "HH:mm" }, new[] { "h:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM' rech 'yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d' rech 'MMMM" } } },
			{ 0x7c92, new [] { new[] { "yyyy/MM/dd" }, new[] { "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" }, new[] { "MMMM, yyyy" }, new[] { "/" }, new[] { ":" }, new[] { "d MMMM" } } },
		};

		static readonly Dictionary<int, string[][]> GroupSizes = new Dictionary<int, string[][]> {
			{ 0x0028, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0039, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0045, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0046, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0047, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0048, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0049, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004a, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004b, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004c, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004d, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004e, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004f, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0051, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0053, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0054, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0057, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x005b, new [] { new [] { "3" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x005d, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x005e, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0061, new [] { new [] { "3" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x006d, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x006f, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0078, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x007c, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0428, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0439, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0445, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0446, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0447, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0448, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0449, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044a, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044b, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044c, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044d, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044e, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044f, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0451, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0453, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0454, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0457, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x045b, new [] { new [] { "3" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x045d, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x045e, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0461, new [] { new [] { "3" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x046d, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x046f, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0478, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x047c, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0845, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0850, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x085d, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x4009, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x540a, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x785d, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x7c28, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x7c50, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x7c5d, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
		};

		static readonly Dictionary<int, string[]> Text = new Dictionary<int, string[]> {
			{ 0x0001, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0002, new [] { "1251", "21025", "0", ";", "10007", "866" } },
			{ 0x0003, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0004, new [] { "936", "500", "0", ",", "10008", "936" } },
			{ 0x0005, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x0006, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0007, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0008, new [] { "1253", "20273", "0", ";", "10006", "737" } },
			{ 0x0009, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x000a, new [] { "1252", "20284", "0", ";", "10000", "850" } },
			{ 0x000b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x000c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x000d, new [] { "1255", "500", "1", ",", "10005", "862" } },
			{ 0x000e, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x000f, new [] { "1252", "20871", "0", ";", "10079", "850" } },
			{ 0x0010, new [] { "1252", "20280", "0", ";", "10000", "850" } },
			{ 0x0011, new [] { "932", "20290", "0", ",", "10001", "932" } },
			{ 0x0012, new [] { "949", "20833", "0", ",", "10003", "949" } },
			{ 0x0013, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0014, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0015, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0016, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0017, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0018, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0019, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x001a, new [] { "1250", "500", "0", ";", "10082", "852" } },
			{ 0x001b, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x001c, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x001d, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x001e, new [] { "874", "20838", "0", ",", "10021", "874" } },
			{ 0x001f, new [] { "1254", "20905", "0", ";", "10081", "857" } },
			{ 0x0020, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0021, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0022, new [] { "1251", "500", "0", ";", "10017", "866" } },
			{ 0x0023, new [] { "1251", "500", "0", ";", "10007", "866" } },
			{ 0x0024, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0025, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0026, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0027, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0028, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0029, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x002a, new [] { "1258", "500", "0", ",", "10000", "1258" } },
			{ 0x002b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x002c, new [] { "1254", "20905", "0", ";", "10081", "857" } },
			{ 0x002d, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x002e, new [] { "1252", "870", "0", ";", "10000", "850" } },
			{ 0x002f, new [] { "1251", "500", "0", ";", "10007", "866" } },
			{ 0x0032, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0034, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0035, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0036, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0037, new [] { "0", "500", "0", ";", "2", "1" } },
			{ 0x0038, new [] { "1252", "20277", "0", ";", "10079", "850" } },
			{ 0x0039, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x003a, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x003b, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x003c, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x003e, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x003f, new [] { "0", "500", "0", ";", "2", "1" } },
			{ 0x0040, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0041, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x0042, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0043, new [] { "1254", "500", "0", ";", "10029", "857" } },
			{ 0x0044, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0045, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0046, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0047, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0048, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0049, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004a, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004c, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004d, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004e, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004f, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0050, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0051, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0052, new [] { "1252", "20285", "0", ",", "10000", "850" } },
			{ 0x0053, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0054, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0056, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0057, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x005a, new [] { "0", "500", "1", ",", "2", "1" } },
			{ 0x005b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x005d, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x005e, new [] { "0", "500", "0", "á£", "2", "1" } },
			{ 0x005f, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0061, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0062, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0063, new [] { "0", "500", "1", ";", "2", "1" } },
			{ 0x0064, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x0065, new [] { "0", "500", "1", "ØŒ", "2", "1" } },
			{ 0x0068, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x006a, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x006b, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x006c, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x006d, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x006e, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x006f, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0070, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x0078, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x007a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x007c, new [] { "1252", "37", "0", ",", "10000", "850" } },
			{ 0x007e, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x007f, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x0080, new [] { "1256", "20420", "1", ",", "10004", "720" } },
			{ 0x0081, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0082, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0083, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0084, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0085, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0086, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x0087, new [] { "1252", "37", "0", ";", "10000", "437" } },
			{ 0x0088, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x008c, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0091, new [] { "1252", "20285", "0", ",", "10000", "850" } },
			{ 0x0401, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0402, new [] { "1251", "21025", "0", ";", "10007", "866" } },
			{ 0x0403, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0404, new [] { "950", "500", "0", ",", "10002", "950" } },
			{ 0x0405, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x0406, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0407, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0408, new [] { "1253", "20273", "0", ";", "10006", "737" } },
			{ 0x0409, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x040b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x040c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x040d, new [] { "1255", "500", "1", ",", "10005", "862" } },
			{ 0x040e, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x040f, new [] { "1252", "20871", "0", ";", "10079", "850" } },
			{ 0x0410, new [] { "1252", "20280", "0", ";", "10000", "850" } },
			{ 0x0411, new [] { "932", "20290", "0", ",", "10001", "932" } },
			{ 0x0412, new [] { "949", "20833", "0", ",", "10003", "949" } },
			{ 0x0413, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0414, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0415, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0416, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0417, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0418, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0419, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x041a, new [] { "1250", "500", "0", ";", "10082", "852" } },
			{ 0x041b, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x041c, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x041d, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x041e, new [] { "874", "20838", "0", ",", "10021", "874" } },
			{ 0x041f, new [] { "1254", "20905", "0", ";", "10081", "857" } },
			{ 0x0420, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0421, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0422, new [] { "1251", "500", "0", ";", "10017", "866" } },
			{ 0x0423, new [] { "1251", "500", "0", ";", "10007", "866" } },
			{ 0x0424, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0425, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0426, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0427, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0428, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0429, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x042a, new [] { "1258", "500", "0", ",", "10000", "1258" } },
			{ 0x042b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x042c, new [] { "1254", "20905", "0", ";", "10081", "857" } },
			{ 0x042d, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x042e, new [] { "1252", "870", "0", ";", "10000", "850" } },
			{ 0x042f, new [] { "1251", "500", "0", ";", "10007", "866" } },
			{ 0x0432, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0434, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0435, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0436, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0437, new [] { "0", "500", "0", ";", "2", "1" } },
			{ 0x0438, new [] { "1252", "20277", "0", ";", "10079", "850" } },
			{ 0x0439, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x043a, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x043b, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x043e, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x043f, new [] { "0", "500", "0", ";", "2", "1" } },
			{ 0x0440, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0441, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x0442, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0443, new [] { "1254", "500", "0", ";", "10029", "857" } },
			{ 0x0444, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0445, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0446, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0447, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0448, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0449, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044a, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044c, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044d, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044e, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044f, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0450, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0451, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0452, new [] { "1252", "20285", "0", ",", "10000", "850" } },
			{ 0x0453, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0454, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0456, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0457, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x045a, new [] { "0", "500", "1", ",", "2", "1" } },
			{ 0x045b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x045d, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x045e, new [] { "0", "500", "0", "á£", "2", "1" } },
			{ 0x0461, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0462, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0463, new [] { "0", "500", "1", ";", "2", "1" } },
			{ 0x0464, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x0465, new [] { "0", "500", "1", "ØŒ", "2", "1" } },
			{ 0x0468, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x046a, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x046b, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x046c, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x046d, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x046e, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x046f, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0470, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x0478, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x047a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x047c, new [] { "1252", "37", "0", ",", "10000", "850" } },
			{ 0x047e, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0480, new [] { "1256", "20420", "1", ",", "10004", "720" } },
			{ 0x0481, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0482, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0483, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0484, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0485, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0486, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x0487, new [] { "1252", "37", "0", ";", "10000", "437" } },
			{ 0x0488, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x048c, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0491, new [] { "1252", "20285", "0", ",", "10000", "850" } },
			{ 0x0801, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0804, new [] { "936", "500", "0", ",", "10008", "936" } },
			{ 0x0807, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0809, new [] { "1252", "20285", "0", ",", "10000", "850" } },
			{ 0x080a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x080c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0810, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0813, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0814, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0816, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x081a, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x081d, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x082c, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x082e, new [] { "1252", "870", "0", ";", "10000", "850" } },
			{ 0x083b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x083c, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x083e, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0843, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0845, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0850, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x085d, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x085f, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x086b, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x0c01, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0c04, new [] { "950", "500", "0", ",", "10002", "950" } },
			{ 0x0c07, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0c09, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0c0a, new [] { "1252", "20284", "0", ";", "10000", "850" } },
			{ 0x0c0c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0c1a, new [] { "1251", "21025", "0", ";", "10007", "855" } },
			{ 0x0c3b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x0c6b, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x1001, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x1004, new [] { "936", "500", "0", ",", "10008", "936" } },
			{ 0x1007, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x1009, new [] { "1252", "37", "0", ",", "10000", "850" } },
			{ 0x100a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x100c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x101a, new [] { "1250", "870", "0", ";", "10082", "852" } },
			{ 0x103b, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x1401, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x1404, new [] { "950", "500", "0", ",", "10002", "950" } },
			{ 0x1407, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x1409, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x140a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x140c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x141a, new [] { "1250", "870", "0", ";", "10082", "852" } },
			{ 0x143b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x1801, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x1809, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x180a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x180c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x181a, new [] { "1250", "870", "0", ";", "10082", "852" } },
			{ 0x183b, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x1c01, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x1c09, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x1c0a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x1c1a, new [] { "1251", "21025", "0", ";", "10007", "855" } },
			{ 0x1c3b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x2001, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x2009, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x200a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x201a, new [] { "1251", "870", "0", ";", "10082", "855" } },
			{ 0x203b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x2401, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x2409, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x240a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x241a, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x243b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x2801, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x2809, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x280a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x281a, new [] { "1251", "21025", "0", ";", "10007", "855" } },
			{ 0x2c01, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x2c09, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x2c0a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x2c1a, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x3001, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x3009, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x300a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x301a, new [] { "1251", "21025", "0", ";", "10007", "855" } },
			{ 0x3401, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x3409, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x340a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x3801, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x380a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x3c01, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x3c0a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x4001, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x4009, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x400a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x4409, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x440a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x4809, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x480a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x4c0a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x500a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x540a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x641a, new [] { "1251", "870", "0", ";", "10082", "855" } },
			{ 0x681a, new [] { "1250", "870", "0", ";", "10082", "852" } },
			{ 0x6c1a, new [] { "1251", "21025", "0", ";", "10007", "855" } },
			{ 0x701a, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x703b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x742c, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x743b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x7804, new [] { "936", "500", "0", ",", "10008", "936" } },
			{ 0x7814, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x781a, new [] { "1250", "870", "0", ";", "10082", "852" } },
			{ 0x782c, new [] { "1254", "20905", "0", ";", "10081", "857" } },
			{ 0x783b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x7843, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x7850, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x785d, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x7c04, new [] { "950", "500", "0", ",", "10002", "950" } },
			{ 0x7c14, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x7c1a, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x7c28, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x7c2e, new [] { "1252", "870", "0", ";", "10000", "850" } },
			{ 0x7c3b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x7c43, new [] { "1254", "500", "0", ";", "10029", "857" } },
			{ 0x7c50, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x7c5d, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x7c5f, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x7c68, new [] { "1252", "37", "0", ",", "10000", "437" } },
		};

		static readonly Dictionary<int, string[]> Numbers = new Dictionary<int, string[]> {
			{ 0x0001, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x0002, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0003, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x0004, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0005, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0006, new [] { "12", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x0007, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0008, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x0009, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x000A, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x000B, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x000C, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x000D, new [] { "2", "2", "1", "1", "1", ".", ",", "." } },
			{ 0x000E, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x000F, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x0010, new [] { "9", "2", "1", "1", "1", ",", ".", "," } },
			{ 0x0011, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0012, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0013, new [] { "12", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x0014, new [] { "12", "2", "1", "0", "0", ",", " ", "," } },
			{ 0x0015, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0016, new [] { "9", "2", "1", "1", "1", ",", ".", "," } },
			{ 0x0017, new [] { "2", "2", "1", "1", "1", ".", " ", "." } },
			{ 0x0018, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x0019, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x001A, new [] { "8", "3", "2", "1", "1", ",", ".", "," } },
			{ 0x001B, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x001C, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x001D, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x001E, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x001F, new [] { "8", "3", "1", "2", "2", ",", ".", "," } },
			{ 0x0020, new [] { "3", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0021, new [] { "0", "0", "1", "1", "1", ",", ".", "," } },
			{ 0x0022, new [] { "5", "1", "1", "1", "1", ",", " ", "," } },
			{ 0x0023, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0024, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0025, new [] { "8", "3", "1", "1", "1", ".", " ", "," } },
			{ 0x0026, new [] { "9", "2", "1", "1", "1", ",", " ", "," } },
			{ 0x0027, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0028, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0029, new [] { "3", "0", "3", "0", "0", "/", ",", "/" } },
			{ 0x002A, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x002B, new [] { "8", "3", "1", "0", "0", ".", ",", "." } },
			{ 0x002C, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x002D, new [] { "8", "3", "1", "10", "3", ",", ".", "," } },
			{ 0x002E, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x002F, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0030, new [] { "1", "0", "1", "1", "2", ",", " ", "," } },
			{ 0x0031, new [] { "1", "0", "1", "1", "2", ",", " ", "," } },
			{ 0x0032, new [] { "2", "2", "1", "2", "2", ".", ",", "." } },
			{ 0x0034, new [] { "2", "2", "1", "2", "2", ".", ",", "." } },
			{ 0x0035, new [] { "2", "2", "1", "2", "2", ".", ",", "." } },
			{ 0x0036, new [] { "2", "2", "1", "1", "1", ",", " ", "," } },
			{ 0x0037, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0038, new [] { "12", "2", "1", "1", "1", ",", ".", "," } },
			{ 0x0039, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x003A, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x003B, new [] { "12", "2", "1", "2", "2", ",", " ", "," } },
			{ 0x003C, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x003E, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x003F, new [] { "1", "0", "1", "1", "1", "-", " ", "," } },
			{ 0x0040, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0041, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0042, new [] { "5", "1", "1", "1", "1", ",", " ", "," } },
			{ 0x0043, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0044, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0045, new [] { "12", "2", "1", "1", "0", ".", ",", "." } },
			{ 0x0046, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x0047, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x0048, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x0049, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x004A, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x004B, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x004C, new [] { "12", "2", "1", "2", "2", ".", ",", "." } },
			{ 0x004D, new [] { "12", "2", "1", "1", "1", ".", ",", "." } },
			{ 0x004E, new [] { "12", "2", "1", "0", "0", "`", ",", "." } },
			{ 0x004F, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x0050, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0051, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0052, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0053, new [] { "5", "1", "2", "1", "1", ".", ",", "." } },
			{ 0x0054, new [] { "8", "3", "1", "0", "0", ".", ",", "." } },
			{ 0x0055, new [] { "9", "3", "1", "1", "1", ".", ",", "." } },
			{ 0x0056, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0057, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x0059, new [] { "9", "2", "3", "0", "3", ".", ",", "." } },
			{ 0x005A, new [] { "8", "3", "1", "0", "0", ".", ",", "." } },
			{ 0x005B, new [] { "14", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x005C, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x005D, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x005E, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x005F, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0061, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0062, new [] { "12", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x0063, new [] { "3", "0", "3", "4", "2", ".", ",", "." } },
			{ 0x0064, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0065, new [] { "10", "3", "1", "0", "0", ".", ",", "." } },
			{ 0x0067, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0068, new [] { "2", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x006A, new [] { "9", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x006B, new [] { "14", "2", "1", "2", "2", ",", ".", "," } },
			{ 0x006C, new [] { "2", "2", "1", "2", "2", ".", ",", "." } },
			{ 0x006D, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x006E, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x006F, new [] { "12", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x0070, new [] { "2", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x0072, new [] { "1", "0", "1", "1", "2", ".", ",", "." } },
			{ 0x0073, new [] { "1", "1", "1", "1", "1", ".", ",", "." } },
			{ 0x0074, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0075, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0077, new [] { "1", "0", "1", "1", "2", ".", ",", "." } },
			{ 0x0078, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x007A, new [] { "9", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x007C, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x007E, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0080, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0081, new [] { "1", "0", "1", "2", "2", ".", ",", "." } },
			{ 0x0082, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0083, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0084, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0085, new [] { "5", "1", "1", "1", "1", ",", " ", "," } },
			{ 0x0086, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0087, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0088, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x008C, new [] { "3", "0", "3", "4", "2", ".", ",", "," } },
			{ 0x0091, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0092, new [] { "2", "0", "1", "2", "2", ".", ",", "." } },
			{ 0x0401, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x0402, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0403, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x0404, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0405, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0406, new [] { "12", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x0407, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0408, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x0409, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x040B, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x040C, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x040D, new [] { "2", "2", "1", "1", "1", ".", ",", "." } },
			{ 0x040E, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x040F, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x0410, new [] { "9", "2", "1", "1", "1", ",", ".", "," } },
			{ 0x0411, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0412, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0413, new [] { "12", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x0414, new [] { "12", "2", "1", "0", "0", ",", " ", "," } },
			{ 0x0415, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0416, new [] { "9", "2", "1", "1", "1", ",", ".", "," } },
			{ 0x0417, new [] { "2", "2", "1", "1", "1", ".", " ", "." } },
			{ 0x0418, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x0419, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x041A, new [] { "8", "3", "2", "1", "1", ",", ".", "," } },
			{ 0x041B, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x041C, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x041D, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x041E, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x041F, new [] { "8", "3", "1", "2", "2", ",", ".", "," } },
			{ 0x0420, new [] { "3", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0421, new [] { "0", "0", "1", "1", "1", ",", ".", "," } },
			{ 0x0422, new [] { "5", "1", "1", "1", "1", ",", " ", "," } },
			{ 0x0423, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0424, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0425, new [] { "8", "3", "1", "1", "1", ".", " ", "," } },
			{ 0x0426, new [] { "9", "2", "1", "1", "1", ",", " ", "," } },
			{ 0x0427, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0428, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0429, new [] { "3", "0", "3", "0", "0", "/", ",", "/" } },
			{ 0x042A, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x042B, new [] { "8", "3", "1", "0", "0", ".", ",", "." } },
			{ 0x042C, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x042D, new [] { "8", "3", "1", "10", "3", ",", ".", "," } },
			{ 0x042E, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x042F, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0430, new [] { "1", "0", "1", "1", "2", ",", " ", "," } },
			{ 0x0431, new [] { "1", "0", "1", "1", "2", ",", " ", "," } },
			{ 0x0432, new [] { "2", "2", "1", "2", "2", ".", ",", "." } },
			{ 0x0434, new [] { "2", "2", "1", "2", "2", ".", ",", "." } },
			{ 0x0435, new [] { "2", "2", "1", "2", "2", ".", ",", "." } },
			{ 0x0436, new [] { "2", "2", "1", "1", "1", ",", " ", "," } },
			{ 0x0437, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0438, new [] { "12", "2", "1", "1", "1", ",", ".", "," } },
			{ 0x0439, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x043A, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x043B, new [] { "12", "2", "1", "2", "2", ",", " ", "," } },
			{ 0x043E, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x043F, new [] { "1", "0", "1", "1", "1", "-", " ", "," } },
			{ 0x0440, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0441, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0442, new [] { "5", "1", "1", "1", "1", ",", " ", "," } },
			{ 0x0443, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0444, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0445, new [] { "12", "2", "1", "1", "0", ".", ",", "." } },
			{ 0x0446, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x0447, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x0448, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x0449, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x044A, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x044B, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x044C, new [] { "12", "2", "1", "2", "2", ".", ",", "." } },
			{ 0x044D, new [] { "12", "2", "1", "1", "1", ".", ",", "." } },
			{ 0x044E, new [] { "12", "2", "1", "0", "0", "`", ",", "." } },
			{ 0x044F, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x0450, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0451, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0452, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0453, new [] { "5", "1", "2", "1", "1", ".", ",", "." } },
			{ 0x0454, new [] { "8", "3", "1", "0", "0", ".", ",", "." } },
			{ 0x0455, new [] { "9", "3", "1", "1", "1", ".", ",", "." } },
			{ 0x0456, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0457, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x045A, new [] { "8", "3", "1", "0", "0", ".", ",", "." } },
			{ 0x045B, new [] { "14", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x045C, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x045D, new [] { "0", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x045E, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0461, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0462, new [] { "12", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x0463, new [] { "3", "0", "3", "4", "2", ".", ",", "." } },
			{ 0x0464, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0465, new [] { "10", "3", "1", "0", "0", ".", ",", "." } },
			{ 0x0468, new [] { "2", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x046A, new [] { "9", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x046B, new [] { "14", "2", "1", "2", "2", ",", ".", "," } },
			{ 0x046C, new [] { "2", "2", "1", "2", "2", ".", ",", "." } },
			{ 0x046D, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x046E, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x046F, new [] { "12", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x0470, new [] { "2", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x0472, new [] { "1", "0", "1", "1", "2", ".", ",", "." } },
			{ 0x0473, new [] { "5", "1", "0", "1", "1", ".", ",", "." } },
			{ 0x0474, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0475, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0477, new [] { "1", "0", "1", "1", "2", ".", ",", "." } },
			{ 0x0478, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x047A, new [] { "9", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x047C, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x047E, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0480, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0481, new [] { "1", "0", "1", "2", "2", ".", ",", "." } },
			{ 0x0482, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0483, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0484, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0485, new [] { "5", "1", "1", "1", "1", ",", " ", "," } },
			{ 0x0486, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0487, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0488, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x048C, new [] { "3", "0", "3", "4", "2", ".", ",", "," } },
			{ 0x0491, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x0492, new [] { "2", "0", "1", "2", "2", ".", ",", "." } },
			{ 0x0801, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x0803, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x0804, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0807, new [] { "2", "2", "1", "1", "1", ".", " ", "," } },
			{ 0x0809, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x080A, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x080C, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0810, new [] { "2", "2", "1", "1", "1", ".", " ", "," } },
			{ 0x0813, new [] { "12", "2", "1", "1", "1", ",", ".", "," } },
			{ 0x0814, new [] { "12", "2", "1", "0", "0", ",", " ", "," } },
			{ 0x0816, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0818, new [] { "5", "1", "1", "1", "2", ",", ".", "," } },
			{ 0x081A, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x081D, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0820, new [] { "1", "0", "1", "1", "2", ".", ",", "." } },
			{ 0x082C, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x082E, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0832, new [] { "2", "2", "1", "2", "2", ".", ",", "." } },
			{ 0x083B, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x083C, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x083E, new [] { "0", "0", "1", "0", "0", ",", ".", "," } },
			{ 0x0843, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x0845, new [] { "12", "2", "1", "1", "0", ".", ",", "." } },
			{ 0x0846, new [] { "9", "2", "2", "9", "3", ".", ",", "." } },
			{ 0x0849, new [] { "12", "2", "1", "1", "1", ".", ",", "." } },
			{ 0x0850, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0859, new [] { "9", "2", "3", "0", "3", ".", ",", "." } },
			{ 0x085D, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x085F, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0861, new [] { "1", "0", "1", "1", "2", ".", ",", "." } },
			{ 0x0867, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x086B, new [] { "12", "2", "1", "1", "1", ",", ".", "," } },
			{ 0x0873, new [] { "1", "1", "1", "1", "1", ".", ",", "." } },
			{ 0x0C01, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x0C04, new [] { "0", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0C07, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x0C09, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0C0A, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x0C0C, new [] { "15", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0C1A, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x0C3B, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x0C50, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x0C6B, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x1000, new [] { "1", "0", "1", "1", "1", ",", ".", "," } },
			{ 0x1001, new [] { "3", "0", "3", "0", "0", ".", ",", "." } },
			{ 0x1004, new [] { "0", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x1007, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x1009, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x100A, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x100C, new [] { "8", "3", "1", "1", "1", ".", " ", "," } },
			{ 0x101A, new [] { "8", "3", "2", "0", "0", ",", ".", "," } },
			{ 0x103B, new [] { "12", "2", "1", "2", "2", ",", " ", "," } },
			{ 0x105F, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x1401, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x1404, new [] { "0", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x1407, new [] { "2", "2", "1", "1", "1", ",", ".", "," } },
			{ 0x1409, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x140A, new [] { "0", "0", "1", "1", "1", ",", ".", "," } },
			{ 0x140C, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x141A, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x143B, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x1801, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x1809, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x180A, new [] { "14", "2", "1", "1", "1", ".", ",", "." } },
			{ 0x180C, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x181A, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x183B, new [] { "12", "2", "1", "2", "2", ",", " ", "," } },
			{ 0x1C01, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x1C09, new [] { "2", "2", "1", "1", "1", ",", " ", "," } },
			{ 0x1C0A, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x1C1A, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x1C3B, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x2001, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x2009, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x200A, new [] { "12", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x200C, new [] { "4", "1", "1", "1", "2", ",", " ", "," } },
			{ 0x201A, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x203B, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x2401, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x2409, new [] { "1", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x240A, new [] { "1", "0", "1", "1", "1", ",", ".", "," } },
			{ 0x240C, new [] { "4", "1", "1", "1", "2", ",", " ", "," } },
			{ 0x241A, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x243B, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x2801, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x2809, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x280A, new [] { "12", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x280C, new [] { "4", "1", "1", "1", "2", ",", " ", "," } },
			{ 0x281A, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x2C01, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x2C09, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x2C0A, new [] { "2", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x2C0C, new [] { "4", "1", "1", "1", "2", ",", " ", "," } },
			{ 0x2C1A, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x3001, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x3009, new [] { "0", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x300A, new [] { "14", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x300C, new [] { "4", "1", "1", "1", "2", ",", " ", "," } },
			{ 0x301A, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x3401, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x3409, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x340A, new [] { "9", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x340C, new [] { "4", "1", "1", "1", "2", ",", " ", "," } },
			{ 0x3801, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x380A, new [] { "9", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x380C, new [] { "4", "1", "1", "1", "2", ",", " ", "," } },
			{ 0x3C01, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x3C09, new [] { "0", "0", "1", "1", "2", ".", ",", "." } },
			{ 0x3C0A, new [] { "14", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x3C0C, new [] { "4", "1", "1", "1", "2", ",", " ", "," } },
			{ 0x4001, new [] { "3", "2", "3", "0", "0", ".", ",", "." } },
			{ 0x4009, new [] { "12", "2", "1", "1", "1", ".", ",", "." } },
			{ 0x400A, new [] { "14", "2", "1", "0", "0", ",", ".", "," } },
			{ 0x4409, new [] { "0", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x440A, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x4809, new [] { "0", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x480A, new [] { "12", "2", "1", "1", "1", ".", ",", "." } },
			{ 0x4C0A, new [] { "0", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x500A, new [] { "1", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x540A, new [] { "0", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x580A, new [] { "1", "0", "1", "1", "2", ".", ",", "." } },
			{ 0x641A, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x681A, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x6C1A, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x701A, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x703B, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x742C, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x743B, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x7804, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x7814, new [] { "12", "2", "1", "0", "0", ",", " ", "," } },
			{ 0x781A, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x782C, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x783B, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x7843, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x7850, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x785D, new [] { "0", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x785F, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x7C04, new [] { "0", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x7C14, new [] { "12", "2", "1", "0", "0", ",", " ", "," } },
			{ 0x7C1A, new [] { "8", "3", "1", "1", "1", ",", ".", "," } },
			{ 0x7C28, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x7C2E, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x7C3B, new [] { "8", "3", "1", "0", "0", ",", ".", "," } },
			{ 0x7C43, new [] { "8", "3", "1", "1", "1", ",", " ", "," } },
			{ 0x7C46, new [] { "9", "2", "2", "9", "3", ".", ",", "." } },
			{ 0x7C50, new [] { "2", "0", "1", "1", "1", ".", ",", "." } },
			{ 0x7C59, new [] { "9", "2", "3", "0", "3", ".", ",", "." } },
			{ 0x7C5C, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x7C5D, new [] { "0", "0", "1", "0", "0", ".", ",", "." } },
			{ 0x7C5F, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x7C67, new [] { "8", "3", "1", "0", "0", ",", " ", "," } },
			{ 0x7C68, new [] { "2", "2", "1", "0", "0", ".", ",", "." } },
			{ 0x7C92, new [] { "2", "0", "1", "2", "2", ".", ",", "." } },
		};

		static readonly Dictionary<int, string> Geo = new Dictionary<int, string> {
			{ 0x0401, "205" },
			{ 0x0402, "35" },
			{ 0x0403, "217" },
			{ 0x0404, "237" },
			{ 0x0405, "75" },
			{ 0x0406, "61" },
			{ 0x0407, "94" },
			{ 0x0408, "98" },
			{ 0x0409, "244" },
			{ 0x040b, "77" },
			{ 0x040c, "84" },
			{ 0x040d, "117" },
			{ 0x040e, "109" },
			{ 0x040f, "110" },
			{ 0x0410, "118" },
			{ 0x0411, "122" },
			{ 0x0412, "134" },
			{ 0x0413, "176" },
			{ 0x0414, "177" },
			{ 0x0415, "191" },
			{ 0x0416, "32" },
			{ 0x0417, "223" },
			{ 0x0418, "200" },
			{ 0x0419, "203" },
			{ 0x041a, "108" },
			{ 0x041b, "143" },
			{ 0x041c, "6" },
			{ 0x041d, "221" },
			{ 0x041e, "227" },
			{ 0x041f, "235" },
			{ 0x0420, "190" },
			{ 0x0421, "111" },
			{ 0x0422, "241" },
			{ 0x0423, "29" },
			{ 0x0424, "212" },
			{ 0x0425, "70" },
			{ 0x0426, "140" },
			{ 0x0427, "141" },
			{ 0x0428, "228" },
			{ 0x0429, "116" },
			{ 0x042a, "251" },
			{ 0x042b, "7" },
			{ 0x042c, "5" },
			{ 0x042d, "217" },
			{ 0x042e, "94" },
			{ 0x042f, "19618" },
			{ 0x0432, "209" },
			{ 0x0434, "209" },
			{ 0x0435, "209" },
			{ 0x0436, "209" },
			{ 0x0437, "88" },
			{ 0x0438, "81" },
			{ 0x0439, "113" },
			{ 0x043a, "163" },
			{ 0x043b, "177" },
			{ 0x043e, "167" },
			{ 0x043f, "137" },
			{ 0x0440, "130" },
			{ 0x0441, "129" },
			{ 0x0442, "238" },
			{ 0x0443, "247" },
			{ 0x0444, "203" },
			{ 0x0445, "113" },
			{ 0x0446, "113" },
			{ 0x0447, "113" },
			{ 0x0448, "113" },
			{ 0x0449, "113" },
			{ 0x044a, "113" },
			{ 0x044b, "113" },
			{ 0x044c, "113" },
			{ 0x044d, "113" },
			{ 0x044e, "113" },
			{ 0x044f, "113" },
			{ 0x0450, "154" },
			{ 0x0451, "45" },
			{ 0x0452, "242" },
			{ 0x0453, "40" },
			{ 0x0454, "138" },
			{ 0x0456, "217" },
			{ 0x0457, "113" },
			{ 0x045a, "222" },
			{ 0x045b, "42" },
			{ 0x045d, "39" },
			{ 0x045e, "73" },
			{ 0x0461, "178" },
			{ 0x0462, "176" },
			{ 0x0463, "3" },
			{ 0x0464, "201" },
			{ 0x0465, "165" },
			{ 0x0468, "175" },
			{ 0x046a, "175" },
			{ 0x046b, "26" },
			{ 0x046c, "209" },
			{ 0x046d, "203" },
			{ 0x046e, "147" },
			{ 0x046f, "93" },
			{ 0x0470, "175" },
			{ 0x0478, "45" },
			{ 0x047a, "46" },
			{ 0x047c, "39" },
			{ 0x047e, "84" },
			{ 0x0480, "45" },
			{ 0x0481, "183" },
			{ 0x0482, "84" },
			{ 0x0483, "84" },
			{ 0x0484, "84" },
			{ 0x0485, "203" },
			{ 0x0486, "99" },
			{ 0x0487, "204" },
			{ 0x0488, "210" },
			{ 0x048c, "3" },
			{ 0x0491, "242" },
			{ 0x0801, "121" },
			{ 0x0804, "45" },
			{ 0x0807, "223" },
			{ 0x0809, "242" },
			{ 0x080a, "166" },
			{ 0x080c, "21" },
			{ 0x0810, "223" },
			{ 0x0813, "21" },
			{ 0x0814, "177" },
			{ 0x0816, "193" },
			{ 0x081a, "269" },
			{ 0x081d, "77" },
			{ 0x082c, "5" },
			{ 0x082e, "94" },
			{ 0x083b, "221" },
			{ 0x083c, "68" },
			{ 0x083e, "37" },
			{ 0x0843, "247" },
			{ 0x0845, "23" },
			{ 0x0850, "154" },
			{ 0x085d, "39" },
			{ 0x085f, "4" },
			{ 0x086b, "66" },
			{ 0x0c01, "67" },
			{ 0x0c04, "104" },
			{ 0x0c07, "14" },
			{ 0x0c09, "12" },
			{ 0x0c0a, "217" },
			{ 0x0c0c, "39" },
			{ 0x0c1a, "269" },
			{ 0x0c3b, "77" },
			{ 0x0c6b, "187" },
			{ 0x1001, "148" },
			{ 0x1004, "215" },
			{ 0x1007, "147" },
			{ 0x1009, "39" },
			{ 0x100a, "99" },
			{ 0x100c, "223" },
			{ 0x101a, "25" },
			{ 0x103b, "177" },
			{ 0x1401, "4" },
			{ 0x1404, "151" },
			{ 0x1407, "145" },
			{ 0x1409, "183" },
			{ 0x140a, "54" },
			{ 0x140c, "147" },
			{ 0x141a, "25" },
			{ 0x143b, "221" },
			{ 0x1801, "159" },
			{ 0x1809, "68" },
			{ 0x180a, "192" },
			{ 0x180c, "158" },
			{ 0x181a, "25" },
			{ 0x183b, "177" },
			{ 0x1c01, "234" },
			{ 0x1c09, "209" },
			{ 0x1c0a, "65" },
			{ 0x1c1a, "25" },
			{ 0x1c3b, "221" },
			{ 0x2001, "164" },
			{ 0x2009, "124" },
			{ 0x200a, "249" },
			{ 0x201a, "25" },
			{ 0x203b, "77" },
			{ 0x2401, "261" },
			{ 0x2409, "124" },
			{ 0x240a, "51" },
			{ 0x241a, "271" },
			{ 0x243b, "77" },
			{ 0x2801, "222" },
			{ 0x2809, "24" },
			{ 0x280a, "187" },
			{ 0x281a, "271" },
			{ 0x2c01, "126" },
			{ 0x2c09, "225" },
			{ 0x2c0a, "11" },
			{ 0x2c1a, "270" },
			{ 0x3001, "139" },
			{ 0x3009, "264" },
			{ 0x300a, "66" },
			{ 0x301a, "270" },
			{ 0x3401, "136" },
			{ 0x3409, "201" },
			{ 0x340a, "46" },
			{ 0x3801, "224" },
			{ 0x380a, "246" },
			{ 0x3c01, "17" },
			{ 0x3c0a, "185" },
			{ 0x4001, "197" },
			{ 0x4009, "113" },
			{ 0x400a, "26" },
			{ 0x4409, "167" },
			{ 0x440a, "72" },
			{ 0x4809, "215" },
			{ 0x480a, "106" },
			{ 0x4c0a, "182" },
			{ 0x500a, "202" },
			{ 0x540a, "244" },
			};


		public static void FillValues (int lcid, CultureInfoEntry ci)
		{
			var dfe = ci.DateTimeFormatEntry;

			var entry_dt = DateTime2[lcid];
			entry_dt[0].CopyTo (dfe.ShortDatePatterns, 0);
			entry_dt[1].CopyTo (dfe.LongDatePatterns, 0);
			entry_dt[2].CopyTo (dfe.ShortTimePatterns, 0);
			entry_dt[3].CopyTo (dfe.LongTimePatterns, 0);
			entry_dt[4].CopyTo (dfe.YearMonthPatterns, 0);
			dfe.DateSeparator = entry_dt[5][0];
			dfe.TimeSeparator = entry_dt[6][0];
			dfe.MonthDayPattern = entry_dt[7][0];

			var entry_te = Text[lcid];
			var te = ci.TextInfoEntry;
			te.ANSICodePage = entry_te[0];
			te.EBCDICCodePage = entry_te[1];
			te.IsRightToLeft = entry_te[2] == "1" ? true : false;
			te.ListSeparator = entry_te[3];
			te.MacCodePage = entry_te[4];
			te.OEMCodePage = entry_te[5];

			var entry_nf = Numbers[lcid];
			var nf = ci.NumberFormatEntry;
			nf.CurrencyNegativePattern = entry_nf[0];
			nf.CurrencyPositivePattern = entry_nf[1];
			nf.NumberNegativePattern = entry_nf[2];
			nf.PercentNegativePattern = entry_nf[3];
			nf.PercentPositivePattern = entry_nf[4];
			nf.CurrencyDecimalSeparator = entry_nf[5];
			nf.CurrencyGroupSeparator = entry_nf[6];
			nf.NumberDecimalSeparator = entry_nf[7];

			string[][] gsizes;
			if (!GroupSizes.TryGetValue (lcid, out gsizes)) {
				gsizes = new[] { new[] { "3" }, new[] { "3" } };
			}

			gsizes[0].CopyTo (nf.CurrencyGroupSizes, 0);
			gsizes[1].CopyTo (nf.NumberGroupSizes, 0);
		}

		public static void FillValues (int lcid, RegionInfoEntry ri)
		{
			var entry = Geo[lcid];
			ri.GeoId = entry;
		}
	}
}
