/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#ifndef QMLJSREUSE_H
#define QMLJSREUSE_H

#include <QtGlobal>
#include <QIcon>

QT_BEGIN_NAMESPACE
class QChar;
QT_END_NAMESPACE

namespace QmlJSEditor {
namespace Internal {

bool isIdentifierChar(const QChar &c, bool atStart = false, bool acceptDollar = true);
bool isValidFirstIdentifierChar(const QChar &c);
bool isValidIdentifierChar(const QChar &c);
bool isDelimiterChar(const QChar &c);
bool isActivationChar(const QChar &c);

QIcon iconForColor(const QColor &color);

} // Internal
} // QmlJSEditor

#endif // QMLJSREUSE_H
