/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.ui.preferences.pages.priv;

import it.sogei.rcp.ui.preferences.Activator;
import it.sogei.rcp.ui.preferences.editors.PasswordFieldEditor;
import it.sogei.rcp.ui.preferences.entities.PreferenceComboFieldBean;
import it.sogei.rcp.ui.preferences.entities.PreferenceFieldBean;
import it.sogei.rcp.ui.preferences.entities.PreferenceRadioFieldBean;
import it.sogei.rcp.ui.preferences.entities.ScopeEnum;
import it.sogei.rcp.ui.preferences.entities.priv.PreferencePageTO;
import it.sogei.rcp.ui.preferences.interfaces.IPreferences;
import it.sogei.rcp.ui.preferences.pages.Messages;
import java.util.HashMap;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePageRCP
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    HashMap<String, String> fieldsMap = new HashMap();
    IPreferences preferences = null;
    String parentId;
    String pluginId;
    String pageId;
    Shell parent;

    public PreferencePageRCP() {
        super(1);
    }

    public PreferencePageRCP(PreferencePageTO prefPageTO, Shell parent) {
        super(1);
        this.preferences = prefPageTO.preferences;
        this.pageId = prefPageTO.id;
        this.parentId = prefPageTO.parentId;
        this.pluginId = prefPageTO.pluginId;
        this.parent = parent;
        if (this.preferences.getScope() == ScopeEnum.INSTANCE) {
            this.setPreferenceStore((IPreferenceStore)Activator.getDefault().preferenceStoreInstance);
        } else {
            this.setPreferenceStore((IPreferenceStore)Activator.getDefault().preferenceStore);
        }
        this.setTitle(this.preferences.getPageTitle());
        this.setDescription(this.preferences.getDescription());
    }

    public void init(IWorkbench workbench) {
        this.createContents((Composite)this.parent);
    }

    protected void createFieldEditors() {
        if (this.preferences.isVisibleWithErrorMessage()) {
            String errMessage = this.preferences.getErrorMessage();
            if (errMessage == null || errMessage.equals("")) {
                errMessage = Messages.PreferencePageRCP_ErrMessage;
            }
            this.setErrorMessage(errMessage);
            return;
        }
        PreferenceFieldBean[] fields = this.preferences.getPreferenceFields();
        if (fields != null && fields.length != 0) {
            int i = 0;
            while (i < fields.length) {
                PreferenceFieldBean field = fields[i];
                if (field != null) {
                    try {
                        String fieldId = String.valueOf(this.pluginId) + "/" + this.pageId + "/" + field.getFieldId();
                        switch (field.getFieldType()) {
                            case BOOLEAN: {
                                this.addField((FieldEditor)new BooleanFieldEditor(fieldId, field.getFieldLabel(), this.getFieldEditorParent()));
                                break;
                            }
                            case INTEGER: {
                                this.addField((FieldEditor)new IntegerFieldEditor(fieldId, field.getFieldLabel(), this.getFieldEditorParent()));
                                break;
                            }
                            case DIRECTORY: {
                                DirectoryFieldEditor dfe2 = new DirectoryFieldEditor(fieldId, field.getFieldLabel(), this.getFieldEditorParent());
                                dfe2.setValidateStrategy(0);
                                dfe2.setErrorMessage(String.valueOf(dfe2.getLabelText()) + ": " + dfe2.getErrorMessage());
                                this.addField((FieldEditor)dfe2);
                                break;
                            }
                            case DIRECTORY_NOEDIT: {
                                DirectoryFieldEditor dfe = new DirectoryFieldEditor(fieldId, field.getFieldLabel(), this.getFieldEditorParent());
                                dfe.setValidateStrategy(0);
                                dfe.setErrorMessage(String.valueOf(dfe.getLabelText()) + ": " + dfe.getErrorMessage());
                                dfe.getTextControl(this.getFieldEditorParent()).setEditable(false);
                                this.addField((FieldEditor)dfe);
                                break;
                            }
                            case FILE: {
                                FileFieldEditor ffe = new FileFieldEditor(fieldId, field.getFieldLabel(), this.getFieldEditorParent());
                                ffe.setValidateStrategy(0);
                                ffe.setErrorMessage(String.valueOf(ffe.getLabelText()) + ": " + ffe.getErrorMessage());
                                this.addField((FieldEditor)ffe);
                                break;
                            }
                            case FILE_NOEDIT: {
                                FileFieldEditor ffe2 = new FileFieldEditor(fieldId, field.getFieldLabel(), this.getFieldEditorParent());
                                ffe2.setValidateStrategy(0);
                                ffe2.setErrorMessage(String.valueOf(ffe2.getLabelText()) + ": " + ffe2.getErrorMessage());
                                ffe2.getTextControl(this.getFieldEditorParent()).setEditable(false);
                                this.addField((FieldEditor)ffe2);
                                break;
                            }
                            case FONT: {
                                this.addField((FieldEditor)new FontFieldEditor(fieldId, field.getFieldLabel(), this.getFieldEditorParent()));
                                break;
                            }
                            case STRING: {
                                StringFieldEditor sfe = new StringFieldEditor(fieldId, field.getFieldLabel(), this.getFieldEditorParent());
                                sfe.setValidateStrategy(0);
                                sfe.setErrorMessage(String.valueOf(sfe.getLabelText()) + ": " + sfe.getErrorMessage());
                                this.addField((FieldEditor)sfe);
                                break;
                            }
                            case PASSWORD: {
                                this.addField(new PasswordFieldEditor(fieldId, field.getFieldLabel(), this.getFieldEditorParent()));
                                break;
                            }
                            case COMBO: {
                                this.addField((FieldEditor)new ComboFieldEditor(fieldId, field.getFieldLabel(), ((PreferenceComboFieldBean)field).getRadioLabelAndValues(), this.getFieldEditorParent()));
                                break;
                            }
                            case RADIO: {
                                this.addField((FieldEditor)new RadioGroupFieldEditor(fieldId, field.getFieldLabel(), ((PreferenceRadioFieldBean)field).getNumColumns(), ((PreferenceRadioFieldBean)field).getRadioLabelAndValues(), this.getFieldEditorParent()));
                                break;
                            }
                        }
                        this.fieldsMap.put(fieldId, field.getFieldDefaultValue());
                        Activator.preferenceMap.put(fieldId, field.getFieldDefaultValue());
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public boolean performOk() {
        boolean ret = super.performOk();
        if (ret) {
            this.preferences.performFinish();
        }
        return ret;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
    }
}

