/*
 * Decompiled with CFR 0.152.
 */
package demo.smime;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import demo.smime.DumpMessage;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.cms.CMSAlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs10.CertificateRequest;
import iaik.smime.CompressedContent;
import iaik.smime.CryptoContent;
import iaik.smime.EncryptedContent;
import iaik.smime.PKCS10Content;
import iaik.smime.SMimeBodyPart;
import iaik.smime.SMimeException;
import iaik.smime.SMimeMultipart;
import iaik.smime.SMimeParameters;
import iaik.smime.SignedContent;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SMimeV3Demo {
    PrivateKey signerPrivateKey;
    X509Certificate encryptionCertOfSigner;
    X509Certificate signerCertificate;
    X509Certificate recipientCertificate;
    X509Certificate[] signerCertificates;
    String host = "mailhost";
    String from = "smimetest@iaik.at";
    String to = "smimetest@iaik.at";
    String lastName = "SMime";
    String firstName = "John";
    static final boolean a = false;

    public void start() throws IOException {
        Session session = DemoUtil.getSession();
        try {
            SMimeBodyPart sMimeBodyPart = new SMimeBodyPart();
            sMimeBodyPart.setText("This is a Test of the IAIK S/MIME implementation!\n\n");
            SMimeBodyPart sMimeBodyPart2 = new SMimeBodyPart();
            sMimeBodyPart2.setDataHandler(new DataHandler((DataSource)new FileDataSource("test.html")));
            sMimeBodyPart2.setFileName("test.html");
            SMimeMultipart sMimeMultipart = new SMimeMultipart();
            sMimeMultipart.addBodyPart((BodyPart)sMimeBodyPart);
            sMimeMultipart.addBodyPart((BodyPart)sMimeBodyPart2);
            DataHandler dataHandler = new DataHandler((Object)sMimeMultipart, sMimeMultipart.getContentType());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Message message = this.createPlainMessage(session, dataHandler);
            System.out.println("creating plain message...");
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createSignedMessage(session, dataHandler, false);
            System.out.println("creating explicitly signed message...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createSignedMessage(session, dataHandler, true);
            System.out.println("creating implicitly signed message...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createEncryptedMessage(session, (AlgorithmID)AlgorithmID.rc2_CBC.clone(), 40, (AlgorithmID)AlgorithmID.esdhKeyAgreement.clone(), (AlgorithmID)AlgorithmID.cms_rc2_wrap.clone(), 128);
            System.out.println("creating encrypted message [RC2/40]...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createEncryptedMessage(session, (AlgorithmID)AlgorithmID.rc2_CBC.clone(), 64, (AlgorithmID)AlgorithmID.esdhKeyAgreement.clone(), (AlgorithmID)AlgorithmID.cms_rc2_wrap.clone(), 128);
            System.out.println("creating encrypted message [RC2/64]...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createEncryptedMessage(session, (AlgorithmID)AlgorithmID.rc2_CBC.clone(), 128, (AlgorithmID)AlgorithmID.esdhKeyAgreement.clone(), (AlgorithmID)AlgorithmID.cms_rc2_wrap.clone(), 128);
            System.out.println("creating encrypted message [RC2/128]...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createEncryptedMessage(session, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone(), 192, (AlgorithmID)AlgorithmID.esdhKeyAgreement.clone(), (AlgorithmID)AlgorithmID.cms_3DES_wrap.clone(), 192);
            System.out.println("creating encrypted message [TripleDES]...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createSignedAndEncryptedMessage(session, dataHandler, true);
            System.out.println("creating implicitly signed and encrypted message [RC2/40]...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createSignedAndEncryptedMessage(session, dataHandler, false);
            System.out.println("creating explicitly signed and encrypted message [RC2/40]...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createCertsOnlyMessage(session);
            System.out.println("creating certs-only message");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createCertsOnlyMultiPartMessage(session);
            System.out.println("creating message with certs-only part");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createPKCS10Message(session);
            System.out.println("creating application/pkcs10 message...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createPKCS10MultiPartMessage(session);
            System.out.println("creating message with pkcs10 part...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
            System.out.println("\n\n*****************************************\n\n");
            message = this.createCompressedMessage(session, dataHandler, (AlgorithmID)CMSAlgorithmID.zlib_compress);
            System.out.println("creating message with compressed data...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            DumpMessage.dump(message);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
        System.out.println("OK!");
    }

    private static void a(Message message) throws IOException {
        System.out.println("------------------------------------------------------------------");
        System.out.println("Message dump: \n");
        try {
            message.writeTo((OutputStream)System.out);
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.getMessage());
        }
        System.out.println("\n------------------------------------------------------------------");
    }

    public static void main(String[] stringArray) throws IOException {
        DemoUtil.initSMimeDemos();
        new SMimeV3Demo().start();
        Util.waitKey();
        System.exit(0);
    }

    public Message createSignedMessage(Session session, DataHandler dataHandler, boolean bl) throws MessagingException {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            string = "IAIK-S/MIME: Implicitly Signed";
            stringBuffer.append("This message is implicitly signed!\n");
            stringBuffer.append("You need an S/MIME aware mail client to view this message.\n");
            stringBuffer.append("\n\n");
        } else {
            string = "IAIK-S/MIME: Explicitly Signed";
            stringBuffer.append("This message is explicitly signed!\n");
            stringBuffer.append("Every mail client can view this message.\n");
            stringBuffer.append("Non S/MIME mail clients will show the signature as attachment.\n");
            stringBuffer.append("\n\n");
        }
        Message message = this.createMessage(session, string);
        SignedContent signedContent = new SignedContent(bl);
        if (dataHandler != null) {
            signedContent.setDataHandler(dataHandler);
        } else {
            signedContent.setText(stringBuffer.toString());
        }
        signedContent.setCertificates((Certificate[])this.signerCertificates);
        try {
            signedContent.addSigner(this.signerPrivateKey, this.signerCertificate, AlgorithmID.sha1, AlgorithmID.dsaWithSHA);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Algorithm not supported: " + noSuchAlgorithmException.getMessage(), (Exception)noSuchAlgorithmException);
        }
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        return message;
    }

    public Message createSignedAndEncryptedMessage(Session session, DataHandler dataHandler, boolean bl) throws MessagingException {
        String string = null;
        String string2 = null;
        if (bl) {
            string = "IAIK-S/MIME: Implicitly Signed and Encrypted";
            string2 = "This message is implicitly signed and encrypted!\n\n\n";
        } else {
            string = "IAIK-S/MIME: Explicitly Signed and Encrypted";
            string2 = "This message is explicitly signed and encrypted!\n\n\n";
        }
        Message message = this.createMessage(session, string);
        SignedContent signedContent = new SignedContent(bl);
        if (dataHandler != null) {
            signedContent.setDataHandler(dataHandler);
        } else {
            signedContent.setText(string2);
        }
        signedContent.setCertificates((Certificate[])this.signerCertificates);
        try {
            signedContent.addSigner(this.signerPrivateKey, this.signerCertificate, AlgorithmID.sha1, AlgorithmID.dsaWithSHA);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Algorithm not supported: " + noSuchAlgorithmException.getMessage(), (Exception)noSuchAlgorithmException);
        }
        EncryptedContent encryptedContent = new EncryptedContent((CryptoContent)signedContent);
        AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.esdhKeyAgreement.clone();
        AlgorithmID algorithmID2 = (AlgorithmID)AlgorithmID.cms_rc2_wrap.clone();
        int n = 128;
        try {
            encryptedContent.addRecipient(this.recipientCertificate, algorithmID, algorithmID2, n);
        }
        catch (SMimeException sMimeException) {
            throw new MessagingException("Error adding ESDH recipient: " + sMimeException.getMessage());
        }
        encryptedContent.addRecipient(this.encryptionCertOfSigner, AlgorithmID.rsaEncryption);
        try {
            encryptedContent.setEncryptionAlgorithm((AlgorithmID)AlgorithmID.rc2_CBC.clone(), 40);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Content encryption algorithm not supported: " + noSuchAlgorithmException.getMessage());
        }
        message.setContent((Object)encryptedContent, encryptedContent.getContentType());
        encryptedContent.setHeaders((Part)message);
        return message;
    }

    public Message createPlainMessage(Session session, DataHandler dataHandler) throws MessagingException {
        Message message = this.createMessage(session, "IAIK-S/MIME: Plain message");
        if (dataHandler != null) {
            message.setDataHandler(dataHandler);
        } else {
            message.setText("This is a plain message!\nIt is wether signed nor encrypted!\n");
        }
        return message;
    }

    public Message createPKCS10MultiPartMessage(Session session) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText("This is a test where the request message is included in the second part!\n\n");
        MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
        SMimeParameters.useNewContentTypes((boolean)true);
        PKCS10Content pKCS10Content = new PKCS10Content();
        CertificateRequest certificateRequest = null;
        try {
            certificateRequest = this.a();
        }
        catch (PKCSException pKCSException) {
            throw new MessagingException(pKCSException.getMessage());
        }
        pKCS10Content.setCertRequest(certificateRequest);
        DataHandler dataHandler = new DataHandler((Object)pKCS10Content, pKCS10Content.getContentType());
        mimeBodyPart2.setDataHandler(dataHandler);
        mimeBodyPart2.setDisposition("attachment");
        mimeBodyPart2.setFileName("smime.p10");
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
        Message message = this.createMessage(session, "IAIK-S/MIME: Certificate Request multipart message");
        message.setContent((Object)mimeMultipart, mimeMultipart.getContentType());
        return message;
    }

    public Message createPKCS10Message(Session session) throws MessagingException {
        Message message = this.createMessage(session, "IAIK-S/MIME: Certificate Request");
        PKCS10Content pKCS10Content = new PKCS10Content();
        CertificateRequest certificateRequest = null;
        try {
            certificateRequest = this.a();
        }
        catch (PKCSException pKCSException) {
            throw new MessagingException(pKCSException.getMessage());
        }
        pKCS10Content.setCertRequest(certificateRequest);
        message.setContent((Object)pKCS10Content, pKCS10Content.getContentType());
        pKCS10Content.setHeaders((Part)message);
        return message;
    }

    public Message createMessage(Session session, String string) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.from));
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to, (boolean)false));
        mimeMessage.setSentDate(new Date());
        mimeMessage.setSubject(string);
        return mimeMessage;
    }

    public Message createEncryptedMessage(Session session, AlgorithmID algorithmID, int n, AlgorithmID algorithmID2, AlgorithmID algorithmID3, int n2) throws MessagingException {
        AlgorithmID algorithmID4 = (AlgorithmID)algorithmID.clone();
        AlgorithmID algorithmID5 = (AlgorithmID)algorithmID2.clone();
        AlgorithmID algorithmID6 = (AlgorithmID)algorithmID3.clone();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IAIK-S/MIME: Encrypted [" + algorithmID4.getName());
        if (n > 0) {
            stringBuffer.append("/" + n);
        }
        stringBuffer.append("]");
        Message message = this.createMessage(session, stringBuffer.toString());
        EncryptedContent encryptedContent = new EncryptedContent();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("This is the encrypted content!\n");
        stringBuffer2.append("Content encryption algorithm: " + algorithmID4.getName());
        stringBuffer2.append("\n\n");
        encryptedContent.setText(stringBuffer2.toString());
        try {
            encryptedContent.addRecipient(this.recipientCertificate, algorithmID5, algorithmID6, n2);
        }
        catch (SMimeException sMimeException) {
            throw new MessagingException("Error adding ESDH recipient: " + sMimeException.getMessage());
        }
        encryptedContent.addRecipient(this.encryptionCertOfSigner, AlgorithmID.rsaEncryption);
        try {
            encryptedContent.setEncryptionAlgorithm(algorithmID4, n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Content encryption algorithm not supported: " + noSuchAlgorithmException.getMessage());
        }
        message.setContent((Object)encryptedContent, encryptedContent.getContentType());
        encryptedContent.setHeaders((Part)message);
        return message;
    }

    public Message createCompressedMessage(Session session, DataHandler dataHandler, AlgorithmID algorithmID) throws MessagingException {
        String string = "IAIK-S/MIME: Compressed [" + algorithmID.getName() + "]";
        Message message = this.createMessage(session, string.toString());
        CompressedContent compressedContent = new CompressedContent();
        if (dataHandler == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("This is the compressed content!\n");
            stringBuffer.append("Compression algorithm: " + algorithmID.getName());
            stringBuffer.append("\n\n");
            compressedContent.setText(stringBuffer.toString());
        } else {
            compressedContent.setDataHandler(dataHandler);
        }
        try {
            compressedContent.setCompressionAlgorithm(algorithmID);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Compression algorithm not supported: " + noSuchAlgorithmException.getMessage());
        }
        message.setContent((Object)compressedContent, compressedContent.getContentType());
        compressedContent.setHeaders((Part)message);
        return message;
    }

    public Message createCertsOnlyMultiPartMessage(Session session) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText("This is a test where the certs-only message is included in the second part!\n\n");
        MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
        SMimeParameters.useNewContentTypes((boolean)true);
        SignedContent signedContent = new SignedContent(true, "certs-only");
        signedContent.setCertificates((Certificate[])this.signerCertificates);
        mimeBodyPart2.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)mimeBodyPart2);
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
        Message message = this.createMessage(session, "IAIK S/MIME: Certs-only multipart message");
        message.setContent((Object)mimeMultipart, mimeMultipart.getContentType());
        return message;
    }

    public Message createCertsOnlyMessage(Session session) throws MessagingException {
        Message message = this.createMessage(session, "IAIK S/MIME: Certs-only message");
        SMimeParameters.useNewContentTypes((boolean)true);
        SignedContent signedContent = new SignedContent(true, "certs-only");
        signedContent.setCertificates((Certificate[])this.signerCertificates);
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        return message;
    }

    private CertificateRequest a() throws PKCSException {
        try {
            Name name = new Name();
            name.addRDN(ObjectID.commonName, (Object)(String.valueOf(this.firstName) + " " + this.lastName));
            name.addRDN(ObjectID.emailAddress, (Object)this.from);
            CertificateRequest certificateRequest = new CertificateRequest(this.signerCertificate.getPublicKey(), name);
            certificateRequest.sign(AlgorithmID.dsaWithSHA, this.signerPrivateKey);
            certificateRequest.verify();
            return certificateRequest;
        }
        catch (Exception exception) {
            throw new PKCSException("Cannot create cert request: " + exception.getMessage());
        }
    }

    public SMimeV3Demo() {
        PrivateKey privateKey;
        System.out.println();
        System.out.println("********************************************************************************************");
        System.out.println("*                                SMimeV3Demo demo                                          *");
        System.out.println("* (shows how to create and parse (verify, decrypt) signed and encrypted S/MIMEv3 messages) *");
        System.out.println("********************************************************************************************");
        System.out.println();
        this.signerCertificates = CMSKeyStore.getCertificateChain(1, 1);
        this.signerPrivateKey = CMSKeyStore.getPrivateKey(1, 1);
        this.signerCertificate = this.signerCertificates[0];
        this.recipientCertificate = CMSKeyStore.getCertificateChain(2, 4)[0];
        DumpMessage.privateKey = privateKey = CMSKeyStore.getPrivateKey(2, 4);
        this.encryptionCertOfSigner = CMSKeyStore.getCertificateChain(0, 4)[0];
    }
}

