/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SignedData;
import iaik.cms.SignerInfo;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.SigningTime;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class SignedDataDemo {
    String testMessage;

    private void a(InputStream inputStream) throws Exception {
        System.out.println("\nVerify the SignedData...");
        SignedData signedData = new SignedData(inputStream);
        byte[] byArray = signedData.getContent();
        System.out.println("Content of SignedData: " + new String(byArray));
        System.out.println("Certificates included:");
        Certificate[] certificateArray = signedData.getCertificates();
        try {
            int n = 0;
            while (n < certificateArray.length) {
                System.out.println(certificateArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("Signers included:");
        SignerInfo[] signerInfoArray = signedData.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            X509Certificate x509Certificate = signedData.verify(n);
            System.out.println("Signer: " + x509Certificate.getSubjectDN());
            System.out.println(signerInfoArray[n].toString(true));
            ++n;
        }
    }

    public void start() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.a(byteArrayOutputStream, this.testMessage, 1);
            this.a(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            byteArrayOutputStream = this.a(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), 2);
            this.a(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        DemoUtil.initDemos();
        new SignedDataDemo().start();
        System.in.read();
    }

    private void a(OutputStream outputStream, String string, int n) throws Exception {
        System.out.println("\nCreate a new SignedData with content: " + string);
        X509Certificate[] x509CertificateArray = CMSKeyStore.getCertificateChain(0, n);
        SignedData signedData = new SignedData(string.getBytes(), 1);
        signedData.setCertificates((Certificate[])x509CertificateArray);
        this.a(signedData, n);
        signedData.writeTo(outputStream);
        outputStream.close();
    }

    private void a(SignedData signedData, int n) throws Exception {
        X509Certificate x509Certificate = CMSKeyStore.getCertificateChain(0, n)[0];
        PrivateKey privateKey = CMSKeyStore.getPrivateKey(0, n);
        Certificate[] certificateArray = signedData.getCertificates();
        Certificate[] certificateArray2 = new Certificate[certificateArray.length + 1];
        System.arraycopy(certificateArray, 0, certificateArray2, 0, certificateArray.length);
        certificateArray2[certificateArray.length] = x509Certificate;
        signedData.setCertificates(certificateArray2);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)new IssuerAndSerialNumber(x509Certificate), AlgorithmID.md5, privateKey);
        Attribute[] attributeArray = new Attribute[]{new Attribute((AttributeValue)new CMSContentType(ObjectID.cms_data)), new Attribute((AttributeValue)new SigningTime())};
        signerInfo.setSignedAttributes(attributeArray);
        signedData.addSignerInfo(signerInfo);
    }

    private ByteArrayOutputStream a(InputStream inputStream, int n) throws Exception {
        System.out.println("Adding a signature to an existing SignedData...");
        SignedData signedData = new SignedData(inputStream);
        byte[] byArray = signedData.getContent();
        System.out.println("Existing content is: " + new String(byArray));
        this.a(signedData, n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        signedData.writeTo((OutputStream)byteArrayOutputStream);
        inputStream.close();
        ((OutputStream)byteArrayOutputStream).close();
        return byteArrayOutputStream;
    }

    public SignedDataDemo() {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                             SignedDataDemo                                     *");
        System.out.println("*    (shows how to add a new signer to an already existing SignedData object)    *");
        System.out.println("**********************************************************************************");
        System.out.println();
        this.testMessage = "This is a test of the CMS implementation!";
    }
}

