/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class PolicyConstraintsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.PolicyConstraints";
    public static final String NAME = "PolicyConstraints";
    public static final String REQUIRE = "require";
    public static final String INHIBIT = "inhibit";
    private static final byte TAG_REQUIRE = 0;
    private static final byte TAG_INHIBIT = 1;
    private int require = -1;
    private int inhibit = -1;

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (this.require == -1 && this.inhibit == -1) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.require != -1) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(this.require);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream);
        }
        if (this.inhibit != -1) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(this.inhibit);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream);
        }
        derOutputStream3.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream3.toByteArray();
    }

    public PolicyConstraintsExtension(int n, int n2) throws IOException {
        this(Boolean.FALSE, n, n2);
    }

    public PolicyConstraintsExtension(Boolean bl, int n, int n2) throws IOException {
        this.require = n;
        this.inhibit = n2;
        this.extensionId = PKIXExtensions.PolicyConstraints_Id;
        this.critical = bl;
        this.encodeThis();
    }

    public PolicyConstraintsExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.PolicyConstraints_Id;
        this.critical = bl;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        if (derValue.tag != 48) {
            throw new IOException("Sequence tag missing for PolicyConstraint.");
        }
        DerInputStream derInputStream = derValue.data;
        while (derInputStream != null && derInputStream.available() != 0) {
            DerValue derValue2 = derInputStream.getDerValue();
            if (derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
                if (this.require != -1) {
                    throw new IOException("Duplicate requireExplicitPolicyfound in the PolicyConstraintsExtension");
                }
                derValue2.resetTag((byte)2);
                this.require = derValue2.getInteger();
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                if (this.inhibit != -1) {
                    throw new IOException("Duplicate inhibitPolicyMappingfound in the PolicyConstraintsExtension");
                }
                derValue2.resetTag((byte)2);
                this.inhibit = derValue2.getInteger();
                continue;
            }
            throw new IOException("Invalid encoding of PolicyConstraint");
        }
    }

    @Override
    public String toString() {
        String string = super.toString() + "PolicyConstraints: [" + "  Require: ";
        string = this.require == -1 ? string + "unspecified;" : string + this.require + ";";
        string = string + "\tInhibit: ";
        string = this.inhibit == -1 ? string + "unspecified" : string + this.inhibit;
        string = string + " ]\n";
        return string;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PolicyConstraints_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Integer)) {
            throw new IOException("Attribute value should be of type Integer.");
        }
        if (string.equalsIgnoreCase(REQUIRE)) {
            this.require = (Integer)object;
        } else if (string.equalsIgnoreCase(INHIBIT)) {
            this.inhibit = (Integer)object;
        } else {
            throw new IOException("Attribute name [" + string + "]" + " not recognized by " + "CertAttrSet:PolicyConstraints.");
        }
        this.encodeThis();
    }

    @Override
    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(REQUIRE)) {
            return new Integer(this.require);
        }
        if (string.equalsIgnoreCase(INHIBIT)) {
            return new Integer(this.inhibit);
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:PolicyConstraints.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(REQUIRE)) {
            this.require = -1;
        } else if (string.equalsIgnoreCase(INHIBIT)) {
            this.inhibit = -1;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyConstraints.");
        }
        this.encodeThis();
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(REQUIRE);
        attributeNameEnumeration.addElement(INHIBIT);
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

