/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2005;

import finanze.IDTE.generale2005.BaseTelem;
import finanze.IDTE.generale2005.Diagnostici;
import finanze.IDTE.generale2005.Dichiarazione;
import finanze.IDTE.generale2005.Modello;
import finanze.IDTE.generale2005.Util;
import finanze.IDTE.resources.RecordParser;

public abstract class LiquidatoreOld
extends Modello {
    protected String flagsTelem = "";
    protected boolean banchePoste = false;
    protected int tipoFornitore = 0;
    protected static final int CODGRAV = 16;
    protected static int CODWARNING = 4;
    protected int codGravDatiIncoerenti;
    protected int codGravConferma;
    protected String codFiscDichiarante = "";
    public static final int CTR_B_INDEX = 0;
    public static final int CTR_RECVAR_INDEX = 1;
    public static final int CTR_F_INDEX = 2;
    public static final int CTR_G_INDEX = 3;
    public static final int CTR_H_INDEX = 4;
    public static final int CTR_C_INDEX = 1;
    public static final int CTR_D_INDEX = 2;
    public static final int CTR_E_INDEX = 3;
    public static final int CTR_I_INDEX = 7;
    public static final int CTR_L_INDEX = 10;
    public static final int CTR_Q_INDEX = 15;
    public static final int CTR_R_INDEX = 16;
    public static final int CTR_S_INDEX = 17;
    public static final int CTR_T_INDEX = 18;
    public static final int CTR_U_INDEX = 19;
    public static final int CTR_X_INDEX = 22;

    protected LiquidatoreOld() {
        this(null, new Dichiarazione());
    }

    protected LiquidatoreOld(RecordParser recordB, Dichiarazione dichiarazione) {
        this.recordB = recordB;
        this.dich = dichiarazione;
        String modClassName = this.getClass().getName();
        this.TIPO_MODELLO = modClassName.substring(modClassName.length() - 5, modClassName.length() - 2);
        this.ANNO = modClassName.substring(modClassName.length() - 2);
        System.out.println("La versione della Liquidazione: " + this.getVersione());
    }

    public static String[] controlloProtocolloBanchePoste(String protocollo, String pacco, double sequenza, String modello, int fornitore, int altricasi2, int Cab, int annoCorrente) {
        String[] rc = new String[]{"0", "0", "0", "0", "0"};
        String prot = "";
        String abi = "";
        String cab = "";
        String tipo = "";
        String data8 = "";
        String progr = "";
        String dataPoste = "";
        String agenzia = "";
        if (protocollo.trim().length() == 25) {
            abi = protocollo.substring(0, 5);
            cab = protocollo.substring(5, 10);
            tipo = protocollo.substring(10, 13);
            data8 = protocollo.substring(13, 21);
            progr = protocollo.substring(21, 25);
            if (fornitore != 8) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(abi) || abi.equals("00000")) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(cab) || cab.equals("00000")) {
                rc[0] = "1070";
            }
            if (!(tipo.equals("UNI") || tipo.equals("SCE") || tipo.equals("SCS") || tipo.equals("IVA") || tipo.equals("730") || tipo.equals("U50") || tipo.equals("U60") || tipo.equals("U61") || tipo.equals("770") || tipo.equals("77S"))) {
                rc[0] = "1070";
            }
            if (!tipo.equals(modello.substring(0, 3))) {
                rc[1] = "1071";
            }
            if (!tipo.equals(modello.substring(0, 3)) && altricasi2 != 1) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(data8) || !Util.controlloData(data8) || data8.equals("00000000")) {
                rc[0] = "1070";
            } else if (Util.valoreDouble(data8.substring(4, 8)) != (double)annoCorrente && Util.valoreDouble(data8.substring(4, 8)) != (double)(annoCorrente - 1) && Util.valoreDouble(data8.substring(4, 8)) != (double)(annoCorrente + 1) && Util.valoreDouble(data8.substring(4, 8)) != (double)(annoCorrente + 2) && Util.valoreDouble(data8.substring(4, 8)) != (double)(annoCorrente + 3) && Util.valoreDouble(data8.substring(4, 8)) != (double)(annoCorrente + 4)) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(progr)) {
                rc[0] = "1070";
            }
        } else if (protocollo.trim().length() == 18) {
            agenzia = protocollo.substring(0, 5);
            progr = protocollo.substring(5, 10);
            dataPoste = protocollo.substring(10, 18);
            if (fornitore != 7) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(agenzia) || agenzia.equals("00000")) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(progr)) {
                rc[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(dataPoste) || !Util.controlloData(dataPoste) || dataPoste.equals("00000000")) {
                rc[0] = "1070";
            } else if (Util.valoreDouble(dataPoste.substring(4, 8)) != (double)annoCorrente && Util.valoreDouble(dataPoste.substring(4, 8)) != (double)(annoCorrente - 1) && Util.valoreDouble(dataPoste.substring(4, 8)) != (double)(annoCorrente + 1) && Util.valoreDouble(dataPoste.substring(4, 8)) != (double)(annoCorrente + 2) && Util.valoreDouble(dataPoste.substring(4, 8)) != (double)(annoCorrente + 3) && Util.valoreDouble(dataPoste.substring(4, 8)) != (double)(annoCorrente + 4)) {
                rc[0] = "1070";
            }
        } else {
            rc[0] = "1070";
        }
        if ((pacco = pacco.replace(' ', '0')).equals("0000000") || pacco.length() != 7) {
            rc[2] = "1072";
        } else if (fornitore == 7 && (Util.valoreDouble(pacco.substring(0, 2)) == 0.0 || Util.valoreDouble(pacco.substring(0, 2)) > 12.0)) {
            rc[2] = "1072";
        }
        if (sequenza == 0.0 || sequenza > 100.0) {
            rc[3] = "1073";
        }
        if (fornitore == 8 && Cab == 0) {
            rc[4] = "1095";
        }
        return rc;
    }

    public static boolean controlloProtocolloTelematico(String protocollo, String progr_dich, String annoDich) {
        boolean protOK = true;
        String data_invio = "";
        String ora_invio = "";
        String min_invio = "";
        String sec_invio = "";
        String num_invio = "";
        boolean protAss = false;
        if (protocollo.trim().length() == 17 && progr_dich.trim().length() == 6 && BaseTelem.currentSystem == 0 && (protocollo.equals("00000000000000000") || progr_dich.equals("000000"))) {
            return false;
        }
        if (protocollo.trim().length() == 17) {
            if (protocollo.equals("00000000000000000")) {
                protAss = true;
            } else {
                data_invio = String.valueOf(protocollo.substring(4, 6)) + protocollo.substring(2, 4) + "20" + protocollo.substring(0, 2);
                ora_invio = protocollo.substring(6, 8);
                min_invio = protocollo.substring(8, 10);
                sec_invio = protocollo.substring(10, 12);
                num_invio = protocollo.substring(12, 17);
                if (!Util.isNumericoAssoluto(data_invio) || data_invio.equals("00000000") || data_invio.equals("0000" + annoDich) || !Util.controlloData(data_invio)) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(ora_invio) || Util.valoreDouble(ora_invio) > 47.0) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(min_invio) || Util.valoreDouble(min_invio) > 59.0) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(sec_invio) || Util.valoreDouble(sec_invio) > 59.0) {
                    protOK = false;
                } else if (!Util.isNumericoAssoluto(num_invio) || Util.valoreDouble(num_invio) == 0.0) {
                    protOK = false;
                }
            }
        } else if (protocollo.trim().length() == 0) {
            protAss = true;
        } else {
            protOK = false;
        }
        if (progr_dich.trim().length() == 6) {
            if (!Util.isNumericoAssoluto(progr_dich) || progr_dich.equals("000000") && !protAss) {
                protOK = false;
            }
        } else if (progr_dich.trim().length() == 0) {
            if (!protAss) {
                protOK = false;
            }
        } else {
            protOK = false;
        }
        return protOK;
    }

    public boolean getBanchePoste() {
        return this.banchePoste;
    }

    public String getCodFiscDichiarante() {
        return this.codFiscDichiarante;
    }

    public int getCodGravConferma() {
        return this.codGravConferma;
    }

    public int getCodGravDatiIncoerenti() {
        return this.codGravDatiIncoerenti;
    }

    public int getTipoFornitore() {
        return this.tipoFornitore;
    }

    public abstract String getVersione();

    private int liquidaQuadriCompilati() {
        int rc = 0;
        String campo = "";
        this.codFiscDichiarante = this.BS(2).trim();
        Dichiarazione dich770 = null;
        if (this.TIPO_MODELLO.equals("770")) {
            String[] quadri = new String[]{"SF", "SG", "SH", "SI", "SK", "SL", "SM", "SO", "SP", "SQ", "SR", "ST", "SX"};
            campo = "";
            if (this.TIPO_MODELLO.equals("770")) {
                dich770 = this.getDichiarazione();
            }
            if (this.AI(7) == 0 && this.AI(8) == 0 || this.AI(7) == 1) {
                int ind = 177;
                while (ind <= 189) {
                    campo = "XXX" + Util.formNum(2, ind - 100);
                    if (this.BI(ind) != 1 && dich770.esisteQuadro(quadri[ind - 177])) {
                        rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1322", campo, (double)this.BI(ind), "1");
                    }
                    if (this.BI(ind) == 1 && !dich770.esisteQuadro(quadri[ind - 177])) {
                        rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1321", campo, (double)this.BI(ind), "");
                    }
                    ++ind;
                }
            }
        }
        return rc;
    }

    public int liquidaTRecA() {
        String cfRecA;
        int rc = 0;
        int CODGRAV24 = 24;
        String string = cfRecA = BaseTelem.currentSystem == 2 ? this.AS(5) : "AAAAAAAAAAAAAAAA";
        if (this.AI(7) > this.AI(8) || this.AI(7) == 0 && this.AI(8) > 0 || this.AI(7) == 1 && this.AI(8) == 1) {
            rc = Diagnostici.DIA(rc, 24, cfRecA, "1047", "XXA", "", "");
        }
        if (this.AS(3).equals("INP05") && this.AS(9).charAt(0) == '1') {
            rc = Diagnostici.DIA(rc, 4, "0000000000000000", "1042", "        ", "", "");
        }
        return rc;
    }

    public int liquidaTRecB() {
        int rc = 0;
        this.codGravDatiIncoerenti = this.banchePoste && this.BI(234) == 1 ? 4 : 16;
        this.codGravConferma = this.flagConferma ? 8 : 14;
        this.codFiscDichiarante = this.BS(2).trim();
        String cfProf = "";
        String cfAltro = "";
        rc = Util.aggRc(rc, this.liquidaTRecBProtocollo());
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && (this.AI(4) == 7 || this.AI(4) == 8)) {
            return rc;
        }
        if (this.TIPO_MODELLO.equals("77S")) {
            if (this.BL(214) != 0L && this.BL(215) != 0L && !LiquidatoreOld.controlloProtocolloTelematico(this.BS(214), this.BS(215), "2005")) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1068", "XXY14", "", "");
            }
            if (this.BL(214) != 0L && this.BL(215) == 0L) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXY14", "", "");
            }
            if (this.BL(214) == 0L && this.BL(215) != 0L) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXY15", "", "");
            }
            if (this.BL(214) != 0L && this.BL(215) != 0L && this.BI(9) == 0 && this.BI(10) == 0) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "6221", "XXB", "", "");
            }
        }
        if (this.BI(9) != 0 && this.BI(10) != 0) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1314", "XXB", "", "");
        }
        if (this.TIPO_MODELLO.equals("IVD")) {
            if (this.BI(36) == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB36", "", "");
            }
            if (this.BI(37) == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB37", "", "");
            }
            if (this.BI(36) != 0 && this.BI(37) != 0) {
                if (this.BI(36) != 2005 && this.BI(36) != 2004) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB36", this.BS(36), "");
                }
                String Periodo = String.valueOf(this.BS(37)) + this.BS(36);
                if (this.BI(36) == 2004 && this.BI(37) < 12) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB37", Periodo, "");
                }
            }
        }
        rc = Util.aggRc(rc, this.liquidaTRecBTipoFornitore());
        rc = Util.aggRc(rc, this.liquidaTRecBCF());
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && Util.esisteAlmenoUnCampo(this.recordB, 38, 50) && (Util.esisteAlmenoUnCampo(this.recordB, 68, 77) || Util.esisteAlmenoUnCampo(this.recordB, 82, 84) || this.BL(93) != 0L)) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1316", "XXB", "", "");
        }
        if (this.TIPO_MODELLO.equals("IVA") && Util.esisteAlmenoUnCampo(this.recordB, 38, 60) && Util.esisteAlmenoUnCampo(this.recordB, 69, 89)) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1316", "XXB", "", "");
        }
        if (this.TIPO_MODELLO.equals("IVD") && Util.esisteAlmenoUnCampo(this.recordB, 38, 60) && Util.esisteAlmenoUnCampo(this.recordB, 69, 88)) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1316", "XXB", "", "");
        }
        if (this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("IVD")) {
            rc = Util.aggRc(rc, this.liquidaTRecBAnagrafica());
        }
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("IVD")) && Util.esisteAlmenoUnCampo(this.recordB, 68, 77) && !Util.esisteAlmenoUnCampo(this.recordB, 98, 118)) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1318", "XXB", "", "");
        }
        if ((this.TIPO_MODELLO.equals("IVD") || this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA")) && Util.esisteAlmenoUnCampo(this.recordB, 98, 117)) {
            rc = Util.aggRc(rc, this.liquidaTRecBRappresentante());
        }
        if ((this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("IVD")) && this.BI(197) == 0) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX97", "", "");
        }
        rc = Util.aggRc(rc, this.liquidaQuadriCompilati());
        if (!this.TIPO_MODELLO.equals("77S") && this.BI(120) == 0) {
            rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1016", "XXX20", "", "");
        }
        if (!this.TIPO_MODELLO.equals("IVD") && Util.esisteAlmenoUnCampo(this.recordB, 206, 207) && this.BS(205).trim().length() == 0) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1014", "XXY05", "", "");
        }
        if (this.TIPO_MODELLO.equals("IVA")) {
            int[] certTrib;
            if (Util.esisteAlmenoUnCampo(this.recordB, 211, 213) && this.BS(210).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1014", "XXY10", "", "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, certTrib = new int[]{210, 211, 213}) && this.BI(212) == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXY12", "", "");
            }
            cfProf = this.BS(210).trim();
            cfAltro = this.BS(211).trim();
            if (cfProf.length() != 0 && cfAltro.length() != 0 && cfProf.equals(cfAltro)) {
                rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1351", "XXY11", "", "");
            }
        }
        if (this.BS(198).trim().length() != 0 && this.BI(203) == 0) {
            rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1310", "XXY03", "", "");
        }
        if (this.BS(205).trim().length() != 0 && this.BI(207) == 0) {
            rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1310", "XXY07", "", "");
        }
        if (this.TIPO_MODELLO.equals("IVA") && this.BS(210).trim().length() != 0 && this.BI(213) == 0) {
            rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1310", "XXY13", "", "");
        }
        return rc;
    }

    private int liquidaTRecBAnagrafica() {
        int rc = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        boolean isCFNumerico = Util.isNumericoAssoluto(this.codFiscDichiarante);
        if ((this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("IVD")) && this.BL(28) == 0L) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1096", "XXB28", this.BS(28), "");
        }
        if (this.BS(33).trim().length() > 0 && !Util.isNumericoAssoluto(this.BS(33).trim())) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1011", "XXB33", "", "");
        }
        if (this.BS(34).trim().length() > 0 && !Util.isNumericoAssoluto(this.BS(34).trim())) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1011", "XXB34", "", "");
        }
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("IVD")) && !isCFNumerico) {
            String provRes;
            if (this.BS(45).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB45", "", "");
            }
            if (!(provRes = this.BS(46).trim()).equals("EE") && !Util.isNonValorizzato(provRes)) {
                if (this.BI(48) == 0) {
                    rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1016", "XXB48", "", "");
                }
                if (this.BS(47).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB47", "", "");
                }
            }
        }
        return rc;
    }

    private int liquidaTRecBCF() {
        int rc = 0;
        int rcBP = 0;
        String CF2 = this.BS(2).trim();
        String CF10 = "";
        if (CF2.length() > 9) {
            CF10 = this.BS(2).substring(0, 10);
        }
        boolean isCfAssente = CF10.equals("PROG REC N");
        boolean isCFNumerico = false;
        boolean isCFerrato = true;
        if (!isCfAssente) {
            isCFNumerico = Util.isNumericoAssoluto(CF2);
            isCFerrato = !Util.controlloCF(CF2);
        }
        boolean pf = false;
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("IVD")) && !isCFNumerico) {
            pf = true;
        }
        boolean errore = true;
        errore = true;
        if (this.banchePoste && (this.BS(25).trim().length() != 0 && this.BS(26).trim().length() != 0 || this.BS(27).trim().length() != 0)) {
            errore = false;
        }
        if (isCfAssente && errore) {
            rc = Diagnostici.DIA(rc, 16, CF2, "1016", "XXB02", "", "");
        }
        if (!isCfAssente && isCFerrato && errore) {
            rc = Diagnostici.DIA(rc, 16, CF2, "1013", "XXB02", CF2, "");
        }
        errore = true;
        if (this.banchePoste && !isCFerrato) {
            errore = false;
        }
        if (!pf) {
            if (this.BS(27).trim().length() == 0 && errore) {
                rc = Diagnostici.DIA(rc, 16, CF2, "1016", "XXB27", "", "");
            }
        } else {
            if (this.BS(25).trim().length() == 0 && errore) {
                rc = Diagnostici.DIA(rc, 16, CF2, "1016", "XXB25", "", "");
            }
            if (this.BS(26).trim().length() == 0 && errore) {
                rc = Diagnostici.DIA(rc, 16, CF2, "1016", "XXB26", "", "");
            }
        }
        if (this.BS(25).trim().length() != 0 && this.BS(27).trim().length() != 0) {
            rc = Diagnostici.DIA(rc, 16, CF2, "1342", "XXB", "", "");
        } else if (this.BS(26).trim().length() != 0 && this.BS(27).trim().length() != 0) {
            rc = Diagnostici.DIA(rc, 16, CF2, "1342", "XXB", "", "");
        }
        int coderr = 16;
        if (this.banchePoste) {
            coderr = this.codGravDatiIncoerenti;
        }
        if (pf) {
            if (this.BS(38).trim().length() == 0 && errore) {
                rcBP = Diagnostici.DIA(rcBP, coderr, this.codFiscDichiarante, "1016", "XXB38", "", "");
            }
            if (this.BL(40) == 0L && errore) {
                rcBP = Diagnostici.DIA(rcBP, coderr, this.codFiscDichiarante, "1016", "XXB40", "", "");
            }
            if (this.BS(41).trim().length() == 0 && errore) {
                rcBP = Diagnostici.DIA(rcBP, coderr, this.codFiscDichiarante, "1016", "XXB41", "", "");
            }
            rc = Util.aggRc(rc, rcBP);
        }
        return rc;
    }

    private int liquidaTRecBDatiSocieta() {
        int rc = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        boolean isCFNumerico = Util.isNumericoAssoluto(this.codFiscDichiarante);
        boolean isProvIta = false;
        String CF11 = "";
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("IVD")) && isCFNumerico) {
            String prov;
            if (!Util.controlloMeseAnno(this.BS(68))) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXB68", this.BS(68), "");
            }
            if (this.BS(65).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB65", "", "");
            }
            if (!(prov = this.BS(70).trim()).equals("EE") && !Util.isNonValorizzato(prov)) {
                if (this.BS(71).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB71", "", "");
                }
                if (this.BI(72) == 0) {
                    rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1016", "XXB72", "", "");
                }
            }
            if (!Util.controlloMeseAnno(this.BS(73))) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXB73", this.BS(73), "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BS(74).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB74", "", "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BS(75).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB75", "", "");
            }
            if (this.BS(75).trim().length() != 0 && this.BS(75).trim().equals("EE")) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1354", "XXB75", "", "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BS(76).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB76", "", "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BI(77) == 0) {
                rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1016", "XXB77", "", "");
            }
            if (this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) {
                if (this.BI(82) == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB82", "", "");
                }
                if (this.BI(84) == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB84", "", "");
                }
            }
            if (this.BI(83) == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB83", "", "");
            }
            if (this.TIPO_MODELLO.equals("770") && this.BI(178) == 0 && Util.esisteAlmenoUnCampo(this.recordB, 86, 88)) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "6234", "XXB86", "", "");
            }
        }
        return rc;
    }

    private int liquidaTRecBProtocollo() {
        int rc = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        String[] rcProt = new String[5];
        if (this.banchePoste) {
            rcProt = LiquidatoreOld.controlloProtocolloBanchePoste(this.BS(5), this.BS(222), this.BD(223), this.getCodiceFornitura(), this.tipoFornitore, this.BI(229), this.BI(224), 2004);
            if (rcProt[0].equals("1070")) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, rcProt[0], "XXB05", "", "");
            }
            if (rcProt[1].equals("1071") && !rcProt[0].equals("1070")) {
                rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1070", "XXB05", "", "");
            }
            if (rcProt[2].equals("1072")) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, rcProt[2], "XXY22", "", "");
            }
            if (rcProt[3].equals("1073")) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, rcProt[3], "XXY23", "", "");
            }
            if (rcProt[4].equals("1095")) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, rcProt[4], "XXY24", "", "");
            }
        } else if (this.BS(5).trim().length() != 0) {
            rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1300", "XXB05", "", "");
        }
        if (this.tipoFornitore == 7 && this.BS(220).trim().length() != 0) {
            String protocollo = this.BS(227).trim();
            if (protocollo.length() == 25) {
                String abi = protocollo.substring(0, 5);
                String cab = protocollo.substring(5, 10);
                String tipo = protocollo.substring(10, 13);
                String data8 = protocollo.substring(13, 21);
                String progr = protocollo.substring(21, 25);
                double annoCorrente = 2005.0;
                if (!(Util.isNumericoAssoluto(abi) && !abi.equals("00000") && Util.isNumericoAssoluto(cab) && !cab.equals("00000") && (tipo.equals("UNI") || tipo.equals("SCE") || tipo.equals("SCS") || tipo.equals("IVA") || tipo.equals("730") || tipo.equals("U50") || tipo.equals("U60") || tipo.equals("U61") || tipo.equals("770") || tipo.equals("77S")) && Util.isNumericoAssoluto(data8) && Util.controlloData(data8) && !data8.equals("00000000") && Util.isNumericoAssoluto(progr))) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1070", "XXY27", "", "");
                } else if (Util.valoreDouble(data8.substring(4, 8)) != annoCorrente && Util.valoreDouble(data8.substring(4, 8)) != annoCorrente - 1.0 && Util.valoreDouble(data8.substring(4, 8)) != annoCorrente + 1.0 && Util.valoreDouble(data8.substring(4, 8)) != annoCorrente + 2.0 && Util.valoreDouble(data8.substring(4, 8)) != annoCorrente + 3.0 && Util.valoreDouble(data8.substring(4, 8)) != annoCorrente + 4.0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1070", "XXY27", "", "");
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1070", "XXY27", "", "");
            }
        }
        return rc;
    }

    private int liquidaTRecBRappresentanteDenominazione() {
        int rc = 0;
        String codFiscRappresentante = this.BS(98).trim();
        boolean isNascitaPresente = Util.esistenzaTuttiCampi(this.recordB, 105, 110, true);
        if (Util.isNumericoAssoluto(codFiscRappresentante) && this.BS(104).trim().length() == 0) {
            rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1362", "XXX04", "", "");
        }
        if (isNascitaPresente && this.BS(104).trim().length() != 0) {
            rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1363", "XXX04", "", "");
        }
        return rc;
    }

    private int liquidaTRecBRappresentante() {
        String prov;
        int rc = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        String codFiscRappresentante = this.BS(98).trim();
        boolean isAnagraficaPresente = Util.esistenzaTuttiCampi(this.recordB, 98, 114, true);
        boolean isProvIta = false;
        boolean isPf = false;
        if (!this.banchePoste) {
            if (codFiscRappresentante.length() == 0) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1014", "XXB98", "", "");
            }
            if (!Util.isNumericoAssoluto(codFiscRappresentante) || this.TIPO_MODELLO.equals("IVD") || this.TIPO_MODELLO.equals("IVA")) {
                isPf = true;
            }
            if (this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) {
                rc = Util.aggRc(rc, this.liquidaTRecBRappresentanteDenominazione());
            }
            if (isPf) {
                if (this.BS(105).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXX05", "", "");
                }
                if (this.BS(106).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXX06", "", "");
                }
                if (this.BS(107).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXX07", "", "");
                }
                if (this.BI(108) == 0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXX08", "", "");
                }
                if (this.BS(109).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXX09", "", "");
                }
            }
        } else {
            if (!isAnagraficaPresente && codFiscRappresentante.length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1014", "XXB98", "", "");
            }
            if (codFiscRappresentante.length() == 0) {
                if (this.BS(105).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX05", "", "");
                }
                if (this.BS(106).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX06", "", "");
                }
                if (this.BS(107).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX07", "", "");
                }
                if (this.BI(108) == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX08", "", "");
                }
                if (this.BS(109).trim().length() == 0) {
                    rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX09", "", "");
                }
            }
            if (isAnagraficaPresente && codFiscRappresentante.length() != 0 && Util.controlloCF(codFiscRappresentante)) {
                rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1326", "XXB", "", "");
            }
        }
        if (this.BI(101) == 0) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX01", "", "");
        }
        if (!(prov = this.BS(112).trim()).equals("EE") && !Util.isNonValorizzato(prov)) {
            isProvIta = true;
        }
        if (isProvIta) {
            if (this.BS(111).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX10", "", "");
            }
            if (this.BI(113) == 0) {
                rc = Diagnostici.DIA(rc, CODWARNING, this.codFiscDichiarante, "1016", "XXX13", "", "");
            }
            if (this.BS(114).trim().length() == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX14", "", "");
            }
        }
        if ((this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("IVD")) && this.BI(101) != 1 && this.BI(101) != 6 && this.BI(101) != 9 && this.BL(99) != 0L) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1300", "XXB99", "", "");
        }
        if (this.TIPO_MODELLO.equals("IVA") && this.BI(103) == 0 && (this.BI(101) == 3 || this.BI(101) == 4)) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX03", "", "");
        }
        if (this.BS(115).trim().length() > 0 && !Util.isNumericoAssoluto(this.BS(115).trim())) {
            rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1011", "XXX15", "", "");
        }
        return rc;
    }

    public int liquidaTRecBScelte() {
        int rc = 0;
        return rc;
    }

    private int liquidaTRecBTipoFornitore() {
        boolean propria;
        int rc = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        int codiceCarica = this.BI(101);
        String codFiscFornitore = this.AS(5).trim();
        String codFiscRappresentante = this.BS(98).trim();
        String codFiscIntermediario = this.BS(198).trim();
        boolean esisteIntermediario = Util.esisteAlmenoUnCampo(this.recordB, 198, 203);
        boolean bl = propria = codFiscFornitore.equals(this.codFiscDichiarante) || codFiscFornitore.equals(codFiscRappresentante);
        if (this.tipoFornitore == 10 && !propria && !esisteIntermediario) {
            rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1303", "XXB", "", "");
        }
        if (this.tipoFornitore == 6) {
            if (!Util.isNumericoAssoluto(this.codFiscDichiarante) || this.codFiscDichiarante.length() != 11) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1305", "XXB02", this.codFiscDichiarante, "");
            }
            if (!codFiscFornitore.equals(this.codFiscDichiarante) && !codFiscFornitore.equals(codFiscIntermediario)) {
                rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1306", "XXB02", "", "");
            }
        }
        if ((this.tipoFornitore == 7 || this.tipoFornitore == 8) && this.BS(232).trim().length() == 0) {
            rc = Diagnostici.DIA(rc, 16, this.codFiscDichiarante, "1016", "XXY32", "", "");
        }
        if (esisteIntermediario) {
            if (Util.isNonValorizzato(codFiscIntermediario)) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1074", "XXX98", "", "");
            }
            if (this.BI(200) == 1 && this.BI(201) == 1) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1307", "XXY00", "", "");
            } else if (this.BI(200) == 0 && this.BI(201) == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1308", "XXY00", "", "");
            }
            if (this.BI(202) == 0) {
                rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1309", "XXY02", "", "");
            }
        }
        return rc;
    }

    public int liquidaTRecZ(int[] ctrRecords) {
        int rc = 0;
        String cfRecZ = "ZZZZZZZZZZZZZZZZ";
        if (this.ZD(3) != (double)ctrRecords[0]) {
            rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ03", this.ZD(3), (double)ctrRecords[0]);
        }
        if (this.TIPO_MODELLO.equals("UNI") || this.TIPO_MODELLO.equals("U50") || this.TIPO_MODELLO.equals("U60") || this.TIPO_MODELLO.equals("U61")) {
            if (this.ZD(4) != (double)ctrRecords[1]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ04", this.ZD(4), (double)ctrRecords[1]);
            }
            if (this.ZD(5) != (double)ctrRecords[2]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ05", this.ZD(5), (double)ctrRecords[2]);
            }
            if (this.ZD(6) != (double)ctrRecords[3]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ06", this.ZD(6), (double)ctrRecords[3]);
            }
            if (this.ZD(7) != (double)ctrRecords[7]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ07", this.ZD(7), (double)ctrRecords[7]);
            }
            if (this.ZD(8) != (double)ctrRecords[10]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ08", this.ZD(8), (double)ctrRecords[10]);
            }
            if (this.ZD(9) != (double)ctrRecords[15]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ10", this.ZD(9), (double)ctrRecords[15]);
            }
            if (this.ZD(10) != (double)ctrRecords[16]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ10", this.ZD(10), (double)ctrRecords[16]);
            }
            if (this.ZD(11) != (double)ctrRecords[17]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ11", this.ZD(11), (double)ctrRecords[17]);
            }
            if (this.ZD(12) != (double)ctrRecords[18]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ12", this.ZD(12), (double)ctrRecords[18]);
            }
            if (this.ZD(13) != (double)ctrRecords[19]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ13", this.ZD(13), (double)ctrRecords[19]);
            }
            if (this.ZD(14) != (double)ctrRecords[22]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ14", this.ZD(14), (double)ctrRecords[22]);
            }
        }
        if ((this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("CAP")) && this.ZD(4) != (double)ctrRecords[1]) {
            rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ04", this.ZD(4), (double)ctrRecords[1]);
        }
        if (this.TIPO_MODELLO.equals("77S")) {
            if (this.ZD(4) != (double)ctrRecords[1]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ04", this.ZD(4), (double)ctrRecords[1]);
            }
            if (this.ZD(5) != (double)ctrRecords[2]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ05", this.ZD(5), (double)ctrRecords[2]);
            }
            if (this.ZD(6) != (double)ctrRecords[3]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ06", this.ZD(6), (double)ctrRecords[3]);
            }
            if (this.ZD(7) != (double)ctrRecords[4]) {
                rc = Diagnostici.DIA(rc, CODWARNING, cfRecZ, "1018", "XXZ07", this.ZD(7), (double)ctrRecords[4]);
            }
        }
        return rc;
    }

    public String mod(int m) {
        String modulo = Util.formNum(8, m);
        return modulo;
    }

    public int numeroModuliQuadro(String quadro) {
        return this.dich.maxModuliDaQuadro(quadro);
    }

    public void setBanchePoste(boolean banchePoste) {
        this.banchePoste = banchePoste;
    }

    public void setTipoFornitore(int tipoFornitore) {
        this.tipoFornitore = tipoFornitore;
    }

    protected int soloSulPrimoModulo(String[] campi, String cfPerc) {
        int rc = 0;
        if (campi == null) {
            return rc;
        }
        int len = campi.length;
        int j = 0;
        while (j < len) {
            String codCampo = campi[j];
            if (codCampo.length() == 8) {
                String quadro = codCampo.substring(0, 2);
                String rigaColonna = codCampo.substring(2, 8);
                int MaxModQuadro = this.dich.maxModuliDaQuadro(quadro);
                int i = 2;
                while (i <= MaxModQuadro) {
                    String modCorrente = Util.formNum(8, i);
                    if (this.dich.esisteCampo(String.valueOf(codCampo) + modCorrente)) {
                        rc = Diagnostici.DIA(rc, this.codGravDatiIncoerenti, cfPerc, "1052", String.valueOf(quadro) + rigaColonna + modCorrente, "", "", "", "");
                    }
                    ++i;
                }
            } else {
                System.out.println("!!!ERRORE!!! - soloSulPrimoModulo(...): formato del codice campo errato: " + codCampo);
            }
            ++j;
        }
        return rc;
    }
}

