 
/****************************************************************************
 *  (c) Copyright 2007 Wi-Fi Alliance.  All Rights Reserved
 *
 *
 *  LICENSE
 *
 *  License is granted only to Wi-Fi Alliance members and designated
 *  contractors (.$B!H.(BAuthorized Licensees.$B!I.(B)...A.N  Authorized Licensees are granted
 *  the non-exclusive, worldwide, limited right to use, copy, import, export
 *  and distribute this software:
 *  (i) solely for noncommercial applications and solely for testing Wi-Fi
 *  equipment; and
 *  (ii) solely for the purpose of embedding the software into Authorized
 *  Licensee.$B!G.(Bs proprietary equipment and software products for distribution to
 *  its customers under a license with at least the same restrictions as
 *  contained in this License, including, without limitation, the disclaimer of
 *  warranty and limitation of liability, below...A.N  The distribution rights
 *  granted in clause
 *  (ii), above, include distribution to third party companies who will
 *  redistribute the Authorized Licensee.$B!G.(Bs product to their customers with or
 *  without such third party.$B!G.(Bs private label. Other than expressly granted
 *  herein, this License is not transferable or sublicensable, and it does not
 *  extend to and may not be used with non-Wi-Fi applications...A.N  Wi-Fi Alliance
 *  reserves all rights not expressly granted herein...A.N 
 *..A.N 
 *  Except as specifically set forth above, commercial derivative works of
 *  this software or applications that use the Wi-Fi scripts generated by this
 *  software are NOT AUTHORIZED without specific prior written permission from
 *  Wi-Fi Alliance.
 *..A.N 
 *  Non-Commercial derivative works of this software for internal use are
 *  authorized and are limited by the same restrictions; provided, however,
 *  that the Authorized Licensee shall provide Wi-Fi Alliance with a copy of
 *  such derivative works under a perpetual, payment-free license to use,
 *  modify, and distribute such derivative works for purposes of testing Wi-Fi
 *  equipment.
 *..A.N 
 *  Neither the name of the author nor "Wi-Fi Alliance" may be used to endorse
 *  or promote products that are derived from or that use this software without
 *  specific prior written permission from Wi-Fi Alliance.
 *
 *  THIS SOFTWARE IS PROVIDED BY WI-FI ALLIANCE "AS IS" AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A..A.N PARTICULAR PURPOSE,
 *  ARE DISCLAIMED. IN NO EVENT SHALL WI-FI ALLIANCE BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, THE COST OF PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE) ARISING IN ANY WAY OUT OF
 *  THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. ******************************************************************************
 */

/*
 * File: wfa_miscs.c - misc functions for agents.
 * 
 *       Revision History:
 *          2006/03/10 -- initially created by qhu
 *          2006/06/01 -- BETA release by qhu
 *          2006/06/13 -- 00.02 release by qhu
 *          2006/06/30 -- 00.10 Release by qhu
 *          2006/07/10 -- 01.00 Release by qhu
 *          2006/09/01 -- 01.05 Release by qhu
 *          2007/01/11 -- 01.10 Released by qhu
 *          2007/02/15  -- WMM Extension Beta released by qhu, mkaroshi
 *          2007/03/30 -- 01.40 WPA2 and Official WMM Beta Release by qhu
 *          2007/04/20 -- 02.00 WPA2 and Official WMM Release by qhu
 *          2007/08/15 --  02.10 WMM-Power Save release by qhu
 *          2007/10/10 --  02.20 Voice SOHO beta -- qhu
 *          2007/11/07 --  02.30 Voice HSO -- qhu
 *
 */
#include <stdio.h>
#include <stdlib.h>

#include "wfa_debug.h"
#include "wfa_sock.h"
#include "wfa_main.h"
#include "wfa_types.h"
#include "wfa_tg.h"
#include "wfa_miscs.h"
#include "wfa_cmds.h"
#ifdef WIN32
#include "io.h"
#endif /* #ifdef WIN32 */
#include "stdlib.h"

#ifndef SIOCGIWNAME
#define SIOCGIWNAME 0x8B01
#endif

extern unsigned short wfa_defined_debug;
extern tgStream_t *theStreams;
extern char PingStr[];
tgStream_t *findStreamProfile(int id);

/*
 * printProfile(): a debugging function to display a profile info based on
 *                 a streamId
 */

void printProfile(tgProfile_t *pf)
{
	DPRINT_INFO(WFA_OUT, "profile type %i direction %i Dest ipAddr %s Dest port %i So ipAddr %s So port %i rate %i duration %i pksize %i\n", pf->profile, pf->direction, pf->dipaddr, pf->dport, pf->sipaddr, pf->sport, pf->rate, pf->duration, pf->pksize);
}


int isString(char *str)
{
	if(*str == '\0')
		return FALSE;

	if((str[0] >= 'a' && str[0] <= 'z') 
		|| (str[0] > 'A' && str[0] < 'Z'))
		return TRUE;
	else
		return FALSE;
}

int isNumber(char *str)
{
	if(*str == '\0')
		return FALSE;

	if (str[0] >= '0' && str[0] <= '9')
		return TRUE;
	else
		return FALSE;
}

int isIpV4Addr(char *str)
{
	int dots = 0;
	char *tmpstr = str;

	if(*str == '\0')
		return FALSE;

	while(*tmpstr != '\0')
	{
		if(*tmpstr == '.')
		{
			dots++;
		}

		tmpstr++;
	}

	if(dots <3)
		return FALSE;
	else
		return TRUE;
}



inline double wfa_timeval2double(struct timeval *tval)
{
	return ((double) tval->tv_sec + (double) tval->tv_usec*1e-6);
}

inline void wfa_double2timeval(struct timeval *tval, double dval)
{
	tval->tv_sec = (long int) dval;
	tval->tv_usec = (long int) ((dval - tval->tv_sec) * 1000000);
}

inline double wfa_ftime_diff(struct timeval *t1, struct timeval *t2)
{
	double dtime;

	dtime = wfa_timeval2double(t2) - wfa_timeval2double(t1);
	return dtime ;
}

int wfa_itime_diff(struct timeval *t1, struct timeval *t2)
{
	int dtime;
	int sec = t2->tv_sec - t1->tv_sec;
	int usec = t2->tv_usec - t1->tv_usec;

	if(usec < 0)
	{
		sec -=1;
		usec += 1000000;
	}

	dtime = sec*1000000 + usec;
	return dtime;
}


/*
 * THe following two functions are converting Little Endian to Big Endian. 
 * If your machine is already a Big Endian, you may flag it out.
 */
inline void int2BuffBigEndian(int val, char *buf)
{
	char *littleEn = (char *)&val;

	buf[0] = littleEn[3];
	buf[1] = littleEn[2];
	buf[2] = littleEn[1];
	buf[3] = littleEn[0];
}

int bigEndianBuff2Int(char *buff)
{
	int val;
	char *strval = (char *)&val;

	strval[0] = buff[3];
	strval[1] = buff[2];
	strval[2] = buff[1];
	strval[3] = buff[0];

	return val;
}


/*
 * The following functions will execute the function by calling asd_Config
 * and results are captured in strstrParams. 
 * The stderr is captured in temporary file. 
 */

int
asd_Config_wmm(char *strFunct, char *strstrParams)
{
	FILE *pipe_fp, *err_fp;
	char temp[280];
	int stat, err_file_size, newErrFd;

	if ((err_fp = fopen(TEMP_STD_ERR_FILE, "w+")) == NULL) {
		DPRINT_ERR(WFA_ERR, "\nFile open error\n");
		return -1;
	}
	newErrFd = DUP(STD_ERR);

	if ((stat = DUP2(fileno(err_fp), STD_ERR)) == -1)  {
		DPRINT_ERR(WFA_ERR, "Error in dup2(fd, STD_ERR) \n");
		return 0;
	}

	sprintf(strFunct, "%s > %s", strFunct, strstrParams);

	/* Execute the command */
	if((pipe_fp = asd_Config(strFunct, strstrParams)) == NULL){
		DPRINT_ERR(WFA_ERR, "asd_Config_wmm:: Error in executing asd_Config\n");
		return -1;
	}
	fflush(stderr);	
	fgets(temp, sizeof(temp), pipe_fp);
	Cleanup_File(pipe_fp);

	/* obtain error file size */
	if (fseek(err_fp, 0, SEEK_END) < 0)
		return -1;
	err_file_size = ftell(err_fp);
	fclose(err_fp);	

	if ((stat = DUP2(newErrFd, STD_ERR)) == -1) {
		DPRINT_ERR(WFA_ERR, "Error in dup2(newErrFd, STD_ERR) \n");
		return 0;
	}

	return err_file_size;
}

/*
 * The following functions will execute the function by calling exec_process
 * The stderr is captured in temporary file. 
 */

int
exec_wmmCmd(char* command)
{
	int newErrFd, stat, file_size;
	FILE *fp;

	fp = fopen(TEMP_STD_ERR_FILE, "w+");
	if ((newErrFd = DUP(STD_ERR)) == -1) {
		DPRINT_ERR(WFA_ERR, "\nError in dup(2)\n");
		return newErrFd;
	}

	if ((stat = DUP2(fileno(fp), STD_ERR)) == -1) {
		DPRINT_ERR(WFA_ERR, "\nError in dup2(fd, 2)\n");
		return stat;
	}

	exec_process(command);

	/* obtain file size */
	fflush(stderr);	
	if (fseek(fp, 0, SEEK_END) < 0)
		file_size = 0;
	file_size = ftell(fp);
	fclose(fp);	

	if ((stat = DUP2(newErrFd, STD_ERR)) == -1) {
		DPRINT_ERR(WFA_ERR, "\nError in dup2(newErrFd, 2)\n");
		return stat;
	}
	return file_size;
}
