/* Generated by re2c 0.13.5 on Sun Oct 26 11:59:08 2008 */
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id: parse_date.c,v 1.29.2.30.2.17 2008/10/26 11:27:07 derick Exp $ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_UNSET   -99999

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7
#define TIMELIB_SPECIAL 8

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { add_warning(s, "Double timezone specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == TIMELIB_UNSET) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != '\t') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->special.type = relunit->multiplier;
			s->time->special.amount = amount;
	}
}

const static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
		}
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/") || strcmp(tz_abbr, "UTC") == 0) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (found && t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;



{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 104,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		104,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0, 128,  64, 160,  96,   0, 
		  4,   4,   4,   4,   4,   4,   4,   4, 
		  4,   4,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  16,  16,  16,  80,  16,  16,  16, 
		 80,  16,  16,  16,  16,  16,  80,  16, 
		 16,  16,  80,  80,  80,  16,  16,  16, 
		 16,  16,  16,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};

	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 29) YYFILL(29);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case 0x00:
	case '\n':	goto yy48;
	case '\t':
	case ' ':	goto yy45;
	case '(':	goto yy42;
	case '+':
	case '-':	goto yy18;
	case ',':
	case '.':	goto yy47;
	case '0':	goto yy13;
	case '1':	goto yy14;
	case '2':	goto yy15;
	case '3':	goto yy16;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy17;
	case '@':	goto yy11;
	case 'A':	goto yy26;
	case 'B':
	case 'C':
	case 'G':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy43;
	case 'D':	goto yy32;
	case 'E':	goto yy36;
	case 'F':	goto yy24;
	case 'I':	goto yy19;
	case 'J':	goto yy22;
	case 'L':	goto yy38;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy30;
	case 'P':	goto yy40;
	case 'S':	goto yy28;
	case 'T':	goto yy9;
	case 'V':	goto yy20;
	case 'W':	goto yy34;
	case 'X':	goto yy21;
	case 'Y':	goto yy2;
	case 'a':	goto yy27;
	case 'b':
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy44;
	case 'd':	goto yy33;
	case 'e':	goto yy37;
	case 'f':	goto yy25;
	case 'j':	goto yy23;
	case 'l':	goto yy39;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy31;
	case 'p':	goto yy41;
	case 's':	goto yy29;
	case 't':	goto yy10;
	case 'w':	goto yy35;
	case 'y':	goto yy4;
	default:	goto yy50;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy1415;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych >= 'a') goto yy142;
		} else {
			if (yych <= 'e') goto yy1424;
			if (yych <= 'z') goto yy142;
		}
	}
yy3:
	YYDEBUG(3, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy1415;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'e') goto yy1415;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1386;
				goto yy137;
			} else {
				if (yych <= 'I') goto yy1387;
				if (yych <= 'N') goto yy137;
				goto yy1385;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1402;
				goto yy142;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1403;
				goto yy142;
			} else {
				if (yych <= 'o') goto yy1401;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1386;
				goto yy137;
			} else {
				if (yych <= 'I') goto yy1387;
				if (yych <= 'N') goto yy137;
				goto yy1385;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1386;
				goto yy137;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1387;
				goto yy137;
			} else {
				if (yych <= 'o') goto yy1385;
				if (yych <= 'z') goto yy137;
				goto yy3;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy1355;
		} else {
			if (yych == 'I') goto yy1356;
			if (yych <= 'N') goto yy137;
			goto yy1357;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1370;
			goto yy142;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1371;
				goto yy142;
			} else {
				if (yych <= 'o') goto yy1372;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy1355;
		} else {
			if (yych == 'I') goto yy1356;
			if (yych <= 'N') goto yy137;
			goto yy1357;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1355;
			goto yy137;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1356;
				goto yy137;
			} else {
				if (yych <= 'o') goto yy1357;
				if (yych <= 'z') goto yy137;
				goto yy3;
			}
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case ')':	goto yy136;
	case '0':
	case '1':	goto yy1287;
	case '2':	goto yy1288;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1289;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy137;
	case 'E':	goto yy1282;
	case 'H':	goto yy1283;
	case 'O':	goto yy1284;
	case 'U':	goto yy1285;
	case 'W':	goto yy1286;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'e':	goto yy1324;
	case 'h':	goto yy1325;
	case 'o':	goto yy1326;
	case 'u':	goto yy1327;
	case 'w':	goto yy1328;
	default:	goto yy3;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case ')':	goto yy136;
	case '0':
	case '1':	goto yy1287;
	case '2':	goto yy1288;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1289;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'E':
	case 'e':	goto yy1282;
	case 'H':
	case 'h':	goto yy1283;
	case 'O':
	case 'o':	goto yy1284;
	case 'U':
	case 'u':	goto yy1285;
	case 'W':
	case 'w':	goto yy1286;
	default:	goto yy3;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1278;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1279;
yy12:
	YYDEBUG(12, *YYCURSOR);
	{
		add_error(s, "Unexpected character");
		goto std;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy1232;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy1234;
	case '-':	goto yy676;
	case '.':	goto yy1244;
	case '/':	goto yy675;
	case '0':	goto yy1277;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1276;
	case ':':	goto yy1245;
	case 'n':	goto yy673;
	case 'r':	goto yy674;
	case 's':	goto yy667;
	case 't':	goto yy671;
	default:	goto yy12;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy663;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy665;
	case '-':	goto yy676;
	case '.':	goto yy677;
	case '/':	goto yy675;
	case '0':
	case '1':
	case '2':	goto yy1276;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1243;
	case ':':	goto yy686;
	case 'n':	goto yy673;
	case 'r':	goto yy674;
	case 's':	goto yy667;
	case 't':	goto yy671;
	default:	goto yy12;
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy663;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy665;
	case '-':	goto yy676;
	case '.':	goto yy677;
	case '/':	goto yy675;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1243;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1230;
	case ':':	goto yy686;
	case 'n':	goto yy673;
	case 'r':	goto yy674;
	case 's':	goto yy667;
	case 't':	goto yy671;
	default:	goto yy12;
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy663;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy665;
	case '-':	goto yy676;
	case '.':	goto yy677;
	case '/':	goto yy675;
	case '0':
	case '1':	goto yy1230;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy672;
	case ':':	goto yy686;
	case 'n':	goto yy673;
	case 'r':	goto yy674;
	case 's':	goto yy667;
	case 't':	goto yy671;
	default:	goto yy12;
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy663;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy665;
	case '-':	goto yy676;
	case '.':	goto yy677;
	case '/':	goto yy675;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy672;
	case ':':	goto yy686;
	case 'n':	goto yy673;
	case 'r':	goto yy674;
	case 's':	goto yy667;
	case 't':	goto yy671;
	default:	goto yy12;
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy54;
	}
	YYDEBUG(-1, yych);
	switch (yych) {
	case '+':
	case '-':	goto yy641;
	case '0':
	case '1':	goto yy638;
	case '2':	goto yy639;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy640;
	default:	goto yy12;
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy305;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy137;
			} else {
				if (yych <= 'I') goto yy637;
				if (yych <= 'U') goto yy137;
				goto yy636;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy636;
				goto yy137;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy305;
			if (yych <= 0x1F) goto yy3;
			goto yy305;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy305;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy305;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy633;
				goto yy137;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy305;
			if (yych <= 0x1F) goto yy3;
			goto yy305;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy305;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy305;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy631;
				goto yy137;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy614;
			if (yych <= 'T') goto yy137;
			goto yy613;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy623;
		} else {
			if (yych == 'u') goto yy622;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy614;
			if (yych <= 'T') goto yy137;
			goto yy613;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy614;
		} else {
			if (yych == 'u') goto yy613;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy137;
				goto yy575;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy576;
				goto yy137;
			} else {
				if (yych <= 'O') goto yy577;
				if (yych <= 'Q') goto yy137;
				goto yy578;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy137;
				if (yych <= '`') goto yy3;
				goto yy142;
			} else {
				if (yych <= 'e') goto yy594;
				if (yych <= 'h') goto yy142;
				goto yy595;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy596;
				goto yy142;
			} else {
				if (yych <= 'r') goto yy597;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy137;
				goto yy575;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy576;
				goto yy137;
			} else {
				if (yych <= 'O') goto yy577;
				if (yych <= 'Q') goto yy137;
				goto yy578;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy137;
				if (yych <= '`') goto yy3;
				goto yy137;
			} else {
				if (yych <= 'e') goto yy575;
				if (yych <= 'h') goto yy137;
				goto yy576;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy577;
				goto yy137;
			} else {
				if (yych <= 'r') goto yy578;
				if (yych <= 'z') goto yy137;
				goto yy3;
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy554;
				goto yy137;
			} else {
				if (yych <= 'P') goto yy553;
				if (yych <= 'T') goto yy137;
				goto yy552;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych == 'g') goto yy566;
				goto yy142;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy565;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy564;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy554;
				goto yy137;
			} else {
				if (yych <= 'P') goto yy553;
				if (yych <= 'T') goto yy137;
				goto yy552;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych == 'g') goto yy554;
				goto yy137;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy553;
				goto yy137;
			} else {
				if (yych <= 'u') goto yy552;
				if (yych <= 'z') goto yy137;
				goto yy3;
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy495;
				goto yy137;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy494;
				goto yy137;
			} else {
				if (yych <= 'I') goto yy496;
				if (yych <= 'T') goto yy137;
				goto yy497;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy524;
				if (yych <= 'd') goto yy142;
				goto yy523;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy525;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy526;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy495;
				goto yy137;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy494;
				goto yy137;
			} else {
				if (yych <= 'I') goto yy496;
				if (yych <= 'T') goto yy137;
				goto yy497;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy495;
				if (yych <= 'd') goto yy137;
				goto yy494;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy496;
				goto yy137;
			} else {
				if (yych <= 'u') goto yy497;
				if (yych <= 'z') goto yy137;
				goto yy3;
			}
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy137;
			goto yy484;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'c') goto yy489;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy137;
			goto yy484;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'c') goto yy484;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy301;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy477;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy301;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'e') goto yy301;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy274;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy288;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy274;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'e') goto yy274;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'I') goto yy254;
			if (yych <= 'K') goto yy137;
			goto yy255;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy142;
			goto yy264;
		} else {
			if (yych == 'l') goto yy265;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'I') goto yy254;
			if (yych <= 'K') goto yy137;
			goto yy255;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy137;
			goto yy254;
		} else {
			if (yych == 'l') goto yy255;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
		goto yy248;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy251;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
		goto yy248;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy248;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy137;
			goto yy154;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy241;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy137;
			goto yy154;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'r') goto yy154;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy153;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy153;
	goto yy12;
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy137;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy142;
		goto yy3;
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy137;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy137;
		goto yy3;
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy54;
	}
	if (yych <= '/') goto yy46;
	if (yych <= '9') goto yy51;
yy46:
	YYDEBUG(46, *YYCURSOR);
	{
		goto std;
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy46;
yy48:
	YYDEBUG(48, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(49, *YYCURSOR);
	{
		s->pos = cursor; s->line++;
		goto std;
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy12;
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	YYDEBUG(52, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy56;
				if (yych >= ' ') goto yy56;
			} else {
				if (yych == 'D') goto yy61;
				if (yych >= 'F') goto yy63;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy59;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy58;
				} else {
					if (yych <= 'T') goto yy65;
					if (yych >= 'W') goto yy62;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy64;
				if (yych >= 'd') goto yy61;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy63;
				} else {
					if (yych == 'h') goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy59;
				if (yych <= 'r') goto yy53;
				if (yych <= 's') goto yy58;
				goto yy65;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy62;
				} else {
					if (yych == 'y') goto yy64;
				}
			}
		}
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 15) {
		if (yyaccept <= 7) {
			if (yyaccept <= 3) {
				if (yyaccept <= 1) {
					if (yyaccept <= 0) {
						goto yy3;
					} else {
						goto yy12;
					}
				} else {
					if (yyaccept <= 2) {
						goto yy46;
					} else {
						goto yy69;
					}
				}
			} else {
				if (yyaccept <= 5) {
					if (yyaccept <= 4) {
						goto yy174;
					} else {
						goto yy276;
					}
				} else {
					if (yyaccept <= 6) {
						goto yy303;
					} else {
						goto yy308;
					}
				}
			}
		} else {
			if (yyaccept <= 11) {
				if (yyaccept <= 9) {
					if (yyaccept <= 8) {
						goto yy332;
					} else {
						goto yy402;
					}
				} else {
					if (yyaccept <= 10) {
						goto yy556;
					} else {
						goto yy679;
					}
				}
			} else {
				if (yyaccept <= 13) {
					if (yyaccept <= 12) {
						goto yy694;
					} else {
						goto yy799;
					}
				} else {
					if (yyaccept <= 14) {
						goto yy843;
					} else {
						goto yy853;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 23) {
			if (yyaccept <= 19) {
				if (yyaccept <= 17) {
					if (yyaccept <= 16) {
						goto yy947;
					} else {
						goto yy967;
					}
				} else {
					if (yyaccept <= 18) {
						goto yy998;
					} else {
						goto yy1005;
					}
				}
			} else {
				if (yyaccept <= 21) {
					if (yyaccept <= 20) {
						goto yy1032;
					} else {
						goto yy977;
					}
				} else {
					if (yyaccept <= 22) {
						goto yy658;
					} else {
						goto yy1157;
					}
				}
			}
		} else {
			if (yyaccept <= 27) {
				if (yyaccept <= 25) {
					if (yyaccept <= 24) {
						goto yy1026;
					} else {
						goto yy1248;
					}
				} else {
					if (yyaccept <= 26) {
						goto yy1256;
					} else {
						goto yy1311;
					}
				}
			} else {
				if (yyaccept <= 29) {
					if (yyaccept <= 28) {
						goto yy1314;
					} else {
						goto yy1392;
					}
				} else {
					if (yyaccept <= 30) {
						goto yy1400;
					} else {
						goto yy1423;
					}
				}
			}
		}
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(55, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy54;
	}
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy51;
	goto yy53;
yy56:
	YYDEBUG(56, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy57:
	YYDEBUG(57, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy56;
				if (yych <= 0x1F) goto yy53;
				goto yy56;
			} else {
				if (yych == 'D') goto yy61;
				if (yych <= 'E') goto yy53;
				goto yy63;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych <= 'L') goto yy53;
				goto yy59;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy53;
				} else {
					if (yych <= 'T') goto yy65;
					if (yych <= 'V') goto yy53;
					goto yy62;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy64;
				if (yych <= 'c') goto yy53;
				goto yy61;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy53;
					goto yy63;
				} else {
					if (yych == 'h') goto yy60;
					goto yy53;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy59;
				if (yych <= 'r') goto yy53;
				if (yych >= 't') goto yy65;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy53;
					goto yy62;
				} else {
					if (yych == 'y') goto yy64;
					goto yy53;
				}
			}
		}
	}
yy58:
	YYDEBUG(58, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy124;
			if (yych <= 'T') goto yy53;
			goto yy122;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy124;
			if (yych == 'u') goto yy122;
			goto yy53;
		}
	}
yy59:
	YYDEBUG(59, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy114;
		if (yych <= 'N') goto yy53;
		goto yy113;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy53;
			goto yy114;
		} else {
			if (yych == 'o') goto yy113;
			goto yy53;
		}
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy111;
	if (yych == 'o') goto yy111;
	goto yy53;
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy110;
	if (yych == 'a') goto yy110;
	goto yy53;
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy98;
	if (yych == 'e') goto yy98;
	goto yy53;
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy83;
		if (yych <= 'Q') goto yy53;
		goto yy82;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy83;
		} else {
			if (yych == 'r') goto yy82;
			goto yy53;
		}
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy79;
	if (yych == 'e') goto yy79;
	goto yy53;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy66;
		if (yych <= 'T') goto yy53;
		goto yy67;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
		} else {
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy74;
	if (yych == 'u') goto yy74;
	goto yy53;
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy68;
	if (yych != 'e') goto yy53;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy70;
	if (yych == 's') goto yy70;
yy69:
	YYDEBUG(69, *YYCURSOR);
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy71;
	if (yych != 'd') goto yy53;
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy72;
	if (yych != 'a') goto yy53;
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych != 'y') goto yy53;
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy69;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy75;
	if (yych != 'r') goto yy69;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy76;
	if (yych != 's') goto yy53;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy77;
	if (yych != 'd') goto yy53;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy78;
	if (yych != 'a') goto yy53;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy80;
	if (yych != 'a') goto yy53;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy81;
	if (yych != 'r') goto yy53;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy73;
	if (yych == 's') goto yy73;
	goto yy69;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy95;
	if (yych == 'i') goto yy95;
	goto yy53;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy84;
	if (yych != 'r') goto yy53;
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy85;
	if (yych != 't') goto yy53;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy87;
		if (yych <= 'M') goto yy53;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy87;
		} else {
			if (yych != 'n') goto yy53;
		}
	}
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy92;
	if (yych == 'i') goto yy92;
	goto yy53;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy88;
	if (yych != 'n') goto yy53;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy89;
	if (yych != 'i') goto yy53;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy90;
	if (yych != 'g') goto yy53;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy91;
	if (yych != 'h') goto yy53;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy81;
	if (yych == 't') goto yy81;
	goto yy53;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy93;
	if (yych != 'g') goto yy53;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy94;
	if (yych != 'h') goto yy53;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy81;
	if (yych == 't') goto yy81;
	goto yy53;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy96;
	if (yych != 'd') goto yy69;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy97;
	if (yych != 'a') goto yy53;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy100;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy100;
		if (yych >= 'f') goto yy53;
	}
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy106;
	if (yych == 'k') goto yy106;
	goto yy53;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy101;
	if (yych != 'n') goto yy69;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy102;
	if (yych != 'e') goto yy53;
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy103;
	if (yych != 's') goto yy53;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy104;
	if (yych != 'd') goto yy53;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy105;
	if (yych != 'a') goto yy53;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy107;
		if (yych <= 'R') goto yy69;
		goto yy73;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy69;
		} else {
			if (yych == 's') goto yy73;
			goto yy69;
		}
	}
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy108;
	if (yych != 'a') goto yy53;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy109;
	if (yych != 'y') goto yy53;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy73;
	if (yych == 's') goto yy73;
	goto yy69;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy81;
	if (yych == 'y') goto yy81;
	goto yy53;
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy112;
	if (yych != 'u') goto yy53;
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy81;
	if (yych == 'r') goto yy81;
	goto yy53;
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy118;
	if (yych == 'n') goto yy118;
	goto yy53;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy115;
	if (yych != 'n') goto yy53;
yy115:
	YYDEBUG(115, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy73;
		if (yych <= 'T') goto yy69;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy69;
			goto yy73;
		} else {
			if (yych != 'u') goto yy69;
		}
	}
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy117;
	if (yych != 't') goto yy53;
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy81;
	if (yych == 'e') goto yy81;
	goto yy53;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy119;
		if (yych <= 'S') goto yy69;
		goto yy120;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy69;
		} else {
			if (yych == 't') goto yy120;
			goto yy69;
		}
	}
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy121;
	if (yych == 'a') goto yy121;
	goto yy53;
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy81;
	if (yych == 'h') goto yy81;
	goto yy53;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy133;
	if (yych == 'n') goto yy133;
	goto yy53;
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy128;
	if (yych == 't') goto yy128;
	goto yy53;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy125;
	if (yych != 'c') goto yy53;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy126;
		if (yych <= 'R') goto yy69;
		goto yy73;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy69;
		} else {
			if (yych == 's') goto yy73;
			goto yy69;
		}
	}
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy127;
	if (yych != 'n') goto yy53;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy81;
	if (yych == 'd') goto yy81;
	goto yy53;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy129;
	if (yych != 'u') goto yy69;
yy129:
	YYDEBUG(129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy130;
	if (yych != 'r') goto yy53;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy131;
	if (yych != 'd') goto yy53;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy132;
	if (yych != 'a') goto yy53;
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy134;
	if (yych != 'd') goto yy69;
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy135;
	if (yych != 'a') goto yy53;
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy138;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy139;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy141;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy136;
	goto yy3;
yy142:
	YYDEBUG(142, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych == '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych != '/') goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych >= '[') goto yy53;
	YYDEBUG(145, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy146;
	}
	goto yy53;
yy146:
	YYDEBUG(146, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(147, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy146;
	}
	if (yych == '/') goto yy144;
	if (yych == '_') goto yy144;
	goto yy3;
yy148:
	YYDEBUG(148, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych == '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych == '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy136;
		if (yych <= '.') goto yy3;
		goto yy144;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy152:
	YYDEBUG(152, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy144;
		goto yy53;
	} else {
		if (yych <= '_') goto yy144;
		if (yych <= '`') goto yy53;
		if (yych <= 'z') goto yy151;
		goto yy53;
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy137;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy137;
		goto yy3;
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'e') goto yy155;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy139;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'v') goto yy156;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy140;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'i') goto yy157;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy141;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'o') goto yy158;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy159;
		if (yych != 'u') goto yy3;
	}
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy160;
	if (yych != 's') goto yy53;
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy161;
	if (yych != ' ') goto yy53;
yy161:
	YYDEBUG(161, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	YYDEBUG(162, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy161;
				if (yych <= 0x1F) goto yy53;
				goto yy161;
			} else {
				if (yych == 'D') goto yy166;
				if (yych <= 'E') goto yy53;
				goto yy168;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy165;
				if (yych <= 'L') goto yy53;
				goto yy164;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy53;
				} else {
					if (yych <= 'T') goto yy170;
					if (yych <= 'V') goto yy53;
					goto yy167;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy169;
				if (yych <= 'c') goto yy53;
				goto yy166;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy53;
					goto yy168;
				} else {
					if (yych == 'h') goto yy165;
					goto yy53;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy164;
				if (yych <= 'r') goto yy53;
				if (yych >= 't') goto yy170;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy53;
					goto yy167;
				} else {
					if (yych == 'y') goto yy169;
					goto yy53;
				}
			}
		}
	}
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy228;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy229;
			if (yych <= 'T') goto yy53;
			goto yy227;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy228;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy229;
			if (yych == 'u') goto yy227;
			goto yy53;
		}
	}
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy219;
		if (yych <= 'N') goto yy53;
		goto yy218;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy53;
			goto yy219;
		} else {
			if (yych == 'o') goto yy218;
			goto yy53;
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy216;
	if (yych == 'o') goto yy216;
	goto yy53;
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy215;
	if (yych == 'a') goto yy215;
	goto yy53;
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy203;
	if (yych == 'e') goto yy203;
	goto yy53;
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy188;
		if (yych <= 'Q') goto yy53;
		goto yy187;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy188;
		} else {
			if (yych == 'r') goto yy187;
			goto yy53;
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy184;
	if (yych == 'e') goto yy184;
	goto yy53;
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy171;
		if (yych <= 'T') goto yy53;
		goto yy172;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
		} else {
			if (yych == 'u') goto yy172;
			goto yy53;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy179;
	if (yych == 'u') goto yy179;
	goto yy53;
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy173;
	if (yych != 'e') goto yy53;
yy173:
	YYDEBUG(173, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy175;
	if (yych == 's') goto yy175;
yy174:
	YYDEBUG(174, *YYCURSOR);
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy176;
	if (yych != 'd') goto yy53;
yy176:
	YYDEBUG(176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy177;
	if (yych != 'a') goto yy53;
yy177:
	YYDEBUG(177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy178;
	if (yych != 'y') goto yy53;
yy178:
	YYDEBUG(178, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy174;
yy179:
	YYDEBUG(179, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy180;
	if (yych != 'r') goto yy174;
yy180:
	YYDEBUG(180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy181;
	if (yych != 's') goto yy53;
yy181:
	YYDEBUG(181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy182;
	if (yych != 'd') goto yy53;
yy182:
	YYDEBUG(182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy183;
	if (yych != 'a') goto yy53;
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy178;
	if (yych == 'y') goto yy178;
	goto yy53;
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy185;
	if (yych != 'a') goto yy53;
yy185:
	YYDEBUG(185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy186;
	if (yych != 'r') goto yy53;
yy186:
	YYDEBUG(186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy178;
	if (yych == 's') goto yy178;
	goto yy174;
yy187:
	YYDEBUG(187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy200;
	if (yych == 'i') goto yy200;
	goto yy53;
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy189;
	if (yych != 'r') goto yy53;
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy190;
	if (yych != 't') goto yy53;
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy192;
		if (yych <= 'M') goto yy53;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy192;
		} else {
			if (yych != 'n') goto yy53;
		}
	}
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy197;
	if (yych == 'i') goto yy197;
	goto yy53;
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy193;
	if (yych != 'n') goto yy53;
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy194;
	if (yych != 'i') goto yy53;
yy194:
	YYDEBUG(194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy195;
	if (yych != 'g') goto yy53;
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy196;
	if (yych != 'h') goto yy53;
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy186;
	if (yych == 't') goto yy186;
	goto yy53;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy198;
	if (yych != 'g') goto yy53;
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy199;
	if (yych != 'h') goto yy53;
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy186;
	if (yych == 't') goto yy186;
	goto yy53;
yy200:
	YYDEBUG(200, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy201;
	if (yych != 'd') goto yy174;
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy202;
	if (yych != 'a') goto yy53;
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy178;
	if (yych == 'y') goto yy178;
	goto yy53;
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy205;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy205;
		if (yych >= 'f') goto yy53;
	}
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy211;
	if (yych == 'k') goto yy211;
	goto yy53;
yy205:
	YYDEBUG(205, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy206;
	if (yych != 'n') goto yy174;
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy207;
	if (yych != 'e') goto yy53;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy208;
	if (yych != 's') goto yy53;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy209;
	if (yych != 'd') goto yy53;
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy210;
	if (yych != 'a') goto yy53;
yy210:
	YYDEBUG(210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy178;
	if (yych == 'y') goto yy178;
	goto yy53;
yy211:
	YYDEBUG(211, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy212;
		if (yych <= 'R') goto yy174;
		goto yy178;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy174;
		} else {
			if (yych == 's') goto yy178;
			goto yy174;
		}
	}
yy212:
	YYDEBUG(212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy213;
	if (yych != 'a') goto yy53;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy214;
	if (yych != 'y') goto yy53;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy178;
	if (yych == 's') goto yy178;
	goto yy174;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy186;
	if (yych == 'y') goto yy186;
	goto yy53;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy217;
	if (yych != 'u') goto yy53;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy186;
	if (yych == 'r') goto yy186;
	goto yy53;
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy223;
	if (yych == 'n') goto yy223;
	goto yy53;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy220;
	if (yych != 'n') goto yy53;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy178;
		if (yych <= 'T') goto yy174;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy174;
			goto yy178;
		} else {
			if (yych != 'u') goto yy174;
		}
	}
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy222;
	if (yych != 't') goto yy53;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy186;
	if (yych == 'e') goto yy186;
	goto yy53;
yy223:
	YYDEBUG(223, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy224;
		if (yych <= 'S') goto yy174;
		goto yy225;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy174;
		} else {
			if (yych == 't') goto yy225;
			goto yy174;
		}
	}
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy226;
	if (yych == 'a') goto yy226;
	goto yy53;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy186;
	if (yych == 'h') goto yy186;
	goto yy53;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy178;
	if (yych == 'y') goto yy178;
	goto yy53;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy238;
	if (yych == 'n') goto yy238;
	goto yy53;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy233;
	if (yych == 't') goto yy233;
	goto yy53;
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy230;
	if (yych != 'c') goto yy53;
yy230:
	YYDEBUG(230, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy231;
		if (yych <= 'R') goto yy174;
		goto yy178;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy174;
		} else {
			if (yych == 's') goto yy178;
			goto yy174;
		}
	}
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy232;
	if (yych != 'n') goto yy53;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy186;
	if (yych == 'd') goto yy186;
	goto yy53;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy234;
	if (yych != 'u') goto yy174;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy235;
	if (yych != 'r') goto yy53;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy236;
	if (yych != 'd') goto yy53;
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy237;
	if (yych != 'a') goto yy53;
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy178;
	if (yych == 'y') goto yy178;
	goto yy53;
yy238:
	YYDEBUG(238, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy239;
	if (yych != 'd') goto yy174;
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy240;
	if (yych != 'a') goto yy53;
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy178;
	if (yych == 'y') goto yy178;
	goto yy53;
yy241:
	YYDEBUG(241, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
			goto yy155;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy242;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy242:
	YYDEBUG(242, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy139;
			goto yy156;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'v') goto yy243;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy140;
			goto yy157;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'i') goto yy244;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy244:
	YYDEBUG(244, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy141;
			goto yy158;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'o') goto yy245;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy245:
	YYDEBUG(245, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'T') goto yy3;
			goto yy159;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'u') goto yy246;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy160;
	if (yych != 's') goto yy152;
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy53;
			goto yy161;
		} else {
			if (yych == ' ') goto yy161;
			goto yy53;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy144;
			if (yych <= '^') goto yy53;
			goto yy144;
		} else {
			if (yych <= '`') goto yy53;
			if (yych <= 'z') goto yy151;
			goto yy53;
		}
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy138;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 's') goto yy249;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy249:
	YYDEBUG(249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy250;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy250:
	YYDEBUG(250, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy161;
		} else {
			if (yych == ' ') goto yy161;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy251:
	YYDEBUG(251, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy138;
			goto yy249;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 's') goto yy252;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy252:
	YYDEBUG(252, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
			goto yy250;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy253;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy161;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy161;
			if (yych == ')') goto yy136;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy138;
			goto yy261;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'g') goto yy261;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'e') goto yy256;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy139;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'v') goto yy257;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy257:
	YYDEBUG(257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy258;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy259;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy259:
	YYDEBUG(259, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy260;
		if (yych != 't') goto yy3;
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy160;
	if (yych == 'h') goto yy160;
	goto yy53;
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy139;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'h') goto yy262;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy140;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 't') goto yy263;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy263:
	YYDEBUG(263, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy161;
		} else {
			if (yych == ' ') goto yy161;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy264:
	YYDEBUG(264, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy138;
			goto yy261;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'g') goto yy271;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
			goto yy256;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy266;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy139;
			goto yy257;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'v') goto yy267;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy267:
	YYDEBUG(267, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy258;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy268;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy268:
	YYDEBUG(268, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
			goto yy259;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'n') goto yy269;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'S') goto yy3;
			goto yy260;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy270;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy160;
	if (yych == 'h') goto yy247;
	goto yy152;
yy271:
	YYDEBUG(271, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy139;
			goto yy262;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy272;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy273;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy161;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy161;
			if (yych == ')') goto yy136;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'C') goto yy138;
			if (yych >= 'E') goto yy277;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'd') goto yy275;
			if (yych <= 'e') goto yy277;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy136;
		} else {
			if (yych <= '@') goto yy276;
			if (yych <= 'M') goto yy139;
			goto yy283;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy139;
			if (yych >= 'a') goto yy139;
		} else {
			if (yych <= 'n') goto yy283;
			if (yych <= 'z') goto yy139;
		}
	}
yy276:
	YYDEBUG(276, *YYCURSOR);
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy139;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'k') goto yy278;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy140;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'd') goto yy279;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy279:
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy280;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy281;
		if (yych != 'y') goto yy3;
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy282;
	if (yych != 's') goto yy276;
yy282:
	YYDEBUG(282, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy276;
yy283:
	YYDEBUG(283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy284;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy141;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 's') goto yy285;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy286;
		if (yych != 'd') goto yy3;
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy287;
	if (yych != 'a') goto yy53;
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy282;
	if (yych == 'y') goto yy282;
	goto yy53;
yy288:
	YYDEBUG(288, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '/') {
			if (yych == ')') goto yy136;
			if (yych <= '.') goto yy3;
			goto yy144;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy138;
			if (yych <= 'D') goto yy275;
			goto yy277;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy143;
			} else {
				if (yych <= 'e') goto yy290;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
	YYDEBUG(289, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy276;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy276;
			if (yych <= 'M') goto yy139;
			goto yy283;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy276;
		} else {
			if (yych == 'n') goto yy296;
			if (yych <= 'z') goto yy148;
			goto yy276;
		}
	}
yy290:
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy139;
			goto yy278;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'k') goto yy291;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy140;
			goto yy279;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'd') goto yy292;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy280;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy293;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'X') goto yy3;
			goto yy281;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'y') goto yy294;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy276;
			goto yy144;
		} else {
			if (yych == 'S') goto yy282;
			goto yy276;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy276;
			goto yy151;
		} else {
			if (yych <= 's') goto yy295;
			if (yych <= 'z') goto yy151;
			goto yy276;
		}
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy144;
		goto yy276;
	} else {
		if (yych <= '_') goto yy144;
		if (yych <= '`') goto yy276;
		if (yych <= 'z') goto yy151;
		goto yy276;
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy284;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy297;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy141;
			goto yy285;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 's') goto yy298;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'C') goto yy3;
			goto yy286;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'd') goto yy299;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy287;
	if (yych != 'a') goto yy152;
	YYDEBUG(300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy282;
	if (yych == 'y') goto yy295;
	goto yy152;
yy301:
	YYDEBUG(301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy138;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'c') goto yy302;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy305;
			} else {
				if (yych == ' ') goto yy305;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
			} else {
				if (yych == 'E') goto yy311;
				goto yy139;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy139;
			} else {
				if (yych <= 'e') goto yy311;
				if (yych <= 'z') goto yy139;
			}
		}
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 20) YYFILL(20);
	yych = *YYCURSOR;
yy305:
	YYDEBUG(305, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy304;
	}
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy307;
	if (yych <= '3') goto yy309;
	if (yych <= '9') goto yy310;
	goto yy53;
yy306:
	YYDEBUG(306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy305;
	if (yych <= '0') goto yy464;
	if (yych <= '2') goto yy465;
	if (yych <= '3') goto yy466;
	goto yy305;
yy307:
	YYDEBUG(307, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy325;
			if (yych <= '0') goto yy405;
			goto yy406;
		} else {
			if (yych <= '2') goto yy462;
			if (yych <= '9') goto yy463;
			goto yy325;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy321;
			if (yych <= 'q') goto yy325;
			goto yy322;
		} else {
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy325;
			if (yych <= '0') goto yy405;
			goto yy406;
		} else {
			if (yych <= '2') goto yy318;
			if (yych <= '9') goto yy319;
			goto yy325;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy321;
			if (yych <= 'q') goto yy325;
			goto yy322;
		} else {
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy325;
			if (yych <= '0') goto yy316;
			goto yy317;
		} else {
			if (yych <= '2') goto yy318;
			if (yych <= '9') goto yy319;
			goto yy325;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy321;
			if (yych <= 'q') goto yy325;
			goto yy322;
		} else {
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy140;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'm') goto yy312;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy312:
	YYDEBUG(312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy141;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'b') goto yy313;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy314;
		if (yych != 'e') goto yy3;
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy315;
	if (yych != 'r') goto yy53;
yy315:
	YYDEBUG(315, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy305;
		if (yych <= 0x1F) goto yy303;
		goto yy305;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy303;
			goto yy305;
		} else {
			if (yych <= '/') goto yy303;
			if (yych <= '9') goto yy305;
			goto yy303;
		}
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy330;
		goto yy53;
	} else {
		if (yych <= '0') goto yy403;
		if (yych <= '9') goto yy404;
		if (yych <= ':') goto yy330;
		goto yy53;
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '2') goto yy404;
		if (yych <= '9') goto yy403;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '3') goto yy403;
		if (yych <= '9') goto yy400;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '9') goto yy400;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy325;
yy321:
	YYDEBUG(321, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy325;
yy322:
	YYDEBUG(322, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy325;
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy325;
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
yy325:
	YYDEBUG(325, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy324;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy308;
		if (yych <= '0') goto yy366;
		if (yych <= '1') goto yy367;
		goto yy368;
	} else {
		if (yych <= '9') goto yy369;
		if (yych != 'T') goto yy308;
	}
	YYDEBUG(326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy327;
	if (yych <= '2') goto yy328;
	if (yych <= '9') goto yy329;
	goto yy53;
yy327:
	YYDEBUG(327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy330;
		goto yy53;
	} else {
		if (yych <= '9') goto yy329;
		if (yych <= ':') goto yy330;
		goto yy53;
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy330;
		goto yy53;
	} else {
		if (yych <= '3') goto yy329;
		if (yych == ':') goto yy330;
		goto yy53;
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy330;
	if (yych != ':') goto yy53;
yy330:
	YYDEBUG(330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy331;
	if (yych <= '9') goto yy333;
	goto yy53;
yy331:
	YYDEBUG(331, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy334;
	} else {
		if (yych <= '9') goto yy333;
		if (yych <= ':') goto yy334;
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy334;
	if (yych != ':') goto yy332;
yy334:
	YYDEBUG(334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy335;
	if (yych <= '6') goto yy336;
	if (yych <= '9') goto yy337;
	goto yy53;
yy335:
	YYDEBUG(335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy332;
	if (yych <= '9') goto yy338;
	goto yy332;
yy336:
	YYDEBUG(336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy338;
	goto yy332;
yy337:
	YYDEBUG(337, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy332;
yy338:
	YYDEBUG(338, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy332;
		} else {
			if (yych <= ' ') goto yy339;
			if (yych == '(') goto yy342;
			goto yy332;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy332;
			if (yych <= '-') goto yy341;
			goto yy332;
		} else {
			if (yych <= 'Z') goto yy343;
			if (yych <= '`') goto yy332;
			if (yych <= 'z') goto yy344;
			goto yy332;
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	YYDEBUG(340, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy339;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy339;
			if (yych == '(') goto yy342;
			goto yy53;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy53;
			if (yych >= '.') goto yy53;
		} else {
			if (yych <= 'Z') goto yy343;
			if (yych <= '`') goto yy53;
			if (yych <= 'z') goto yy344;
			goto yy53;
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy361;
	if (yych <= '2') goto yy362;
	if (yych <= '9') goto yy363;
	goto yy53;
yy342:
	YYDEBUG(342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy344;
	if (yych <= '`') goto yy53;
	if (yych <= 'z') goto yy344;
	goto yy53;
yy343:
	YYDEBUG(343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy337;
		goto yy332;
	} else {
		if (yych <= 'Z') goto yy345;
		if (yych <= '`') goto yy332;
		if (yych <= 'z') goto yy350;
		goto yy332;
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy337;
		goto yy332;
	} else {
		if (yych <= 'Z') goto yy345;
		if (yych <= '`') goto yy332;
		if (yych >= '{') goto yy332;
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy337;
		goto yy332;
	} else {
		if (yych <= 'Z') goto yy346;
		if (yych <= '`') goto yy332;
		if (yych >= '{') goto yy332;
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy337;
		goto yy332;
	} else {
		if (yych <= 'Z') goto yy347;
		if (yych <= '`') goto yy332;
		if (yych >= '{') goto yy332;
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy337;
		goto yy332;
	} else {
		if (yych <= 'Z') goto yy348;
		if (yych <= '`') goto yy332;
		if (yych >= '{') goto yy332;
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy337;
		goto yy332;
	} else {
		if (yych <= 'Z') goto yy349;
		if (yych <= '`') goto yy332;
		if (yych >= '{') goto yy332;
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy337;
	goto yy332;
yy350:
	YYDEBUG(350, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy332;
			goto yy337;
		} else {
			if (yych == '/') goto yy352;
			goto yy332;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy346;
			if (yych <= '^') goto yy332;
			goto yy352;
		} else {
			if (yych <= '`') goto yy332;
			if (yych >= '{') goto yy332;
		}
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy332;
			goto yy337;
		} else {
			if (yych != '/') goto yy332;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy347;
			if (yych <= '^') goto yy332;
		} else {
			if (yych <= '`') goto yy332;
			if (yych <= 'z') goto yy356;
			goto yy332;
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych >= '[') goto yy53;
	YYDEBUG(353, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '`') goto yy53;
	if (yych >= '{') goto yy53;
yy354:
	YYDEBUG(354, *YYCURSOR);
	yyaccept = 8;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(355, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy352;
		goto yy332;
	} else {
		if (yych <= '_') goto yy352;
		if (yych <= '`') goto yy332;
		if (yych <= 'z') goto yy354;
		goto yy332;
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy332;
			goto yy337;
		} else {
			if (yych == '/') goto yy352;
			goto yy332;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy348;
			if (yych <= '^') goto yy332;
			goto yy352;
		} else {
			if (yych <= '`') goto yy332;
			if (yych >= '{') goto yy332;
		}
	}
	YYDEBUG(357, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy332;
			goto yy337;
		} else {
			if (yych == '/') goto yy352;
			goto yy332;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy349;
			if (yych <= '^') goto yy332;
			goto yy352;
		} else {
			if (yych <= '`') goto yy332;
			if (yych >= '{') goto yy332;
		}
	}
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy337;
		if (yych <= '.') goto yy332;
		goto yy352;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy332;
			goto yy352;
		} else {
			if (yych <= '`') goto yy332;
			if (yych >= '{') goto yy332;
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(360, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy352;
		goto yy53;
	} else {
		if (yych <= '_') goto yy352;
		if (yych <= '`') goto yy53;
		if (yych <= 'z') goto yy359;
		goto yy53;
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy332;
	if (yych <= '9') goto yy363;
	if (yych <= ':') goto yy364;
	goto yy332;
yy362:
	YYDEBUG(362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy332;
		if (yych >= '4') goto yy365;
	} else {
		if (yych <= '9') goto yy337;
		if (yych <= ':') goto yy364;
		goto yy332;
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy332;
	if (yych <= '5') goto yy365;
	if (yych <= '9') goto yy337;
	if (yych >= ';') goto yy332;
yy364:
	YYDEBUG(364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy332;
	if (yych <= '5') goto yy365;
	if (yych <= '9') goto yy337;
	goto yy332;
yy365:
	YYDEBUG(365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy332;
	if (yych <= '9') goto yy337;
	goto yy332;
yy366:
	YYDEBUG(366, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy330;
		goto yy308;
	} else {
		if (yych <= '0') goto yy398;
		if (yych <= '9') goto yy399;
		if (yych <= ':') goto yy330;
		goto yy308;
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy308;
	} else {
		if (yych <= '2') goto yy399;
		if (yych <= '9') goto yy398;
		if (yych <= ':') goto yy371;
		goto yy308;
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy308;
	} else {
		if (yych <= '3') goto yy398;
		if (yych <= '9') goto yy370;
		if (yych <= ':') goto yy371;
		goto yy308;
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy308;
	} else {
		if (yych <= '9') goto yy370;
		if (yych <= ':') goto yy371;
		goto yy308;
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy308;
	if (yych <= '9') goto yy396;
	goto yy308;
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy372;
	if (yych <= '9') goto yy373;
	goto yy53;
yy372:
	YYDEBUG(372, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy374;
		goto yy332;
	} else {
		if (yych <= '9') goto yy389;
		if (yych <= ':') goto yy374;
		goto yy332;
	}
yy373:
	YYDEBUG(373, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy374;
	if (yych != ':') goto yy332;
yy374:
	YYDEBUG(374, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy375;
	if (yych <= '6') goto yy376;
	if (yych <= '9') goto yy337;
	goto yy53;
yy375:
	YYDEBUG(375, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy332;
	if (yych <= '9') goto yy377;
	goto yy332;
yy376:
	YYDEBUG(376, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy332;
yy377:
	YYDEBUG(377, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy379;
			goto yy332;
		} else {
			if (yych <= ' ') goto yy379;
			if (yych == '(') goto yy379;
			goto yy332;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy332;
			if (yych <= '-') goto yy379;
			goto yy332;
		} else {
			if (yych <= 'Z') goto yy379;
			if (yych <= '`') goto yy332;
			if (yych <= 'z') goto yy379;
			goto yy332;
		}
	}
yy378:
	YYDEBUG(378, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
yy379:
	YYDEBUG(379, *YYCURSOR);
	if (yych <= '-') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy53;
				goto yy378;
			} else {
				if (yych == ' ') goto yy378;
				goto yy53;
			}
		} else {
			if (yych <= '*') {
				if (yych <= '(') goto yy342;
				goto yy53;
			} else {
				if (yych == ',') goto yy53;
				goto yy341;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'A') {
				if (yych <= '@') goto yy53;
			} else {
				if (yych != 'P') goto yy343;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy53;
				if (yych <= 'a') goto yy381;
				goto yy344;
			} else {
				if (yych <= 'p') goto yy381;
				if (yych <= 'z') goto yy344;
				goto yy53;
			}
		}
	}
	YYDEBUG(380, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy337;
			goto yy332;
		} else {
			if (yych <= '.') goto yy382;
			if (yych <= '@') goto yy332;
			goto yy345;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy383;
			if (yych <= 'Z') goto yy345;
			goto yy332;
		} else {
			if (yych == 'm') goto yy388;
			if (yych <= 'z') goto yy350;
			goto yy332;
		}
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy337;
			goto yy332;
		} else {
			if (yych <= '.') goto yy382;
			if (yych <= '@') goto yy332;
			goto yy345;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy383;
			if (yych <= 'Z') goto yy345;
			goto yy332;
		} else {
			if (yych == 'm') goto yy383;
			if (yych <= 'z') goto yy345;
			goto yy332;
		}
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy387;
	if (yych == 'm') goto yy387;
	goto yy53;
yy383:
	YYDEBUG(383, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy385;
			if (yych <= 0x08) goto yy332;
			goto yy385;
		} else {
			if (yych == ' ') goto yy385;
			if (yych <= '(') goto yy332;
			goto yy337;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy332;
		} else {
			if (yych <= 'Z') goto yy346;
			if (yych <= '`') goto yy332;
			if (yych <= 'z') goto yy346;
			goto yy332;
		}
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy385;
		if (yych <= 0x08) goto yy53;
	} else {
		if (yych != ' ') goto yy53;
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(386, *YYCURSOR);
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy385;
		if (yych == '\t') goto yy385;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy385;
		if (yych == '.') goto yy384;
		goto yy53;
	}
yy388:
	YYDEBUG(388, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy385;
			if (yych == '\t') goto yy385;
			goto yy332;
		} else {
			if (yych <= ' ') goto yy385;
			if (yych == ')') goto yy337;
			goto yy332;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy384;
			if (yych <= '/') goto yy352;
			if (yych <= '@') goto yy332;
			goto yy346;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy332;
				goto yy352;
			} else {
				if (yych <= '`') goto yy332;
				if (yych <= 'z') goto yy351;
				goto yy332;
			}
		}
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy390;
			if (yych <= 0x1F) goto yy332;
		} else {
			if (yych == '.') goto yy374;
			if (yych <= '9') goto yy332;
			goto yy374;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy392;
			if (yych <= 'O') goto yy332;
			goto yy392;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy332;
				goto yy392;
			} else {
				if (yych == 'p') goto yy392;
				goto yy332;
			}
		}
	}
yy390:
	YYDEBUG(390, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(391, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy390;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy390;
			if (yych <= '@') goto yy53;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy53;
		} else {
			if (yych <= 'a') goto yy392;
			if (yych != 'p') goto yy53;
		}
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy53;
	} else {
		if (yych <= 'M') goto yy394;
		if (yych == 'm') goto yy394;
		goto yy53;
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy394;
	if (yych != 'm') goto yy53;
yy394:
	YYDEBUG(394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy385;
		if (yych == '\t') goto yy385;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy385;
		if (yych != '.') goto yy53;
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy385;
		if (yych <= 0x08) goto yy53;
		goto yy385;
	} else {
		if (yych == ' ') goto yy385;
		goto yy53;
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy308;
	if (yych >= ':') goto yy308;
	YYDEBUG(397, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy308;
yy398:
	YYDEBUG(398, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy330;
		goto yy308;
	} else {
		if (yych <= '9') goto yy396;
		if (yych <= ':') goto yy330;
		goto yy308;
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy308;
	} else {
		if (yych <= '9') goto yy396;
		if (yych <= ':') goto yy371;
		goto yy308;
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy401:
	YYDEBUG(401, *YYCURSOR);
	++YYCURSOR;
yy402:
	YYDEBUG(402, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy330;
		goto yy53;
	} else {
		if (yych <= '9') goto yy401;
		if (yych <= ':') goto yy330;
		goto yy53;
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '9') goto yy401;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy438;
			goto yy325;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy330;
			if (yych == 'n') goto yy321;
			goto yy325;
		} else {
			if (yych <= 'r') goto yy322;
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych != '.') goto yy325;
		} else {
			if (yych <= '0') goto yy408;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy321;
			goto yy325;
		} else {
			if (yych <= 'r') goto yy322;
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy325;
		if (yych <= '0') goto yy413;
		goto yy414;
	} else {
		if (yych <= '2') goto yy415;
		if (yych <= '5') goto yy416;
		if (yych <= '9') goto yy417;
		goto yy325;
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '0') goto yy411;
		if (yych <= '9') goto yy412;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '2') goto yy412;
		if (yych <= '9') goto yy411;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '3') goto yy411;
		if (yych <= '9') goto yy401;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy411:
	YYDEBUG(411, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy330;
	if (yych == ':') goto yy330;
	goto yy402;
yy412:
	YYDEBUG(412, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy371;
	if (yych == ':') goto yy371;
	goto yy402;
yy413:
	YYDEBUG(413, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy308;
	} else {
		if (yych <= '0') goto yy432;
		if (yych <= '9') goto yy437;
		if (yych <= ':') goto yy433;
		goto yy308;
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy418;
		goto yy308;
	} else {
		if (yych <= '2') goto yy437;
		if (yych <= '9') goto yy432;
		if (yych <= ':') goto yy418;
		goto yy308;
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy418;
		goto yy308;
	} else {
		if (yych <= '3') goto yy432;
		if (yych <= '9') goto yy431;
		if (yych <= ':') goto yy418;
		goto yy308;
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy418;
		goto yy308;
	} else {
		if (yych <= '9') goto yy431;
		if (yych <= ':') goto yy418;
		goto yy308;
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy308;
	} else {
		if (yych <= '9') goto yy370;
		if (yych >= ';') goto yy308;
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy419;
	if (yych <= '6') goto yy420;
	if (yych <= '9') goto yy373;
	goto yy53;
yy419:
	YYDEBUG(419, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy374;
		goto yy332;
	} else {
		if (yych <= '9') goto yy421;
		if (yych <= ':') goto yy374;
		goto yy332;
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy374;
		goto yy332;
	} else {
		if (yych <= '0') goto yy377;
		if (yych == ':') goto yy374;
		goto yy332;
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy332;
			goto yy423;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy332;
				goto yy423;
			} else {
				if (yych == '+') goto yy423;
				goto yy332;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy423;
			if (yych <= '.') goto yy374;
			if (yych <= '9') goto yy332;
			goto yy374;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy332;
				goto yy423;
			} else {
				if (yych <= '`') goto yy332;
				if (yych <= 'z') goto yy423;
				goto yy332;
			}
		}
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
yy423:
	YYDEBUG(423, *YYCURSOR);
	if (yych <= '-') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy53;
				goto yy422;
			} else {
				if (yych == ' ') goto yy422;
				goto yy53;
			}
		} else {
			if (yych <= '*') {
				if (yych <= '(') goto yy342;
				goto yy53;
			} else {
				if (yych == ',') goto yy53;
				goto yy341;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'A') {
				if (yych <= '@') goto yy53;
			} else {
				if (yych != 'P') goto yy343;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy53;
				if (yych <= 'a') goto yy425;
				goto yy344;
			} else {
				if (yych <= 'p') goto yy425;
				if (yych <= 'z') goto yy344;
				goto yy53;
			}
		}
	}
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy337;
			goto yy332;
		} else {
			if (yych <= '.') goto yy427;
			if (yych <= '@') goto yy332;
			goto yy345;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy426;
			if (yych <= 'Z') goto yy345;
			goto yy332;
		} else {
			if (yych == 'm') goto yy430;
			if (yych <= 'z') goto yy350;
			goto yy332;
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy337;
			goto yy332;
		} else {
			if (yych <= '.') goto yy427;
			if (yych <= '@') goto yy332;
			goto yy345;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy426;
			if (yych <= 'Z') goto yy345;
			goto yy332;
		} else {
			if (yych == 'm') goto yy426;
			if (yych <= 'z') goto yy345;
			goto yy332;
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy385;
			if (yych <= 0x08) goto yy332;
			goto yy385;
		} else {
			if (yych == ' ') goto yy385;
			if (yych <= '(') goto yy332;
			goto yy337;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy429;
			goto yy332;
		} else {
			if (yych <= 'Z') goto yy346;
			if (yych <= '`') goto yy332;
			if (yych <= 'z') goto yy346;
			goto yy332;
		}
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy428;
	if (yych != 'm') goto yy53;
yy428:
	YYDEBUG(428, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy385;
		if (yych == '\t') goto yy385;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy385;
		if (yych != '.') goto yy53;
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy385;
		if (yych <= 0x08) goto yy53;
		goto yy385;
	} else {
		if (yych == ' ') goto yy385;
		goto yy53;
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy385;
			if (yych == '\t') goto yy385;
			goto yy332;
		} else {
			if (yych <= ' ') goto yy385;
			if (yych == ')') goto yy337;
			goto yy332;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy429;
			if (yych <= '/') goto yy352;
			if (yych <= '@') goto yy332;
			goto yy346;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy332;
				goto yy352;
			} else {
				if (yych <= '`') goto yy332;
				if (yych <= 'z') goto yy351;
				goto yy332;
			}
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy390;
			if (yych <= 0x1F) goto yy308;
			goto yy390;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy308;
				goto yy374;
			} else {
				if (yych <= '/') goto yy308;
				if (yych <= '9') goto yy396;
				goto yy374;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy392;
			if (yych <= 'O') goto yy308;
			goto yy392;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy308;
				goto yy392;
			} else {
				if (yych == 'p') goto yy392;
				goto yy308;
			}
		}
	}
yy432:
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy390;
			if (yych <= 0x1F) goto yy308;
			goto yy390;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy308;
			} else {
				if (yych <= '/') goto yy308;
				if (yych <= '9') goto yy396;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy392;
			if (yych <= 'O') goto yy308;
			goto yy392;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy308;
				goto yy392;
			} else {
				if (yych == 'p') goto yy392;
				goto yy308;
			}
		}
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy434;
	if (yych <= '6') goto yy435;
	if (yych <= '9') goto yy333;
	goto yy53;
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy334;
		goto yy332;
	} else {
		if (yych <= '9') goto yy436;
		if (yych <= ':') goto yy334;
		goto yy332;
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy334;
		goto yy332;
	} else {
		if (yych <= '0') goto yy377;
		if (yych == ':') goto yy334;
		goto yy332;
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy379;
			if (yych <= 0x1F) goto yy332;
			goto yy379;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy332;
				goto yy379;
			} else {
				if (yych == '+') goto yy379;
				goto yy332;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy379;
			if (yych <= '.') goto yy334;
			if (yych <= '9') goto yy332;
			goto yy334;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy332;
				goto yy379;
			} else {
				if (yych <= '`') goto yy332;
				if (yych <= 'z') goto yy379;
				goto yy332;
			}
		}
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy390;
			if (yych <= 0x1F) goto yy308;
			goto yy390;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy308;
				goto yy418;
			} else {
				if (yych <= '/') goto yy308;
				if (yych <= '9') goto yy396;
				goto yy418;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy392;
			if (yych <= 'O') goto yy308;
			goto yy392;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy308;
				goto yy392;
			} else {
				if (yych == 'p') goto yy392;
				goto yy308;
			}
		}
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy325;
		if (yych <= '0') goto yy440;
		goto yy441;
	} else {
		if (yych <= '2') goto yy442;
		if (yych <= '5') goto yy443;
		if (yych <= '9') goto yy444;
		goto yy325;
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy330;
		goto yy53;
	} else {
		if (yych <= '0') goto yy411;
		if (yych <= '9') goto yy412;
		if (yych <= ':') goto yy330;
		goto yy53;
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy457;
		goto yy308;
	} else {
		if (yych <= '0') goto yy456;
		if (yych <= '9') goto yy461;
		if (yych <= ':') goto yy457;
		goto yy308;
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy445;
		goto yy308;
	} else {
		if (yych <= '2') goto yy461;
		if (yych <= '9') goto yy456;
		if (yych <= ':') goto yy445;
		goto yy308;
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy445;
		goto yy308;
	} else {
		if (yych <= '3') goto yy456;
		if (yych <= '9') goto yy455;
		if (yych <= ':') goto yy445;
		goto yy308;
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy445;
		goto yy308;
	} else {
		if (yych <= '9') goto yy455;
		if (yych <= ':') goto yy445;
		goto yy308;
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy308;
	} else {
		if (yych <= '9') goto yy370;
		if (yych >= ';') goto yy308;
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy446;
	if (yych <= '6') goto yy447;
	if (yych <= '9') goto yy373;
	goto yy53;
yy446:
	YYDEBUG(446, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy374;
		goto yy332;
	} else {
		if (yych <= '9') goto yy448;
		if (yych <= ':') goto yy374;
		goto yy332;
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy374;
		goto yy332;
	} else {
		if (yych <= '0') goto yy338;
		if (yych == ':') goto yy374;
		goto yy332;
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy450;
			if (yych <= 0x1F) goto yy332;
			goto yy450;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy332;
				goto yy450;
			} else {
				if (yych == '+') goto yy450;
				goto yy332;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy450;
			if (yych <= '.') goto yy374;
			if (yych <= '9') goto yy332;
			goto yy374;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy332;
				goto yy450;
			} else {
				if (yych <= '`') goto yy332;
				if (yych <= 'z') goto yy450;
				goto yy332;
			}
		}
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
yy450:
	YYDEBUG(450, *YYCURSOR);
	if (yych <= '-') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy53;
				goto yy449;
			} else {
				if (yych == ' ') goto yy449;
				goto yy53;
			}
		} else {
			if (yych <= '*') {
				if (yych <= '(') goto yy342;
				goto yy53;
			} else {
				if (yych == ',') goto yy53;
				goto yy341;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'A') {
				if (yych <= '@') goto yy53;
			} else {
				if (yych != 'P') goto yy343;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy53;
				if (yych <= 'a') goto yy452;
				goto yy344;
			} else {
				if (yych <= 'p') goto yy452;
				if (yych <= 'z') goto yy344;
				goto yy53;
			}
		}
	}
	YYDEBUG(451, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy337;
			goto yy332;
		} else {
			if (yych <= '.') goto yy393;
			if (yych <= '@') goto yy332;
			goto yy345;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy453;
			if (yych <= 'Z') goto yy345;
			goto yy332;
		} else {
			if (yych == 'm') goto yy454;
			if (yych <= 'z') goto yy350;
			goto yy332;
		}
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy337;
			goto yy332;
		} else {
			if (yych <= '.') goto yy393;
			if (yych <= '@') goto yy332;
			goto yy345;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy453;
			if (yych <= 'Z') goto yy345;
			goto yy332;
		} else {
			if (yych == 'm') goto yy453;
			if (yych <= 'z') goto yy345;
			goto yy332;
		}
	}
yy453:
	YYDEBUG(453, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy385;
			if (yych <= 0x08) goto yy332;
			goto yy385;
		} else {
			if (yych == ' ') goto yy385;
			if (yych <= '(') goto yy332;
			goto yy337;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy395;
			goto yy332;
		} else {
			if (yych <= 'Z') goto yy346;
			if (yych <= '`') goto yy332;
			if (yych <= 'z') goto yy346;
			goto yy332;
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy385;
			if (yych == '\t') goto yy385;
			goto yy332;
		} else {
			if (yych <= ' ') goto yy385;
			if (yych == ')') goto yy337;
			goto yy332;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy395;
			if (yych <= '/') goto yy352;
			if (yych <= '@') goto yy332;
			goto yy346;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy332;
				goto yy352;
			} else {
				if (yych <= '`') goto yy332;
				if (yych <= 'z') goto yy351;
				goto yy332;
			}
		}
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy334;
		goto yy308;
	} else {
		if (yych <= '9') goto yy396;
		if (yych <= ':') goto yy334;
		goto yy308;
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy308;
	} else {
		if (yych <= '9') goto yy396;
		if (yych >= ';') goto yy308;
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy458;
	if (yych <= '6') goto yy459;
	if (yych <= '9') goto yy333;
	goto yy53;
yy458:
	YYDEBUG(458, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy334;
		goto yy332;
	} else {
		if (yych <= '9') goto yy460;
		if (yych <= ':') goto yy334;
		goto yy332;
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy334;
		goto yy332;
	} else {
		if (yych <= '0') goto yy338;
		if (yych == ':') goto yy334;
		goto yy332;
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy339;
			if (yych <= 0x1F) goto yy332;
			goto yy339;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy332;
				goto yy342;
			} else {
				if (yych == '+') goto yy341;
				goto yy332;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy341;
			if (yych <= '.') goto yy334;
			if (yych <= '9') goto yy332;
			goto yy334;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy332;
				goto yy343;
			} else {
				if (yych <= '`') goto yy332;
				if (yych <= 'z') goto yy344;
				goto yy332;
			}
		}
	}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy445;
		goto yy308;
	} else {
		if (yych <= '9') goto yy396;
		if (yych <= ':') goto yy445;
		goto yy308;
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy407;
			goto yy325;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy321;
			goto yy325;
		} else {
			if (yych <= 'r') goto yy322;
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy407;
			goto yy325;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy321;
			goto yy325;
		} else {
			if (yych <= 'r') goto yy322;
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy325;
			if (yych <= '0') goto yy467;
			goto yy468;
		} else {
			if (yych <= '2') goto yy475;
			if (yych <= '9') goto yy476;
			goto yy325;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy321;
			if (yych <= 'q') goto yy325;
			goto yy322;
		} else {
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy325;
			if (yych <= '0') goto yy467;
			goto yy468;
		} else {
			if (yych <= '2') goto yy475;
			if (yych <= '9') goto yy476;
			goto yy325;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy321;
			if (yych <= 'q') goto yy325;
			goto yy322;
		} else {
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy325;
			if (yych >= '1') goto yy468;
		} else {
			if (yych <= '2') goto yy318;
			if (yych <= '9') goto yy319;
			goto yy325;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy321;
			if (yych <= 'q') goto yy325;
			goto yy322;
		} else {
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy325;
			if (yych <= '-') goto yy469;
			if (yych <= '.') goto yy438;
			goto yy325;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy330;
			if (yych == 'n') goto yy321;
			goto yy325;
		} else {
			if (yych <= 'r') goto yy322;
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy325;
			if (yych <= '-') goto yy469;
			if (yych <= '.') goto yy407;
			goto yy325;
		} else {
			if (yych <= '0') goto yy408;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy321;
			goto yy325;
		} else {
			if (yych <= 'r') goto yy322;
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(470, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy471;
	if (yych <= '9') goto yy472;
yy471:
	YYDEBUG(471, *YYCURSOR);
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy471;
	if (yych >= ':') goto yy471;
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy471;
	if (yych >= ':') goto yy471;
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy471;
yy475:
	YYDEBUG(475, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy325;
			if (yych <= '-') goto yy469;
			if (yych <= '.') goto yy407;
			goto yy325;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy321;
			goto yy325;
		} else {
			if (yych <= 'r') goto yy322;
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy325;
			if (yych <= '-') goto yy469;
			if (yych <= '.') goto yy407;
			goto yy325;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy321;
			goto yy325;
		} else {
			if (yych <= 'r') goto yy322;
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy323;
			goto yy325;
		}
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy138;
			goto yy302;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'c') goto yy478;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'E') goto yy311;
				if (yych <= 'Z') goto yy139;
				goto yy303;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy148;
			} else {
				if (yych <= 'e') goto yy479;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy140;
			goto yy312;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'm') goto yy480;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy141;
			goto yy313;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'b') goto yy481;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'D') goto yy3;
			goto yy314;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy482;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy482:
	YYDEBUG(482, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy315;
	if (yych != 'r') goto yy152;
yy483:
	YYDEBUG(483, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy305;
			goto yy303;
		} else {
			if (yych <= ' ') goto yy305;
			if (yych <= ',') goto yy303;
			goto yy305;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy144;
			if (yych <= '9') goto yy305;
			goto yy303;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy303;
			if (yych <= 'z') goto yy151;
			goto yy303;
		}
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy138;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 't') goto yy485;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy303;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
				goto yy303;
			} else {
				if (yych != 'O') goto yy139;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'o') goto yy486;
				if (yych <= 'z') goto yy139;
				goto yy303;
			}
		}
	}
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy140;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'b') goto yy487;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy488;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy488:
	YYDEBUG(488, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy315;
		if (yych == 'r') goto yy315;
		goto yy3;
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy138;
			goto yy485;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy490;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'O') goto yy486;
				if (yych <= 'Z') goto yy139;
				goto yy303;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy148;
			} else {
				if (yych <= 'o') goto yy491;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy140;
			goto yy487;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'b') goto yy492;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
			goto yy488;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy493;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'Q') goto yy3;
			goto yy315;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'r') goto yy483;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy510;
				goto yy138;
			} else {
				if (yych <= 'P') goto yy509;
				if (yych <= 'U') goto yy138;
				goto yy511;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy138;
				goto yy3;
			} else {
				if (yych == 'c') goto yy510;
				goto yy138;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy509;
				goto yy138;
			} else {
				if (yych <= 'v') goto yy511;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy495:
	YYDEBUG(495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy138;
			goto yy504;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 't') goto yy504;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy138;
			goto yy502;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'x') goto yy502;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'n') goto yy498;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy276;
			goto yy136;
		} else {
			if (yych <= '@') goto yy276;
			if (yych <= 'C') goto yy139;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy276;
			goto yy139;
		} else {
			if (yych <= 'd') goto yy499;
			if (yych <= 'z') goto yy139;
			goto yy276;
		}
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy500;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy141;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'y') goto yy501;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy136;
	goto yy276;
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy503;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'h') goto yy263;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy276;
			goto yy136;
		} else {
			if (yych <= '@') goto yy276;
			if (yych <= 'T') goto yy139;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy276;
			goto yy139;
		} else {
			if (yych <= 'u') goto yy505;
			if (yych <= 'z') goto yy139;
			goto yy276;
		}
	}
yy505:
	YYDEBUG(505, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'r') goto yy506;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy507;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy508;
		if (yych != 'a') goto yy3;
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy282;
	if (yych == 'y') goto yy282;
	goto yy53;
yy509:
	YYDEBUG(509, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy303;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
				goto yy303;
			} else {
				if (yych == 'T') goto yy518;
				goto yy139;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy303;
				goto yy139;
			} else {
				if (yych <= 't') goto yy518;
				if (yych <= 'z') goto yy139;
				goto yy303;
			}
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy139;
			goto yy515;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'o') goto yy515;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy139;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'e') goto yy512;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy140;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'n') goto yy513;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy514;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy160;
		if (yych == 'h') goto yy160;
		goto yy3;
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy140;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'n') goto yy516;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy517;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy161;
		goto yy3;
	} else {
		if (yych <= ' ') goto yy161;
		if (yych == ')') goto yy136;
		goto yy3;
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy303;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
				goto yy303;
			} else {
				if (yych != 'E') goto yy140;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy303;
				goto yy140;
			} else {
				if (yych <= 'e') goto yy519;
				if (yych <= 'z') goto yy140;
				goto yy303;
			}
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy141;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'm') goto yy520;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy521;
		if (yych != 'b') goto yy3;
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy522;
	if (yych != 'e') goto yy53;
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy315;
	if (yych == 'r') goto yy315;
	goto yy53;
yy523:
	YYDEBUG(523, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych == '/') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'O') {
				if (yych == 'C') goto yy510;
				goto yy138;
			} else {
				if (yych <= 'P') goto yy509;
				if (yych <= 'U') goto yy138;
				goto yy511;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy138;
				if (yych <= '^') goto yy3;
				goto yy144;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'b') goto yy143;
				goto yy539;
			}
		} else {
			if (yych <= 'u') {
				if (yych == 'p') goto yy538;
				goto yy143;
			} else {
				if (yych <= 'v') goto yy540;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy524:
	YYDEBUG(524, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy138;
			goto yy504;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy533;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy525:
	YYDEBUG(525, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy138;
			goto yy502;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'x') goto yy531;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
			goto yy498;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'n') goto yy527;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy276;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy276;
			if (yych <= 'C') goto yy139;
			goto yy499;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy276;
		} else {
			if (yych == 'd') goto yy528;
			if (yych <= 'z') goto yy148;
			goto yy276;
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy500;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy529;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy141;
			goto yy501;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'y') goto yy530;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy136;
		if (yych <= '.') goto yy276;
		goto yy144;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy276;
			goto yy144;
		} else {
			if (yych <= '`') goto yy276;
			if (yych <= 'z') goto yy151;
			goto yy276;
		}
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
			goto yy503;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy532;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy273;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy276;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy276;
			if (yych <= 'T') goto yy139;
			goto yy505;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy276;
		} else {
			if (yych == 'u') goto yy534;
			if (yych <= 'z') goto yy148;
			goto yy276;
		}
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
			goto yy506;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'r') goto yy535;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy535:
	YYDEBUG(535, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
			goto yy507;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'd') goto yy536;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy508;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy537;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy537:
	YYDEBUG(537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy282;
	if (yych == 'y') goto yy295;
	goto yy152;
yy538:
	YYDEBUG(538, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'T') goto yy518;
				if (yych <= 'Z') goto yy139;
				goto yy303;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy148;
			} else {
				if (yych <= 't') goto yy547;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy139;
			goto yy515;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'o') goto yy544;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy139;
			goto yy512;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy541;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy140;
			goto yy513;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'n') goto yy542;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy542:
	YYDEBUG(542, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
			goto yy514;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy543;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy543:
	YYDEBUG(543, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'G') goto yy3;
			goto yy160;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy247;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy544:
	YYDEBUG(544, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy140;
			goto yy516;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'n') goto yy545;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
			goto yy517;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'd') goto yy546;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy161;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy161;
			if (yych <= '(') goto yy3;
			goto yy136;
		}
	} else {
		if (yych <= '^') {
			if (yych == '/') goto yy144;
			goto yy3;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy547:
	YYDEBUG(547, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy303;
				goto yy140;
			} else {
				if (yych <= 'E') goto yy519;
				if (yych <= 'Z') goto yy140;
				goto yy303;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy149;
			} else {
				if (yych <= 'e') goto yy548;
				if (yych <= 'z') goto yy149;
				goto yy303;
			}
		}
	}
yy548:
	YYDEBUG(548, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy141;
			goto yy520;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'm') goto yy549;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy549:
	YYDEBUG(549, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'A') goto yy3;
			goto yy521;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'b') goto yy550;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy550:
	YYDEBUG(550, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy522;
	if (yych != 'e') goto yy152;
	YYDEBUG(551, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy315;
	if (yych == 'r') goto yy483;
	goto yy152;
yy552:
	YYDEBUG(552, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy138;
			goto yy560;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'g') goto yy560;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy553:
	YYDEBUG(553, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy138;
			goto yy557;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'r') goto yy557;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy554:
	YYDEBUG(554, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy138;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'o') goto yy555;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy555:
	YYDEBUG(555, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy136;
	} else {
		if (yych <= 'Z') goto yy139;
		if (yych <= '`') goto yy556;
		if (yych <= 'z') goto yy139;
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->have_special_relative && s->time->special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->special.amount = 0 - s->time->special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy557:
	YYDEBUG(557, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy303;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
				goto yy303;
			} else {
				if (yych != 'I') goto yy139;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'i') goto yy558;
				if (yych <= 'z') goto yy139;
				goto yy303;
			}
		}
	}
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy140;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'l') goto yy559;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy559:
	YYDEBUG(559, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy305;
			goto yy303;
		} else {
			if (yych <= ' ') goto yy305;
			if (yych == ')') goto yy136;
			goto yy303;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy303;
			if (yych <= '9') goto yy305;
			goto yy303;
		} else {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy303;
			if (yych <= 'z') goto yy141;
			goto yy303;
		}
	}
yy560:
	YYDEBUG(560, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy303;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
				goto yy303;
			} else {
				if (yych != 'U') goto yy139;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'u') goto yy561;
				if (yych <= 'z') goto yy139;
				goto yy303;
			}
		}
	}
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy140;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 's') goto yy562;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy562:
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy563;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy563:
	YYDEBUG(563, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy303;
			goto yy305;
		} else {
			if (yych == ' ') goto yy305;
			goto yy303;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy136;
			if (yych <= ',') goto yy303;
			goto yy305;
		} else {
			if (yych <= '/') goto yy303;
			if (yych <= '9') goto yy305;
			goto yy303;
		}
	}
yy564:
	YYDEBUG(564, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy138;
			goto yy560;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'g') goto yy571;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy565:
	YYDEBUG(565, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy138;
			goto yy557;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'r') goto yy568;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy138;
			goto yy555;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'o') goto yy567;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy567:
	YYDEBUG(567, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy556;
			goto yy136;
		} else {
			if (yych == '/') goto yy144;
			goto yy556;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy556;
			goto yy144;
		} else {
			if (yych <= '`') goto yy556;
			if (yych <= 'z') goto yy148;
			goto yy556;
		}
	}
yy568:
	YYDEBUG(568, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'I') goto yy558;
				if (yych <= 'Z') goto yy139;
				goto yy303;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy148;
			} else {
				if (yych <= 'i') goto yy569;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy140;
			goto yy559;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'l') goto yy570;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy570:
	YYDEBUG(570, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy305;
			if (yych <= 0x1F) goto yy303;
			goto yy305;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy303;
			goto yy305;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy144;
			if (yych <= '9') goto yy305;
			if (yych <= '@') goto yy303;
			goto yy141;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy303;
				goto yy144;
			} else {
				if (yych <= '`') goto yy303;
				if (yych <= 'z') goto yy150;
				goto yy303;
			}
		}
	}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'U') goto yy561;
				if (yych <= 'Z') goto yy139;
				goto yy303;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy148;
			} else {
				if (yych <= 'u') goto yy572;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy572:
	YYDEBUG(572, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy140;
			goto yy562;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 's') goto yy573;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy573:
	YYDEBUG(573, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
			goto yy563;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy574;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy305;
			goto yy303;
		} else {
			if (yych <= ' ') goto yy305;
			if (yych == ')') goto yy136;
			goto yy303;
		}
	} else {
		if (yych <= '^') {
			if (yych == '/') goto yy144;
			if (yych <= '9') goto yy305;
			goto yy303;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy303;
			if (yych <= 'z') goto yy151;
			goto yy303;
		}
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy138;
			goto yy589;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'b') goto yy589;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy576:
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'F') goto yy586;
			if (yych <= 'Q') goto yy138;
			goto yy585;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy138;
			goto yy586;
		} else {
			if (yych == 'r') goto yy585;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy577:
	YYDEBUG(577, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy138;
			goto yy582;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'u') goto yy582;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy138;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'i') goto yy579;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy276;
			goto yy136;
		} else {
			if (yych <= '@') goto yy276;
			if (yych <= 'C') goto yy139;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy276;
			goto yy139;
		} else {
			if (yych <= 'd') goto yy580;
			if (yych <= 'z') goto yy139;
			goto yy276;
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy581;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy141;
			goto yy501;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'y') goto yy501;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy139;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'r') goto yy583;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy140;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 't') goto yy584;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy141;
			goto yy517;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'h') goto yy517;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy139;
			goto yy588;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 's') goto yy588;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy587;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'h') goto yy263;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 't') goto yy263;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy303;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
				goto yy303;
			} else {
				if (yych != 'R') goto yy139;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'r') goto yy590;
				if (yych <= 'z') goto yy139;
				goto yy303;
			}
		}
	}
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy140;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'u') goto yy591;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy591:
	YYDEBUG(591, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy592;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy593;
		if (yych != 'r') goto yy3;
	}
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy315;
	if (yych == 'y') goto yy315;
	goto yy53;
yy594:
	YYDEBUG(594, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy138;
			goto yy589;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'b') goto yy608;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy595:
	YYDEBUG(595, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy136;
			if (yych <= '.') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'E') {
				if (yych <= '@') goto yy3;
				goto yy138;
			} else {
				if (yych <= 'F') goto yy586;
				if (yych <= 'Q') goto yy138;
				goto yy585;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy138;
				goto yy3;
			} else {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy3;
				goto yy143;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy605;
				goto yy143;
			} else {
				if (yych <= 'r') goto yy604;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy596:
	YYDEBUG(596, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy138;
			goto yy582;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'u') goto yy601;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy138;
			goto yy579;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'i') goto yy598;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy598:
	YYDEBUG(598, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy276;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy276;
			if (yych <= 'C') goto yy139;
			goto yy580;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy276;
		} else {
			if (yych == 'd') goto yy599;
			if (yych <= 'z') goto yy148;
			goto yy276;
		}
	}
yy599:
	YYDEBUG(599, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy581;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy600;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy141;
			goto yy501;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'y') goto yy530;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy601:
	YYDEBUG(601, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy139;
			goto yy583;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'r') goto yy602;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy140;
			goto yy584;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy603;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy603:
	YYDEBUG(603, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy141;
			goto yy517;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy546;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy604:
	YYDEBUG(604, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy139;
			goto yy588;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 's') goto yy607;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy605:
	YYDEBUG(605, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
			goto yy587;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy606;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy606:
	YYDEBUG(606, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy273;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy607:
	YYDEBUG(607, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy273;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'R') goto yy590;
				if (yych <= 'Z') goto yy139;
				goto yy303;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy148;
			} else {
				if (yych <= 'r') goto yy609;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy140;
			goto yy591;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'u') goto yy610;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy592;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy611;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy611:
	YYDEBUG(611, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'Q') goto yy3;
			goto yy593;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'r') goto yy612;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy315;
	if (yych == 'y') goto yy483;
	goto yy152;
yy613:
	YYDEBUG(613, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'L') goto yy620;
			if (yych <= 'M') goto yy138;
			goto yy619;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy138;
			goto yy620;
		} else {
			if (yych == 'n') goto yy619;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'n') goto yy615;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy303;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
				goto yy303;
			} else {
				if (yych != 'U') goto yy139;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'u') goto yy616;
				if (yych <= 'z') goto yy139;
				goto yy303;
			}
		}
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy617;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy617:
	YYDEBUG(617, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'r') goto yy618;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy315;
		if (yych == 'y') goto yy315;
		goto yy3;
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy303;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
				goto yy303;
			} else {
				if (yych == 'E') goto yy621;
				goto yy139;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'e') goto yy621;
				if (yych <= 'z') goto yy139;
				goto yy303;
			}
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy303;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
				goto yy303;
			} else {
				if (yych != 'Y') goto yy139;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'y') goto yy621;
				if (yych <= 'z') goto yy139;
				goto yy303;
			}
		}
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy305;
			goto yy303;
		} else {
			if (yych <= ' ') goto yy305;
			if (yych == ')') goto yy136;
			goto yy303;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy303;
			if (yych <= '9') goto yy305;
			goto yy303;
		} else {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy303;
			if (yych <= 'z') goto yy140;
			goto yy303;
		}
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '/') {
			if (yych == ')') goto yy136;
			if (yych <= '.') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'K') {
				if (yych <= '@') goto yy3;
				goto yy138;
			} else {
				if (yych <= 'L') goto yy620;
				if (yych <= 'M') goto yy138;
				goto yy619;
			}
		}
	} else {
		if (yych <= 'k') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy138;
				goto yy3;
			} else {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy3;
				goto yy143;
			}
		} else {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy629;
				goto yy143;
			} else {
				if (yych <= 'n') goto yy628;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy623:
	YYDEBUG(623, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
			goto yy615;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'n') goto yy624;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy624:
	YYDEBUG(624, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'U') goto yy616;
				if (yych <= 'Z') goto yy139;
				goto yy303;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy148;
			} else {
				if (yych <= 'u') goto yy625;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy625:
	YYDEBUG(625, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy617;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy626;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy626:
	YYDEBUG(626, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
			goto yy618;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'r') goto yy627;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy627:
	YYDEBUG(627, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'X') goto yy3;
			goto yy315;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'y') goto yy483;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'E') goto yy621;
				if (yych <= 'Z') goto yy139;
				goto yy303;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy148;
			} else {
				if (yych <= 'e') goto yy630;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'Y') goto yy621;
				if (yych <= 'Z') goto yy139;
				goto yy303;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy148;
			} else {
				if (yych <= 'y') goto yy630;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy630:
	YYDEBUG(630, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy305;
			if (yych <= 0x1F) goto yy303;
			goto yy305;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy303;
			goto yy305;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy144;
			if (yych <= '9') goto yy305;
			if (yych <= '@') goto yy303;
			goto yy140;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy303;
				goto yy144;
			} else {
				if (yych <= '`') goto yy303;
				if (yych <= 'z') goto yy149;
				goto yy303;
			}
		}
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy305;
			if (yych <= 0x1F) goto yy3;
			goto yy305;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy305;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy305;
			if (yych <= '@') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy138;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy632:
	YYDEBUG(632, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy305;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy305;
			if (yych == ')') goto yy136;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy305;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy633:
	YYDEBUG(633, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy305;
			if (yych <= 0x1F) goto yy3;
			goto yy305;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy305;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy305;
			if (yych <= '@') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy138;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
	YYDEBUG(634, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy305;
			if (yych <= 0x1F) goto yy3;
			goto yy305;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy305;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy305;
			if (yych <= '@') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy139;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy139;
				goto yy3;
			}
		}
	}
	YYDEBUG(635, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy305;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy305;
			if (yych == ')') goto yy136;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy305;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy636:
	YYDEBUG(636, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy305;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy305;
			if (yych == ')') goto yy136;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy305;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy637:
	YYDEBUG(637, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy305;
			if (yych <= 0x1F) goto yy3;
			goto yy305;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy305;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy305;
			if (yych <= '@') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy632;
				goto yy138;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy660;
				} else {
					if (yych <= ':') goto yy645;
					if (yych <= 'C') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy639:
	YYDEBUG(639, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ':') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '3') {
					if (yych <= '/') goto yy3;
					goto yy660;
				} else {
					if (yych <= '5') goto yy643;
					if (yych <= '9') goto yy644;
					goto yy645;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy3;
					goto yy57;
				} else {
					if (yych == 'F') goto yy57;
					goto yy3;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy3;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy3;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy643;
				} else {
					if (yych <= '9') goto yy644;
					if (yych <= ':') goto yy645;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy3;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy3;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(642, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy54;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy641;
		goto yy53;
	} else {
		if (yych <= '-') goto yy641;
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy51;
		goto yy53;
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy659;
				if (yych <= 'C') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy647;
				if (yych <= 'C') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy646;
	if (yych <= '9') goto yy136;
	goto yy3;
yy646:
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy136;
	goto yy3;
yy647:
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
yy648:
	YYDEBUG(648, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych != '-') goto yy57;
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy650;
	if (yych <= '1') goto yy651;
	goto yy53;
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy652;
	goto yy53;
yy651:
	YYDEBUG(651, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy654;
	if (yych <= '2') goto yy655;
	if (yych <= '3') goto yy656;
	goto yy53;
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy657;
	goto yy53;
yy655:
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy657;
	goto yy53;
yy656:
	YYDEBUG(656, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '2') goto yy53;
yy657:
	YYDEBUG(657, *YYCURSOR);
	++YYCURSOR;
yy658:
	YYDEBUG(658, *YYCURSOR);
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy659:
	YYDEBUG(659, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy648;
				if (yych <= 'C') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy660:
	YYDEBUG(660, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '9') goto yy659;
					if (yych <= ':') goto yy645;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy3;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy3;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(661, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy662;
				if (yych <= 'C') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy662:
	YYDEBUG(662, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych == '-') goto yy649;
				if (yych <= 'C') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy663:
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy665;
	if (yych <= '0') goto yy919;
	if (yych <= '1') goto yy920;
	if (yych <= '9') goto yy921;
	goto yy665;
yy664:
	YYDEBUG(664, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy665:
	YYDEBUG(665, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy664;
	case '-':
	case '.':	goto yy764;
	case 'A':
	case 'a':	goto yy683;
	case 'D':
	case 'd':	goto yy669;
	case 'F':
	case 'f':	goto yy670;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy678;
	case 'J':
	case 'j':	goto yy682;
	case 'M':
	case 'm':	goto yy668;
	case 'N':
	case 'n':	goto yy685;
	case 'O':
	case 'o':	goto yy684;
	case 'P':
	case 'p':	goto yy687;
	case 'S':
	case 's':	goto yy666;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy680;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy681;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy666:
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy1229;
			if (yych <= 'T') goto yy53;
			goto yy122;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy1229;
			if (yych == 'u') goto yy122;
			goto yy53;
		}
	}
yy667:
	YYDEBUG(667, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy1229;
			if (yych == 'U') goto yy122;
			goto yy53;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy123;
			if (yych <= 'd') goto yy53;
			goto yy1229;
		} else {
			if (yych <= 's') goto yy53;
			if (yych <= 't') goto yy912;
			if (yych <= 'u') goto yy122;
			goto yy53;
		}
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy779;
			goto yy53;
		} else {
			if (yych <= 'I') goto yy114;
			if (yych <= 'N') goto yy53;
			goto yy113;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy779;
			goto yy53;
		} else {
			if (yych <= 'i') goto yy114;
			if (yych == 'o') goto yy113;
			goto yy53;
		}
	}
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy110;
		if (yych <= 'D') goto yy53;
		goto yy766;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy110;
		} else {
			if (yych == 'e') goto yy766;
			goto yy53;
		}
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy782;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy83;
			if (yych <= 'Q') goto yy53;
			goto yy82;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy782;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy83;
			if (yych == 'r') goto yy82;
			goto yy53;
		}
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy66;
		if (yych <= 'T') goto yy53;
		goto yy67;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy1228;
		} else {
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
yy672:
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy925;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy924;
	goto yy57;
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy717;
		goto yy53;
	} else {
		if (yych <= 'd') goto yy912;
		if (yych == 'o') goto yy717;
		goto yy53;
	}
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy912;
	goto yy53;
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy852;
	case '3':	goto yy854;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy855;
	case 'A':
	case 'a':	goto yy859;
	case 'D':
	case 'd':	goto yy863;
	case 'F':
	case 'f':	goto yy857;
	case 'J':
	case 'j':	goto yy856;
	case 'M':
	case 'm':	goto yy858;
	case 'N':
	case 'n':	goto yy862;
	case 'O':
	case 'o':	goto yy861;
	case 'S':
	case 's':	goto yy860;
	default:	goto yy53;
	}
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy802;
	case '1':	goto yy803;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy804;
	case 'A':
	case 'a':	goto yy808;
	case 'D':
	case 'd':	goto yy812;
	case 'F':
	case 'f':	goto yy806;
	case 'J':
	case 'j':	goto yy805;
	case 'M':
	case 'm':	goto yy807;
	case 'N':
	case 'n':	goto yy811;
	case 'O':
	case 'o':	goto yy810;
	case 'S':
	case 's':	goto yy809;
	default:	goto yy765;
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy765;
		if (yych <= '0') goto yy755;
		goto yy756;
	} else {
		if (yych <= '5') goto yy757;
		if (yych <= '9') goto yy758;
		goto yy765;
	}
yy678:
	YYDEBUG(678, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '.') goto yy719;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy721;
			if (yych == 'I') goto yy754;
		} else {
			if (yych == 'W') goto yy679;
			if (yych <= 'X') goto yy727;
		}
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy680:
	YYDEBUG(680, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy679;
			goto yy719;
		} else {
			if (yych == ' ') goto yy719;
			goto yy679;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy719;
			if (yych <= '/') goto yy679;
			goto yy721;
		} else {
			if (yych == 'I') goto yy752;
			goto yy679;
		}
	}
yy681:
	YYDEBUG(681, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy679;
			goto yy719;
		} else {
			if (yych == ' ') goto yy719;
			goto yy679;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy719;
			if (yych <= '/') goto yy679;
			goto yy721;
		} else {
			if (yych == 'I') goto yy751;
			goto yy679;
		}
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy744;
		if (yych <= 'T') goto yy53;
		goto yy743;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy744;
		} else {
			if (yych == 'u') goto yy743;
			goto yy53;
		}
	}
yy683:
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy688;
			goto yy53;
		} else {
			if (yych <= 'M') goto yy689;
			if (yych == 'P') goto yy737;
			goto yy53;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy736;
			if (yych == 'm') goto yy689;
			goto yy53;
		} else {
			if (yych <= 'p') goto yy737;
			if (yych == 'u') goto yy736;
			goto yy53;
		}
	}
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy731;
	if (yych == 'c') goto yy731;
	goto yy53;
yy685:
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy717;
	if (yych == 'o') goto yy717;
	goto yy53;
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy693;
	if (yych <= '9') goto yy695;
	goto yy53;
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy53;
	} else {
		if (yych <= 'M') goto yy689;
		if (yych == 'm') goto yy689;
		goto yy53;
	}
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy689;
	if (yych != 'm') goto yy53;
yy689:
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy691;
		if (yych == '\t') goto yy691;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy691;
		if (yych != '.') goto yy53;
	}
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy691;
		if (yych <= 0x08) goto yy53;
	} else {
		if (yych != ' ') goto yy53;
	}
yy691:
	YYDEBUG(691, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(692, *YYCURSOR);
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy696;
	} else {
		if (yych <= '9') goto yy710;
		if (yych <= ':') goto yy696;
	}
yy694:
	YYDEBUG(694, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy696;
	if (yych != ':') goto yy694;
yy696:
	YYDEBUG(696, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy697;
	if (yych <= '6') goto yy698;
	if (yych <= '9') goto yy699;
	goto yy53;
yy697:
	YYDEBUG(697, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy700;
	if (yych <= '/') goto yy694;
	if (yych <= '9') goto yy703;
	goto yy694;
yy698:
	YYDEBUG(698, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy700;
	if (yych == '0') goto yy703;
	goto yy694;
yy699:
	YYDEBUG(699, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy694;
yy700:
	YYDEBUG(700, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy701:
	YYDEBUG(701, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(702, *YYCURSOR);
	if (yych <= '/') goto yy694;
	if (yych <= '9') goto yy701;
	goto yy694;
yy703:
	YYDEBUG(703, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy694;
		} else {
			if (yych <= ' ') goto yy704;
			if (yych == '.') goto yy700;
			goto yy694;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy706;
			if (yych == 'P') goto yy706;
			goto yy694;
		} else {
			if (yych <= 'a') goto yy706;
			if (yych == 'p') goto yy706;
			goto yy694;
		}
	}
yy704:
	YYDEBUG(704, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(705, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy704;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy704;
			if (yych <= '@') goto yy53;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy53;
		} else {
			if (yych <= 'a') goto yy706;
			if (yych != 'p') goto yy53;
		}
	}
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy53;
	} else {
		if (yych <= 'M') goto yy708;
		if (yych == 'm') goto yy708;
		goto yy53;
	}
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy708;
	if (yych != 'm') goto yy53;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy691;
		if (yych == '\t') goto yy691;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy691;
		if (yych != '.') goto yy53;
	}
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy691;
		if (yych <= 0x08) goto yy53;
		goto yy691;
	} else {
		if (yych == ' ') goto yy691;
		goto yy53;
	}
yy710:
	YYDEBUG(710, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy711;
			if (yych <= 0x1F) goto yy694;
		} else {
			if (yych == '.') goto yy696;
			if (yych <= '9') goto yy694;
			goto yy696;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy713;
			if (yych <= 'O') goto yy694;
			goto yy713;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy694;
				goto yy713;
			} else {
				if (yych == 'p') goto yy713;
				goto yy694;
			}
		}
	}
yy711:
	YYDEBUG(711, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(712, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy711;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy711;
			if (yych <= '@') goto yy53;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy53;
		} else {
			if (yych <= 'a') goto yy713;
			if (yych != 'p') goto yy53;
		}
	}
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy53;
	} else {
		if (yych <= 'M') goto yy715;
		if (yych == 'm') goto yy715;
		goto yy53;
	}
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy715;
	if (yych != 'm') goto yy53;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy691;
		if (yych == '\t') goto yy691;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy691;
		if (yych != '.') goto yy53;
	}
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy691;
		if (yych <= 0x08) goto yy53;
		goto yy691;
	} else {
		if (yych == ' ') goto yy691;
		goto yy53;
	}
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy718;
	if (yych != 'v') goto yy53;
yy718:
	YYDEBUG(718, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'E') goto yy723;
			if (yych == 'e') goto yy723;
			goto yy679;
		}
	}
yy719:
	YYDEBUG(719, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy720:
	YYDEBUG(720, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy719;
		if (yych <= 0x1F) goto yy53;
		goto yy719;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy53;
			goto yy719;
		} else {
			if (yych <= '/') goto yy53;
			if (yych >= ':') goto yy53;
		}
	}
yy721:
	YYDEBUG(721, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy722;
	if (yych <= '9') goto yy728;
yy722:
	YYDEBUG(722, *YYCURSOR);
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy723:
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy724;
	if (yych != 'm') goto yy53;
yy724:
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy725;
	if (yych != 'b') goto yy53;
yy725:
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy726;
	if (yych != 'e') goto yy53;
yy726:
	YYDEBUG(726, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy727;
	if (yych != 'r') goto yy53;
yy727:
	YYDEBUG(727, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy719;
		if (yych <= 0x1F) goto yy679;
		goto yy719;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy679;
			goto yy719;
		} else {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		}
	}
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy722;
	if (yych >= ':') goto yy722;
yy729:
	YYDEBUG(729, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy722;
	if (yych >= ':') goto yy722;
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy722;
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy732;
	if (yych != 't') goto yy53;
yy732:
	YYDEBUG(732, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			goto yy719;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'O') goto yy733;
			if (yych != 'o') goto yy679;
		}
	}
yy733:
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy734;
	if (yych != 'b') goto yy53;
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy735;
	if (yych != 'e') goto yy53;
yy735:
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy727;
	if (yych == 'r') goto yy727;
	goto yy53;
yy736:
	YYDEBUG(736, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy740;
	if (yych == 'g') goto yy740;
	goto yy53;
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy738;
	if (yych != 'r') goto yy53;
yy738:
	YYDEBUG(738, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			goto yy719;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'I') goto yy739;
			if (yych != 'i') goto yy679;
		}
	}
yy739:
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy727;
	if (yych == 'l') goto yy727;
	goto yy53;
yy740:
	YYDEBUG(740, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			goto yy719;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'U') goto yy741;
			if (yych != 'u') goto yy679;
		}
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy742;
	if (yych != 's') goto yy53;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy727;
	if (yych == 't') goto yy727;
	goto yy53;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy750;
		if (yych <= 'M') goto yy53;
		goto yy749;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy750;
		} else {
			if (yych == 'n') goto yy749;
			goto yy53;
		}
	}
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy745;
	if (yych != 'n') goto yy53;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			goto yy719;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'U') goto yy746;
			if (yych != 'u') goto yy679;
		}
	}
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy747;
	if (yych != 'a') goto yy53;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy748;
	if (yych != 'r') goto yy53;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy727;
	if (yych == 'y') goto yy727;
	goto yy53;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			goto yy719;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'E') goto yy727;
			if (yych == 'e') goto yy727;
			goto yy679;
		}
	}
yy750:
	YYDEBUG(750, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			goto yy719;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'Y') goto yy727;
			if (yych == 'y') goto yy727;
			goto yy679;
		}
	}
yy751:
	YYDEBUG(751, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy679;
			goto yy719;
		} else {
			if (yych == ' ') goto yy719;
			goto yy679;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy719;
			if (yych <= '/') goto yy679;
			goto yy721;
		} else {
			if (yych == 'I') goto yy727;
			goto yy679;
		}
	}
yy752:
	YYDEBUG(752, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy679;
			goto yy719;
		} else {
			if (yych == ' ') goto yy719;
			goto yy679;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy719;
			if (yych <= '/') goto yy679;
			goto yy721;
		} else {
			if (yych != 'I') goto yy679;
		}
	}
	YYDEBUG(753, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy679;
			goto yy719;
		} else {
			if (yych == ' ') goto yy719;
			goto yy679;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy719;
			if (yych <= '/') goto yy679;
			goto yy721;
		} else {
			if (yych == 'I') goto yy727;
			goto yy679;
		}
	}
yy754:
	YYDEBUG(754, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy679;
			goto yy719;
		} else {
			if (yych == ' ') goto yy719;
			goto yy679;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy719;
			if (yych <= '/') goto yy679;
			goto yy721;
		} else {
			if (yych == 'I') goto yy727;
			goto yy679;
		}
	}
yy755:
	YYDEBUG(755, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy694;
		if (yych <= '-') goto yy789;
		goto yy788;
	} else {
		if (yych <= '/') goto yy694;
		if (yych <= '9') goto yy801;
		if (yych <= ':') goto yy696;
		goto yy694;
	}
yy756:
	YYDEBUG(756, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy694;
		if (yych <= '-') goto yy789;
		if (yych <= '.') goto yy788;
		goto yy694;
	} else {
		if (yych <= '2') goto yy801;
		if (yych <= '9') goto yy710;
		if (yych <= ':') goto yy696;
		goto yy694;
	}
yy757:
	YYDEBUG(757, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy694;
		if (yych <= '-') goto yy789;
		goto yy788;
	} else {
		if (yych <= '/') goto yy694;
		if (yych <= '9') goto yy710;
		if (yych <= ':') goto yy696;
		goto yy694;
	}
yy758:
	YYDEBUG(758, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy694;
		if (yych <= '-') goto yy789;
		goto yy788;
	} else {
		if (yych == ':') goto yy696;
		goto yy694;
	}
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy782;
	if (yych == 'e') goto yy782;
	goto yy53;
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy779;
	if (yych == 'a') goto yy779;
	goto yy53;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy737;
		if (yych <= 'T') goto yy53;
		goto yy736;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy737;
		} else {
			if (yych == 'u') goto yy736;
			goto yy53;
		}
	}
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy772;
	if (yych == 'e') goto yy772;
	goto yy53;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy766;
	if (yych == 'e') goto yy766;
	goto yy53;
yy764:
	YYDEBUG(764, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy765:
	YYDEBUG(765, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy764;
	case 'A':
	case 'a':	goto yy761;
	case 'D':
	case 'd':	goto yy763;
	case 'F':
	case 'f':	goto yy759;
	case 'I':	goto yy678;
	case 'J':
	case 'j':	goto yy682;
	case 'M':
	case 'm':	goto yy760;
	case 'N':
	case 'n':	goto yy685;
	case 'O':
	case 'o':	goto yy684;
	case 'S':
	case 's':	goto yy762;
	case 'V':	goto yy680;
	case 'X':	goto yy681;
	default:	goto yy53;
	}
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy767;
	if (yych != 'c') goto yy53;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			goto yy719;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'E') goto yy768;
			if (yych != 'e') goto yy679;
		}
	}
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy769;
	if (yych != 'm') goto yy53;
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy770;
	if (yych != 'b') goto yy53;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy771;
	if (yych != 'e') goto yy53;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy727;
	if (yych == 'r') goto yy727;
	goto yy53;
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy773;
	if (yych != 'p') goto yy53;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			goto yy719;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'T') goto yy774;
			if (yych != 't') goto yy679;
		}
	}
yy774:
	YYDEBUG(774, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			goto yy719;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'E') goto yy775;
			if (yych != 'e') goto yy679;
		}
	}
yy775:
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy776;
	if (yych != 'm') goto yy53;
yy776:
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy777;
	if (yych != 'b') goto yy53;
yy777:
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy778;
	if (yych != 'e') goto yy53;
yy778:
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy727;
	if (yych == 'r') goto yy727;
	goto yy53;
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy780;
		if (yych <= 'X') goto yy53;
		goto yy727;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy727;
			goto yy53;
		}
	}
yy780:
	YYDEBUG(780, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			goto yy719;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'C') goto yy781;
			if (yych != 'c') goto yy679;
		}
	}
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy727;
	if (yych == 'h') goto yy727;
	goto yy53;
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy783;
	if (yych != 'b') goto yy53;
yy783:
	YYDEBUG(783, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			goto yy719;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'R') goto yy784;
			if (yych != 'r') goto yy679;
		}
	}
yy784:
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy785;
	if (yych != 'u') goto yy53;
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy786;
	if (yych != 'a') goto yy53;
yy786:
	YYDEBUG(786, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy787;
	if (yych != 'r') goto yy53;
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy727;
	if (yych == 'y') goto yy727;
	goto yy53;
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy795;
	if (yych <= '6') goto yy796;
	if (yych <= '9') goto yy797;
	goto yy53;
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(790, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(793, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(794, *YYCURSOR);
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy795:
	YYDEBUG(795, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy700;
	if (yych <= '/') goto yy694;
	if (yych <= '9') goto yy800;
	goto yy694;
yy796:
	YYDEBUG(796, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy700;
		goto yy694;
	} else {
		if (yych <= '0') goto yy800;
		if (yych <= '9') goto yy798;
		goto yy694;
	}
yy797:
	YYDEBUG(797, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy700;
	if (yych <= '/') goto yy694;
	if (yych >= ':') goto yy694;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy799;
	if (yych <= '9') goto yy792;
yy799:
	YYDEBUG(799, *YYCURSOR);
	{
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy800:
	YYDEBUG(800, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy704;
			if (yych <= 0x1F) goto yy694;
			goto yy704;
		} else {
			if (yych == '.') goto yy700;
			if (yych <= '/') goto yy694;
			goto yy792;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy706;
			if (yych <= 'O') goto yy694;
			goto yy706;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy694;
				goto yy706;
			} else {
				if (yych == 'p') goto yy706;
				goto yy694;
			}
		}
	}
yy801:
	YYDEBUG(801, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy711;
			if (yych <= 0x1F) goto yy694;
			goto yy711;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy694;
				goto yy789;
			} else {
				if (yych <= '.') goto yy788;
				if (yych <= '9') goto yy694;
				goto yy696;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy713;
			if (yych <= 'O') goto yy694;
			goto yy713;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy694;
				goto yy713;
			} else {
				if (yych == 'p') goto yy713;
				goto yy694;
			}
		}
	}
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy841;
		goto yy789;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy804;
		goto yy53;
	}
yy803:
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy841;
		goto yy789;
	} else {
		if (yych <= '/') goto yy53;
		if (yych >= '3') goto yy53;
	}
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '-') goto yy841;
	if (yych <= '.') goto yy789;
	goto yy53;
yy805:
	YYDEBUG(805, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy837;
		if (yych <= 'T') goto yy53;
		goto yy836;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy837;
		} else {
			if (yych == 'u') goto yy836;
			goto yy53;
		}
	}
yy806:
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy834;
	if (yych == 'e') goto yy834;
	goto yy53;
yy807:
	YYDEBUG(807, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy831;
	if (yych == 'a') goto yy831;
	goto yy53;
yy808:
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy828;
		if (yych <= 'T') goto yy53;
		goto yy827;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy828;
		} else {
			if (yych == 'u') goto yy827;
			goto yy53;
		}
	}
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy824;
	if (yych == 'e') goto yy824;
	goto yy53;
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy822;
	if (yych == 'c') goto yy822;
	goto yy53;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy820;
	if (yych == 'o') goto yy820;
	goto yy53;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy813;
	if (yych != 'e') goto yy53;
yy813:
	YYDEBUG(813, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy814;
	if (yych != 'c') goto yy53;
yy814:
	YYDEBUG(814, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych >= '.') goto yy719;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'E') goto yy768;
			if (yych == 'e') goto yy768;
			goto yy679;
		}
	}
yy815:
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy720;
	if (yych <= '0') goto yy816;
	if (yych <= '2') goto yy817;
	if (yych <= '3') goto yy818;
	goto yy720;
yy816:
	YYDEBUG(816, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy722;
	if (yych <= '9') goto yy819;
	goto yy722;
yy817:
	YYDEBUG(817, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy722;
	if (yych <= '9') goto yy819;
	goto yy722;
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy722;
	if (yych <= '1') goto yy819;
	if (yych <= '9') goto yy728;
	goto yy722;
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy722;
	if (yych <= '9') goto yy729;
	goto yy722;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy821;
	if (yych != 'v') goto yy53;
yy821:
	YYDEBUG(821, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '-') goto yy815;
			goto yy719;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'E') goto yy723;
			if (yych == 'e') goto yy723;
			goto yy679;
		}
	}
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy823;
	if (yych != 't') goto yy53;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '-') goto yy815;
			goto yy719;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'O') goto yy733;
			if (yych == 'o') goto yy733;
			goto yy679;
		}
	}
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy825;
	if (yych != 'p') goto yy53;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '-') goto yy815;
			goto yy719;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'T') goto yy826;
			if (yych != 't') goto yy679;
		}
	}
yy826:
	YYDEBUG(826, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '-') goto yy815;
			goto yy719;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'E') goto yy775;
			if (yych == 'e') goto yy775;
			goto yy679;
		}
	}
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy830;
	if (yych == 'g') goto yy830;
	goto yy53;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy829;
	if (yych != 'r') goto yy53;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '-') goto yy815;
			goto yy719;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'I') goto yy739;
			if (yych == 'i') goto yy739;
			goto yy679;
		}
	}
yy830:
	YYDEBUG(830, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '-') goto yy815;
			goto yy719;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'U') goto yy741;
			if (yych == 'u') goto yy741;
			goto yy679;
		}
	}
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy832;
		if (yych <= 'X') goto yy53;
		goto yy833;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy833;
			goto yy53;
		}
	}
yy832:
	YYDEBUG(832, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '-') goto yy815;
			goto yy719;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'C') goto yy781;
			if (yych == 'c') goto yy781;
			goto yy679;
		}
	}
yy833:
	YYDEBUG(833, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy679;
			goto yy719;
		} else {
			if (yych == ' ') goto yy719;
			goto yy679;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy815;
			goto yy719;
		} else {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		}
	}
yy834:
	YYDEBUG(834, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy835;
	if (yych != 'b') goto yy53;
yy835:
	YYDEBUG(835, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '-') goto yy815;
			goto yy719;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'R') goto yy784;
			if (yych == 'r') goto yy784;
			goto yy679;
		}
	}
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy840;
		if (yych <= 'M') goto yy53;
		goto yy839;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy840;
		} else {
			if (yych == 'n') goto yy839;
			goto yy53;
		}
	}
yy837:
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy838;
	if (yych != 'n') goto yy53;
yy838:
	YYDEBUG(838, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '-') goto yy815;
			goto yy719;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'U') goto yy746;
			if (yych == 'u') goto yy746;
			goto yy679;
		}
	}
yy839:
	YYDEBUG(839, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '-') goto yy815;
			goto yy719;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'E') goto yy727;
			if (yych == 'e') goto yy727;
			goto yy679;
		}
	}
yy840:
	YYDEBUG(840, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy719;
			goto yy679;
		} else {
			if (yych <= ' ') goto yy719;
			if (yych <= ',') goto yy679;
			if (yych <= '-') goto yy815;
			goto yy719;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy679;
			if (yych <= '9') goto yy721;
			goto yy679;
		} else {
			if (yych <= 'Y') goto yy727;
			if (yych == 'y') goto yy727;
			goto yy679;
		}
	}
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy842;
	if (yych <= '3') goto yy844;
	if (yych <= '9') goto yy845;
	goto yy53;
yy842:
	YYDEBUG(842, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy843;
		if (yych <= '9') goto yy851;
		if (yych >= 'n') goto yy847;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
		}
	}
yy843:
	YYDEBUG(843, *YYCURSOR);
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy844:
	YYDEBUG(844, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy843;
			goto yy851;
		} else {
			if (yych <= '9') goto yy791;
			if (yych <= 'm') goto yy843;
			goto yy847;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy843;
		}
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy843;
		if (yych <= '9') goto yy791;
		if (yych <= 'm') goto yy843;
		goto yy847;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy843;
		}
	}
yy846:
	YYDEBUG(846, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy850;
	goto yy53;
yy847:
	YYDEBUG(847, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy850;
	goto yy53;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy850;
	goto yy53;
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy53;
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy843;
yy851:
	YYDEBUG(851, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy843;
		if (yych <= '9') goto yy792;
		if (yych <= 'm') goto yy843;
		goto yy847;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy843;
		}
	}
yy852:
	YYDEBUG(852, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy906;
		} else {
			if (yych <= '9') goto yy855;
			if (yych >= 'n') goto yy903;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy904;
		} else {
			if (yych <= 's') goto yy902;
			if (yych <= 't') goto yy905;
		}
	}
yy853:
	YYDEBUG(853, *YYCURSOR);
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy854:
	YYDEBUG(854, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy853;
			goto yy906;
		} else {
			if (yych <= '1') goto yy855;
			if (yych <= 'm') goto yy853;
			goto yy903;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy853;
			goto yy904;
		} else {
			if (yych <= 's') goto yy902;
			if (yych <= 't') goto yy905;
			goto yy853;
		}
	}
yy855:
	YYDEBUG(855, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy906;
		if (yych <= 'm') goto yy853;
		goto yy903;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy853;
			goto yy904;
		} else {
			if (yych <= 's') goto yy902;
			if (yych <= 't') goto yy905;
			goto yy853;
		}
	}
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy901;
		if (yych <= 'T') goto yy53;
		goto yy900;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy901;
		} else {
			if (yych == 'u') goto yy900;
			goto yy53;
		}
	}
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy899;
	if (yych == 'e') goto yy899;
	goto yy53;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy898;
	if (yych == 'a') goto yy898;
	goto yy53;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy897;
		if (yych <= 'T') goto yy53;
		goto yy896;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy897;
		} else {
			if (yych == 'u') goto yy896;
			goto yy53;
		}
	}
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy894;
	if (yych == 'e') goto yy894;
	goto yy53;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy893;
	if (yych == 'c') goto yy893;
	goto yy53;
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy892;
	if (yych == 'o') goto yy892;
	goto yy53;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy864;
	if (yych != 'e') goto yy53;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy865;
	if (yych != 'c') goto yy53;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy53;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy872;
	if (yych <= '2') goto yy873;
	goto yy53;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy874;
	goto yy53;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '4') goto yy53;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy879;
	if (yych <= '6') goto yy880;
	goto yy53;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy881;
	goto yy53;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy53;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy882;
	if (yych != ' ') goto yy53;
yy882:
	YYDEBUG(882, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	YYDEBUG(883, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy882;
		if (yych <= 0x1F) goto yy53;
		goto yy882;
	} else {
		if (yych <= '+') {
			if (yych <= '*') goto yy53;
		} else {
			if (yych != '-') goto yy53;
		}
	}
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy885;
	if (yych <= '2') goto yy887;
	if (yych <= '9') goto yy888;
	goto yy53;
yy885:
	YYDEBUG(885, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy886;
	if (yych <= '9') goto yy888;
	if (yych <= ':') goto yy889;
yy886:
	YYDEBUG(886, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy886;
		if (yych >= '4') goto yy890;
	} else {
		if (yych <= '9') goto yy891;
		if (yych <= ':') goto yy889;
		goto yy886;
	}
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy886;
	if (yych <= '5') goto yy890;
	if (yych <= '9') goto yy891;
	if (yych >= ';') goto yy886;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy886;
	if (yych <= '5') goto yy890;
	if (yych <= '9') goto yy891;
	goto yy886;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy886;
	if (yych >= ':') goto yy886;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy886;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy865;
	if (yych == 'v') goto yy865;
	goto yy53;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy865;
	if (yych == 't') goto yy865;
	goto yy53;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy895;
	if (yych != 'p') goto yy53;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy866;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy865;
		if (yych == 't') goto yy865;
		goto yy53;
	}
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy865;
	if (yych == 'g') goto yy865;
	goto yy53;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy865;
	if (yych == 'r') goto yy865;
	goto yy53;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy865;
		if (yych <= 'X') goto yy53;
		goto yy865;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy865;
		} else {
			if (yych == 'y') goto yy865;
			goto yy53;
		}
	}
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy865;
	if (yych == 'b') goto yy865;
	goto yy53;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy865;
		if (yych <= 'M') goto yy53;
		goto yy865;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy865;
		} else {
			if (yych == 'n') goto yy865;
			goto yy53;
		}
	}
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy865;
	if (yych == 'n') goto yy865;
	goto yy53;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy911;
	goto yy53;
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy911;
	goto yy53;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy911;
	goto yy53;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy911;
	goto yy53;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy853;
	if (yych >= ':') goto yy853;
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy853;
	if (yych >= ':') goto yy853;
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy853;
	if (yych >= ':') goto yy853;
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy853;
yy911:
	YYDEBUG(911, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy906;
	goto yy853;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy914;
		goto yy765;
	} else {
		if (yych <= '-') goto yy915;
		if (yych <= '.') goto yy914;
		if (yych >= '0') goto yy765;
	}
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case 'A':
	case 'a':	goto yy859;
	case 'D':
	case 'd':	goto yy863;
	case 'F':
	case 'f':	goto yy857;
	case 'J':
	case 'j':	goto yy856;
	case 'M':
	case 'm':	goto yy858;
	case 'N':
	case 'n':	goto yy862;
	case 'O':
	case 'o':	goto yy861;
	case 'S':
	case 's':	goto yy860;
	default:	goto yy53;
	}
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy765;
	if (yych <= '0') goto yy919;
	if (yych <= '1') goto yy920;
	if (yych <= '9') goto yy921;
	goto yy765;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy765;
	if (yych <= '0') goto yy916;
	if (yych <= '1') goto yy917;
	if (yych <= '9') goto yy918;
	goto yy765;
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy789;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy918;
	goto yy53;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy789;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy789;
	goto yy53;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy789;
		goto yy922;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy921;
		goto yy53;
	}
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy789;
		goto yy922;
	} else {
		if (yych <= '/') goto yy53;
		if (yych >= '3') goto yy53;
	}
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '-') goto yy789;
	if (yych >= '/') goto yy53;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy798;
	goto yy53;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy968;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy966;
	goto yy57;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy934;
	case '1':	goto yy935;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy936;
	case 'A':
	case 'a':	goto yy929;
	case 'D':
	case 'd':	goto yy933;
	case 'F':
	case 'f':	goto yy927;
	case 'J':
	case 'j':	goto yy926;
	case 'M':
	case 'm':	goto yy928;
	case 'N':
	case 'n':	goto yy932;
	case 'O':
	case 'o':	goto yy931;
	case 'S':
	case 's':	goto yy930;
	default:	goto yy53;
	}
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy965;
		if (yych <= 'T') goto yy53;
		goto yy964;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy965;
		} else {
			if (yych == 'u') goto yy964;
			goto yy53;
		}
	}
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy963;
	if (yych == 'e') goto yy963;
	goto yy53;
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy962;
	if (yych == 'a') goto yy962;
	goto yy53;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy961;
		if (yych <= 'T') goto yy53;
		goto yy960;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy961;
		} else {
			if (yych == 'u') goto yy960;
			goto yy53;
		}
	}
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy958;
	if (yych == 'e') goto yy958;
	goto yy53;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy957;
	if (yych == 'c') goto yy957;
	goto yy53;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy956;
	if (yych == 'o') goto yy956;
	goto yy53;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy948;
	if (yych == 'e') goto yy948;
	goto yy53;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy937;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy941;
	goto yy53;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy937;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy941;
	goto yy53;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy938;
	if (yych <= '3') goto yy939;
	if (yych <= '9') goto yy940;
	goto yy53;
yy938:
	YYDEBUG(938, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy843;
		if (yych <= '9') goto yy940;
		if (yych <= 'm') goto yy843;
		goto yy847;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy843;
		}
	}
yy939:
	YYDEBUG(939, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy843;
		if (yych <= '1') goto yy940;
		if (yych <= 'm') goto yy843;
		goto yy847;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy843;
		}
	}
yy940:
	YYDEBUG(940, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy847;
		goto yy843;
	} else {
		if (yych <= 'r') goto yy848;
		if (yych <= 's') goto yy846;
		if (yych <= 't') goto yy849;
		goto yy843;
	}
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych >= '1') goto yy944;
	} else {
		if (yych <= '3') goto yy945;
		if (yych <= '9') goto yy940;
		goto yy53;
	}
	YYDEBUG(943, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy843;
		if (yych <= '9') goto yy946;
		if (yych <= 'm') goto yy843;
		goto yy847;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy843;
		}
	}
yy944:
	YYDEBUG(944, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy843;
		if (yych <= '9') goto yy946;
		if (yych <= 'm') goto yy843;
		goto yy847;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy843;
		}
	}
yy945:
	YYDEBUG(945, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy843;
		if (yych <= '1') goto yy946;
		if (yych <= 'm') goto yy843;
		goto yy847;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy843;
		}
	}
yy946:
	YYDEBUG(946, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy847;
	} else {
		if (yych <= 'r') goto yy848;
		if (yych <= 's') goto yy846;
		if (yych <= 't') goto yy849;
	}
yy947:
	YYDEBUG(947, *YYCURSOR);
	{
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy949;
	if (yych != 'c') goto yy53;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy951;
	if (yych <= '2') goto yy952;
	if (yych <= '3') goto yy953;
	goto yy53;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy954;
	goto yy53;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy954;
	goto yy53;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '2') goto yy53;
yy954:
	YYDEBUG(954, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(955, *YYCURSOR);
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy949;
	if (yych == 'v') goto yy949;
	goto yy53;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy949;
	if (yych == 't') goto yy949;
	goto yy53;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy959;
	if (yych != 'p') goto yy53;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy950;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy949;
		if (yych == 't') goto yy949;
		goto yy53;
	}
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy949;
	if (yych == 'g') goto yy949;
	goto yy53;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy949;
	if (yych == 'r') goto yy949;
	goto yy53;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy949;
		if (yych <= 'X') goto yy53;
		goto yy949;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy949;
		} else {
			if (yych == 'y') goto yy949;
			goto yy53;
		}
	}
yy963:
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy949;
	if (yych == 'b') goto yy949;
	goto yy53;
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy949;
		if (yych <= 'M') goto yy53;
		goto yy949;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy949;
		} else {
			if (yych == 'n') goto yy949;
			goto yy53;
		}
	}
yy965:
	YYDEBUG(965, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy949;
	if (yych == 'n') goto yy949;
	goto yy53;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy974;
	case '-':	goto yy971;
	case '.':	goto yy975;
	case '/':	goto yy972;
	case '0':	goto yy988;
	case '1':	goto yy989;
	case '2':	goto yy991;
	case '3':	goto yy992;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	case ':':	goto yy990;
	case 'W':	goto yy993;
	default:	goto yy967;
	}
yy967:
	YYDEBUG(967, *YYCURSOR);
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy969;
	case '1':	goto yy970;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy936;
	case 'A':
	case 'a':	goto yy929;
	case 'D':
	case 'd':	goto yy933;
	case 'F':
	case 'f':	goto yy927;
	case 'J':
	case 'j':	goto yy926;
	case 'M':
	case 'm':	goto yy928;
	case 'N':
	case 'n':	goto yy932;
	case 'O':
	case 'o':	goto yy931;
	case 'S':
	case 's':	goto yy930;
	default:	goto yy53;
	}
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy937;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy936;
	goto yy53;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy937;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy936;
	goto yy53;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy1156;
	case '1':	goto yy1158;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1159;
	case 'A':
	case 'a':	goto yy1150;
	case 'D':
	case 'd':	goto yy1154;
	case 'F':
	case 'f':	goto yy1148;
	case 'J':
	case 'j':	goto yy1147;
	case 'M':
	case 'm':	goto yy1149;
	case 'N':
	case 'n':	goto yy1153;
	case 'O':
	case 'o':	goto yy1152;
	case 'S':
	case 's':	goto yy1151;
	case 'W':	goto yy1155;
	default:	goto yy1122;
	}
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1130;
	if (yych <= '1') goto yy1131;
	if (yych <= '9') goto yy1132;
	goto yy53;
yy973:
	YYDEBUG(973, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy974:
	YYDEBUG(974, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy973;
	case '-':
	case '.':	goto yy1121;
	case 'A':
	case 'a':	goto yy983;
	case 'D':
	case 'd':	goto yy987;
	case 'F':
	case 'f':	goto yy981;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy976;
	case 'J':
	case 'j':	goto yy980;
	case 'M':
	case 'm':	goto yy982;
	case 'N':
	case 'n':	goto yy986;
	case 'O':
	case 'o':	goto yy985;
	case 'S':
	case 's':	goto yy984;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy978;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy979;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy975:
	YYDEBUG(975, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1122;
	if (yych <= '0') goto yy1114;
	if (yych <= '2') goto yy1115;
	if (yych <= '3') goto yy1116;
	goto yy1122;
yy976:
	YYDEBUG(976, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy1113;
	} else {
		if (yych == 'W') goto yy977;
		if (yych <= 'X') goto yy1067;
	}
yy977:
	YYDEBUG(977, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy978:
	YYDEBUG(978, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1111;
	goto yy977;
yy979:
	YYDEBUG(979, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1110;
	goto yy977;
yy980:
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1103;
		if (yych <= 'T') goto yy53;
		goto yy1102;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy1103;
		} else {
			if (yych == 'u') goto yy1102;
			goto yy53;
		}
	}
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy1096;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy83;
			if (yych <= 'Q') goto yy53;
			goto yy82;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy1096;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy83;
			if (yych == 'r') goto yy82;
			goto yy53;
		}
	}
yy982:
	YYDEBUG(982, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy1093;
			goto yy53;
		} else {
			if (yych <= 'I') goto yy114;
			if (yych <= 'N') goto yy53;
			goto yy113;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy1093;
			goto yy53;
		} else {
			if (yych <= 'i') goto yy114;
			if (yych == 'o') goto yy113;
			goto yy53;
		}
	}
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1087;
		if (yych <= 'T') goto yy53;
		goto yy1086;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy1087;
		} else {
			if (yych == 'u') goto yy1086;
			goto yy53;
		}
	}
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy1079;
			if (yych <= 'T') goto yy53;
			goto yy122;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy1079;
			if (yych == 'u') goto yy122;
			goto yy53;
		}
	}
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1074;
	if (yych == 'c') goto yy1074;
	goto yy53;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1068;
	if (yych == 'o') goto yy1068;
	goto yy53;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy110;
		if (yych <= 'D') goto yy53;
		goto yy1061;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy110;
		} else {
			if (yych == 'e') goto yy1061;
			goto yy53;
		}
	}
yy988:
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy1058;
	if (yych <= '9') goto yy1059;
	goto yy57;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy1027;
	if (yych <= '9') goto yy1006;
	goto yy57;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1007;
	if (yych <= '1') goto yy1008;
	goto yy53;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1006;
	goto yy57;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy1002;
	if (yych <= '6') goto yy1003;
	if (yych <= '9') goto yy51;
	goto yy57;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '0') goto yy994;
		if (yych <= '4') goto yy995;
		goto yy996;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy53;
			goto yy98;
		} else {
			if (yych == 'e') goto yy98;
			goto yy53;
		}
	}
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy997;
	goto yy53;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy997;
	goto yy53;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '4') goto yy53;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy999;
	if (yych <= '/') goto yy998;
	if (yych <= '7') goto yy1000;
yy998:
	YYDEBUG(998, *YYCURSOR);
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy999:
	YYDEBUG(999, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '8') goto yy53;
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1001, *YYCURSOR);
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1004;
	goto yy57;
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '6') goto yy1004;
	if (yych <= '9') goto yy51;
	goto yy57;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych >= ' ') goto yy57;
			} else {
				if (yych == 'D') goto yy57;
				if (yych >= 'F') goto yy57;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy57;
				if (yych >= 'M') goto yy57;
			} else {
				if (yych <= 'R') goto yy1005;
				if (yych <= 'T') goto yy57;
				if (yych >= 'W') goto yy57;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy57;
				if (yych >= 'd') goto yy57;
			} else {
				if (yych == 'f') goto yy57;
				if (yych >= 'h') goto yy57;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych >= 's') goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy57;
				} else {
					if (yych == 'y') goto yy57;
				}
			}
		}
	}
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1004;
	goto yy57;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1009;
	goto yy53;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1011;
	if (yych <= '2') goto yy1012;
	if (yych <= '3') goto yy1013;
	goto yy53;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1014;
	goto yy53;
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1014;
	goto yy53;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '2') goto yy53;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy53;
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1016;
	if (yych <= '2') goto yy1017;
	goto yy53;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1018;
	goto yy53;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '4') goto yy53;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1023;
	if (yych <= '6') goto yy1024;
	goto yy53;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy53;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	++YYCURSOR;
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych >= '1') goto yy1029;
	} else {
		if (yych <= '3') goto yy1030;
		if (yych <= '9') goto yy1004;
		goto yy57;
	}
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1005;
				goto yy57;
			} else {
				if (yych <= '/') goto yy1005;
				if (yych <= '9') goto yy1031;
				if (yych <= 'C') goto yy1005;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1005;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1005;
					if (yych <= 'T') goto yy57;
					goto yy1005;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1005;
				if (yych <= 'Y') goto yy57;
				goto yy1005;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1005;
				} else {
					if (yych == 'g') goto yy1005;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1005;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1005;
				}
			}
		}
	}
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1005;
				goto yy57;
			} else {
				if (yych <= '/') goto yy1005;
				if (yych <= '9') goto yy1031;
				if (yych <= 'C') goto yy1005;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1005;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1005;
					if (yych <= 'T') goto yy57;
					goto yy1005;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1005;
				if (yych <= 'Y') goto yy57;
				goto yy1005;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1005;
				} else {
					if (yych == 'g') goto yy1005;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1005;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1005;
				}
			}
		}
	}
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1005;
				goto yy57;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy1005;
				} else {
					if (yych <= '9') goto yy51;
					if (yych <= 'C') goto yy1005;
					goto yy57;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1005;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1005;
					if (yych <= 'T') goto yy57;
					goto yy1005;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1005;
				if (yych <= 'Y') goto yy57;
				goto yy1005;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1005;
				} else {
					if (yych == 'g') goto yy1005;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1005;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1005;
				}
			}
		}
	}
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy56;
				if (yych >= ' ') goto yy56;
			} else {
				if (yych == 'D') goto yy61;
				if (yych >= 'F') goto yy63;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy59;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy58;
				} else {
					if (yych <= 'T') goto yy1033;
					if (yych >= 'W') goto yy62;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy64;
				if (yych >= 'd') goto yy61;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy63;
				} else {
					if (yych == 'h') goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy59;
				if (yych <= 'r') goto yy1032;
				if (yych <= 's') goto yy58;
				goto yy1034;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy62;
				} else {
					if (yych == 'y') goto yy64;
				}
			}
		}
	}
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych <= '1') goto yy1048;
			goto yy1049;
		} else {
			if (yych <= '9') goto yy1050;
			if (yych <= 'G') goto yy53;
			goto yy66;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy67;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy66;
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych >= '2') goto yy1036;
		} else {
			if (yych <= '9') goto yy1037;
			if (yych <= 'G') goto yy53;
			goto yy66;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy67;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy66;
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1042;
	if (yych <= '9') goto yy1037;
	goto yy53;
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1042;
	if (yych <= '5') goto yy1038;
	goto yy53;
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1040;
	if (yych <= '6') goto yy1041;
	goto yy53;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1025;
	goto yy53;
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1043;
	if (yych <= '9') goto yy1039;
	goto yy53;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1044;
	if (yych <= '6') goto yy1045;
	if (yych <= '9') goto yy1039;
	goto yy53;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1046;
	if (yych <= '6') goto yy1047;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1046;
	if (yych <= '5') goto yy1040;
	if (yych <= '6') goto yy1041;
	goto yy53;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '9') goto yy1025;
	goto yy1026;
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1025;
	goto yy1026;
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1057;
	if (yych <= '9') goto yy1050;
	if (yych <= ':') goto yy1051;
	goto yy53;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '3') goto yy1057;
		goto yy1038;
	} else {
		if (yych == ':') goto yy1051;
		goto yy53;
	}
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1038;
	if (yych != ':') goto yy53;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1055;
	if (yych <= '6') goto yy1056;
	goto yy53;
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1025;
	goto yy53;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1043;
	if (yych <= '9') goto yy1039;
	if (yych <= ':') goto yy1051;
	goto yy53;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych <= '0') goto yy1060;
		goto yy1029;
	} else {
		if (yych <= '3') goto yy1030;
		if (yych <= '9') goto yy1004;
		goto yy57;
	}
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych <= '0') goto yy1028;
		goto yy1029;
	} else {
		if (yych <= '3') goto yy1030;
		if (yych <= '9') goto yy1004;
		goto yy57;
	}
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1031;
	goto yy57;
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1062;
	if (yych != 'c') goto yy53;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1063;
	if (yych != 'e') goto yy977;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1064;
	if (yych != 'm') goto yy53;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1065;
	if (yych != 'b') goto yy53;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1066;
	if (yych != 'e') goto yy53;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1067;
	if (yych != 'r') goto yy53;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy977;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1069;
	if (yych != 'v') goto yy53;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1070;
	if (yych != 'e') goto yy977;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1071;
	if (yych != 'm') goto yy53;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1072;
	if (yych != 'b') goto yy53;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1073;
	if (yych != 'e') goto yy53;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1067;
	if (yych == 'r') goto yy1067;
	goto yy53;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1075;
	if (yych != 't') goto yy53;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy1076;
	if (yych != 'o') goto yy977;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1077;
	if (yych != 'b') goto yy53;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1078;
	if (yych != 'e') goto yy53;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1067;
	if (yych == 'r') goto yy1067;
	goto yy53;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy125;
		if (yych <= 'O') goto yy53;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy125;
		} else {
			if (yych != 'p') goto yy53;
		}
	}
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1081;
	if (yych != 't') goto yy977;
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1082;
	if (yych != 'e') goto yy977;
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1083;
	if (yych != 'm') goto yy53;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1084;
	if (yych != 'b') goto yy53;
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1085;
	if (yych != 'e') goto yy53;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1067;
	if (yych == 'r') goto yy1067;
	goto yy53;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1090;
	if (yych == 'g') goto yy1090;
	goto yy53;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1088;
	if (yych != 'r') goto yy53;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy1089;
	if (yych != 'i') goto yy977;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1067;
	if (yych == 'l') goto yy1067;
	goto yy53;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1091;
	if (yych != 'u') goto yy977;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1092;
	if (yych != 's') goto yy53;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1067;
	if (yych == 't') goto yy1067;
	goto yy53;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1094;
		if (yych <= 'X') goto yy53;
		goto yy1067;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy1067;
			goto yy53;
		}
	}
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy1095;
	if (yych != 'c') goto yy977;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1067;
	if (yych == 'h') goto yy1067;
	goto yy53;
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1097;
	if (yych != 'b') goto yy53;
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy1098;
	if (yych != 'r') goto yy977;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1099;
	if (yych != 'u') goto yy53;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1100;
	if (yych != 'a') goto yy53;
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1101;
	if (yych != 'r') goto yy53;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1067;
	if (yych == 'y') goto yy1067;
	goto yy53;
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1109;
		if (yych <= 'M') goto yy53;
		goto yy1108;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy1109;
		} else {
			if (yych == 'n') goto yy1108;
			goto yy53;
		}
	}
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1104;
	if (yych != 'n') goto yy53;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1105;
	if (yych != 'u') goto yy977;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1106;
	if (yych != 'a') goto yy53;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1107;
	if (yych != 'r') goto yy53;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1067;
	if (yych == 'y') goto yy1067;
	goto yy53;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1067;
	if (yych == 'e') goto yy1067;
	goto yy977;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1067;
	if (yych == 'y') goto yy1067;
	goto yy977;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1067;
	goto yy977;
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy977;
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1067;
	goto yy977;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1067;
	goto yy977;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1129;
	if (yych <= '9') goto yy1128;
	goto yy53;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1127;
	goto yy53;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1125;
	if (yych <= '6') goto yy1124;
	goto yy53;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1096;
	if (yych == 'e') goto yy1096;
	goto yy53;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1093;
	if (yych == 'a') goto yy1093;
	goto yy53;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1123;
	if (yych == 'e') goto yy1123;
	goto yy53;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1061;
	if (yych == 'e') goto yy1061;
	goto yy53;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy1121;
	case 'A':
	case 'a':	goto yy983;
	case 'D':
	case 'd':	goto yy1120;
	case 'F':
	case 'f':	goto yy1117;
	case 'I':	goto yy976;
	case 'J':
	case 'j':	goto yy980;
	case 'M':
	case 'm':	goto yy1118;
	case 'N':
	case 'n':	goto yy986;
	case 'O':
	case 'o':	goto yy985;
	case 'S':
	case 's':	goto yy1119;
	case 'V':	goto yy978;
	case 'X':	goto yy979;
	default:	goto yy53;
	}
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1080;
	if (yych == 'p') goto yy1080;
	goto yy53;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '6') goto yy1126;
	goto yy53;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1005;
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1126;
	goto yy53;
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1126;
	goto yy53;
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy1126;
	goto yy53;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy1133;
	if (yych <= '9') goto yy1141;
	goto yy53;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy1133;
	if (yych <= '2') goto yy1141;
	goto yy53;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy53;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1134;
	if (yych <= '3') goto yy1135;
	if (yych <= '9') goto yy1136;
	goto yy53;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy658;
		if (yych <= '9') goto yy1136;
		if (yych <= 'm') goto yy658;
		goto yy1138;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy658;
			goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
			goto yy658;
		}
	}
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy658;
		if (yych <= '1') goto yy1136;
		if (yych <= 'm') goto yy658;
		goto yy1138;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy658;
			goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
			goto yy658;
		}
	}
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy1138;
		goto yy658;
	} else {
		if (yych <= 'r') goto yy1139;
		if (yych <= 's') goto yy1137;
		if (yych <= 't') goto yy1140;
		goto yy658;
	}
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy657;
	goto yy53;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy657;
	goto yy53;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy657;
	goto yy53;
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy657;
	goto yy53;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy53;
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych >= '1') goto yy1144;
	} else {
		if (yych <= '3') goto yy1145;
		if (yych <= '9') goto yy1136;
		goto yy53;
	}
	YYDEBUG(1143, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy658;
		if (yych <= '9') goto yy1146;
		if (yych <= 'm') goto yy658;
		goto yy1138;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy658;
			goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
			goto yy658;
		}
	}
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy658;
		if (yych <= '9') goto yy1146;
		if (yych <= 'm') goto yy658;
		goto yy1138;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy658;
			goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
			goto yy658;
		}
	}
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy658;
		if (yych <= '1') goto yy1146;
		if (yych <= 'm') goto yy658;
		goto yy1138;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy658;
			goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
			goto yy658;
		}
	}
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy657;
		if (yych <= 'm') goto yy658;
		goto yy1138;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy658;
			goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
			goto yy658;
		}
	}
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1224;
		if (yych <= 'T') goto yy53;
		goto yy1223;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy1224;
		} else {
			if (yych == 'u') goto yy1223;
			goto yy53;
		}
	}
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1221;
	if (yych == 'e') goto yy1221;
	goto yy53;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1218;
	if (yych == 'a') goto yy1218;
	goto yy53;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1215;
		if (yych <= 'T') goto yy53;
		goto yy1214;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy1215;
		} else {
			if (yych == 'u') goto yy1214;
			goto yy53;
		}
	}
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1211;
	if (yych == 'e') goto yy1211;
	goto yy53;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1209;
	if (yych == 'c') goto yy1209;
	goto yy53;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1207;
	if (yych == 'o') goto yy1207;
	goto yy53;
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1205;
	if (yych == 'e') goto yy1205;
	goto yy53;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy994;
	if (yych <= '4') goto yy995;
	if (yych <= '5') goto yy996;
	goto yy53;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1160;
	if (yych <= '/') goto yy1157;
	if (yych <= '9') goto yy1179;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	{
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1160;
	if (yych <= '/') goto yy1157;
	if (yych <= '2') goto yy1179;
	goto yy1157;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy1157;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1161;
	if (yych <= '3') goto yy1162;
	if (yych <= '9') goto yy1163;
	goto yy53;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy843;
			goto yy1163;
		} else {
			if (yych == 'T') goto yy1168;
			goto yy843;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1165;
			if (yych <= 'q') goto yy843;
			goto yy1166;
		} else {
			if (yych <= 's') goto yy1164;
			if (yych <= 't') goto yy1167;
			goto yy843;
		}
	}
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy843;
		} else {
			if (yych == 'T') goto yy1168;
			goto yy843;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1165;
			if (yych <= 'q') goto yy843;
			goto yy1166;
		} else {
			if (yych <= 's') goto yy1164;
			if (yych <= 't') goto yy1167;
			goto yy843;
		}
	}
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1168;
		if (yych <= 'm') goto yy843;
		goto yy1165;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy1166;
		} else {
			if (yych <= 's') goto yy1164;
			if (yych <= 't') goto yy1167;
			goto yy843;
		}
	}
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1178;
	goto yy53;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1178;
	goto yy53;
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1178;
	goto yy53;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1178;
	goto yy53;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1169;
	if (yych <= '2') goto yy1170;
	if (yych <= '9') goto yy1171;
	goto yy53;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1171;
	if (yych <= ':') goto yy1172;
	goto yy53;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1171;
	if (yych == ':') goto yy1172;
	goto yy53;
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1173;
	if (yych <= '9') goto yy1174;
	goto yy53;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1174;
	if (yych <= ':') goto yy1175;
	goto yy53;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1176;
	if (yych <= '6') goto yy1177;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '9') goto yy1025;
	goto yy1026;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1025;
	goto yy1026;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1168;
	goto yy843;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy1157;
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych >= '1') goto yy1182;
	} else {
		if (yych <= '3') goto yy1183;
		if (yych <= '9') goto yy1163;
		goto yy53;
	}
	YYDEBUG(1181, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy843;
			goto yy1184;
		} else {
			if (yych == 'T') goto yy1168;
			goto yy843;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1165;
			if (yych <= 'q') goto yy843;
			goto yy1166;
		} else {
			if (yych <= 's') goto yy1164;
			if (yych <= 't') goto yy1167;
			goto yy843;
		}
	}
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy843;
			goto yy1184;
		} else {
			if (yych == 'T') goto yy1168;
			goto yy843;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1165;
			if (yych <= 'q') goto yy843;
			goto yy1166;
		} else {
			if (yych <= 's') goto yy1164;
			if (yych <= 't') goto yy1167;
			goto yy843;
		}
	}
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy843;
		} else {
			if (yych == 'T') goto yy1168;
			goto yy843;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1165;
			if (yych <= 'q') goto yy843;
			goto yy1166;
		} else {
			if (yych <= 's') goto yy1164;
			if (yych <= 't') goto yy1167;
			goto yy843;
		}
	}
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1185;
		if (yych <= 'm') goto yy658;
		goto yy1165;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy658;
			goto yy1166;
		} else {
			if (yych <= 's') goto yy1164;
			if (yych <= 't') goto yy1167;
			goto yy658;
		}
	}
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1186;
	if (yych <= '2') goto yy1187;
	if (yych <= '9') goto yy1171;
	goto yy53;
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1188;
	if (yych <= ':') goto yy1172;
	goto yy53;
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1188;
	if (yych == ':') goto yy1172;
	goto yy53;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1190;
	if (yych <= '9') goto yy1174;
	goto yy53;
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1191;
	if (yych <= ':') goto yy1175;
	goto yy53;
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1193;
	if (yych <= '6') goto yy1194;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '9') goto yy1195;
	goto yy1026;
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1026;
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy1026;
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yyaccept = 24;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	YYDEBUG(1198, *YYCURSOR);
	if (yych <= ',') {
		if (yych != '+') goto yy1026;
	} else {
		if (yych <= '-') goto yy1199;
		if (yych <= '/') goto yy1026;
		if (yych <= '9') goto yy1197;
		goto yy1026;
	}
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1200;
	if (yych <= '2') goto yy1201;
	if (yych <= '9') goto yy1202;
	goto yy53;
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '9') goto yy1202;
	if (yych <= ':') goto yy1203;
	goto yy1026;
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1026;
		if (yych >= '4') goto yy1204;
	} else {
		if (yych <= '9') goto yy1025;
		if (yych <= ':') goto yy1203;
		goto yy1026;
	}
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '5') goto yy1204;
	if (yych <= '9') goto yy1025;
	if (yych >= ';') goto yy1026;
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '5') goto yy1204;
	if (yych <= '9') goto yy1025;
	goto yy1026;
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '9') goto yy1025;
	goto yy1026;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1206;
	if (yych != 'c') goto yy53;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'E') goto yy1063;
		if (yych == 'e') goto yy1063;
		goto yy977;
	}
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1208;
	if (yych != 'v') goto yy53;
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'E') goto yy1070;
		if (yych == 'e') goto yy1070;
		goto yy977;
	}
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1210;
	if (yych != 't') goto yy53;
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'O') goto yy1076;
		if (yych == 'o') goto yy1076;
		goto yy977;
	}
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1212;
	if (yych != 'p') goto yy53;
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'T') goto yy1213;
		if (yych != 't') goto yy977;
	}
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'E') goto yy1082;
		if (yych == 'e') goto yy1082;
		goto yy977;
	}
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1217;
	if (yych == 'g') goto yy1217;
	goto yy53;
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1216;
	if (yych != 'r') goto yy53;
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'I') goto yy1089;
		if (yych == 'i') goto yy1089;
		goto yy977;
	}
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'U') goto yy1091;
		if (yych == 'u') goto yy1091;
		goto yy977;
	}
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1219;
		if (yych <= 'X') goto yy53;
		goto yy1220;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy1220;
			goto yy53;
		}
	}
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'C') goto yy1095;
		if (yych == 'c') goto yy1095;
		goto yy977;
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy950;
	goto yy977;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1222;
	if (yych != 'b') goto yy53;
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'R') goto yy1098;
		if (yych == 'r') goto yy1098;
		goto yy977;
	}
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1227;
		if (yych <= 'M') goto yy53;
		goto yy1226;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy1227;
		} else {
			if (yych == 'n') goto yy1226;
			goto yy53;
		}
	}
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1225;
	if (yych != 'n') goto yy53;
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'U') goto yy1105;
		if (yych == 'u') goto yy1105;
		goto yy977;
	}
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'E') goto yy1067;
		if (yych == 'e') goto yy1067;
		goto yy977;
	}
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy950;
		goto yy977;
	} else {
		if (yych <= 'Y') goto yy1067;
		if (yych == 'y') goto yy1067;
		goto yy977;
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy765;
			goto yy914;
		} else {
			if (yych <= ',') goto yy765;
			if (yych <= '-') goto yy915;
			goto yy914;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy913;
			if (yych <= 'T') goto yy765;
			goto yy74;
		} else {
			if (yych == 'u') goto yy74;
			goto yy765;
		}
	}
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy125;
		if (yych <= 'O') goto yy53;
		goto yy773;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy125;
		} else {
			if (yych == 'p') goto yy773;
			goto yy53;
		}
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy1232;
			goto yy1234;
		} else {
			if (yych <= '-') goto yy1231;
			if (yych <= '.') goto yy914;
			if (yych <= '/') goto yy913;
			goto yy924;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy673;
			goto yy1234;
		} else {
			if (yych <= 'r') goto yy674;
			if (yych <= 's') goto yy667;
			if (yych <= 't') goto yy671;
			goto yy1234;
		}
	}
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy1235;
	case '1':	goto yy1236;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy804;
	case 'A':
	case 'a':	goto yy808;
	case 'D':
	case 'd':	goto yy812;
	case 'F':
	case 'f':	goto yy806;
	case 'J':
	case 'j':	goto yy805;
	case 'M':
	case 'm':	goto yy807;
	case 'N':
	case 'n':	goto yy811;
	case 'O':
	case 'o':	goto yy810;
	case 'S':
	case 's':	goto yy809;
	default:	goto yy765;
	}
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1234;
	if (yych <= '0') goto yy919;
	if (yych <= '1') goto yy920;
	if (yych <= '9') goto yy921;
	goto yy1234;
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1233;
	case '-':
	case '.':	goto yy764;
	case 'A':
	case 'a':	goto yy761;
	case 'D':
	case 'd':	goto yy669;
	case 'F':
	case 'f':	goto yy670;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy678;
	case 'J':
	case 'j':	goto yy682;
	case 'M':
	case 'm':	goto yy668;
	case 'N':
	case 'n':	goto yy685;
	case 'O':
	case 'o':	goto yy684;
	case 'S':
	case 's':	goto yy666;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy680;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy681;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy841;
		goto yy789;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy1237;
		goto yy53;
	}
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy841;
		goto yy789;
	} else {
		if (yych <= '/') goto yy53;
		if (yych >= '3') goto yy53;
	}
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '-') goto yy1238;
	if (yych <= '.') goto yy789;
	goto yy53;
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych >= '1') goto yy1240;
	} else {
		if (yych <= '3') goto yy1241;
		if (yych <= '9') goto yy845;
		goto yy53;
	}
	YYDEBUG(1239, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy843;
		if (yych <= '9') goto yy1242;
		if (yych <= 'm') goto yy843;
		goto yy847;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy843;
		}
	}
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy843;
		if (yych <= '9') goto yy1242;
		if (yych <= 'm') goto yy843;
		goto yy847;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy843;
		}
	}
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy843;
		} else {
			if (yych <= '9') goto yy791;
			if (yych <= 'm') goto yy843;
			goto yy847;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy843;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy843;
		}
	}
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy947;
		if (yych <= '9') goto yy792;
		if (yych <= 'm') goto yy947;
		goto yy847;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy947;
			goto yy848;
		} else {
			if (yych <= 's') goto yy846;
			if (yych <= 't') goto yy849;
			goto yy947;
		}
	}
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1232;
			if (yych <= ',') goto yy1234;
			goto yy1231;
		} else {
			if (yych <= '.') goto yy1244;
			if (yych <= '/') goto yy913;
			if (yych <= '5') goto yy1246;
			goto yy924;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1245;
			if (yych == 'n') goto yy673;
			goto yy1234;
		} else {
			if (yych <= 'r') goto yy674;
			if (yych <= 's') goto yy667;
			if (yych <= 't') goto yy671;
			goto yy1234;
		}
	}
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy765;
		if (yych <= '0') goto yy1268;
		goto yy1269;
	} else {
		if (yych <= '5') goto yy1270;
		if (yych <= '9') goto yy1271;
		goto yy765;
	}
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1263;
	if (yych <= '9') goto yy1264;
	goto yy53;
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy968;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(1247, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy974;
	case '-':	goto yy971;
	case '.':	goto yy975;
	case '/':	goto yy972;
	case '0':	goto yy1249;
	case '1':	goto yy1250;
	case '2':	goto yy1251;
	case '3':	goto yy1252;
	case '4':
	case '5':	goto yy1253;
	case '6':	goto yy1254;
	case '7':
	case '8':
	case '9':	goto yy51;
	case ':':	goto yy990;
	case 'W':	goto yy993;
	default:	goto yy1248;
	}
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy1261;
	if (yych <= '9') goto yy1262;
	goto yy57;
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy1260;
	if (yych <= '9') goto yy1259;
	goto yy57;
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1259;
	goto yy57;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy1257;
	if (yych <= '6') goto yy1258;
	if (yych <= '9') goto yy1255;
	goto yy57;
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1255;
	goto yy57;
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy1255;
	if (yych <= '9') goto yy51;
	goto yy57;
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych >= ' ') goto yy57;
			} else {
				if (yych == 'D') goto yy57;
				if (yych >= 'F') goto yy57;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy57;
				if (yych >= 'M') goto yy57;
			} else {
				if (yych <= 'R') goto yy1256;
				if (yych <= 'T') goto yy57;
				if (yych >= 'W') goto yy57;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy57;
				if (yych >= 'd') goto yy57;
			} else {
				if (yych == 'f') goto yy57;
				if (yych >= 'h') goto yy57;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych >= 's') goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy57;
				} else {
					if (yych == 'y') goto yy57;
				}
			}
		}
	}
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1256;
				goto yy57;
			} else {
				if (yych <= '/') goto yy1256;
				if (yych <= '9') goto yy1004;
				if (yych <= 'C') goto yy1256;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1256;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1256;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1256;
					if (yych <= 'T') goto yy57;
					goto yy1256;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1256;
				if (yych <= 'Y') goto yy57;
				goto yy1256;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1256;
				} else {
					if (yych == 'g') goto yy1256;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1256;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1256;
				}
			}
		}
	}
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1256;
				goto yy57;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1256;
					goto yy1004;
				} else {
					if (yych <= '9') goto yy51;
					if (yych <= 'C') goto yy1256;
					goto yy57;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1256;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1256;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1256;
					if (yych <= 'T') goto yy57;
					goto yy1256;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1256;
				if (yych <= 'Y') goto yy57;
				goto yy1256;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1256;
				} else {
					if (yych == 'g') goto yy1256;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1256;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1256;
				}
			}
		}
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1256;
				goto yy57;
			} else {
				if (yych <= '/') goto yy1256;
				if (yych <= '9') goto yy1004;
				if (yych <= 'C') goto yy1256;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1256;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1256;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1256;
					if (yych <= 'T') goto yy57;
					goto yy1256;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1256;
				if (yych <= 'Y') goto yy57;
				goto yy1256;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1256;
				} else {
					if (yych == 'g') goto yy1256;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1256;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1256;
				}
			}
		}
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1256;
				goto yy57;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1256;
					goto yy1028;
				} else {
					if (yych <= '2') goto yy1029;
					if (yych <= '3') goto yy1030;
					goto yy1004;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'F') goto yy57;
					goto yy1256;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy1256;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy1256;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy1256;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy1256;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy1256;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy1256;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1256;
				}
			}
		}
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1256;
				goto yy57;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1256;
					goto yy1060;
				} else {
					if (yych <= '2') goto yy1029;
					if (yych <= '3') goto yy1030;
					goto yy1004;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'F') goto yy57;
					goto yy1256;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy1256;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy1256;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy1256;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy1256;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy1256;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy1256;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1256;
				}
			}
		}
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1256;
				goto yy57;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1256;
					goto yy1028;
				} else {
					if (yych <= '2') goto yy1029;
					if (yych <= '3') goto yy1030;
					goto yy1004;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'F') goto yy57;
					goto yy1256;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy1256;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy1256;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy1256;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy1256;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy1256;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy1256;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1256;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1256;
				}
			}
		}
	}
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1265;
		goto yy694;
	} else {
		if (yych <= '9') goto yy1264;
		if (yych <= ':') goto yy1265;
		goto yy694;
	}
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1265;
	if (yych != ':') goto yy694;
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1266;
	if (yych <= '6') goto yy1267;
	if (yych <= '9') goto yy699;
	goto yy53;
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy700;
	if (yych <= '/') goto yy694;
	if (yych <= '9') goto yy699;
	goto yy694;
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy700;
	if (yych == '0') goto yy699;
	goto yy694;
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy694;
		if (yych <= '-') goto yy789;
		goto yy1272;
	} else {
		if (yych <= '/') goto yy694;
		if (yych <= '9') goto yy1271;
		if (yych <= ':') goto yy1265;
		goto yy694;
	}
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy694;
		if (yych <= '-') goto yy789;
		if (yych <= '.') goto yy1272;
		goto yy694;
	} else {
		if (yych <= '2') goto yy1271;
		if (yych <= '9') goto yy1264;
		if (yych <= ':') goto yy1265;
		goto yy694;
	}
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy694;
		if (yych <= '-') goto yy789;
		goto yy1272;
	} else {
		if (yych <= '/') goto yy694;
		if (yych <= '9') goto yy1264;
		if (yych <= ':') goto yy1265;
		goto yy694;
	}
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy694;
		if (yych <= '-') goto yy789;
	} else {
		if (yych == ':') goto yy1265;
		goto yy694;
	}
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1273;
	if (yych <= '6') goto yy1274;
	if (yych <= '9') goto yy797;
	goto yy53;
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy700;
	if (yych <= '/') goto yy694;
	if (yych <= '9') goto yy1275;
	goto yy694;
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy700;
		goto yy694;
	} else {
		if (yych <= '0') goto yy1275;
		if (yych <= '9') goto yy798;
		goto yy694;
	}
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy700;
	if (yych <= '/') goto yy694;
	if (yych <= '9') goto yy792;
	goto yy694;
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy663;
			if (yych <= ',') goto yy665;
			goto yy1231;
		} else {
			if (yych <= '.') goto yy677;
			if (yych <= '/') goto yy675;
			if (yych <= '5') goto yy1246;
			goto yy924;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy686;
			if (yych == 'n') goto yy673;
			goto yy665;
		} else {
			if (yych <= 'r') goto yy674;
			if (yych <= 's') goto yy667;
			if (yych <= 't') goto yy671;
			goto yy665;
		}
	}
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1232;
			if (yych <= ',') goto yy1234;
			goto yy1231;
		} else {
			if (yych <= '.') goto yy1244;
			if (yych <= '/') goto yy675;
			if (yych <= '5') goto yy1246;
			goto yy924;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1245;
			if (yych == 'n') goto yy673;
			goto yy1234;
		} else {
			if (yych <= 'r') goto yy674;
			if (yych <= 's') goto yy667;
			if (yych <= 't') goto yy671;
			goto yy1234;
		}
	}
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1280, *YYCURSOR);
	if (yych <= '/') goto yy1281;
	if (yych <= '9') goto yy1279;
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
			goto yy1322;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'n') goto yy1322;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1316;
			if (yych <= 'T') goto yy138;
			goto yy1315;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy138;
			goto yy1316;
		} else {
			if (yych == 'u') goto yy1315;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1304;
			if (yych <= 'L') goto yy138;
			goto yy1305;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy138;
			goto yy1304;
		} else {
			if (yych == 'm') goto yy1305;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
			goto yy1300;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'e') goto yy1300;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
			goto yy1296;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'e') goto yy1296;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1245;
		goto yy53;
	} else {
		if (yych <= '9') goto yy1290;
		if (yych <= ':') goto yy1245;
		goto yy53;
	}
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1245;
		goto yy53;
	} else {
		if (yych <= '3') goto yy1290;
		if (yych == ':') goto yy1245;
		goto yy53;
	}
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1245;
	if (yych == ':') goto yy1245;
	goto yy53;
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1245;
		goto yy53;
	} else {
		if (yych <= '5') goto yy1291;
		if (yych == ':') goto yy1245;
		goto yy53;
	}
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(1292, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1248;
	if (yych <= '5') goto yy1293;
	if (yych <= '6') goto yy1294;
	goto yy1248;
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1295;
	goto yy53;
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy53;
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1256;
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy139;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'l') goto yy1297;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy140;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'f') goto yy1298;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy1299;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy160;
		if (yych == 'h') goto yy160;
		goto yy3;
	}
yy1300:
	YYDEBUG(1300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy276;
			goto yy136;
		} else {
			if (yych <= '@') goto yy276;
			if (yych <= 'R') goto yy139;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy276;
			goto yy139;
		} else {
			if (yych <= 's') goto yy1301;
			if (yych <= 'z') goto yy139;
			goto yy276;
		}
	}
yy1301:
	YYDEBUG(1301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy140;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'd') goto yy1302;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1302:
	YYDEBUG(1302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1303;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy282;
		if (yych == 'y') goto yy282;
		goto yy3;
	}
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
		goto yy1312;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1312;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy139;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'o') goto yy1306;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'r') goto yy1307;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'r') goto yy1308;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1309;
		if (yych != 'o') goto yy3;
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1310;
	if (yych != 'w') goto yy53;
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	++YYCURSOR;
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy140;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'y') goto yy1313;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy136;
	} else {
		if (yych <= 'Z') goto yy141;
		if (yych <= '`') goto yy1314;
		if (yych <= 'z') goto yy141;
	}
yy1314:
	YYDEBUG(1314, *YYCURSOR);
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy276;
			goto yy136;
		} else {
			if (yych <= '@') goto yy276;
			if (yych <= 'Q') goto yy139;
			goto yy1318;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy276;
			goto yy139;
		} else {
			if (yych <= 'r') goto yy1318;
			if (yych <= 'z') goto yy139;
			goto yy276;
		}
	}
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy139;
			if (yych >= 'S') goto yy250;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'r') goto yy1317;
			if (yych <= 's') goto yy250;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1317:
	YYDEBUG(1317, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'd') goto yy263;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy140;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 's') goto yy1319;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy1320;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1321;
		if (yych != 'a') goto yy3;
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy282;
	if (yych == 'y') goto yy282;
	goto yy53;
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy1323;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'h') goto yy263;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
			goto yy1322;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'n') goto yy1353;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy136;
			if (yych <= '.') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy138;
			} else {
				if (yych <= 'I') goto yy1316;
				if (yych <= 'T') goto yy138;
				goto yy1315;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy138;
				goto yy3;
			} else {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy3;
				goto yy143;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'i') goto yy1347;
				goto yy143;
			} else {
				if (yych <= 'u') goto yy1346;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '/') {
			if (yych == ')') goto yy136;
			if (yych <= '.') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				goto yy138;
			} else {
				if (yych <= 'D') goto yy1304;
				if (yych <= 'L') goto yy138;
				goto yy1305;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy138;
				goto yy3;
			} else {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy3;
				goto yy143;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'd') goto yy1337;
				goto yy143;
			} else {
				if (yych <= 'm') goto yy1338;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
			goto yy1300;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1333;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
			goto yy1296;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1329;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1329:
	YYDEBUG(1329, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy139;
			goto yy1297;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'l') goto yy1330;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy140;
			goto yy1298;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'f') goto yy1331;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
			goto yy1299;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy1332;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'G') goto yy3;
			goto yy160;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy247;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1333:
	YYDEBUG(1333, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy276;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy276;
			if (yych <= 'R') goto yy139;
			goto yy1301;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy276;
		} else {
			if (yych == 's') goto yy1334;
			if (yych <= 'z') goto yy148;
			goto yy276;
		}
	}
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy140;
			goto yy1302;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1335;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy1303;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1336;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'X') goto yy3;
			goto yy282;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'y') goto yy295;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy1312;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1344;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy139;
			goto yy1306;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1339;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy1339:
	YYDEBUG(1339, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
			goto yy1307;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1340;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
			goto yy1308;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1341;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1341:
	YYDEBUG(1341, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'N') goto yy3;
			goto yy1309;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1342;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1310;
	if (yych != 'w') goto yy152;
	YYDEBUG(1343, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy144;
		goto yy1311;
	} else {
		if (yych <= '_') goto yy144;
		if (yych <= '`') goto yy1311;
		if (yych <= 'z') goto yy151;
		goto yy1311;
	}
yy1344:
	YYDEBUG(1344, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy140;
			goto yy1313;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'y') goto yy1345;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1345:
	YYDEBUG(1345, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy1314;
			goto yy136;
		} else {
			if (yych == '/') goto yy144;
			goto yy1314;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy1314;
			goto yy144;
		} else {
			if (yych <= '`') goto yy1314;
			if (yych <= 'z') goto yy150;
			goto yy1314;
		}
	}
yy1346:
	YYDEBUG(1346, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy276;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy276;
			if (yych <= 'Q') goto yy139;
			goto yy1318;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy276;
		} else {
			if (yych == 'r') goto yy1349;
			if (yych <= 'z') goto yy148;
			goto yy276;
		}
	}
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '/') {
			if (yych == ')') goto yy136;
			if (yych <= '.') goto yy3;
			goto yy144;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy139;
			if (yych <= 'R') goto yy1317;
			goto yy250;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy148;
			} else {
				if (yych <= 's') goto yy253;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
	YYDEBUG(1348, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'd') goto yy273;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy140;
			goto yy1319;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 's') goto yy1350;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1350:
	YYDEBUG(1350, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
			goto yy1320;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1351;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy1321;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1352;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy282;
	if (yych == 'y') goto yy295;
	goto yy152;
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
			goto yy1323;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy1354;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy1354:
	YYDEBUG(1354, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy273;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1367;
			if (yych <= 'X') goto yy138;
			goto yy1368;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy138;
			goto yy1367;
		} else {
			if (yych == 'y') goto yy1368;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1356:
	YYDEBUG(1356, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy138;
			goto yy1361;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'd') goto yy1361;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'n') goto yy1358;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1358:
	YYDEBUG(1358, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy276;
			goto yy136;
		} else {
			if (yych <= '@') goto yy276;
			if (yych <= 'C') goto yy139;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy276;
			goto yy139;
		} else {
			if (yych <= 'd') goto yy1359;
			if (yych <= 'z') goto yy139;
			goto yy276;
		}
	}
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1360;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy141;
			goto yy501;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'y') goto yy501;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy139;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'n') goto yy1362;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy140;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'i') goto yy1363;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy141;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'g') goto yy1364;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1364:
	YYDEBUG(1364, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1365;
		if (yych != 'h') goto yy3;
	}
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1366;
	if (yych != 't') goto yy53;
yy1366:
	YYDEBUG(1366, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1314;
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy303;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
				goto yy303;
			} else {
				if (yych == 'C') goto yy1369;
				goto yy139;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'c') goto yy1369;
				if (yych <= 'z') goto yy139;
				goto yy303;
			}
		}
	}
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy305;
			if (yych <= 0x1F) goto yy303;
			goto yy305;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy303;
			goto yy306;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy303;
			if (yych <= '9') goto yy305;
			goto yy303;
		} else {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy303;
			if (yych <= 'z') goto yy139;
			goto yy303;
		}
	}
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy559;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'h') goto yy559;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '/') {
			if (yych == ')') goto yy136;
			if (yych <= '.') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy3;
				goto yy138;
			} else {
				if (yych <= 'R') goto yy1367;
				if (yych <= 'X') goto yy138;
				goto yy1368;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy138;
				goto yy3;
			} else {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy3;
				goto yy143;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'r') goto yy1382;
				goto yy143;
			} else {
				if (yych <= 'y') goto yy1383;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1371:
	YYDEBUG(1371, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy138;
			goto yy1361;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1376;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
			goto yy1358;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'n') goto yy1373;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1373:
	YYDEBUG(1373, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy276;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy276;
			if (yych <= 'C') goto yy139;
			goto yy1359;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy276;
		} else {
			if (yych == 'd') goto yy1374;
			if (yych <= 'z') goto yy148;
			goto yy276;
		}
	}
yy1374:
	YYDEBUG(1374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy1360;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1375;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1375:
	YYDEBUG(1375, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy141;
			goto yy501;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'y') goto yy530;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1376:
	YYDEBUG(1376, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy139;
			goto yy1362;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'n') goto yy1377;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy1377:
	YYDEBUG(1377, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy140;
			goto yy1363;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'i') goto yy1378;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1378:
	YYDEBUG(1378, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy141;
			goto yy1364;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'g') goto yy1379;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1379:
	YYDEBUG(1379, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'G') goto yy3;
			goto yy1365;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1380;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1380:
	YYDEBUG(1380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1366;
	if (yych != 't') goto yy152;
	YYDEBUG(1381, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy144;
		goto yy1314;
	} else {
		if (yych <= '_') goto yy144;
		if (yych <= '`') goto yy1314;
		if (yych <= 'z') goto yy151;
		goto yy1314;
	}
yy1382:
	YYDEBUG(1382, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'C') goto yy1369;
				if (yych <= 'Z') goto yy139;
				goto yy303;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy148;
			} else {
				if (yych <= 'c') goto yy1384;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy1383:
	YYDEBUG(1383, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy305;
			if (yych <= 0x1F) goto yy303;
			goto yy305;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy303;
				goto yy136;
			} else {
				if (yych <= ',') goto yy303;
				if (yych <= '-') goto yy306;
				goto yy305;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy144;
			if (yych <= '9') goto yy305;
			if (yych <= '@') goto yy303;
			goto yy139;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy303;
				goto yy144;
			} else {
				if (yych <= '`') goto yy303;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy1384:
	YYDEBUG(1384, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy559;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy570;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1385:
	YYDEBUG(1385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'O') goto yy1393;
			if (yych <= 'U') goto yy138;
			if (yych <= 'V') goto yy1394;
			goto yy1391;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy138;
			goto yy1393;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy138;
				goto yy1394;
			} else {
				if (yych <= 'w') goto yy1391;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy1386:
	YYDEBUG(1386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy138;
			goto yy1390;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'x') goto yy1390;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1387:
	YYDEBUG(1387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'n') goto yy1388;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1388:
	YYDEBUG(1388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy1389;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1389:
	YYDEBUG(1389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'h') goto yy263;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1390:
	YYDEBUG(1390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
			goto yy250;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy250;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1391:
	YYDEBUG(1391, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy136;
	} else {
		if (yych <= 'Z') goto yy139;
		if (yych <= '`') goto yy1392;
		if (yych <= 'z') goto yy139;
	}
yy1392:
	YYDEBUG(1392, *YYCURSOR);
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1393:
	YYDEBUG(1393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy139;
			goto yy1399;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'n') goto yy1399;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1394:
	YYDEBUG(1394, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy303;
			} else {
				if (yych <= '-') goto yy306;
				if (yych <= '.') goto yy305;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy305;
				goto yy303;
			} else {
				if (yych != 'E') goto yy139;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'e') goto yy1395;
				if (yych <= 'z') goto yy139;
				goto yy303;
			}
		}
	}
yy1395:
	YYDEBUG(1395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy140;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'm') goto yy1396;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1396:
	YYDEBUG(1396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy141;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'b') goto yy1397;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1397:
	YYDEBUG(1397, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1398;
		if (yych != 'e') goto yy3;
	}
yy1398:
	YYDEBUG(1398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy315;
	if (yych == 'r') goto yy315;
	goto yy53;
yy1399:
	YYDEBUG(1399, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy136;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy1400;
		if (yych <= 'z') goto yy140;
	}
yy1400:
	YYDEBUG(1400, *YYCURSOR);
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1401:
	YYDEBUG(1401, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych == '/') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'N') goto yy138;
				goto yy1393;
			} else {
				if (yych <= 'U') goto yy138;
				if (yych <= 'V') goto yy1394;
				goto yy1391;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy138;
				goto yy3;
			} else {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy3;
				goto yy143;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1408;
				if (yych <= 'u') goto yy143;
				goto yy1409;
			} else {
				if (yych <= 'w') goto yy1407;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1402:
	YYDEBUG(1402, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy138;
			goto yy1390;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'x') goto yy1406;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1403:
	YYDEBUG(1403, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
			goto yy1388;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'n') goto yy1404;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1404:
	YYDEBUG(1404, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
			goto yy1389;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy1405;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy1405:
	YYDEBUG(1405, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy263;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy273;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1406:
	YYDEBUG(1406, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
			goto yy250;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy253;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy1407:
	YYDEBUG(1407, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy1392;
			goto yy136;
		} else {
			if (yych == '/') goto yy144;
			goto yy1392;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy1392;
			goto yy144;
		} else {
			if (yych <= '`') goto yy1392;
			if (yych <= 'z') goto yy148;
			goto yy1392;
		}
	}
yy1408:
	YYDEBUG(1408, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy139;
			goto yy1399;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'n') goto yy1414;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy1409:
	YYDEBUG(1409, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy303;
				goto yy305;
			} else {
				if (yych == ' ') goto yy305;
				goto yy303;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy303;
				goto yy306;
			} else {
				if (yych == '/') goto yy144;
				goto yy305;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy303;
				goto yy139;
			} else {
				if (yych <= 'E') goto yy1395;
				if (yych <= 'Z') goto yy139;
				goto yy303;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy303;
				goto yy148;
			} else {
				if (yych <= 'e') goto yy1410;
				if (yych <= 'z') goto yy148;
				goto yy303;
			}
		}
	}
yy1410:
	YYDEBUG(1410, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy140;
			goto yy1396;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'm') goto yy1411;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1411:
	YYDEBUG(1411, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy141;
			goto yy1397;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'b') goto yy1412;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1412:
	YYDEBUG(1412, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'D') goto yy3;
			goto yy1398;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1413;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1413:
	YYDEBUG(1413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy315;
	if (yych == 'r') goto yy483;
	goto yy152;
yy1414:
	YYDEBUG(1414, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy1400;
			goto yy136;
		} else {
			if (yych == '/') goto yy144;
			goto yy1400;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy1400;
			goto yy144;
		} else {
			if (yych <= '`') goto yy1400;
			if (yych <= 'z') goto yy149;
			goto yy1400;
		}
	}
yy1415:
	YYDEBUG(1415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy138;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 's') goto yy1416;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1416:
	YYDEBUG(1416, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy1417;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1417:
	YYDEBUG(1417, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy1418;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1418:
	YYDEBUG(1418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'r') goto yy1419;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1419:
	YYDEBUG(1419, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1420;
		if (yych != 'd') goto yy3;
	}
yy1420:
	YYDEBUG(1420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1421;
	if (yych != 'a') goto yy53;
yy1421:
	YYDEBUG(1421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1422;
	if (yych != 'y') goto yy53;
yy1422:
	YYDEBUG(1422, *YYCURSOR);
	++YYCURSOR;
yy1423:
	YYDEBUG(1423, *YYCURSOR);
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1424:
	YYDEBUG(1424, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy138;
			goto yy1416;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy138;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 's') goto yy1425;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1425:
	YYDEBUG(1425, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
			goto yy1417;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy1426;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy1426:
	YYDEBUG(1426, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy1418;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1427;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1427:
	YYDEBUG(1427, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
			goto yy1419;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1428;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1428:
	YYDEBUG(1428, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'C') goto yy3;
			goto yy1420;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1429;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1429:
	YYDEBUG(1429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1421;
	if (yych != 'a') goto yy152;
	YYDEBUG(1430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1422;
	if (yych != 'y') goto yy152;
	YYDEBUG(1431, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy144;
		goto yy1423;
	} else {
		if (yych <= '_') goto yy144;
		if (yych <= '`') goto yy1423;
		if (yych <= 'z') goto yy151;
		goto yy1423;
	}
}

}

#define YYMAXFILL 29

timelib_time* timelib_strtotime(char *s, int len, struct timelib_error_container **errors, const timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->f == TIMELIB_UNSET) parsed->f = now->f != TIMELIB_UNSET ? now->f : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
