%feature("docstring") OT::ProcessEvent
"Event defined from a process and a domain.

The event occurs when the process enters the specified domain.

Parameters
----------
process : :class:`~openturns.Process`
    Process.
domain : :class:`~openturns.Domain`
    Domain, of same dimension.

See also
--------
DomainEvent, ThresholdEvent

Examples
--------
>>> import openturns as ot
>>> dim = 2
>>> dist = ot.Normal(dim)
>>> X = ot.WhiteNoise(dist)
>>> domain = ot.Interval(dim)
>>> event = ot.ProcessEvent(X, domain)"
