/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.waveform;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JButton;

public class DragButton
extends JButton
implements DragGestureListener,
DragSourceListener {
    private DragSource dragSource;
    private int panelNumber;
    private static Font textFont = null;

    public DragButton(String s, int panelNumber) {
        super(s);
        if (textFont == null) {
            textFont = new Font(this.getFont().getFamily(), 0, 20);
        }
        this.setFont(textFont);
        this.panelNumber = panelNumber;
        this.setBorderPainted(false);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Cursor style = DragSource.DefaultMoveDrop;
        String command = "MOVEBUTTON";
        if ((e.getTriggerEvent().getModifiersEx() & 0x40) != 0) {
            style = DragSource.DefaultCopyDrop;
        }
        command = "COPYBUTTON";
        StringSelection transferable = new StringSelection("PANEL " + this.panelNumber + " " + command + " " + this.getText());
        this.dragSource.startDrag(e, style, transferable, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }
}

