/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.GDSLayers;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.util.math.DBMath;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Xml {
    public static final double DEFAULT_LE_GATECAP = 0.4;
    public static final double DEFAULT_LE_WIRERATIO = 0.16;
    public static final double DEFAULT_LE_DIFFALPHA = 0.7;
    private static final Map<String, XmlKeyword> xmlKeywords = new HashMap<String, XmlKeyword>();
    private static Schema schema;

    private Xml() {
    }

    private static synchronized void loadTechnologySchema() throws SAXException, IOException {
        if (schema != null) {
            return;
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL technologySchemaUrl = Technology.class.getResource("Technology.xsd");
        if (technologySchemaUrl != null) {
            schema = schemaFactory.newSchema(new StreamSource(technologySchemaUrl.openStream()));
        } else {
            System.err.println("Schema file Technology.xsd, working without XML schema");
            System.out.println("Schema file Technology.xsd, working without XML schema");
        }
    }

    public static Technology parseTechnology(URL fileURL) {
        return Xml.parseTechnology(fileURL, true);
    }

    public static Technology parseTechnology(URL fileURL, boolean checkSchema) {
        block7: {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                if (schema == null) {
                    Xml.loadTechnologySchema();
                }
                if (checkSchema) {
                    factory.setSchema(schema);
                }
                long startTime = System.currentTimeMillis();
                SAXParser parser = factory.newSAXParser();
                URLConnection urlCon = fileURL.openConnection();
                InputStream inputStream = urlCon.getInputStream();
                XMLReader handler = new XMLReader();
                parser.parse(inputStream, (DefaultHandler)handler);
                if (Job.getDebug()) {
                    long stopTime = System.currentTimeMillis();
                    System.out.println("Loading technology " + fileURL + " ... " + (stopTime - startTime) + " msec");
                }
                return handler.tech;
            }
            catch (SAXParseException e) {
                String msg = "Error parsing Xml technology:\n" + e.getMessage() + "\n" + " Line " + e.getLineNumber() + " column " + e.getColumnNumber() + " of " + fileURL;
                msg = msg.replaceAll("\"http://electric.sun.com/Technology\":", "");
                System.out.println(msg);
                Job.getUserInterface().showErrorMessage(msg, "Error parsing Xml technology");
            }
            catch (Exception e) {
                String msg = "ERROR: XML technology " + fileURL + " failed to load: " + e.getMessage();
                System.out.println(msg);
                Job.getUserInterface().showErrorMessage(msg, "Error loading Xml technology");
            }
            catch (Error a) {
                String msg = "Assertion while loading Xml technology " + fileURL;
                System.out.println(msg);
                if (!Job.getDebug()) break block7;
                a.printStackTrace();
            }
        }
        return null;
    }

    public static MenuPalette parseComponentMenuXMLTechEdit(String xml, List<PrimitiveNodeGroup> nodeGroups, List<ArcProto> arcs, List<PrimitiveNode> pureLayerNodes) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            SAXParser parser = factory.newSAXParser();
            InputSource is = new InputSource(new StringReader(xml));
            XMLReader handler = new XMLReader(nodeGroups, arcs, pureLayerNodes);
            parser.parse(is, (DefaultHandler)handler);
            return ((XMLReader)handler).tech.menuPalette;
        }
        catch (Exception e) {
            System.out.println("Error parsing XML component menu data");
            e.printStackTrace();
            return null;
        }
    }

    static {
        for (XmlKeyword k : (XmlKeyword[])XmlKeyword.class.getEnumConstants()) {
            xmlKeywords.put(k.name(), k);
        }
        schema = null;
    }

    private static class OneLineWriter
    extends Writer {
        private OneLineWriter(PrintWriter out) {
            super(out);
        }

        @Override
        protected void p(String s2) {
            for (int i = 0; i < s2.length(); ++i) {
                this.out.print(s2.charAt(i));
            }
        }

        @Override
        protected void checkIndent() {
            this.indentEmitted = true;
        }

        @Override
        protected void l() {
            this.indentEmitted = false;
        }
    }

    private static class Writer {
        private static final int INDENT_WIDTH = 4;
        protected final PrintWriter out;
        private int indent;
        protected boolean indentEmitted;

        private Writer(PrintWriter out) {
            this.out = out;
        }

        private void writeTechnology(Technology t, boolean includeDateAndVersion, String copyrightMessage, Map<Object, Map<String, Object>> additionalAttributes) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            this.header();
            this.pl("");
            this.out.println("<!--");
            this.pl(" *");
            if (includeDateAndVersion) {
                this.pl(" * Electric(tm) VLSI Design System, version " + com.sun.electric.database.text.Version.getVersion());
            } else {
                this.pl(" * Electric(tm) VLSI Design System");
            }
            this.pl(" *");
            this.pl(" * File: " + t.techName + ".xml");
            this.pl(" * " + t.techName + " technology description");
            this.pl(" * Generated automatically from a library");
            this.pl(" *");
            if (copyrightMessage != null) {
                int start = 0;
                while (start < copyrightMessage.length()) {
                    int endPos = copyrightMessage.indexOf(10, start);
                    if (endPos < 0) {
                        endPos = copyrightMessage.length();
                    }
                    String oneLine = copyrightMessage.substring(start, endPos);
                    this.pl(" * " + oneLine);
                    start = endPos + 1;
                }
            }
            this.out.println("-->");
            this.l();
            this.b(XmlKeyword.technology);
            this.a("name", t.techName);
            this.a("class", t.className);
            this.l();
            this.a("xmlns", "http://electric.sun.com/Technology");
            this.l();
            this.a("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.l();
            this.a("xsi:schemaLocation", "http://electric.sun.com/Technology ../../technology/Technology.xsd");
            this.cl();
            this.l();
            this.bcpel(XmlKeyword.shortName, t.shortTechName);
            this.bcpel(XmlKeyword.description, t.description);
            for (Version version : t.versions) {
                this.b(XmlKeyword.version);
                this.a("tech", version.techVersion);
                this.a("electric", version.electricVersion);
                this.el();
            }
            this.b(XmlKeyword.numMetals);
            this.a("min", t.minNumMetals);
            this.a("max", t.maxNumMetals);
            this.a("default", t.defaultNumMetals);
            this.el();
            this.b(XmlKeyword.scale);
            this.a("value", t.scaleValue);
            this.a("relevant", t.scaleRelevant);
            this.el();
            this.b(XmlKeyword.resolution);
            this.a("value", t.resolutionValue);
            this.el();
            this.b(XmlKeyword.defaultFoundry);
            this.a("value", t.defaultFoundry);
            this.el();
            this.b(XmlKeyword.minResistance);
            this.a("value", t.minResistance);
            this.el();
            this.b(XmlKeyword.minCapacitance);
            this.a("value", t.minCapacitance);
            this.el();
            if (t.leGateCapacitance != 0.4 || t.leWireRatio != 0.16 || t.leDiffAlpha != 0.7) {
                this.b(XmlKeyword.logicalEffort);
                this.a("gateCapacitance", t.leGateCapacitance);
                this.a("wireRatio", t.leWireRatio);
                this.a("diffAlpha", t.leDiffAlpha);
                this.el();
            }
            this.l();
            if (t.transparentLayers.size() != 0) {
                this.comment("Transparent layers");
                for (int i = 0; i < t.transparentLayers.size(); ++i) {
                    Color color = t.transparentLayers.get(i);
                    this.b(XmlKeyword.transparentLayer);
                    this.a("transparent", i + 1);
                    this.cl();
                    this.bcpel(XmlKeyword.r, color.getRed());
                    this.bcpel(XmlKeyword.g, color.getGreen());
                    this.bcpel(XmlKeyword.b, color.getBlue());
                    this.el(XmlKeyword.transparentLayer);
                }
                this.l();
            }
            this.comment("**************************************** LAYERS ****************************************");
            for (Layer li : t.layers) {
                this.writeXml(li);
            }
            this.comment("******************** ARCS ********************");
            for (ArcProto ai : t.arcs) {
                this.writeXml(ai);
                this.l();
            }
            this.comment("******************** NODES ********************");
            for (PrimitiveNodeGroup nodeGroup : t.nodeGroups) {
                this.writeXml(nodeGroup, additionalAttributes);
                this.l();
            }
            for (SpiceHeader spiceHeader : t.spiceHeaders) {
                this.writeSpiceHeaderXml(spiceHeader);
            }
            this.writeMenuPaletteXml(t.menuPalette);
            for (Foundry foundry : t.foundries) {
                this.writeFoundryXml(foundry);
            }
            this.el(XmlKeyword.technology);
        }

        private void writeXml(Layer li) {
            EGraphics desc = li.desc;
            String funString = null;
            int funExtra = li.extraFunction;
            if (funExtra != 0) {
                int deplEnhMask = 768;
                if ((funExtra & 0x300) != 0) {
                    funString = Layer.Function.getExtraName(funExtra & 0x300);
                    if ((funExtra &= 0xFFFFFCFF) != 0) {
                        funString = funString + "_" + Layer.Function.getExtraName(funExtra);
                    }
                } else {
                    funString = Layer.Function.getExtraName(funExtra);
                }
            }
            this.b(XmlKeyword.layer);
            this.a("name", li.name);
            this.a("fun", li.function.name());
            this.a("extraFun", funString);
            this.cl();
            if (desc.getTransparentLayer() > 0) {
                this.b(XmlKeyword.transparentColor);
                this.a("transparent", desc.getTransparentLayer());
                this.el();
            } else {
                Color color = desc.getColor();
                this.b(XmlKeyword.opaqueColor);
                this.a("r", color.getRed());
                this.a("g", color.getGreen());
                this.a("b", color.getBlue());
                this.el();
            }
            this.bcpel(XmlKeyword.patternedOnDisplay, desc.isPatternedOnDisplay());
            this.bcpel(XmlKeyword.patternedOnPrinter, desc.isPatternedOnPrinter());
            int[] pattern = desc.getPattern();
            for (int j = 0; j < 16; ++j) {
                String p = "";
                for (int k = 0; k < 16; ++k) {
                    p = p + ((pattern[j] & 1 << 15 - k) != 0 ? (char)'X' : ' ');
                }
                this.bcpel(XmlKeyword.pattern, p);
            }
            if (li.desc.getOutlined() != null) {
                this.bcpel(XmlKeyword.outlined, desc.getOutlined().getConstName());
            }
            this.bcpel(XmlKeyword.opacity, desc.getOpacity());
            this.bcpel(XmlKeyword.foreground, desc.getForeground());
            this.b(XmlKeyword.display3D);
            this.a("thick", li.thick3D);
            this.a("height", li.height3D);
            this.a("mode", (Object)li.desc.getTransparencyMode());
            this.a("factor", li.desc.getTransparencyFactor());
            this.el();
            if (li.cif != null && li.cif.length() > 0) {
                this.b(XmlKeyword.cifLayer);
                this.a("cif", li.cif);
                this.el();
            }
            if (li.skill != null && li.skill.length() > 0) {
                this.b(XmlKeyword.skillLayer);
                this.a("skill", li.skill);
                this.el();
            }
            if (li.resistance != 0.0 || li.capacitance != 0.0 || li.edgeCapacitance != 0.0) {
                this.b(XmlKeyword.parasitics);
                this.a("resistance", li.resistance);
                this.a("capacitance", li.capacitance);
                this.a("edgeCapacitance", li.edgeCapacitance);
                this.el();
            }
            if (li.pureLayerNode != null) {
                String nodeName = li.pureLayerNode.name;
                Poly.Type style = li.pureLayerNode.style;
                String styleStr = style == Poly.Type.FILLED ? null : style.name();
                String portName = li.pureLayerNode.port;
                this.b(XmlKeyword.pureLayerNode);
                this.a("name", nodeName);
                this.a("style", styleStr);
                this.a("port", portName);
                this.cl();
                this.bcpel(XmlKeyword.oldName, li.pureLayerNode.oldName);
                this.bcpel(XmlKeyword.lambda, li.pureLayerNode.size.value);
                for (String portArc : li.pureLayerNode.portArcs) {
                    this.bcpel(XmlKeyword.portArc, portArc);
                }
                this.el(XmlKeyword.pureLayerNode);
            }
            this.el(XmlKeyword.layer);
            this.l();
        }

        private void writeXml(ArcProto ai) {
            this.b(XmlKeyword.arcProto);
            this.a("name", ai.name);
            this.a("fun", ai.function.getConstantName());
            this.cl();
            this.bcpel(XmlKeyword.oldName, ai.oldName);
            if (ai.wipable) {
                this.bel(XmlKeyword.wipable);
            }
            if (ai.curvable) {
                this.bel(XmlKeyword.curvable);
            }
            if (ai.special) {
                this.bel(XmlKeyword.special);
            }
            if (ai.notUsed) {
                this.bel(XmlKeyword.notUsed);
            }
            if (ai.skipSizeInPalette) {
                this.bel(XmlKeyword.skipSizeInPalette);
            }
            this.bcpel(XmlKeyword.extended, ai.extended);
            this.bcpel(XmlKeyword.fixedAngle, ai.fixedAngle);
            this.bcpel(XmlKeyword.angleIncrement, ai.angleIncrement);
            if (ai.antennaRatio != 0.0) {
                this.bcpel(XmlKeyword.antennaRatio, ai.antennaRatio);
            }
            for (Map.Entry<Integer, Double> e : ai.diskOffset.entrySet()) {
                this.b(XmlKeyword.diskOffset);
                this.a("untilVersion", e.getKey());
                this.a("width", e.getValue());
                this.el();
            }
            if (ai.defaultWidth.value != 0.0) {
                this.bcl(XmlKeyword.defaultWidth);
                this.bcpel(XmlKeyword.lambda, ai.defaultWidth.value);
                this.el(XmlKeyword.defaultWidth);
            }
            for (ArcLayer al : ai.arcLayers) {
                String style = al.style == Poly.Type.FILLED ? "FILLED" : "CLOSED";
                this.b(XmlKeyword.arcLayer);
                this.a("layer", al.layer);
                this.a("style", style);
                double extend = al.extend.value;
                if (extend == 0.0) {
                    this.el();
                    continue;
                }
                this.cl();
                this.bcpel(XmlKeyword.lambda, extend);
                this.el(XmlKeyword.arcLayer);
            }
            this.el(XmlKeyword.arcProto);
        }

        private void writeXml(PrimitiveNodeGroup ng, Map<Object, Map<String, Object>> additionalAttributes) {
            int j;
            PrimitiveNode n;
            if (ng.isSingleton) {
                n = ng.nodes.get(0);
                this.b(XmlKeyword.primitiveNode);
                this.a("name", n.name);
                this.a("fun", n.function.name());
                this.cl();
                this.bcpel(XmlKeyword.oldName, n.oldName);
            } else {
                this.bcl(XmlKeyword.primitiveNodeGroup);
                for (PrimitiveNode primitiveNode : ng.nodes) {
                    this.b(XmlKeyword.primitiveNode);
                    this.a("name", primitiveNode.name);
                    this.a("fun", primitiveNode.function.name());
                    if (primitiveNode.oldName != null || primitiveNode.highVt || primitiveNode.lowVt || primitiveNode.nativeBit || primitiveNode.od18 || primitiveNode.od25 || primitiveNode.od33 || primitiveNode.curvePin) {
                        this.cl();
                        this.bcpel(XmlKeyword.oldName, primitiveNode.oldName);
                        if (primitiveNode.lowVt) {
                            this.bel(XmlKeyword.lowVt);
                        }
                        if (primitiveNode.highVt) {
                            this.bel(XmlKeyword.highVt);
                        }
                        if (primitiveNode.nativeBit) {
                            this.bel(XmlKeyword.nativeBit);
                        }
                        if (primitiveNode.od18) {
                            this.bel(XmlKeyword.od18);
                        }
                        if (primitiveNode.od25) {
                            this.bel(XmlKeyword.od25);
                        }
                        if (primitiveNode.od33) {
                            this.bel(XmlKeyword.od33);
                        }
                        if (primitiveNode.curvePin) {
                            this.bel(XmlKeyword.curvePin);
                        }
                        this.el(XmlKeyword.primitiveNode);
                        continue;
                    }
                    this.el();
                }
            }
            if (ng.shrinkArcs) {
                this.bel(XmlKeyword.shrinkArcs);
            }
            if (ng.partialCircle) {
                this.bel(XmlKeyword.partialCircle);
            }
            if (ng.square) {
                this.bel(XmlKeyword.square);
            }
            if (ng.canBeZeroSize) {
                this.bel(XmlKeyword.canBeZeroSize);
            }
            if (ng.wipes) {
                this.bel(XmlKeyword.wipes);
            }
            if (ng.lockable) {
                this.bel(XmlKeyword.lockable);
            }
            if (ng.edgeSelect) {
                this.bel(XmlKeyword.edgeSelect);
            }
            if (ng.skipSizeInPalette) {
                this.bel(XmlKeyword.skipSizeInPalette);
            }
            if (ng.notUsed) {
                this.bel(XmlKeyword.notUsed);
            }
            if (ng.isSingleton) {
                n = ng.nodes.get(0);
                if (n.lowVt) {
                    this.bel(XmlKeyword.lowVt);
                }
                if (n.highVt) {
                    this.bel(XmlKeyword.highVt);
                }
                if (n.nativeBit) {
                    this.bel(XmlKeyword.nativeBit);
                }
                if (n.od18) {
                    this.bel(XmlKeyword.od18);
                }
                if (n.od25) {
                    this.bel(XmlKeyword.od25);
                }
                if (n.od33) {
                    this.bel(XmlKeyword.od33);
                }
                if (n.curvePin) {
                    this.bel(XmlKeyword.curvePin);
                }
            }
            for (Map.Entry entry : ng.diskOffset.entrySet()) {
                EPoint p = (EPoint)entry.getValue();
                this.b(XmlKeyword.diskOffset);
                this.a("untilVersion", entry.getKey());
                this.a("x", p.getLambdaX());
                this.a("y", p.getLambdaY());
                this.el();
            }
            if (ng.defaultWidth.value != 0.0) {
                this.bcl(XmlKeyword.defaultWidth);
                this.bcpel(XmlKeyword.lambda, ng.defaultWidth.value);
                this.el(XmlKeyword.defaultWidth);
            }
            if (ng.defaultHeight.value != 0.0) {
                this.bcl(XmlKeyword.defaultHeight);
                this.bcpel(XmlKeyword.lambda, ng.defaultHeight.value);
                this.el(XmlKeyword.defaultHeight);
            }
            this.bcl(XmlKeyword.nodeBase);
            this.bcl(XmlKeyword.box);
            this.b(XmlKeyword.lambdaBox);
            this.a("klx", ng.baseLX.value);
            this.a("khx", ng.baseHX.value);
            this.a("kly", ng.baseLY.value);
            this.a("khy", ng.baseHY.value);
            this.el();
            this.el(XmlKeyword.box);
            this.el(XmlKeyword.nodeBase);
            if (ng.protection != null) {
                this.b(XmlKeyword.protection);
                this.a("location", (Object)ng.protection);
                this.el();
            }
            for (j = 0; j < ng.nodeLayers.size(); ++j) {
                Map<String, Object> attrs;
                NodeLayer nodeLayer = ng.nodeLayers.get(j);
                this.b(XmlKeyword.nodeLayer);
                this.a("layer", nodeLayer.layer);
                this.a("style", nodeLayer.style.name());
                if (nodeLayer.portNum != 0) {
                    this.a("portNum", (Object)nodeLayer.portNum);
                }
                if (!nodeLayer.inLayers || !nodeLayer.inElectricalLayers) {
                    this.a("electrical", nodeLayer.inElectricalLayers);
                }
                if (additionalAttributes != null && (attrs = additionalAttributes.get(nodeLayer)) != null) {
                    for (Map.Entry<String, Object> e : attrs.entrySet()) {
                        this.a(e.getKey(), e.getValue());
                    }
                }
                this.cl();
                if (nodeLayer.inNodes != null) {
                    assert (!ng.isSingleton);
                    this.bcl(XmlKeyword.inNodes);
                    for (int i = 0; i < ng.nodes.size(); ++i) {
                        if (!nodeLayer.inNodes.get(i)) continue;
                        this.b(XmlKeyword.primitiveNode);
                        this.a("name", ng.nodes.get((int)i).name);
                        this.el();
                    }
                    this.el(XmlKeyword.inNodes);
                }
                switch (nodeLayer.representation) {
                    case 1: {
                        if (ng.specialType == 1) {
                            this.writeBox(XmlKeyword.serpbox, nodeLayer.lx, nodeLayer.hx, nodeLayer.ly, nodeLayer.hy);
                            this.a("lWidth", nodeLayer.lWidth);
                            this.a("rWidth", nodeLayer.rWidth);
                            this.a("tExtent", nodeLayer.tExtent);
                            this.a("bExtent", nodeLayer.bExtent);
                            this.cl();
                            this.b(XmlKeyword.lambdaBox);
                            this.a("klx", nodeLayer.lx.value);
                            this.a("khx", nodeLayer.hx.value);
                            this.a("kly", nodeLayer.ly.value);
                            this.a("khy", nodeLayer.hy.value);
                            this.el();
                            this.el(XmlKeyword.serpbox);
                            break;
                        }
                        this.writeBox(XmlKeyword.box, nodeLayer.lx, nodeLayer.hx, nodeLayer.ly, nodeLayer.hy);
                        this.cl();
                        this.b(XmlKeyword.lambdaBox);
                        this.a("klx", nodeLayer.lx.value);
                        this.a("khx", nodeLayer.hx.value);
                        this.a("kly", nodeLayer.ly.value);
                        this.a("khy", nodeLayer.hy.value);
                        this.el();
                        this.el(XmlKeyword.box);
                        break;
                    }
                    case 0: {
                        this.b(XmlKeyword.points);
                        this.el();
                        break;
                    }
                    case 3: {
                        this.writeBox(XmlKeyword.multicutbox, nodeLayer.lx, nodeLayer.hx, nodeLayer.ly, nodeLayer.hy);
                        this.a("sizex", nodeLayer.sizex);
                        this.a("sizey", nodeLayer.sizey);
                        this.a("sep1d", nodeLayer.sep1d);
                        this.a("sep2d", nodeLayer.sep2d);
                        this.cl();
                        this.b(XmlKeyword.lambdaBox);
                        this.a("klx", nodeLayer.lx.value);
                        this.a("khx", nodeLayer.hx.value);
                        this.a("kly", nodeLayer.ly.value);
                        this.a("khy", nodeLayer.hy.value);
                        this.el();
                        this.el(XmlKeyword.multicutbox);
                    }
                }
                for (Technology.TechPoint tp : nodeLayer.techPoints) {
                    double xm = tp.getX().getMultiplier();
                    double xa = tp.getX().getAdder().getLambda();
                    double ym = tp.getY().getMultiplier();
                    double ya = tp.getY().getAdder().getLambda();
                    this.b(XmlKeyword.techPoint);
                    this.a("xm", xm);
                    this.a("xa", xa);
                    this.a("ym", ym);
                    this.a("ya", ya);
                    this.el();
                }
                this.el(XmlKeyword.nodeLayer);
            }
            for (j = 0; j < ng.ports.size(); ++j) {
                PrimitivePort primitivePort = ng.ports.get(j);
                this.b(XmlKeyword.primitivePort);
                this.a("name", primitivePort.name);
                this.cl();
                this.b(XmlKeyword.portAngle);
                this.a("primary", primitivePort.portAngle);
                this.a("range", primitivePort.portRange);
                this.el();
                this.bcpel(XmlKeyword.portTopology, primitivePort.portTopology);
                this.writeBox(XmlKeyword.box, primitivePort.lx, primitivePort.hx, primitivePort.ly, primitivePort.hy);
                this.cl();
                this.b(XmlKeyword.lambdaBox);
                this.a("klx", primitivePort.lx.value);
                this.a("khx", primitivePort.hx.value);
                this.a("kly", primitivePort.ly.value);
                this.a("khy", primitivePort.hy.value);
                this.el();
                this.el(XmlKeyword.box);
                for (String portArc : primitivePort.portArcs) {
                    this.bcpel(XmlKeyword.portArc, portArc);
                }
                this.el(XmlKeyword.primitivePort);
            }
            switch (ng.specialType) {
                case 2: {
                    this.bel(XmlKeyword.polygonal);
                    break;
                }
                case 1: {
                    this.b(XmlKeyword.serpTrans);
                    this.cl();
                    for (int i = 0; i < 6; ++i) {
                        this.bcpel(XmlKeyword.specialValue, ng.specialValues[i]);
                    }
                    this.el(XmlKeyword.serpTrans);
                }
            }
            if (ng.nodeSizeRule != null) {
                NodeSizeRule r = ng.nodeSizeRule;
                this.b(XmlKeyword.minSizeRule);
                this.a("width", r.width);
                this.a("height", r.height);
                this.a("rule", r.rule);
                this.el();
            }
            if (ng.spiceTemplate != null) {
                this.b(XmlKeyword.spiceTemplate);
                this.a("value", ng.spiceTemplate);
                this.el();
            }
            this.el(ng.isSingleton ? XmlKeyword.primitiveNode : XmlKeyword.primitiveNodeGroup);
        }

        private void writeBox(XmlKeyword keyword, Distance lx, Distance hx, Distance ly, Distance hy) {
            this.b(keyword);
            if (lx.k != -1.0) {
                this.a("klx", lx.k);
            }
            if (hx.k != 1.0) {
                this.a("khx", hx.k);
            }
            if (ly.k != -1.0) {
                this.a("kly", ly.k);
            }
            if (hy.k != 1.0) {
                this.a("khy", hy.k);
            }
        }

        private void writeSpiceHeaderXml(SpiceHeader spiceHeader) {
            this.b(XmlKeyword.spiceHeader);
            this.a("level", spiceHeader.level);
            this.cl();
            for (String line : spiceHeader.spiceLines) {
                this.b(XmlKeyword.spiceLine);
                this.a("line", line);
                this.el();
            }
            this.el(XmlKeyword.spiceHeader);
            this.l();
        }

        public void writeMenuPaletteXml(MenuPalette menuPalette) {
            if (menuPalette == null) {
                return;
            }
            this.b(XmlKeyword.menuPalette);
            this.a("numColumns", menuPalette.numColumns);
            this.cl();
            for (int i = 0; i < menuPalette.menuBoxes.size(); ++i) {
                if (i % menuPalette.numColumns == 0) {
                    this.l();
                }
                this.writeMenuBoxXml(menuPalette.menuBoxes.get(i));
            }
            this.l();
            this.el(XmlKeyword.menuPalette);
            this.l();
        }

        private void writeMenuBoxXml(List<?> list) {
            this.b(XmlKeyword.menuBox);
            if (list == null || list.size() == 0) {
                this.el();
                return;
            }
            this.cl();
            for (Object o : list) {
                if (o instanceof ArcProto) {
                    this.bcpel(XmlKeyword.menuArc, ((ArcProto)o).name);
                    continue;
                }
                if (o instanceof PrimitiveNode) {
                    this.bcpel(XmlKeyword.menuNode, ((PrimitiveNode)o).name);
                    continue;
                }
                if (o instanceof MenuNodeInst) {
                    MenuNodeInst ni = (MenuNodeInst)o;
                    this.b(XmlKeyword.menuNodeInst);
                    this.a("protoName", ni.protoName);
                    this.a("function", ni.function.name());
                    if (ni.techBits != 0) {
                        this.a("techBits", ni.techBits);
                    }
                    if (ni.rotation != 0) {
                        this.a("rotation", ni.rotation);
                    }
                    if (ni.partialCircle != 0) {
                        this.a("partialCircle", ni.partialCircle);
                    }
                    if (ni.text == null) {
                        this.el();
                        continue;
                    }
                    this.cl();
                    this.b(XmlKeyword.menuNodeText);
                    this.a("text", ni.text);
                    this.el();
                    this.el(XmlKeyword.menuNodeInst);
                    continue;
                }
                if (o == null) {
                    this.bel(XmlKeyword.menuText);
                    continue;
                }
                this.bcpel(XmlKeyword.menuText, o);
            }
            this.el(XmlKeyword.menuBox);
        }

        private void writeFoundryXml(Foundry foundry) {
            this.b(XmlKeyword.Foundry);
            this.a("name", foundry.name);
            this.cl();
            this.l();
            for (Map.Entry<String, String> e : foundry.layerGds.entrySet()) {
                this.b(XmlKeyword.layerGds);
                this.a("layer", e.getKey());
                this.a("gds", e.getValue());
                this.el();
            }
            this.l();
            for (DRCTemplate rule : foundry.rules) {
                DRCTemplate.exportDRCRule(this.out, rule);
            }
            this.el(XmlKeyword.Foundry);
        }

        private void header() {
            this.checkIndent();
            this.out.print("<?xml");
            this.a("version", "1.0");
            this.a("encoding", "UTF-8");
            this.out.println("?>");
        }

        private void comment(String s2) {
            this.checkIndent();
            this.out.print("<!-- ");
            this.p(s2);
            this.out.print(" -->");
            this.l();
        }

        private void a(String name, Object value) {
            this.checkIndent();
            if (value == null) {
                return;
            }
            this.out.print(" " + name + "=\"");
            this.p(value.toString());
            this.out.print("\"");
        }

        private void a(String name, double value) {
            this.a(name, new Double(value));
        }

        private void a(String name, int value) {
            this.a(name, new Integer(value));
        }

        private void bcpel(XmlKeyword key, Object v) {
            if (v == null) {
                return;
            }
            this.b(key);
            this.c();
            this.p(v.toString());
            this.el(key);
        }

        private void bcpel(XmlKeyword key, int v) {
            this.bcpel(key, new Integer(v));
        }

        private void bcpel(XmlKeyword key, double v) {
            this.bcpel(key, new Double(v));
        }

        private void bcl(XmlKeyword key) {
            this.b(key);
            this.cl();
        }

        private void bel(XmlKeyword key) {
            this.b(key);
            this.el();
        }

        private void pl(String s2) {
            this.checkIndent();
            this.p(s2);
            this.l();
        }

        protected void p(String s2) {
            assert (this.indentEmitted);
            block7: for (int i = 0; i < s2.length(); ++i) {
                char c = s2.charAt(i);
                switch (c) {
                    case '<': {
                        this.out.print("&lt;");
                        continue block7;
                    }
                    case '>': {
                        this.out.print("&gt;");
                        continue block7;
                    }
                    case '&': {
                        this.out.print("&amp;");
                        continue block7;
                    }
                    case '\'': {
                        this.out.print("&apos;");
                        continue block7;
                    }
                    case '\"': {
                        this.out.print("quot;");
                        continue block7;
                    }
                    default: {
                        this.out.print(c);
                    }
                }
            }
        }

        private void b(XmlKeyword key) {
            this.checkIndent();
            this.out.print('<');
            this.out.print(key.name());
            this.indent += 4;
        }

        private void cl() {
            assert (this.indentEmitted);
            this.out.print('>');
            this.l();
        }

        private void c() {
            assert (this.indentEmitted);
            this.out.print('>');
        }

        private void el() {
            this.e();
            this.l();
        }

        private void e() {
            assert (this.indentEmitted);
            this.out.print("/>");
            this.indent -= 4;
        }

        private void el(XmlKeyword key) {
            this.indent -= 4;
            this.checkIndent();
            this.out.print("</");
            this.out.print(key.name());
            this.out.print(">");
            this.l();
        }

        protected void checkIndent() {
            if (this.indentEmitted) {
                return;
            }
            for (int i = 0; i < this.indent; ++i) {
                this.out.print(' ');
            }
            this.indentEmitted = true;
        }

        protected void l() {
            this.out.println();
            this.indentEmitted = false;
        }
    }

    private static class XMLReader
    extends DefaultHandler {
        private static boolean DEBUG = false;
        private Locator locator;
        private Technology tech = new Technology();
        private int curTransparent = 0;
        private int curR;
        private int curG;
        private int curB;
        private Layer curLayer;
        private boolean patternedOnDisplay;
        private boolean patternedOnPrinter;
        private final int[] pattern = new int[16];
        private int curPatternIndex;
        private EGraphics.Outline outline;
        private double opacity;
        private boolean foreground;
        private EGraphics.J3DTransparencyOption transparencyMode;
        private double transparencyFactor;
        private ArcProto curArc;
        private PrimitiveNodeGroup curNodeGroup;
        private boolean curNodeGroupHasNodeBase;
        private PrimitiveNode curNode;
        private NodeLayer curNodeLayer;
        private PrimitivePort curPort;
        private int curSpecialValueIndex;
        private ArrayList<Object> curMenuBox;
        private MenuNodeInst curMenuNodeInst;
        private Distance curDistance;
        private SpiceHeader curSpiceHeader;
        private Foundry curFoundry;
        private Collection<String> curLayerNamesList;
        private Collection<String> curNodeNamesList;
        private boolean acceptCharacters;
        private StringBuilder charBuffer = new StringBuilder();
        private Attributes attributes;

        XMLReader() {
        }

        XMLReader(List<PrimitiveNodeGroup> nodeGroups, List<ArcProto> arcs, List<PrimitiveNode> pureLayerNodes) {
            this.tech.arcs.addAll(arcs);
            this.tech.nodeGroups.addAll(nodeGroups);
            this.tech.pureLayerNodes.addAll(pureLayerNodes);
        }

        private void beginCharacters() {
            assert (!this.acceptCharacters);
            this.acceptCharacters = true;
            assert (this.charBuffer.length() == 0);
        }

        private String endCharacters() {
            assert (this.acceptCharacters);
            String s2 = this.charBuffer.toString();
            this.charBuffer.setLength(0);
            this.acceptCharacters = false;
            return s2;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            return null;
        }

        @Override
        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private void printLocator() {
            System.out.println("publicId=" + this.locator.getPublicId() + " systemId=" + this.locator.getSystemId() + " line=" + this.locator.getLineNumber() + " column=" + this.locator.getColumnNumber());
        }

        @Override
        public void startDocument() throws SAXException {
            if (DEBUG) {
                System.out.println("startDocument");
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (DEBUG) {
                System.out.println("endDocument");
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (DEBUG) {
                System.out.println("startPrefixMapping prefix=" + prefix + " uri=" + uri);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            if (DEBUG) {
                System.out.println("endPrefixMapping prefix=" + prefix);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            boolean dump = false;
            XmlKeyword key = (XmlKeyword)((Object)xmlKeywords.get(localName));
            this.attributes = attributes;
            switch (key) {
                case technology: {
                    this.tech.techName = this.a("name");
                    this.tech.className = this.a_("class");
                    if (this.tech.className == null) break;
                    int index = this.tech.className.indexOf(".");
                    String realName = this.tech.className;
                    while (index != -1) {
                        realName = realName.substring(index + 1);
                        index = realName.indexOf(".");
                    }
                    if (realName.toLowerCase().equals(this.tech.techName.toLowerCase())) break;
                    System.out.println("Mismatch between techName '" + this.tech.techName + "' and className '" + realName + "' in the XML technology file (line " + this.locator.getLineNumber() + ").");
                    break;
                }
                case version: {
                    Version localVersion = new Version();
                    localVersion.techVersion = Integer.parseInt(this.a("tech"));
                    localVersion.electricVersion = com.sun.electric.database.text.Version.parseVersion(this.a("electric"));
                    this.tech.versions.add(localVersion);
                    break;
                }
                case numMetals: {
                    this.tech.minNumMetals = Integer.parseInt(this.a("min"));
                    this.tech.maxNumMetals = Integer.parseInt(this.a("max"));
                    this.tech.defaultNumMetals = Integer.parseInt(this.a("default"));
                    if (this.tech.defaultNumMetals >= this.tech.minNumMetals && this.tech.defaultNumMetals <= this.tech.maxNumMetals) break;
                    throw new SAXException("Invalid default number of metals (not in between valid range) default=" + this.tech.defaultNumMetals + ", min=" + this.tech.minNumMetals + ", max=" + this.tech.maxNumMetals + " (line " + this.locator.getLineNumber() + ").");
                }
                case scale: {
                    this.tech.scaleValue = Double.parseDouble(this.a("value"));
                    this.tech.scaleRelevant = Boolean.parseBoolean(this.a("relevant"));
                    break;
                }
                case resolution: {
                    this.tech.resolutionValue = Double.parseDouble(this.a("value"));
                    break;
                }
                case defaultFoundry: {
                    this.tech.defaultFoundry = this.a("value");
                    break;
                }
                case minResistance: {
                    this.tech.minResistance = Double.parseDouble(this.a("value"));
                    break;
                }
                case minCapacitance: {
                    this.tech.minCapacitance = Double.parseDouble(this.a("value"));
                    break;
                }
                case logicalEffort: {
                    this.tech.leGateCapacitance = Double.parseDouble(this.a("gateCapacitance"));
                    this.tech.leWireRatio = Double.parseDouble(this.a("wireRatio"));
                    this.tech.leDiffAlpha = Double.parseDouble(this.a("diffAlpha"));
                    break;
                }
                case transparentLayer: {
                    this.curTransparent = Integer.parseInt(this.a("transparent"));
                    this.curB = 0;
                    this.curG = 0;
                    this.curR = 0;
                    break;
                }
                case layer: {
                    this.curLayer = new Layer();
                    this.curLayer.name = this.a("name");
                    if (!TextUtils.isValidLayerName(this.curLayer.name)) {
                        throw new SAXException("Invalid name for layer '" + this.curLayer.name + "' (line " + this.locator.getLineNumber() + ").");
                    }
                    this.curLayer.function = Layer.Function.valueOf(this.a("fun"));
                    String extraFunStr = this.a_("extraFun");
                    if (extraFunStr != null) {
                        this.curLayer.extraFunction = extraFunStr.equals("depletion_heavy") ? 2304 : (extraFunStr.equals("depletion_light") ? 1280 : (extraFunStr.equals("enhancement_heavy") ? 2560 : (extraFunStr.equals("enhancement_light") ? 1536 : Layer.Function.parseExtraName(extraFunStr))));
                    }
                    this.curTransparent = 0;
                    this.curB = 0;
                    this.curG = 0;
                    this.curR = 0;
                    this.patternedOnDisplay = false;
                    this.patternedOnPrinter = false;
                    Arrays.fill(this.pattern, 0);
                    this.curPatternIndex = 0;
                    this.transparencyMode = EGraphics.DEFAULT_MODE;
                    this.transparencyFactor = 0.0;
                    break;
                }
                case transparentColor: {
                    this.curTransparent = Integer.parseInt(this.a("transparent"));
                    if (this.curTransparent <= 0) break;
                    Color color = this.tech.transparentLayers.get(this.curTransparent - 1);
                    this.curR = color.getRed();
                    this.curG = color.getGreen();
                    this.curB = color.getBlue();
                    break;
                }
                case opaqueColor: {
                    this.curR = Integer.parseInt(this.a("r"));
                    this.curG = Integer.parseInt(this.a("g"));
                    this.curB = Integer.parseInt(this.a("b"));
                    break;
                }
                case display3D: {
                    String factorStr;
                    this.curLayer.thick3D = Double.parseDouble(this.a("thick"));
                    this.curLayer.height3D = Double.parseDouble(this.a("height"));
                    String modeStr = this.a_("mode");
                    if (modeStr != null) {
                        this.transparencyMode = EGraphics.J3DTransparencyOption.valueOf(modeStr);
                    }
                    if ((factorStr = this.a_("factor")) == null) break;
                    this.transparencyFactor = Double.parseDouble(factorStr);
                    break;
                }
                case cifLayer: {
                    this.curLayer.cif = this.a("cif");
                    break;
                }
                case skillLayer: {
                    this.curLayer.skill = this.a("skill");
                    break;
                }
                case parasitics: {
                    this.curLayer.resistance = Double.parseDouble(this.a("resistance"));
                    this.curLayer.capacitance = Double.parseDouble(this.a("capacitance"));
                    this.curLayer.edgeCapacitance = Double.parseDouble(this.a("edgeCapacitance"));
                    break;
                }
                case pureLayerNode: {
                    this.curLayer.pureLayerNode = new PureLayerNode();
                    this.curLayer.pureLayerNode.name = this.a("name");
                    String styleStr = this.a_("style");
                    this.curLayer.pureLayerNode.style = styleStr != null ? Poly.Type.valueOf(styleStr) : Poly.Type.FILLED;
                    this.curLayer.pureLayerNode.port = this.a("port");
                    this.curDistance = this.curLayer.pureLayerNode.size;
                    PrimitiveNode n = new PrimitiveNode();
                    n.name = this.curLayer.pureLayerNode.name;
                    n.function = PrimitiveNode.Function.NODE;
                    this.tech.pureLayerNodes.add(n);
                    break;
                }
                case arcProto: {
                    this.curArc = new ArcProto();
                    this.curArc.name = this.a("name");
                    this.curArc.function = ArcProto.Function.valueOf(this.a("fun"));
                    break;
                }
                case wipable: {
                    this.curArc.wipable = true;
                    break;
                }
                case curvable: {
                    this.curArc.curvable = true;
                    break;
                }
                case special: {
                    this.curArc.special = true;
                    break;
                }
                case notUsed: {
                    if (this.curArc != null) {
                        this.curArc.notUsed = true;
                        break;
                    }
                    if (this.curNodeGroup == null) break;
                    this.curNodeGroup.notUsed = true;
                    break;
                }
                case skipSizeInPalette: {
                    if (this.curArc != null) {
                        this.curArc.skipSizeInPalette = true;
                        break;
                    }
                    if (this.curNodeGroup == null) break;
                    this.curNodeGroup.skipSizeInPalette = true;
                    break;
                }
                case diskOffset: {
                    if (this.curArc != null) {
                        this.curArc.diskOffset.put(new Integer(Integer.parseInt(this.a("untilVersion"))), new Double(Double.parseDouble(this.a("width"))));
                        break;
                    }
                    if (this.curNodeGroup == null) break;
                    this.curNodeGroup.diskOffset.put(new Integer(Integer.parseInt(this.a("untilVersion"))), EPoint.fromLambda(Double.parseDouble(this.a("x")), Double.parseDouble(this.a("y"))));
                    break;
                }
                case defaultWidth: {
                    if (this.curArc != null) {
                        this.curDistance = this.curArc.defaultWidth;
                        break;
                    }
                    if (this.curNodeGroup == null) break;
                    this.curDistance = this.curNodeGroup.defaultWidth;
                    break;
                }
                case arcLayer: {
                    ArcLayer arcLayer = new ArcLayer();
                    arcLayer.layer = this.a("layer");
                    this.curDistance = arcLayer.extend;
                    arcLayer.style = Poly.Type.valueOf(this.a("style"));
                    this.curArc.arcLayers.add(arcLayer);
                    break;
                }
                case primitiveNodeGroup: {
                    this.curNodeGroup = new PrimitiveNodeGroup();
                    this.curNodeGroupHasNodeBase = false;
                    this.curNode = null;
                    if (this.a_("name") != null) {
                        System.out.println("Warning in technology " + this.tech.techName + ": attribute 'name' in <primitiveNodeGroup> is deprecated");
                    }
                    if (this.a_("fun") == null) break;
                    System.out.println("Warning in technology " + this.tech.techName + ": attribute 'fun' in <primitiveNodeGroup> is deprecated");
                    break;
                }
                case inNodes: {
                    if (this.curNodeGroup.isSingleton) {
                        throw new SAXException("<inNodes> can be used only inside <primitiveNodeGroup> (line " + this.locator.getLineNumber() + ")");
                    }
                    this.curNodeLayer.inNodes = new BitSet();
                    break;
                }
                case primitiveNode: {
                    if (this.curNodeLayer != null) {
                        int i;
                        assert (!this.curNodeGroup.isSingleton && this.curNode == null);
                        String nodeName = this.a("name");
                        for (i = 0; i < this.curNodeGroup.nodes.size() && !this.curNodeGroup.nodes.get((int)i).name.equals(nodeName); ++i) {
                        }
                        if (i >= this.curNodeGroup.nodes.size()) {
                            throw new SAXException("No node " + nodeName + " in group (line " + this.locator.getLineNumber() + ")");
                        }
                        this.curNodeLayer.inNodes.set(i);
                        break;
                    }
                    if (this.curNodeGroup != null) {
                        assert (!this.curNodeGroup.isSingleton);
                        this.curNode = new PrimitiveNode();
                        this.curNode.name = this.a("name");
                        this.curNode.function = PrimitiveNode.Function.valueOf(this.a("fun"));
                        this.curNodeGroup.nodes.add(this.curNode);
                        break;
                    }
                    this.curNodeGroup = new PrimitiveNodeGroup();
                    this.curNodeGroupHasNodeBase = false;
                    this.curNodeGroup.isSingleton = true;
                    this.curNode = new PrimitiveNode();
                    this.curNode.name = this.a("name");
                    this.curNode.function = PrimitiveNode.Function.valueOf(this.a("fun"));
                    this.curNodeGroup.nodes.add(this.curNode);
                    break;
                }
                case shrinkArcs: {
                    this.curNodeGroup.shrinkArcs = true;
                    break;
                }
                case partialCircle: {
                    this.curNodeGroup.partialCircle = true;
                    break;
                }
                case square: {
                    this.curNodeGroup.square = true;
                    break;
                }
                case canBeZeroSize: {
                    this.curNodeGroup.canBeZeroSize = true;
                    break;
                }
                case wipes: {
                    this.curNodeGroup.wipes = true;
                    break;
                }
                case lockable: {
                    this.curNodeGroup.lockable = true;
                    break;
                }
                case edgeSelect: {
                    this.curNodeGroup.edgeSelect = true;
                    break;
                }
                case lowVt: {
                    this.curNode.lowVt = true;
                    break;
                }
                case highVt: {
                    this.curNode.highVt = true;
                    break;
                }
                case nativeBit: {
                    this.curNode.nativeBit = true;
                    break;
                }
                case curvePin: {
                    this.curNode.curvePin = true;
                    break;
                }
                case od18: {
                    this.curNode.od18 = true;
                    break;
                }
                case od25: {
                    this.curNode.od25 = true;
                    break;
                }
                case od33: {
                    this.curNode.od33 = true;
                    break;
                }
                case defaultHeight: {
                    this.curDistance = this.curNodeGroup.defaultHeight;
                    break;
                }
                case nodeBase: {
                    this.curNodeGroupHasNodeBase = true;
                    break;
                }
                case sizeOffset: {
                    this.curNodeGroup.baseLX.value = Double.parseDouble(this.a("lx"));
                    this.curNodeGroup.baseHX.value = -Double.parseDouble(this.a("hx"));
                    this.curNodeGroup.baseLY.value = Double.parseDouble(this.a("ly"));
                    this.curNodeGroup.baseHY.value = -Double.parseDouble(this.a("hy"));
                    break;
                }
                case protection: {
                    this.curNodeGroup.protection = ProtectionType.valueOf(this.a("location"));
                    break;
                }
                case nodeLayer: {
                    String electrical;
                    this.curNodeLayer = new NodeLayer();
                    this.curNodeLayer.layer = this.a("layer");
                    if (this.tech.findLayer(this.curNodeLayer.layer) == null) {
                        throw new SAXException("Error: cannot find layer '" + this.curNodeLayer.layer + "' in primitive node '" + this.curNode.name + "' (line " + this.locator.getLineNumber() + "). Skipping this NodeLayer");
                    }
                    this.curNodeLayer.style = Poly.Type.valueOf(this.a("style"));
                    String portNum = this.a_("portNum");
                    if (portNum != null) {
                        this.curNodeLayer.portNum = Integer.parseInt(portNum);
                    }
                    if ((electrical = this.a_("electrical")) != null) {
                        if (Boolean.parseBoolean(electrical)) {
                            this.curNodeLayer.inElectricalLayers = true;
                        } else {
                            this.curNodeLayer.inLayers = true;
                        }
                    } else {
                        this.curNodeLayer.inLayers = true;
                        this.curNodeLayer.inElectricalLayers = true;
                    }
                    this.curNodeLayer.message = this.a_("message");
                    String relSize = this.a_("relSize");
                    if (relSize == null) break;
                    this.curNodeLayer.relSize = Double.parseDouble(relSize);
                    break;
                }
                case box: {
                    if (this.curNodeLayer != null) {
                        this.curNodeLayer.representation = 1;
                        this.curNodeLayer.lx.k = this.da_("klx", -1.0);
                        this.curNodeLayer.hx.k = this.da_("khx", 1.0);
                        this.curNodeLayer.ly.k = this.da_("kly", -1.0);
                        this.curNodeLayer.hy.k = this.da_("khy", 1.0);
                        break;
                    }
                    if (this.curPort != null) {
                        this.curPort.lx.k = this.da_("klx", -1.0);
                        this.curPort.hx.k = this.da_("khx", 1.0);
                        this.curPort.ly.k = this.da_("kly", -1.0);
                        this.curPort.hy.k = this.da_("khy", 1.0);
                        break;
                    }
                    assert (this.curNodeGroupHasNodeBase);
                    this.curNodeGroup.baseLY.k = -1.0;
                    this.curNodeGroup.baseLX.k = -1.0;
                    this.curNodeGroup.baseHY.k = 1.0;
                    this.curNodeGroup.baseHX.k = 1.0;
                    break;
                }
                case points: {
                    this.curNodeLayer.representation = 0;
                    break;
                }
                case multicutbox: {
                    this.curNodeLayer.representation = 3;
                    this.curNodeLayer.lx.k = this.da_("klx", -1.0);
                    this.curNodeLayer.hx.k = this.da_("khx", 1.0);
                    this.curNodeLayer.ly.k = this.da_("kly", -1.0);
                    this.curNodeLayer.hy.k = this.da_("khy", 1.0);
                    this.curNodeLayer.sizex = Double.parseDouble(this.a("sizex"));
                    this.curNodeLayer.sizey = Double.parseDouble(this.a("sizey"));
                    this.curNodeLayer.sep1d = Double.parseDouble(this.a("sep1d"));
                    this.curNodeLayer.sep2d = Double.parseDouble(this.a("sep2d"));
                    break;
                }
                case serpbox: {
                    this.curNodeLayer.representation = 1;
                    this.curNodeLayer.lx.k = this.da_("klx", -1.0);
                    this.curNodeLayer.hx.k = this.da_("khx", 1.0);
                    this.curNodeLayer.ly.k = this.da_("kly", -1.0);
                    this.curNodeLayer.hy.k = this.da_("khy", 1.0);
                    this.curNodeLayer.lWidth = Double.parseDouble(this.a("lWidth"));
                    this.curNodeLayer.rWidth = Double.parseDouble(this.a("rWidth"));
                    this.curNodeLayer.tExtent = Double.parseDouble(this.a("tExtent"));
                    this.curNodeLayer.bExtent = Double.parseDouble(this.a("bExtent"));
                    break;
                }
                case lambdaBox: {
                    if (this.curNodeLayer != null) {
                        this.curNodeLayer.lx.value = Double.parseDouble(this.a("klx"));
                        this.curNodeLayer.hx.value = Double.parseDouble(this.a("khx"));
                        this.curNodeLayer.ly.value = Double.parseDouble(this.a("kly"));
                        this.curNodeLayer.hy.value = Double.parseDouble(this.a("khy"));
                        break;
                    }
                    if (this.curPort != null) {
                        this.curPort.lx.value = Double.parseDouble(this.a("klx"));
                        this.curPort.hx.value = Double.parseDouble(this.a("khx"));
                        this.curPort.ly.value = Double.parseDouble(this.a("kly"));
                        this.curPort.hy.value = Double.parseDouble(this.a("khy"));
                        break;
                    }
                    assert (this.curNodeGroupHasNodeBase);
                    this.curNodeGroup.baseLX.value = Double.parseDouble(this.a("klx"));
                    this.curNodeGroup.baseHX.value = Double.parseDouble(this.a("khx"));
                    this.curNodeGroup.baseLY.value = Double.parseDouble(this.a("kly"));
                    this.curNodeGroup.baseHY.value = Double.parseDouble(this.a("khy"));
                    break;
                }
                case techPoint: {
                    double xm = Double.parseDouble(this.a("xm"));
                    double xa = Double.parseDouble(this.a("xa"));
                    double ym = Double.parseDouble(this.a("ym"));
                    double ya = Double.parseDouble(this.a("ya"));
                    Technology.TechPoint p = new Technology.TechPoint(new EdgeH(xm, xa), new EdgeV(ym, ya));
                    if (this.curNodeLayer == null) break;
                    this.curNodeLayer.techPoints.add(p);
                    break;
                }
                case primitivePort: {
                    this.curPort = new PrimitivePort();
                    this.curPort.name = this.a("name");
                    break;
                }
                case portAngle: {
                    this.curPort.portAngle = Integer.parseInt(this.a("primary"));
                    this.curPort.portRange = Integer.parseInt(this.a("range"));
                    break;
                }
                case polygonal: {
                    this.curNodeGroup.specialType = 2;
                    break;
                }
                case serpTrans: {
                    this.curNodeGroup.specialType = 1;
                    this.curNodeGroup.specialValues = new double[6];
                    this.curSpecialValueIndex = 0;
                    break;
                }
                case minSizeRule: {
                    this.curNodeGroup.nodeSizeRule = new NodeSizeRule();
                    this.curNodeGroup.nodeSizeRule.width = Double.parseDouble(this.a("width"));
                    this.curNodeGroup.nodeSizeRule.height = Double.parseDouble(this.a("height"));
                    this.curNodeGroup.nodeSizeRule.rule = this.a("rule");
                    break;
                }
                case spiceTemplate: {
                    this.curNodeGroup.spiceTemplate = this.a("value");
                    break;
                }
                case spiceHeader: {
                    this.curSpiceHeader = new SpiceHeader();
                    this.curSpiceHeader.level = Integer.parseInt(this.a("level"));
                    this.tech.spiceHeaders.add(this.curSpiceHeader);
                    break;
                }
                case spiceLine: {
                    this.curSpiceHeader.spiceLines.add(this.a("line"));
                    break;
                }
                case menuPalette: {
                    this.tech.menuPalette = new MenuPalette();
                    this.tech.menuPalette.numColumns = Integer.parseInt(this.a("numColumns"));
                    break;
                }
                case menuBox: {
                    this.curMenuBox = new ArrayList();
                    this.tech.menuPalette.menuBoxes.add(this.curMenuBox);
                    break;
                }
                case menuNodeInst: {
                    String partialCircleField;
                    String rotField;
                    String techBits;
                    this.curMenuNodeInst = new MenuNodeInst();
                    this.curMenuNodeInst.protoName = this.a("protoName");
                    if (this.tech.findNode(this.curMenuNodeInst.protoName) == null) {
                        System.out.println("Warning in technology " + this.tech.techName + ": cannot find node '" + this.curMenuNodeInst.protoName + "' for component menu (line " + this.locator.getLineNumber() + ")");
                    }
                    this.curMenuNodeInst.function = PrimitiveNode.Function.findType(this.a("function"));
                    if (this.curMenuNodeInst.function == null) {
                        System.out.println("Error in technology " + this.tech.techName + ": cannot find function '" + this.a("function") + "' for node '" + this.a("protoName' (line " + this.locator.getLineNumber() + ")"));
                    }
                    if ((techBits = this.a_("techBits")) != null) {
                        this.curMenuNodeInst.techBits = Integer.parseInt(techBits);
                    }
                    if ((rotField = this.a_("rotation")) != null) {
                        this.curMenuNodeInst.rotation = Integer.parseInt(rotField);
                    }
                    if ((partialCircleField = this.a_("partialCircle")) == null) break;
                    this.curMenuNodeInst.partialCircle = Integer.parseInt(partialCircleField);
                    break;
                }
                case menuNodeText: {
                    this.curMenuNodeInst.text = this.a("text");
                    break;
                }
                case Foundry: {
                    this.curFoundry = new Foundry();
                    this.curFoundry.name = this.a("name");
                    this.tech.foundries.add(this.curFoundry);
                    break;
                }
                case layerGds: {
                    String layerN = this.a("layer");
                    if (this.tech.findLayer(layerN) == null) {
                        System.out.println("Warning in technology " + this.tech.techName + ": cannot find layer name for gds definition '" + layerN + "' (line " + this.locator.getLineNumber() + "). Skipping gds declaration.");
                        break;
                    }
                    String gdsV = this.a("gds");
                    GDSLayers numbers = GDSLayers.parseLayerString(gdsV);
                    if (numbers == null) {
                        System.out.println("Warning in technology " + this.tech.techName + ": cannot parse gds string '" + gdsV + "' for layer name in gds section '" + layerN + "' (line " + this.locator.getLineNumber() + "). Skipping gds declaration.");
                        break;
                    }
                    String previousDef = this.curFoundry.layerGds.get(layerN);
                    if (previousDef != null) {
                        System.out.println("Warning in technology " + this.tech.techName + ": previous GDS definition '" + previousDef + "' for layer " + layerN + " is being overwritten by new value '" + gdsV + "' (line " + this.locator.getLineNumber() + ")");
                    }
                    this.curFoundry.layerGds.put(layerN, gdsV);
                    break;
                }
                case LayerRule: 
                case LayersRule: 
                case NodeLayersRule: 
                case NodeRule: {
                    if (this.curLayerNamesList == null) {
                        this.curLayerNamesList = this.tech.getLayerNames();
                    }
                    if (this.curNodeNamesList == null) {
                        this.curNodeNamesList = this.tech.getNodeNames();
                    }
                    if (DRCTemplate.parseXmlElement(this.curFoundry.rules, this.curLayerNamesList, this.curNodeNamesList, key.name(), attributes, localName)) break;
                    System.out.println("Warning in technology " + this.tech.techName + ": cannot find layer name in DRC rule '" + key.name() + "' (line " + this.locator.getLineNumber() + ")");
                    break;
                }
                default: {
                    assert (key.hasText);
                    this.beginCharacters();
                    return;
                }
            }
            assert (!key.hasText);
            if (dump) {
                System.out.println("startElement uri=" + uri + " localName=" + localName + " qName=" + qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    System.out.println("\tattribute " + i + " uri=" + attributes.getURI(i) + " localName=" + attributes.getLocalName(i) + " QName=" + attributes.getQName(i) + " type=" + attributes.getType(i) + " value=<" + attributes.getValue(i) + ">");
                }
            }
        }

        private double da_(String attrName, double defaultValue) {
            String s2 = this.a_(attrName);
            return s2 != null ? Double.parseDouble(s2) : defaultValue;
        }

        private String a(String attrName) {
            String v = this.attributes.getValue(attrName);
            return v;
        }

        private String a_(String attrName) {
            String v = this.attributes.getValue(attrName);
            if (v == null) {
                return null;
            }
            return v;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XmlKeyword key = (XmlKeyword)((Object)xmlKeywords.get(localName));
            if (key.hasText) {
                String text = this.endCharacters();
                switch (key) {
                    case shortName: {
                        this.tech.shortTechName = text;
                        break;
                    }
                    case description: {
                        this.tech.description = text;
                        break;
                    }
                    case r: {
                        this.curR = Integer.parseInt(text);
                        break;
                    }
                    case g: {
                        this.curG = Integer.parseInt(text);
                        break;
                    }
                    case b: {
                        this.curB = Integer.parseInt(text);
                        break;
                    }
                    case patternedOnDisplay: {
                        this.patternedOnDisplay = Boolean.parseBoolean(text);
                        break;
                    }
                    case patternedOnPrinter: {
                        this.patternedOnPrinter = Boolean.parseBoolean(text);
                        break;
                    }
                    case pattern: {
                        int p = 0;
                        assert (text.length() == 16);
                        for (int j = 0; j < text.length(); ++j) {
                            if (text.charAt(text.length() - j - 1) == ' ') continue;
                            p |= 1 << j;
                        }
                        this.pattern[this.curPatternIndex++] = p;
                        break;
                    }
                    case outlined: {
                        this.outline = EGraphics.Outline.valueOf(text);
                        break;
                    }
                    case opacity: {
                        this.opacity = Double.parseDouble(text);
                        break;
                    }
                    case foreground: {
                        this.foreground = Boolean.parseBoolean(text);
                        break;
                    }
                    case oldName: {
                        if (this.curLayer != null) {
                            this.curLayer.pureLayerNode.oldName = text;
                            break;
                        }
                        if (this.curArc != null) {
                            this.curArc.oldName = text;
                            break;
                        }
                        this.curNode.oldName = text;
                        break;
                    }
                    case extended: {
                        this.curArc.extended = Boolean.parseBoolean(text);
                        break;
                    }
                    case fixedAngle: {
                        this.curArc.fixedAngle = Boolean.parseBoolean(text);
                        break;
                    }
                    case angleIncrement: {
                        this.curArc.angleIncrement = Integer.parseInt(text);
                        break;
                    }
                    case antennaRatio: {
                        this.curArc.antennaRatio = Double.parseDouble(text);
                        break;
                    }
                    case portTopology: {
                        this.curPort.portTopology = Integer.parseInt(text);
                        break;
                    }
                    case portArc: {
                        if (this.curLayer != null && this.curLayer.pureLayerNode != null) {
                            this.curLayer.pureLayerNode.portArcs.add(text);
                        }
                        if (this.curPort == null) break;
                        if (this.tech.findArc(text) == null) {
                            System.out.println("Error in technology " + this.tech.techName + ": cannot find layer '" + text + "' as portArc in node '" + this.curNode.name + "'");
                            break;
                        }
                        this.curPort.portArcs.add(text);
                        break;
                    }
                    case specialValue: {
                        this.curNodeGroup.specialValues[this.curSpecialValueIndex++] = Double.parseDouble(text);
                        break;
                    }
                    case menuArc: {
                        ArcProto ap = this.tech.findArc(text);
                        if (ap == null) {
                            System.out.println("Warning in technology " + this.tech.techName + ": cannot find arc '" + text + "' for component menu");
                            break;
                        }
                        this.curMenuBox.add(ap);
                        break;
                    }
                    case menuNode: {
                        PrimitiveNode np = this.tech.findNode(text);
                        if (np == null) {
                            System.out.println("Warning in technology " + this.tech.techName + ": cannot find node '" + text + "' for component menu");
                            break;
                        }
                        this.curMenuBox.add(np);
                        break;
                    }
                    case menuText: {
                        this.curMenuBox.add(text);
                        break;
                    }
                    case lambda: {
                        this.curDistance.addLambda(Double.parseDouble(text));
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                return;
            }
            switch (key) {
                case technology: {
                    break;
                }
                case transparentLayer: {
                    while (this.curTransparent > this.tech.transparentLayers.size()) {
                        this.tech.transparentLayers.add(null);
                    }
                    Color oldColor = this.tech.transparentLayers.set(this.curTransparent - 1, new Color(this.curR, this.curG, this.curB));
                    assert (oldColor == null);
                    break;
                }
                case layer: {
                    assert (this.curPatternIndex == 0 || this.curPatternIndex == this.pattern.length);
                    this.curLayer.desc = new EGraphics(this.patternedOnDisplay, this.patternedOnPrinter, this.outline, this.curTransparent, this.curR, this.curG, this.curB, this.opacity, this.foreground, (int[])this.pattern.clone(), this.transparencyMode, this.transparencyFactor);
                    if (this.tech.findLayer(this.curLayer.name) != null) {
                        System.out.println("Error: layer '" + this.curLayer.name + "' already defined");
                    }
                    assert (this.tech.findLayer(this.curLayer.name) == null);
                    this.tech.layers.add(this.curLayer);
                    this.curLayer = null;
                    break;
                }
                case arcProto: {
                    this.tech.arcs.add(this.curArc);
                    this.curArc = null;
                    break;
                }
                case primitiveNodeGroup: {
                    this.fixNodeBase();
                    this.tech.nodeGroups.add(this.curNodeGroup);
                    this.curNodeGroup = null;
                    this.curNode = null;
                    break;
                }
                case primitiveNode: {
                    if (this.curNodeGroup.isSingleton) {
                        this.fixNodeBase();
                        this.tech.nodeGroups.add(this.curNodeGroup);
                        this.curNodeGroup = null;
                        this.curNode = null;
                        break;
                    }
                    if (this.curNodeLayer != null) break;
                    assert (!this.curNodeGroup.isSingleton);
                    this.curNode = null;
                    break;
                }
                case nodeLayer: {
                    if (this.curNodeLayer == null) break;
                    this.curNodeGroup.nodeLayers.add(this.curNodeLayer);
                    this.curNodeLayer = null;
                    break;
                }
                case primitivePort: {
                    this.curNodeGroup.ports.add(this.curPort);
                    this.curPort = null;
                    break;
                }
                case menuNodeInst: {
                    this.curMenuBox.add(this.curMenuNodeInst);
                    this.curMenuNodeInst = null;
                    break;
                }
                case version: 
                case numMetals: 
                case scale: 
                case resolution: 
                case defaultFoundry: 
                case minResistance: 
                case minCapacitance: 
                case logicalEffort: 
                case transparentColor: 
                case opaqueColor: 
                case display3D: 
                case cifLayer: 
                case skillLayer: 
                case parasitics: 
                case pureLayerNode: 
                case wipable: 
                case curvable: 
                case special: 
                case notUsed: 
                case skipSizeInPalette: 
                case diskOffset: 
                case defaultWidth: 
                case arcLayer: 
                case inNodes: 
                case shrinkArcs: 
                case square: 
                case canBeZeroSize: 
                case wipes: 
                case lockable: 
                case edgeSelect: 
                case lowVt: 
                case highVt: 
                case nativeBit: 
                case curvePin: 
                case od18: 
                case od25: 
                case od33: 
                case defaultHeight: 
                case nodeBase: 
                case sizeOffset: 
                case protection: 
                case box: 
                case points: 
                case multicutbox: 
                case serpbox: 
                case lambdaBox: 
                case techPoint: 
                case portAngle: 
                case polygonal: 
                case serpTrans: 
                case minSizeRule: 
                case spiceTemplate: 
                case spiceHeader: 
                case spiceLine: 
                case menuPalette: 
                case menuBox: 
                case menuNodeText: 
                case Foundry: 
                case layerGds: 
                case LayerRule: 
                case LayersRule: 
                case NodeLayersRule: 
                case NodeRule: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void fixNodeBase() {
            double ly;
            double hy;
            double lx;
            double hx;
            if (this.curNodeGroupHasNodeBase) {
                return;
            }
            if (this.curNodeGroup.nodeSizeRule != null) {
                hx = 0.5 * this.curNodeGroup.nodeSizeRule.width;
                lx = -hx;
                hy = 0.5 * this.curNodeGroup.nodeSizeRule.height;
                ly = -hy;
            } else {
                lx = Double.POSITIVE_INFINITY;
                hx = Double.NEGATIVE_INFINITY;
                ly = Double.POSITIVE_INFINITY;
                hy = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < this.curNodeGroup.nodeLayers.size(); ++i) {
                    double y;
                    double x;
                    NodeLayer nl = this.curNodeGroup.nodeLayers.get(i);
                    if (nl.representation == 1 || nl.representation == 3) {
                        x = nl.lx.value;
                        lx = Math.min(lx, x);
                        hx = Math.max(hx, x);
                        x = nl.hx.value;
                        lx = Math.min(lx, x);
                        hx = Math.max(hx, x);
                        y = nl.ly.value;
                        ly = Math.min(ly, y);
                        hy = Math.max(hy, y);
                        y = nl.hy.value;
                        ly = Math.min(ly, y);
                        hy = Math.max(hy, y);
                        continue;
                    }
                    for (Technology.TechPoint p : nl.techPoints) {
                        x = p.getX().getAdder().getLambda();
                        lx = Math.min(lx, x);
                        hx = Math.max(hx, x);
                        y = p.getY().getAdder().getLambda();
                        ly = Math.min(ly, y);
                        hy = Math.max(hy, y);
                    }
                }
            }
            this.curNodeGroup.baseLX.value = DBMath.round(lx + this.curNodeGroup.baseLX.value);
            this.curNodeGroup.baseHX.value = DBMath.round(hx + this.curNodeGroup.baseHX.value);
            this.curNodeGroup.baseLY.value = DBMath.round(ly + this.curNodeGroup.baseLY.value);
            this.curNodeGroup.baseHY.value = DBMath.round(hy + this.curNodeGroup.baseHY.value);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.acceptCharacters) {
                this.charBuffer.append(ch, start, length);
            } else {
                int i;
                boolean nonBlank = false;
                for (i = 0; i < length; ++i) {
                    char c = ch[start + i];
                    nonBlank = nonBlank || c != ' ' && c != '\n' && c != '\t';
                }
                if (nonBlank) {
                    System.out.print("characters size=" + ch.length + " start=" + start + " length=" + length + " {");
                    for (i = 0; i < length; ++i) {
                        System.out.print(ch[start + i]);
                    }
                    System.out.println("}");
                }
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            System.out.println("warning publicId=" + e.getPublicId() + " systemId=" + e.getSystemId() + " line=" + e.getLineNumber() + " column=" + e.getColumnNumber() + " message=" + e.getMessage() + " exception=" + e.getException());
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }

    private static enum XmlKeyword {
        technology,
        shortName(true),
        description(true),
        version,
        numMetals,
        scale,
        resolution,
        defaultFoundry,
        minResistance,
        minCapacitance,
        logicalEffort,
        transparentLayer,
        r(true),
        g(true),
        b(true),
        layer,
        transparentColor,
        opaqueColor,
        patternedOnDisplay(true),
        patternedOnPrinter(true),
        pattern(true),
        outlined(true),
        opacity(true),
        foreground(true),
        display3D,
        cifLayer,
        skillLayer,
        parasitics,
        pureLayerNode,
        arcProto,
        oldName(true),
        wipable,
        curvable,
        special,
        notUsed,
        skipSizeInPalette,
        extended(true),
        fixedAngle(true),
        angleIncrement(true),
        antennaRatio(true),
        diskOffset,
        defaultWidth,
        arcLayer,
        primitiveNodeGroup,
        inNodes,
        primitiveNode,
        shrinkArcs,
        square,
        canBeZeroSize,
        wipes,
        lockable,
        edgeSelect,
        lowVt,
        highVt,
        nativeBit,
        od18,
        od25,
        od33,
        defaultHeight,
        nodeBase,
        sizeOffset,
        nodeLayer,
        box,
        multicutbox,
        serpbox,
        lambdaBox,
        points,
        techPoint,
        primitivePort,
        portAngle,
        portTopology(true),
        portArc(true),
        polygonal,
        serpTrans,
        specialValue(true),
        protection,
        minSizeRule,
        spiceTemplate,
        spiceHeader,
        spiceLine,
        menuPalette,
        menuBox,
        menuArc(true),
        menuNode(true),
        menuText(true),
        menuNodeInst,
        menuNodeText,
        lambda(true),
        Foundry,
        layerGds,
        LayerRule,
        LayersRule,
        NodeLayersRule,
        NodeRule,
        partialCircle,
        curvePin;

        private final boolean hasText;

        private XmlKeyword() {
            this.hasText = false;
        }

        private XmlKeyword(boolean hasText) {
            this.hasText = hasText;
        }
    }

    public static class Foundry
    implements Serializable {
        public String name;
        public final Map<String, String> layerGds = new LinkedHashMap<String, String>();
        public final List<DRCTemplate> rules = new ArrayList<DRCTemplate>();
    }

    public static class Distance
    implements Serializable {
        public double k;
        public double value;

        public void addLambda(double lambdaValue) {
            this.value += lambdaValue;
        }
    }

    public static class MenuNodeInst
    implements Serializable {
        public String protoName;
        public PrimitiveNode.Function function;
        public int techBits;
        public String text;
        public int rotation;
        public int partialCircle;
    }

    public static class MenuPalette
    implements Serializable {
        public int numColumns;
        public List<List<?>> menuBoxes = new ArrayList();

        public String writeXml() {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            OneLineWriter writer = new OneLineWriter(out);
            writer.writeMenuPaletteXml(this);
            out.close();
            return sw.getBuffer().toString();
        }
    }

    public static class SpiceHeader
    implements Serializable {
        public int level;
        public final List<String> spiceLines = new ArrayList<String>();
    }

    public static class PrimitivePort
    implements Serializable {
        public String name;
        public int portAngle;
        public int portRange;
        public int portTopology;
        public final Distance lx = new Distance();
        public final Distance hx = new Distance();
        public final Distance ly = new Distance();
        public final Distance hy = new Distance();
        public final List<String> portArcs = new ArrayList<String>();
    }

    public static class NodeSizeRule
    implements Serializable {
        public double width;
        public double height;
        public String rule;
    }

    public static class NodeLayer
    implements Serializable {
        public String layer;
        public BitSet inNodes;
        public Poly.Type style;
        public int portNum;
        public boolean inLayers;
        public boolean inElectricalLayers;
        public int representation;
        public final Distance lx = new Distance();
        public final Distance hx = new Distance();
        public final Distance ly = new Distance();
        public final Distance hy = new Distance();
        public final List<Technology.TechPoint> techPoints = new ArrayList<Technology.TechPoint>();
        public double sizex;
        public double sizey;
        public double sep1d;
        public double sep2d;
        public double lWidth;
        public double rWidth;
        public double tExtent;
        public double bExtent;
        private String message;
        private double relSize;

        public String getMessage() {
            return this.message;
        }

        public double getRelSize() {
            return this.relSize;
        }
    }

    public static enum ProtectionType {
        both,
        left,
        right,
        none;

    }

    public static class PrimitiveNodeGroup
    implements Serializable {
        public boolean isSingleton;
        public final List<PrimitiveNode> nodes = new ArrayList<PrimitiveNode>();
        public boolean shrinkArcs;
        public boolean partialCircle;
        public boolean square;
        public boolean canBeZeroSize;
        public boolean wipes;
        public boolean lockable;
        public boolean edgeSelect;
        public boolean skipSizeInPalette;
        public boolean notUsed;
        public final Map<Integer, EPoint> diskOffset = new TreeMap<Integer, EPoint>();
        public final Distance defaultWidth = new Distance();
        public final Distance defaultHeight = new Distance();
        public final Distance baseLX = new Distance();
        public final Distance baseHX = new Distance();
        public final Distance baseLY = new Distance();
        public final Distance baseHY = new Distance();
        public ProtectionType protection;
        public final List<NodeLayer> nodeLayers = new ArrayList<NodeLayer>();
        public final List<PrimitivePort> ports = new ArrayList<PrimitivePort>();
        public int specialType;
        public double[] specialValues;
        public NodeSizeRule nodeSizeRule;
        public String spiceTemplate;
    }

    public static class PrimitiveNode
    implements Serializable {
        public String name;
        public PrimitiveNode.Function function;
        public String oldName;
        public boolean lowVt;
        public boolean highVt;
        public boolean nativeBit;
        public boolean od18;
        public boolean od25;
        public boolean od33;
        public boolean curvePin;
    }

    public static class ArcLayer
    implements Serializable {
        public String layer;
        public final Distance extend = new Distance();
        public Poly.Type style;
    }

    public static class ArcProto
    implements Serializable {
        public String name;
        public String oldName;
        public ArcProto.Function function;
        public boolean wipable;
        public boolean curvable;
        public boolean special;
        public boolean notUsed;
        public boolean skipSizeInPalette;
        public final Map<Integer, Double> diskOffset = new TreeMap<Integer, Double>();
        public final Distance defaultWidth = new Distance();
        public boolean extended;
        public boolean fixedAngle;
        public int angleIncrement;
        public double antennaRatio;
        public final List<ArcLayer> arcLayers = new ArrayList<ArcLayer>();
    }

    public static class PureLayerNode
    implements Serializable {
        public String name;
        public String oldName;
        public Poly.Type style;
        public String port;
        public final Distance size = new Distance();
        public final List<String> portArcs = new ArrayList<String>();
    }

    public static class Layer
    implements Serializable {
        public String name;
        public Layer.Function function;
        public int extraFunction;
        public EGraphics desc;
        public double thick3D;
        public double height3D;
        public String cif;
        public String skill;
        public double resistance;
        public double capacitance;
        public double edgeCapacitance;
        public PureLayerNode pureLayerNode;
    }

    public static class Version
    implements Serializable {
        public int techVersion;
        public com.sun.electric.database.text.Version electricVersion;
    }

    public static class Technology
    implements Serializable {
        public String techName;
        public String className;
        public String shortTechName;
        public String description;
        public final List<Version> versions = new ArrayList<Version>();
        public int minNumMetals;
        public int maxNumMetals;
        public int defaultNumMetals;
        public double scaleValue;
        public double resolutionValue;
        public boolean scaleRelevant;
        public String defaultFoundry;
        public double minResistance;
        public double minCapacitance;
        public double leGateCapacitance = 0.4;
        public double leWireRatio = 0.16;
        public double leDiffAlpha = 0.7;
        public final List<Color> transparentLayers = new ArrayList<Color>();
        public final List<Layer> layers = new ArrayList<Layer>();
        public final List<ArcProto> arcs = new ArrayList<ArcProto>();
        public final List<PrimitiveNodeGroup> nodeGroups = new ArrayList<PrimitiveNodeGroup>();
        private final List<PrimitiveNode> pureLayerNodes = new ArrayList<PrimitiveNode>();
        public final List<SpiceHeader> spiceHeaders = new ArrayList<SpiceHeader>();
        public MenuPalette menuPalette;
        public final List<Foundry> foundries = new ArrayList<Foundry>();

        public Layer findLayer(String name) {
            for (Layer layer : this.layers) {
                if (!layer.name.equals(name)) continue;
                return layer;
            }
            return null;
        }

        public Collection<String> getLayerNames() {
            ArrayList<String> l = new ArrayList<String>();
            for (Layer layer : this.layers) {
                l.add(layer.name);
            }
            return l;
        }

        public ArcProto findArc(String name) {
            for (ArcProto arc : this.arcs) {
                if (!arc.name.equals(name)) continue;
                return arc;
            }
            return null;
        }

        public PrimitiveNodeGroup findNodeGroup(String name) {
            for (PrimitiveNodeGroup nodeGroup : this.nodeGroups) {
                for (PrimitiveNode n : nodeGroup.nodes) {
                    if (!n.name.equals(name)) continue;
                    return nodeGroup;
                }
            }
            return null;
        }

        public PrimitiveNode findNode(String name) {
            for (PrimitiveNodeGroup nodeGroup : this.nodeGroups) {
                for (PrimitiveNode n : nodeGroup.nodes) {
                    if (!n.name.equals(name)) continue;
                    return n;
                }
            }
            for (PrimitiveNode n : this.pureLayerNodes) {
                if (!n.name.equals(name)) continue;
                return n;
            }
            return null;
        }

        public Collection<String> getNodeNames() {
            ArrayList<String> l = new ArrayList<String>();
            for (PrimitiveNodeGroup nodeGroup : this.nodeGroups) {
                for (PrimitiveNode n : nodeGroup.nodes) {
                    l.add(n.name);
                }
            }
            return l;
        }

        public PrimitiveNode findPinNode(String arc) {
            for (PrimitiveNodeGroup nodeGroup : this.nodeGroups) {
                boolean foundPort = false;
                for (PrimitivePort p : nodeGroup.ports) {
                    if (!p.portArcs.contains(arc)) continue;
                    foundPort = true;
                    break;
                }
                if (!foundPort) continue;
                for (PrimitiveNode n : nodeGroup.nodes) {
                    if (!n.function.isPin()) continue;
                    return n;
                }
            }
            return null;
        }

        public void writeXml(String fileName) {
            this.writeXml(fileName, true, null);
        }

        public void writeXml(String fileName, boolean includeDateAndVersion, String copyrightMessage) {
            this.writeXml(fileName, includeDateAndVersion, copyrightMessage, null);
        }

        public void writeXml(String fileName, boolean includeDateAndVersion, String copyrightMessage, Map<Object, Map<String, Object>> additionalAttributes) {
            try {
                PrintWriter out = new PrintWriter(fileName);
                Writer writer = new Writer(out);
                writer.writeTechnology(this, includeDateAndVersion, copyrightMessage, additionalAttributes);
                out.close();
                System.out.println("Wrote " + fileName);
                System.out.println(" (Add this file to the 'Added Technologies' Project Preferences to install it in Electric)");
            }
            catch (IOException e) {
                System.out.println("Error creating " + fileName);
            }
        }

        public Technology deepClone() {
            try {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(byteStream);
                out.writeObject(this);
                out.flush();
                byte[] serializedXml = byteStream.toByteArray();
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(serializedXml));
                Technology clone2 = (Technology)in.readObject();
                in.close();
                return clone2;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

