/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.PowerChannel;
import com.sun.electric.tool.simulation.test.Pst3202;

public class Pst3202Channel
extends PowerChannel {
    private final Pst3202 supply;
    private final int channel;

    public Pst3202Channel(String channelName, String supplyName, int channel) {
        Pst3202.checkChannel(channel);
        this.name = channelName + " (" + supplyName + " channel " + channel + ")";
        this.supply = new Pst3202(supplyName);
        this.channel = channel;
        Pst3202Channel.logInit("Initialized Pst3202Channel " + this.name);
    }

    public String getSupplyName() {
        return this.supply.getName();
    }

    public int getChannel() {
        return this.channel;
    }

    @Override
    public String getState() {
        return this.supply.getState(this.channel);
    }

    @Override
    public float readVoltage() {
        this.logOther("Reading voltage on " + this.getName());
        return this.supply.readVoltage(this.channel);
    }

    @Override
    public void setVoltageNoWait(float volts) {
        this.logSet("Pst3202Channel setting voltage on " + this.getName() + " to " + volts + " V");
        if (!this.supply.setVoltage(this.channel, volts)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.supply.setVoltage(this.channel, volts)) {
                Infrastructure.fatal(this.getName() + " power supply error setting voltage " + volts);
            }
        }
    }

    @Override
    public void waitForVoltage(float setVolts) {
        if (this.supply.isDisabled()) {
            return;
        }
        super.waitForVoltage(setVolts);
    }

    @Override
    public float getVoltageSetpoint() {
        this.logOther("Reading voltage setpoint on " + this.getName());
        return this.supply.getVoltageSetpoint(this.channel);
    }

    @Override
    public float getVoltageResolution() {
        this.logOther("Getting voltage resolution on " + this.getName());
        return Pst3202.getVoltageResolution(this.channel);
    }

    @Override
    public float readCurrent() {
        this.logOther("Reading current on " + this.getName());
        return this.supply.readCurrent(this.channel);
    }

    @Override
    public void setCurrent(float amps) {
        this.logSet("Setting current limit on " + this.getName() + " to " + amps);
        this.supply.setCurrent(this.channel, amps);
    }

    @Override
    public float getCurrentSetpoint() {
        this.logOther("Reading current setpoint on " + this.getName());
        return this.supply.getCurrentSetpoint(this.channel);
    }

    public static void main(String[] args) {
        Infrastructure.gpibControllers = new int[]{1};
        Pst3202Channel channel1 = new Pst3202Channel("chan1", "hPst3202", 1);
        Pst3202Channel channel2 = new Pst3202Channel("chan2", "hPst3202", 2);
        Pst3202Channel channel3 = new Pst3202Channel("chan3", "hPst3202", 3);
        System.out.println("Voltage setpoints: " + channel1.getVoltageSetpoint() + ", " + channel2.getVoltageSetpoint() + ", " + channel3.getVoltageSetpoint());
        System.out.println("Voltages read: " + channel1.readVoltage() + ", " + channel2.readVoltage() + ", " + channel3.readVoltage());
        System.out.println("Current limits: " + channel1.getCurrentSetpoint() + ", " + channel2.getCurrentSetpoint() + ", " + channel3.getCurrentSetpoint());
        System.out.println("Currents read: " + channel1.readCurrent() + ", " + channel2.readCurrent() + ", " + channel3.readCurrent());
        channel3.setCurrent(2.0f);
        System.out.println("Chan 1 resolution: " + channel1.getVoltageResolution() + " V");
        System.out.println("Chan 2 resolution: " + channel2.getVoltageResolution() + " V");
        System.out.println("Chan 3 resolution: " + channel3.getVoltageResolution() + " V");
    }
}

