/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.router;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.flag.Utils;
import com.sun.electric.tool.generator.flag.router.Segment;
import com.sun.electric.tool.generator.flag.router.Track;
import java.util.ArrayList;
import java.util.List;

public class Channel
implements Comparable<Channel> {
    private static final double METAL_WIDE_SPACE = 4.0;
    private static final double METAL_SPACE = 3.0;
    private static final double METAL_WIDTH = 3.0;
    private static final double METAL_PITCH = 6.0;
    private final boolean horizontal;
    private final List<Track> tracks = new ArrayList<Track>();
    private final double minL;
    private final double maxL;
    private final double minW;
    private final double maxW;
    private final String description;

    private static void prln(String msg) {
        Utils.prln(msg);
    }

    public Channel(boolean horizontal, double l1, double l2, double w1, double w2, String description) {
        this.horizontal = horizontal;
        this.minL = Math.min(l1, l2);
        this.maxL = Math.max(l1, l2);
        this.minW = Math.min(w1, w2);
        this.maxW = Math.max(w1, w2);
        this.description = description;
        double trackCent = this.minW + 4.0 + 1.5;
        while (trackCent + 1.5 + 4.0 <= this.maxW) {
            int ndx = this.tracks.size();
            this.tracks.add(new Track(trackCent, this, ndx));
            trackCent += 6.0;
        }
    }

    @Override
    public int compareTo(Channel c) {
        double delta = this.minW - c.minW;
        return (int)Math.signum(delta);
    }

    public Segment allocate(double xy1, double xy2, double boundXY1, double boundXY2) {
        double min2 = Math.min(xy1, xy2) - 6.0;
        double max2 = Math.max(xy1, xy2) + 6.0;
        double minBound = Math.min(boundXY1, boundXY2);
        double maxBound = Math.max(boundXY1, boundXY2);
        if (max2 > this.maxL || min2 < this.minL) {
            return null;
        }
        double minCost = Double.MAX_VALUE;
        Track bestTrack = null;
        int nbTracks = this.tracks.size();
        int midNdx = (nbTracks - 1) / 2;
        for (Track t : this.tracks) {
            if (!t.isAvailable(min2, max2)) continue;
            double center = t.getCenter();
            double cost = Math.abs(t.getIndex() - midNdx);
            double c = center - maxBound;
            if (c > 0.0) {
                cost += c * 1000.0;
            }
            if ((c = minBound - center) > 0.0) {
                cost += c * 1000.0;
            }
            if (!(cost < minCost)) continue;
            minCost = cost;
            bestTrack = t;
        }
        if (bestTrack == null) {
            String lDesc = this.isHorizontal() ? "x=" : "y=";
            String wDesc = this.isHorizontal() ? "y=" : "x=";
            Channel.prln("Failed to allocate " + this.description + " segment from " + lDesc + min2 + " to " + lDesc + max2 + " between " + wDesc + this.minW + " and " + wDesc + this.maxW);
            Channel.prln(this.toString());
            return null;
        }
        Segment s = bestTrack.allocate(min2, max2);
        Job.error(s == null, "Impossible: we already checked it's available");
        return s;
    }

    public Segment allocateBiggestFromTrack(double min2, double src, double max2, double trackCenter) {
        for (Track t : this.tracks) {
            double center = t.getCenter();
            if (center != trackCenter) continue;
            return t.allocateBiggest(min2, src, max2);
        }
        return null;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public boolean hasTracks() {
        return this.tracks.size() != 0;
    }

    public String toString() {
        double yMax;
        double xMax;
        double yMin;
        double xMin;
        if (this.horizontal) {
            xMin = this.minL;
            yMin = this.minW;
            xMax = this.maxL;
            yMax = this.maxW;
        } else {
            xMin = this.minW;
            yMin = this.minL;
            xMax = this.maxW;
            yMax = this.maxL;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.horizontal ? "  Horizontal" : "  Vertical");
        sb.append(" channel bounds: (");
        sb.append(xMin + ", " + yMin + ") (");
        sb.append(xMax + ", " + yMax + ") ");
        sb.append(" Tracks:\n");
        for (Track t : this.tracks) {
            sb.append(t.toString());
        }
        return sb.toString();
    }

    public double getMinTrackCenter() {
        return this.tracks.get(0).getCenter();
    }

    public double getMaxTrackCenter() {
        return this.tracks.get(this.tracks.size() - 1).getCenter();
    }

    public double getMinTrackEnd() {
        return this.minL;
    }

    public double getMaxTrackEnd() {
        return this.maxL;
    }
}

