/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.verilog;

import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.verilog.VerilogData;
import com.sun.electric.tool.user.ViewChanges;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerilogReader
extends Input {
    List<NodeInst> transistors = new ArrayList<NodeInst>();
    double maxWidth = 100.0;
    double nodeWidth = 10.0;
    double primitiveHeight = 0.5;
    double primitiveWidth = 0.5;
    Map<Cell, Point2D.Double> locationMap = new HashMap<Cell, Point2D.Double>();
    PrimitiveNode essentialBounds = Generic.tech().findNodeProto("Essential-Bounds");
    Cell topCell = null;
    Map<String, NodeInst> pinsMap = new HashMap<String, NodeInst>();
    private String typicalSkipStrings = "\t\\";
    private VerilogPreferences localPrefs;

    public VerilogReader(VerilogPreferences ap) {
        this.localPrefs = ap;
    }

    private String readCellHeader(List<String> inputs) throws IOException {
        block0: while (true) {
            String key = this.getAKeyword();
            StringTokenizer parse = new StringTokenizer(key, "( ),\t", false);
            while (true) {
                if (!parse.hasMoreTokens()) continue block0;
                String value = parse.nextToken();
                if (value.equals(";")) {
                    return null;
                }
                inputs.add(value);
            }
            break;
        }
    }

    private NodeInst readSupply(VerilogData.VerilogModule module, boolean power, String name) {
        VerilogData.VerilogPort supply = module.addPort(name, false);
        supply.type = power ? PortCharacteristic.PWR : PortCharacteristic.GND;
        return null;
    }

    private CellInstance readInstance(VerilogData.VerilogModule module, VerilogData.VerilogModule element) throws IOException {
        StringBuffer signature = new StringBuffer();
        ArrayList<String> exports = new ArrayList<String>();
        ArrayList<String> pins = new ArrayList<String>();
        while (true) {
            String key;
            if ((key = this.getRestOfLine()).contains("//")) {
                continue;
            }
            signature.append(key);
            if (key.contains(";")) break;
        }
        String line = signature.toString();
        int index = line.indexOf("(");
        String instanceName = element.getName() + "-instance";
        assert (index > -1);
        if (index > 0) {
            instanceName = line.substring(0, index);
        }
        line = line.substring(index + 1, line.length());
        StringTokenizer parse = new StringTokenizer(line, ")", false);
        exports.clear();
        pins.clear();
        while (parse.hasMoreTokens()) {
            String value = parse.nextToken();
            index = (value = value.replaceAll(" ", "")).indexOf(".");
            if (index == -1) continue;
            int index2 = value.indexOf("(");
            assert (index2 != -1);
            String n = value.substring(index + 1, index2);
            n = TextUtils.correctName(n, false, true);
            exports.add(n);
            n = value.substring(index2 + 1);
            n = TextUtils.correctName(n, false, false);
            if (n.contains(" ")) assert (false);
            pins.add(n);
        }
        instanceName = TextUtils.correctName(instanceName, false, true);
        instanceName = instanceName.replaceAll(" ", "");
        CellInstance localCell = new CellInstance(instanceName);
        VerilogData.VerilogInstance verilogInst = null;
        verilogInst = module.addInstance(instanceName, element);
        for (int i = 0; i < exports.size(); ++i) {
            String export = (String)exports.get(i);
            String pin = (String)pins.get(i);
            pin = pin.replaceAll(" ", "");
            VerilogData.VerilogPort exp = element.findPort(export = export.replaceAll(" ", ""));
            if (exp == null) {
                exp = element.addPort(export, false);
            }
            verilogInst.addPortInstance(pin, exp);
        }
        return localCell;
    }

    private String readWiresAndSupplies(VerilogData.VerilogModule module, boolean readWires, boolean power) throws IOException {
        ArrayList<String> values = new ArrayList<String>(2);
        block0: while (true) {
            String input = this.getRestOfLine();
            StringTokenizer parse = new StringTokenizer(input, ",;", true);
            while (true) {
                StringTokenizer p;
                if (!parse.hasMoreTokens()) continue block0;
                String net = parse.nextToken();
                if (net.equals(",")) continue;
                if (net.equals(";")) {
                    return null;
                }
                if (readWires) {
                    p = new StringTokenizer(net, this.typicalSkipStrings + " ", false);
                    values.clear();
                    while (p.hasMoreTokens()) {
                        values.add(p.nextToken());
                    }
                    int size = values.size();
                    if (size == 0) continue;
                    assert (size == 1 || size == 2);
                    PrimitiveNode primitive = Schematics.tech().wirePinNode;
                    String pinName = (String)values.get(size - 1);
                    int[] vals = new int[]{0, 0};
                    int count = 0;
                    if (values.size() == 2) {
                        p = new StringTokenizer((String)values.get(0), "[:]", false);
                        while (p.hasMoreTokens()) {
                            String s = p.nextToken();
                            if (!TextUtils.isANumber(s)) continue;
                            vals[count++] = Integer.parseInt(s);
                        }
                        if (count == 2 && vals[0] != vals[1]) {
                            primitive = Schematics.tech().busPinNode;
                        } else {
                            System.out.println(net + " is not a bus wire");
                        }
                    }
                    pinName = TextUtils.correctName(pinName, false, true);
                    module.addWire(pinName, values.size() == 2 ? (String)values.get(0) : null);
                    continue;
                }
                p = new StringTokenizer(net, "\t ", false);
                String name = p.nextToken();
                name = TextUtils.correctName(name, false, true);
                this.readSupply(module, power, name);
            }
            break;
        }
    }

    private void ignoreUntilEndOfStatement(String endString) throws IOException {
        String input;
        String key = endString != null ? endString : ";";
        do {
            input = this.getRestOfLine();
            if (endString != null || !input.contains("begin")) continue;
            key = "end";
        } while (!input.contains(key));
    }

    private String readInputOutput(VerilogData.VerilogModule module, PortCharacteristic portType) throws IOException {
        block0: while (true) {
            String input = this.getRestOfLine();
            StringTokenizer parse = new StringTokenizer(input, ";,", true);
            while (true) {
                if (!parse.hasMoreTokens()) continue block0;
                String net = parse.nextToken();
                if (net.equals(",")) continue;
                if (net.equals(";")) {
                    return null;
                }
                StringTokenizer p = new StringTokenizer(net, " \t", false);
                ArrayList<String> l = new ArrayList<String>(2);
                while (p.hasMoreTokens()) {
                    String name = p.nextToken();
                    l.add(name);
                }
                PrimitiveNode primitive = Schematics.tech().wirePinNode;
                int size = l.size();
                if (size == 0) continue;
                assert (size == 1 || size == 2);
                String name = (String)l.get(size - 1);
                if (l.size() == 2) {
                    primitive = Schematics.tech().busPinNode;
                }
                VerilogData.VerilogPort export = module.findPort(name);
                if (Job.getDebug()) assert (export != null);
                if (export == null) continue;
                if (export.type != PortCharacteristic.UNKNOWN && export.type != portType) {
                    System.out.println("Inconsistency in asigning port type in " + name + ". Found " + (Object)((Object)portType) + " and was " + (Object)((Object)export.type));
                }
                export.type = portType;
                if (l.size() != 2) continue;
                export.setBusInformation((String)l.get(0));
            }
            break;
        }
    }

    private String readCell(VerilogData verilogData, boolean primitive) throws IOException {
        ArrayList<String> inputs = new ArrayList<String>(10);
        this.readCellHeader(inputs);
        String cellName = (String)inputs.get(0);
        VerilogData.VerilogModule module = null;
        Cell cell = null;
        module = verilogData.getModule(cellName);
        if (module == null) {
            module = verilogData.addModule(cellName, primitive);
        }
        module.setValid(true);
        for (int i = 1; i < inputs.size(); ++i) {
            module.addPort((String)inputs.get(i), true);
        }
        String nextToken = null;
        while (true) {
            String key = null;
            if (nextToken != null) {
                key = nextToken;
                nextToken = null;
            } else {
                key = this.getAKeyword();
            }
            if (key.startsWith("/")) {
                this.getRestOfLine();
                continue;
            }
            if (key.startsWith("endmodule") || key.startsWith("endprimitive")) {
                return null;
            }
            if (key.equals("wire")) {
                this.readWiresAndSupplies(module, true, false);
                continue;
            }
            if (key.startsWith("tri")) assert (false);
            if (key.equals("input")) {
                this.readInputOutput(module, PortCharacteristic.IN);
                continue;
            }
            if (key.equals("output")) {
                this.readInputOutput(module, PortCharacteristic.OUT);
                continue;
            }
            if (key.equals("inout")) {
                this.readInputOutput(module, PortCharacteristic.BIDIR);
                continue;
            }
            if (key.startsWith("supply")) {
                boolean power = key.contains("supply1");
                this.readWiresAndSupplies(module, false, power);
                continue;
            }
            if (key.equals("assign") || key.startsWith("always") || key.startsWith("initial") || key.startsWith("reg") || key.startsWith("table") || key.startsWith("specify")) {
                if (Job.getDebug()) {
                    System.out.println("Ignoring " + key);
                }
                String endStatement = null;
                if (key.startsWith("table")) {
                    endStatement = "endtable";
                } else if (key.startsWith("specify")) {
                    endStatement = "endspecify";
                }
                this.ignoreUntilEndOfStatement(endStatement);
                continue;
            }
            if (key.equals("tranif1")) {
                assert (false);
                nextToken = this.readGate(cell, PrimitiveNode.Function.TRANMOS);
                continue;
            }
            if (key.equals("tranif0")) {
                assert (false);
                nextToken = this.readGate(cell, PrimitiveNode.Function.TRAPMOS);
                continue;
            }
            VerilogData.VerilogModule element = verilogData.getModule(key);
            if (element == null) {
                element = verilogData.addModule(key, false);
            }
            this.readInstance(module, element);
        }
    }

    private Point2D.Double getNextLocation(Cell cell) {
        Point2D.Double point = this.locationMap.get(cell);
        double xPos = 0.0;
        double yPos = 0.0;
        if (point != null) {
            xPos = point.getX();
            yPos = point.getY();
        }
        double x = xPos * this.nodeWidth;
        double y = yPos * this.nodeWidth;
        Point2D.Double p = new Point2D.Double(x, y);
        if (x > this.maxWidth) {
            yPos += 1.0;
            xPos = 0.0;
        } else {
            xPos += 1.0;
        }
        point = new Point2D.Double(xPos, yPos);
        this.locationMap.put(cell, point);
        return p;
    }

    private String readGate(Cell cell, PrimitiveNode.Function function) throws IOException {
        String input = this.getRestOfLine();
        StringTokenizer parse = new StringTokenizer(input, "(;, \t)", false);
        ArrayList<String> list = new ArrayList<String>(2);
        while (parse.hasMoreTokens()) {
            String value = parse.nextToken();
            list.add(value);
        }
        Orientation orient = Orientation.fromAngle(900);
        double width = Schematics.tech().transistorNode.getDefWidth();
        double height = Schematics.tech().transistorNode.getDefHeight();
        Point2D.Double p = this.getNextLocation(cell);
        NodeInst ni = NodeInst.newInstance(Schematics.tech().transistorNode, p, width, height, cell, orient, null);
        Schematics.tech().transistorNode.getTechnology().setPrimitiveFunction(ni, function);
        this.transistors.add(ni);
        PortInst[] ports = new PortInst[3];
        int count = 0;
        Iterator<PortInst> it = ni.getPortInsts();
        while (it.hasNext()) {
            ports[count++] = it.next();
        }
        for (int i = 1; i < list.size(); ++i) {
            String name = (String)list.get(i);
            int pos = (3 + i) % 3;
            double posX = ((Point2D)p).getX();
            double posY = ((Point2D)p).getY();
            switch (pos) {
                case 0: {
                    posX -= width / 2.0;
                    break;
                }
                case 1: {
                    posX += width / 2.0;
                    posY -= height / 2.0;
                    break;
                }
                case 2: {
                    posX += width / 2.0;
                    posY += height / 2.0;
                }
            }
            PrimitiveNode primitive = Schematics.tech().wirePinNode;
            ni = NodeInst.newInstance(primitive, new Point2D.Double(posX, posY), this.primitiveWidth, this.primitiveHeight, cell, Orientation.IDENT, null);
            ArcInst.makeInstanceBase(Schematics.tech().wire_arc, 0.0, ni.getOnlyPortInst(), ports[pos], null, null, name);
        }
        return null;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        this.initKeywordParsing();
        boolean fullOyster = true;
        VerilogData verilogData = this.parseVerilogInternal(lib.getName(), fullOyster);
        Cell topCell = this.buildCells(verilogData, lib, fullOyster);
        return topCell != null ? lib : null;
    }

    public VerilogData parseVerilog(String[] lines, String verilogName) {
        if (this.openStringsInput(lines)) {
            System.out.println("Cannot open string set " + verilogName + " as Verilog");
            return null;
        }
        System.out.println("Reading Verilog format " + verilogName);
        this.initKeywordParsing();
        VerilogReader.setProgressValue(0);
        VerilogReader.setProgressNote("Reading Verilog format " + verilogName);
        VerilogData verilogData = this.parseVerilogInternal(verilogName, true);
        System.out.println("Verilog format " + verilogName + " read");
        return verilogData;
    }

    public VerilogData parseVerilog(String file, boolean simplifyWires) {
        URL fileURL = TextUtils.makeURLToFile(file);
        if (this.openTextInput(fileURL)) {
            System.out.println("Cannot open the Verilog file: " + file);
            return null;
        }
        System.out.println("Reading Verilog file: " + file);
        this.initKeywordParsing();
        VerilogReader.setProgressValue(0);
        VerilogReader.setProgressNote("Reading Verilog file:" + file);
        VerilogData verilogData = this.parseVerilogInternal(file, simplifyWires);
        System.out.println("Verilog file: " + file + " read");
        return verilogData;
    }

    public Cell createCellsOnly(VerilogData verilogData, Job job) {
        Cell theCell = null;
        Library library = Library.newInstance(verilogData.name, null);
        String topCellName = TextUtils.getFileNameWithoutExtension(verilogData.name);
        this.buildCells(verilogData, library, false);
        theCell = library.findNodeProto(topCellName);
        if (job != null) {
            System.out.println("Accumulative time after creating cells '" + verilogData.name + "' " + job.getInfo());
        }
        return theCell;
    }

    public VerilogData readVerilogOnly(String file, boolean fullOyster, Job job) {
        VerilogData verilogData = this.parseVerilog(file, fullOyster);
        if (verilogData == null) {
            return null;
        }
        if (job != null) {
            System.out.println("Accumulative time before creating cells '" + file + "' " + job.getInfo());
        }
        return verilogData;
    }

    public Cell readVerilog(String testName, String file, boolean createCells, boolean fullOyster, Job job) {
        URL fileURL = TextUtils.makeURLToFile(file);
        VerilogData verilogData = this.parseVerilog(file, fullOyster);
        if (verilogData == null) {
            return null;
        }
        int index = file.lastIndexOf("/");
        String libName = file.substring(index + 1);
        if (job != null) {
            System.out.println("Accumulative time before creating cells '" + testName + "' " + job.getInfo());
        }
        if (createCells) {
            Library library = Library.newInstance(libName, null);
            String topCellName = TextUtils.getFileNameWithoutExtension(fileURL);
            this.topCell = this.buildCells(verilogData, library, fullOyster);
            Cell c = library.findNodeProto(topCellName);
            if (c == null) {
                System.out.println("Check this case in readVerilog");
            } else {
                this.topCell = c;
            }
        }
        if (job != null) {
            System.out.println("Accumulative time after creating cells '" + testName + "' " + job.getInfo());
        }
        return this.topCell;
    }

    private VerilogData parseVerilogInternal(String fileName, boolean simplifyWires) {
        VerilogData verilogData = new VerilogData(fileName);
        try {
            String nextToken = null;
            String key = null;
            while (true) {
                if (nextToken != null) {
                    key = nextToken;
                    nextToken = null;
                } else {
                    key = this.getAKeyword();
                }
                if (key != null) {
                    if (key.startsWith("/")) {
                        this.getRestOfLine();
                        continue;
                    }
                    if (!key.equals("module") && !key.equals("primitive")) continue;
                    boolean primitive = key.equals("primitive");
                    nextToken = this.readCell(verilogData, primitive);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println("ERROR reading Verilog file");
        }
        if (simplifyWires) {
            verilogData.simplifyWires();
        }
        return verilogData;
    }

    private Cell buildCells(VerilogData verilogCell, Library lib, boolean fullOyster) {
        Cell topCell = null;
        for (VerilogData.VerilogModule module : verilogCell.getModules()) {
            Cell cell = this.buildCellFromModule(module, lib, fullOyster);
            if (topCell != null) continue;
            topCell = cell;
        }
        return topCell;
    }

    private void addPins(VerilogData.VerilogConnection port, Cell cell, boolean addExport, boolean fullOyster) {
        PortCharacteristic portType = port.getPortType();
        List<String> pinNames = port.getPinNames(fullOyster);
        Collections.sort(pinNames);
        for (String pinName : pinNames) {
            PrimitiveNode primitive = Schematics.tech().wirePinNode;
            NodeInst ni = cell.findNode(pinName);
            if (ni == null) {
                ni = NodeInst.newInstance(primitive, this.getNextLocation(cell), this.primitiveWidth, this.primitiveHeight, cell, Orientation.IDENT, pinName);
                if (!addExport) continue;
                Export.newInstance(cell, ni.getOnlyPortInst(), pinName, portType);
                continue;
            }
            assert (false);
            System.out.println("Wire/Input/Output " + pinName + " exists");
        }
    }

    private Cell buildCellFromModule(VerilogData.VerilogModule module, Library lib, boolean fullOyster) {
        String cellName = module.name + View.SCHEMATIC.getAbbreviationExtension();
        Cell cell = lib.findNodeProto(cellName);
        if (cell != null) {
            return cell;
        }
        cell = Cell.makeInstance(lib, cellName);
        cell.setTechnology(Schematics.tech());
        List<Object> all = module.getAllSorted();
        for (Object obj : all) {
            if (obj instanceof VerilogData.VerilogWire) {
                VerilogData.VerilogWire wire = (VerilogData.VerilogWire)obj;
                this.addPins(wire, cell, false, fullOyster);
                continue;
            }
            if (!(obj instanceof VerilogData.VerilogPort)) continue;
            VerilogData.VerilogPort port = (VerilogData.VerilogPort)obj;
            String name = port.name;
            PortCharacteristic portType = port.type;
            if (portType == PortCharacteristic.BIDIR || portType == PortCharacteristic.IN || portType == PortCharacteristic.OUT || portType == PortCharacteristic.CLK || portType == PortCharacteristic.UNKNOWN) {
                this.addPins(port, cell, true, fullOyster);
                continue;
            }
            if (portType == PortCharacteristic.PWR || portType == PortCharacteristic.GND) {
                boolean power = portType == PortCharacteristic.PWR;
                PrimitiveNode np = power ? Schematics.tech().powerNode : Schematics.tech().groundNode;
                Point2D.Double p = this.getNextLocation(cell);
                double height = this.primitiveHeight;
                NodeInst supply = NodeInst.newInstance(np, p, this.primitiveWidth, height, cell, Orientation.IDENT, name);
                NodeInst ni = NodeInst.newInstance(Schematics.tech().wirePinNode, new Point2D.Double(p.getX(), p.getY() + height / 2.0), 0.5, 0.5, cell, Orientation.IDENT, name + "@0");
                ArcInst.makeInstanceBase(Schematics.tech().wire_arc, 0.0, ni.getOnlyPortInst(), supply.getOnlyPortInst(), null, null, name);
                Export.newInstance(cell, ni.getOnlyPortInst(), name, portType);
                continue;
            }
            System.out.println("Skipping this characteristic?");
        }
        for (VerilogData.VerilogInstance inst : module.getInstances()) {
            this.buildNodeInstFromModule(inst, lib, cell, fullOyster);
        }
        if (fullOyster) {
            ViewChanges.makeIconViewNoGUI(cell, true, true);
        }
        return cell;
    }

    Cell buildNodeInstFromModule(VerilogData.VerilogInstance inst, Library lib, Cell parent, boolean fullOyster) {
        Cell schematics = this.buildCellFromModule(inst.element, lib, fullOyster);
        Cell icon = fullOyster ? schematics.iconView() : schematics;
        NodeInst cellInst = NodeInst.newInstance(icon, this.getNextLocation(parent), 10.0, 10.0, parent, Orientation.IDENT, inst.name);
        for (VerilogData.VerilogPortInst port : inst.ports) {
            List<String> localPorts = port.getPortNames();
            int startPort = port.port.start;
            int endPort = port.port.end;
            int count = startPort;
            boolean asc = startPort < endPort;
            for (String s : localPorts) {
                int index;
                NodeInst pin = parent.findNode(s);
                if (pin == null && (index = s.indexOf("[")) != -1) {
                    s = s.substring(0, index);
                    pin = parent.findNode(s);
                }
                if (pin == null) {
                    if (Job.getDebug()) {
                        System.out.println("Unknown signal " + s + " in cell " + parent.describe(false));
                    }
                    PrimitiveNode primitive = port.port.isBusConnection() ? Schematics.tech().busPinNode : Schematics.tech().wirePinNode;
                    pin = NodeInst.newInstance(primitive, this.getNextLocation(parent), this.primitiveWidth, this.primitiveHeight, parent, Orientation.IDENT, s);
                }
                ArcProto node = pin.getProto() == Schematics.tech().busPinNode ? Schematics.tech().bus_arc : Schematics.tech().wire_arc;
                String exportName = port.port.name;
                if (port.port.isBusConnection()) {
                    exportName = exportName + "[" + count + "]";
                }
                PortInst ex = cellInst.findPortInst(exportName);
                assert (ex != null);
                ArcInst ai = ArcInst.makeInstanceBase(node, 0.0, pin.getOnlyPortInst(), ex, null, null, s);
                if (ai == null) assert (ai != null);
                ai.setFixedAngle(false);
                if (asc) {
                    ++count;
                    continue;
                }
                --count;
            }
        }
        return schematics;
    }

    private static class CellInstance {
        String name;
        List<PortInfo> list = new ArrayList<PortInfo>();

        CellInstance(String n) {
            this.name = TextUtils.correctName(n, false, true);
        }

        void addConnection(String local, boolean isBus, PortProto ex) {
            PortInfo port = new PortInfo(local, isBus, ex);
            this.list.add(port);
        }

        static class PortInfo {
            String local;
            boolean isBus;
            PortProto ex;

            PortInfo(String local, boolean isBus, PortProto ex) {
                this.local = isBus ? local : TextUtils.correctName(local, false, true);
                this.isBus = isBus;
                this.ex = ex;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VerilogPreferences
    extends Input.InputPreferences {
        public VerilogPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, Map<Library, Cell> currentCells, Job job) {
            VerilogReader in = new VerilogReader(this);
            if (in.openTextInput(fileURL)) {
                return null;
            }
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            return lib;
        }
    }
}

