/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.ui.ClickAndDragListener;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.MeasureListener;
import com.sun.electric.tool.user.ui.OutlineListener;
import com.sun.electric.tool.user.ui.ToolBarButton;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.WiringListener;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class ToolBar
extends JToolBar
implements PropertyChangeListener,
InternalFrameListener {
    public static final String selectAreaName = "Area";
    public static final String selectObjectsName = "Objects";
    public static final String moveFullName = "Full";
    public static final String moveHalfName = "Half";
    public static final String moveQuarterName = "Quarter";
    public static final String cursorClickZoomWireName = "Click/Zoom/Wire";
    public static final String cursorSelectName = "Toggle Select";
    public static final String cursorWiringName = "Toggle Wiring";
    public static final String cursorPanName = "Toggle Pan";
    public static final String cursorZoomName = "Toggle Zoom";
    public static final String cursorOutlineName = "Toggle Outline Edit";
    public static final String cursorMeasureName = "Toggle Measure Distance";
    public static final String specialSelectName = "Special Select";
    public static final String OpenLibraryName = "Open Library";
    public static final String SaveLibraryName = "Save Library";
    private JButton goBackButton;
    private JButton goForwardButton;
    private JButton undoButton;
    private JButton redoButton;
    private ToolBarButton saveLibraryButton;
    public static final boolean secondaryInputModes = false;
    private static CursorMode curMode = CursorMode.CLICKZOOMWIRE;
    private static ArrowDistance curArrowDistance = ArrowDistance.FULL;
    private static SelectMode curSelectMode = SelectMode.OBJECTS;
    public static Cursor zoomCursor = ToolBar.readCursor("CursorZoom.gif", 6, 6);
    public static Cursor zoomOutCursor = ToolBar.readCursor("CursorZoomOut.gif", 6, 6);
    public static Cursor panCursor = ToolBar.readCursor("CursorPan.gif", 8, 8);
    public static Cursor wiringCursor = ToolBar.readCursor("CursorWiring.gif", 0, 0);
    public static Cursor outlineCursor = ToolBar.readCursor("CursorOutline.gif", 0, 0);
    public static Cursor measureCursor = ToolBar.readCursor("CursorMeasure.gif", 0, 0);
    public static final ImageIcon selectSpecialIconOn = Resources.getResource(ToolBar.class, "ButtonSelectSpecialOn.gif");
    public static final ImageIcon selectSpecialIconOff = Resources.getResource(ToolBar.class, "ButtonSelectSpecialOff.gif");

    private ToolBar() {
        Undo.addPropertyChangeListener(this);
    }

    public static ToolBar createToolBar() {
        ToolBar toolbar = new ToolBar();
        toolbar.setFloatable(true);
        toolbar.setRollover(true);
        ButtonGroup modeGroup = new ButtonGroup();
        ToolBarButton open = ToolBarButton.newInstance(OpenLibraryName, Resources.getResource(toolbar.getClass(), "ButtonOpenLibrary.gif"));
        open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.openLibraryCommand();
            }
        });
        open.setToolTipText(OpenLibraryName);
        open.setModel(new DefaultButtonModel());
        toolbar.add(open);
        toolbar.saveLibraryButton = ToolBarButton.newInstance(SaveLibraryName, Resources.getResource(toolbar.getClass(), "ButtonSaveLibrary.gif"));
        toolbar.saveLibraryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.saveLibraryCommand(Library.getCurrent(), OpenFile.Type.ELIB, false);
            }
        });
        toolbar.saveLibraryButton.setToolTipText(SaveLibraryName);
        toolbar.saveLibraryButton.setModel(new DefaultButtonModel());
        toolbar.saveLibraryButton.setEnabled(Library.getCurrent() != null);
        toolbar.add(toolbar.saveLibraryButton);
        toolbar.addSeparator();
        ToolBarButton clickZoomWireButton = ToolBarButton.newInstance(cursorClickZoomWireName, Resources.getResource(toolbar.getClass(), "ButtonClickZoomWire.gif"));
        clickZoomWireButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.clickZoomWireCommand();
            }
        });
        clickZoomWireButton.setToolTipText("ClickZoomWire");
        clickZoomWireButton.setSelected(true);
        toolbar.add(clickZoomWireButton);
        modeGroup.add(clickZoomWireButton);
        ToolBarButton panButton = ToolBarButton.newInstance(cursorPanName, Resources.getResource(toolbar.getClass(), "ButtonPan.gif"));
        panButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.panCommand();
            }
        });
        panButton.setToolTipText(cursorPanName);
        toolbar.add(panButton);
        modeGroup.add(panButton);
        ToolBarButton zoomButton = ToolBarButton.newInstance(cursorZoomName, Resources.getResource(toolbar.getClass(), "ButtonZoom.gif"));
        zoomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.zoomCommand();
            }
        });
        zoomButton.setToolTipText(cursorZoomName);
        toolbar.add(zoomButton);
        modeGroup.add(zoomButton);
        ToolBarButton outlineButton = ToolBarButton.newInstance(cursorOutlineName, Resources.getResource(toolbar.getClass(), "ButtonOutline.gif"));
        outlineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.outlineEditCommand();
            }
        });
        outlineButton.setToolTipText(cursorOutlineName);
        toolbar.add(outlineButton);
        modeGroup.add(outlineButton);
        ToolBarButton measureButton = ToolBarButton.newInstance(cursorMeasureName, Resources.getResource(toolbar.getClass(), "ButtonMeasure.gif"));
        measureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.measureCommand();
            }
        });
        measureButton.setToolTipText(cursorMeasureName);
        toolbar.add(measureButton);
        modeGroup.add(measureButton);
        toolbar.addSeparator();
        ButtonGroup arrowGroup = new ButtonGroup();
        ToolBarButton fullButton = ToolBarButton.newInstance(moveFullName, Resources.getResource(toolbar.getClass(), "ButtonFull.gif"));
        fullButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.fullArrowDistanceCommand();
            }
        });
        fullButton.setToolTipText("Full motion");
        fullButton.setSelected(true);
        toolbar.add(fullButton);
        arrowGroup.add(fullButton);
        ToolBarButton halfButton = ToolBarButton.newInstance(moveHalfName, Resources.getResource(toolbar.getClass(), "ButtonHalf.gif"));
        halfButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.halfArrowDistanceCommand();
            }
        });
        halfButton.setToolTipText("Half motion");
        toolbar.add(halfButton);
        arrowGroup.add(halfButton);
        ToolBarButton quarterButton = ToolBarButton.newInstance(moveQuarterName, Resources.getResource(toolbar.getClass(), "ButtonQuarter.gif"));
        quarterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.quarterArrowDistanceCommand();
            }
        });
        quarterButton.setToolTipText("Quarter motion");
        toolbar.add(quarterButton);
        arrowGroup.add(quarterButton);
        toolbar.addSeparator();
        ButtonGroup selectGroup = new ButtonGroup();
        ToolBarButton objectsButton = ToolBarButton.newInstance(selectObjectsName, Resources.getResource(toolbar.getClass(), "ButtonObjects.gif"));
        objectsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.selectObjectsCommand();
            }
        });
        objectsButton.setToolTipText("Select Objects");
        objectsButton.setSelected(true);
        toolbar.add(objectsButton);
        selectGroup.add(objectsButton);
        ToolBarButton areaButton = ToolBarButton.newInstance(selectAreaName, Resources.getResource(toolbar.getClass(), "ButtonArea.gif"));
        areaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.selectAreaCommand();
            }
        });
        areaButton.setToolTipText("Select Area");
        toolbar.add(areaButton);
        selectGroup.add(areaButton);
        ToolBarButton selectSpecialButton = ToolBarButton.newInstance(specialSelectName, selectSpecialIconOff);
        selectSpecialButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.toggleSelectSpecialCommand(e);
            }
        });
        selectSpecialButton.setToolTipText("Toggle Special Select");
        toolbar.add(selectSpecialButton);
        toolbar.addSeparator();
        ToolBarButton preferencesButton = ToolBarButton.newInstance("Preferences", Resources.getResource(toolbar.getClass(), "ButtonPreferences.gif"));
        preferencesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesFrame.preferencesCommand();
            }
        });
        preferencesButton.setToolTipText("Preferences");
        preferencesButton.setModel(new DefaultButtonModel());
        toolbar.add(preferencesButton);
        toolbar.addSeparator();
        toolbar.undoButton = new JButton(Resources.getResource(toolbar.getClass(), "ButtonUndo.gif"));
        toolbar.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.undoCommand();
            }
        });
        toolbar.undoButton.setToolTipText("Undo");
        toolbar.undoButton.setModel(new DefaultButtonModel());
        toolbar.undoButton.setEnabled(Undo.getUndoEnabled());
        toolbar.add(toolbar.undoButton);
        toolbar.redoButton = new JButton(Resources.getResource(toolbar.getClass(), "ButtonRedo.gif"));
        toolbar.redoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.redoCommand();
            }
        });
        toolbar.redoButton.setToolTipText("Redo");
        toolbar.redoButton.setModel(new DefaultButtonModel());
        toolbar.redoButton.setEnabled(Undo.getRedoEnabled());
        toolbar.add(toolbar.redoButton);
        toolbar.addSeparator();
        toolbar.goBackButton = new JButton(Resources.getResource(toolbar.getClass(), "ButtonGoBack.gif"));
        toolbar.goBackButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.goBackButtonCommand();
            }
        });
        toolbar.goBackButton.setToolTipText("Go Back a Cell");
        toolbar.goBackButton.setEnabled(false);
        toolbar.add(toolbar.goBackButton);
        toolbar.goForwardButton = new JButton(Resources.getResource(toolbar.getClass(), "ButtonGoForward.gif"));
        toolbar.goForwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.goForwardButtonCommand();
            }
        });
        toolbar.goForwardButton.setToolTipText("Go Forward a Cell");
        toolbar.goForwardButton.setEnabled(false);
        toolbar.add(toolbar.goForwardButton);
        toolbar.addSeparator();
        ToolBarButton expandButton = ToolBarButton.newInstance("Expand Cell Instances", Resources.getResource(toolbar.getClass(), "ButtonExpand.gif"));
        expandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.expandOneLevelDownCommand();
            }
        });
        expandButton.setToolTipText("Expand Cell Instances");
        expandButton.setModel(new DefaultButtonModel());
        toolbar.add(expandButton);
        ToolBarButton unExpandButton = ToolBarButton.newInstance("Unexpand Cell Instances", Resources.getResource(toolbar.getClass(), "ButtonUnexpand.gif"));
        unExpandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.unexpandOneLevelUpCommand();
            }
        });
        unExpandButton.setToolTipText("Unexpand Cell Instances");
        unExpandButton.setModel(new DefaultButtonModel());
        toolbar.add(unExpandButton);
        return toolbar;
    }

    public static Cursor readCursor(String cursorName, int hotX, int hotY) {
        ImageIcon imageIcon = Resources.getResource(ToolBar.class, cursorName);
        Image image = imageIcon.getImage();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Dimension bestSize = Toolkit.getDefaultToolkit().getBestCursorSize(width, height);
        int bestWidth = (int)bestSize.getWidth();
        int bestHeight = (int)bestSize.getHeight();
        if (bestWidth != 0 && bestHeight != 0 && (bestWidth != width || bestHeight != height)) {
            if (bestWidth > width && bestHeight > height) {
                BufferedImage newImage = new BufferedImage(bestWidth, bestHeight, 2);
                Graphics g = ((Image)newImage).getGraphics();
                g.drawImage(image, (bestWidth - width) / 2, (bestHeight - height) / 2, null);
                image = newImage;
                hotX += (bestWidth - width) / 2;
                hotY += (bestHeight - height) / 2;
            } else {
                image = image.getScaledInstance(bestWidth, bestHeight, 0);
                hotX = hotX * bestWidth / width;
                hotY = hotY * bestHeight / height;
            }
        }
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(hotX, hotY), cursorName);
        return cursor;
    }

    public static void clickZoomWireCommand() {
        WindowFrame.setListener(ClickZoomWireListener.theOne);
        TopLevel.setCurrentCursor(Cursor.getPredefinedCursor(0));
        curMode = CursorMode.CLICKZOOMWIRE;
    }

    public static void selectCommand() {
        WindowFrame.setListener(ClickAndDragListener.theOne);
        TopLevel.setCurrentCursor(Cursor.getPredefinedCursor(0));
        curMode = CursorMode.SELECT;
    }

    public static void wiringCommand() {
        if (WindowFrame.getListener() == WiringListener.theOne) {
            ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
            return;
        }
        WindowFrame.setListener(WiringListener.theOne);
        TopLevel.setCurrentCursor(wiringCursor);
        curMode = CursorMode.WIRE;
    }

    public static void toggleSelectSpecialCommand(ActionEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        if (b.isSelected()) {
            ToolBarButton.setIconForButton(specialSelectName, selectSpecialIconOn);
        } else {
            ToolBarButton.setIconForButton(specialSelectName, selectSpecialIconOff);
        }
    }

    public static void panCommand() {
        if (WindowFrame.getListener() == ZoomAndPanListener.theOne) {
            ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
            return;
        }
        WindowFrame.setListener(ZoomAndPanListener.theOne);
        TopLevel.setCurrentCursor(panCursor);
        curMode = CursorMode.PAN;
    }

    public static void zoomCommand() {
        if (WindowFrame.getListener() == ZoomAndPanListener.theOne) {
            ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
            return;
        }
        WindowFrame.setListener(ZoomAndPanListener.theOne);
        TopLevel.setCurrentCursor(zoomCursor);
        curMode = CursorMode.ZOOM;
    }

    public static void outlineEditCommand() {
        if (WindowFrame.getListener() == OutlineListener.theOne) {
            ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
            return;
        }
        CursorMode oldMode = curMode;
        NodeInst ni = (NodeInst)Highlight.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            System.out.println("Must first select a node with outline capabilities");
            if (oldMode == CursorMode.OUTLINE) {
                ToolBar.selectCommand();
            } else {
                ToolBar.setCursorMode(oldMode);
            }
            return;
        }
        if (!ni.getProto().isHoldsOutline()) {
            System.out.println("Cannot edit outline information on " + ni.getProto().describe() + " nodes");
            if (oldMode == CursorMode.OUTLINE) {
                ToolBar.selectCommand();
            } else {
                ToolBar.setCursorMode(oldMode);
            }
            return;
        }
        if (WindowFrame.getListener() != OutlineListener.theOne) {
            OutlineListener.theOne.setNode(ni);
        }
        WindowFrame.setListener(OutlineListener.theOne);
        TopLevel.setCurrentCursor(outlineCursor);
        curMode = CursorMode.OUTLINE;
    }

    public static void measureCommand() {
        if (WindowFrame.getListener() == MeasureListener.theOne) {
            ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
            return;
        }
        MeasureListener.theOne.reset();
        WindowFrame.setListener(MeasureListener.theOne);
        TopLevel.setCurrentCursor(measureCursor);
        curMode = CursorMode.MEASURE;
    }

    public static void setCursorMode(CursorMode mode) {
        if (mode == CursorMode.CLICKZOOMWIRE) {
            ToolBarButton.doClick(cursorClickZoomWireName);
        } else if (mode == CursorMode.SELECT) {
            ToolBarButton.doClick(cursorSelectName);
        } else if (mode == CursorMode.WIRE) {
            ToolBarButton.doClick(cursorWiringName);
        } else if (mode == CursorMode.PAN) {
            ToolBarButton.doClick(cursorPanName);
        } else if (mode == CursorMode.ZOOM) {
            ToolBarButton.doClick(cursorZoomName);
        } else if (mode == CursorMode.OUTLINE) {
            ToolBarButton.doClick(cursorOutlineName);
        } else if (mode == CursorMode.MEASURE) {
            ToolBarButton.doClick(cursorMeasureName);
        }
    }

    public static CursorMode getCursorMode() {
        return curMode;
    }

    public static void fullArrowDistanceCommand() {
        curArrowDistance = ArrowDistance.FULL;
    }

    public static void halfArrowDistanceCommand() {
        curArrowDistance = ArrowDistance.HALF;
    }

    public static void quarterArrowDistanceCommand() {
        curArrowDistance = ArrowDistance.QUARTER;
    }

    public static double getArrowDistance() {
        return curArrowDistance.getDistance();
    }

    public static void selectObjectsCommand() {
        curSelectMode = SelectMode.OBJECTS;
    }

    public static void selectAreaCommand() {
        curSelectMode = SelectMode.AREA;
    }

    public static SelectMode getSelectMode() {
        return curSelectMode;
    }

    public static boolean getSelectSpecial() {
        return ToolBarButton.getButtonState(specialSelectName);
    }

    public static void goBackButtonCommand() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf != null) {
            wf.getContent().cellHistoryGoBack();
        }
    }

    public static void goForwardButtonCommand() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf != null) {
            wf.getContent().cellHistoryGoForward();
        }
    }

    public void setSaveLibraryButton(boolean value) {
        this.saveLibraryButton.setEnabled(value);
    }

    public void finished() {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (!(component instanceof ToolBarButton)) continue;
            ToolBarButton b = (ToolBarButton)component;
            b.finished();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        boolean enabled = (Boolean)evt.getNewValue();
        if (name.equals("GoBackEnabled")) {
            this.goBackButton.setEnabled(enabled);
        } else if (name.equals("GoForwardEnabled")) {
            this.goForwardButton.setEnabled(enabled);
        } else if (name.equals("UndoEnabled")) {
            this.undoButton.setEnabled(enabled);
        } else if (name.equals("RedoEnabled")) {
            this.redoButton.setEnabled(enabled);
        }
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        JInternalFrame source = e.getInternalFrame();
        if (source instanceof JInternalFrame) {
            WindowFrame useFrame = null;
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame frame = (WindowFrame)it.next();
                if (!frame.generatedEvent(e)) continue;
                useFrame = frame;
                break;
            }
            if (useFrame == null) {
                return;
            }
            WindowContent content = useFrame.getContent();
            if (content == null) {
                return;
            }
            this.goBackButton.setEnabled(content.cellHistoryCanGoBack());
            this.goForwardButton.setEnabled(content.cellHistoryCanGoForward());
        }
    }

    public void internalFrameClosed(InternalFrameEvent e) {
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void internalFrameOpened(InternalFrameEvent e) {
    }

    public void setEnabled(String name, boolean flag) {
        if (name.equals(SaveLibraryName)) {
            this.saveLibraryButton.setEnabled(flag);
        }
    }

    public static class SelectMode {
        private String name;
        public static final SelectMode OBJECTS = new SelectMode("objects");
        public static final SelectMode AREA = new SelectMode("area");

        private SelectMode(String name) {
            this.name = name;
        }

        public String toString() {
            return "SelectMode=" + this.name;
        }
    }

    public static class ArrowDistance {
        private String name;
        private double amount;
        public static final ArrowDistance FULL = new ArrowDistance("full", 1.0);
        public static final ArrowDistance HALF = new ArrowDistance("half", 0.5);
        public static final ArrowDistance QUARTER = new ArrowDistance("quarter", 0.25);

        private ArrowDistance(String name, double amount) {
            this.name = name;
            this.amount = amount;
        }

        public double getDistance() {
            return this.amount;
        }

        public String toString() {
            return "ArrowDistance=" + this.name;
        }
    }

    public static class CursorMode {
        private String name;
        public static final CursorMode CLICKZOOMWIRE = new CursorMode("clickzoomwire");
        public static final CursorMode SELECT = new CursorMode("select");
        public static final CursorMode WIRE = new CursorMode("wire");
        public static final CursorMode PAN = new CursorMode("pan");
        public static final CursorMode ZOOM = new CursorMode("zoom");
        public static final CursorMode OUTLINE = new CursorMode("outline");
        public static final CursorMode MEASURE = new CursorMode("measure");

        private CursorMode(String name) {
            this.name = name;
        }

        public String toString() {
            return "CursorMode=" + this.name;
        }
    }
}

