/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.electric.database.hierarchy

import com.sun.electric.database.EditingPreferences
import com.sun.electric.database.hierarchy.BatchChanges.NodeReplacement
import com.sun.electric.database.topology.NodeInst

import scala.collection.JavaConverters._

class BatchChangesScala extends BatchChanges {
  
  /**
   * Method to replace a batch of nodes "oldNi" with a new one of type "newNp"
   * and return the new node.  Also removes any node-specific variables.
   * @param database replace nodes in this database
   * @param replacements a batch of replacement tasks
   * @param allowMissingPorts true to allow replacement to have missing ports and, therefore, delete the arcs that used to be there.
   * @param ep EditingPreferences
   * @return a map from old NodeInst to result of its replacement
   */
  override def replaceNodeInsts(database: EDatabase, replacements: java.util.Collection[NodeReplacement],
                                allowMissingPorts: Boolean, ep: EditingPreferences) {
    if (allowMissingPorts || replacements.asScala.map(_.cellId.libId).toSet.size != 1) {
      super.replaceNodeInsts(database, replacements, allowMissingPorts, ep)
    } else {
      val cellId = replacements.iterator.next.cellId
      val cell = database.getCell(cellId)
      val rb = new ReplaceBuilder(database.backup, ep)
      val newSnapshot = rb.update(replacements.asScala)
      
      val oldNodeInsts: List[NodeInst] = replacements.asScala.map(r => cell.getNodeById(r.nodeId)).toList
      database.checkChanging()
      database.lowLevelSetCanUndoing(true)
      database.undo(newSnapshot)
      database.lowLevelSetCanUndoing(false)
      cell.getLibrary.setChanged()
      rb.logger.debug("Database changed")
    }
  }
}
