/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkCursorType GdkCursor_get_type (GdkCursor * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.Cursor
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Cursor_getType (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkCursor *obj_g = (GdkCursor *)getPointerFromHandle(env, obj);
    return (jint) (GdkCursor_get_type (obj_g));
}

/*
 * Class:     org.gnu.gdk.Cursor
 * Method:    gdk_cursor_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Cursor_gdk_1cursor_1new (JNIEnv *env, jclass cls, jint 
    cursorType) 
{
    GdkCursorType cursorType_g = (GdkCursorType) cursorType;
    return getHandleFromPointer(env, gdk_cursor_new (cursorType_g));
}

/*
 * Class:     org.gnu.gdk.Cursor
 * Method:    gdk_cursor_new_from_pixmap
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Cursor_gdk_1cursor_1new_1from_1pixmap (JNIEnv *env, 
    jclass cls, jobject source, jobject mask, jobject fg, jobject bg, jint x, jint y) 
{
    GdkPixmap *source_g = (GdkPixmap *)getPointerFromHandle(env, source);
    GdkPixmap *mask_g = (GdkPixmap *)getPointerFromHandle(env, mask);
    GdkColor *fg_g = (GdkColor *)getPointerFromHandle(env, fg);
    GdkColor *bg_g = (GdkColor *)getPointerFromHandle(env, bg);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    return getHandleFromPointer(env, gdk_cursor_new_from_pixmap (source_g, mask_g, fg_g, bg_g, x_g, y_g));
}

/*
 * Class:     org.gnu.gdk.Cursor
 * Method:    gdk_cursor_ref
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Cursor_gdk_1cursor_1ref (JNIEnv *env, jclass cls, jobject cursor) 
{
    GdkCursor *cursor_g = (GdkCursor *)getPointerFromHandle(env, cursor);
    return getHandleFromPointer(env, gdk_cursor_ref (cursor_g));
}

/*
 * Class:     org.gnu.gdk.Cursor
 * Method:    gdk_cursor_unref
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Cursor_gdk_1cursor_1unref (JNIEnv *env, jclass cls, 
    jobject cursor) 
{
    GdkCursor *cursor_g = (GdkCursor *)getPointerFromHandle(env, cursor);
    gdk_cursor_unref (cursor_g);
}


#ifdef __cplusplus
}

#endif
