/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gtk.RadioMenuItem
 * Method:    gtk_radio_menu_item_new_with_label
 * Signature: ([ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL 
Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1new_1with_1label(JNIEnv *env, 
    jclass cls, jintArray group, jstring label) 
{
	GSList* list = NULL;
	jint* array;
	jsize len;
	int index;
	jint value;
	const gchar* label_g;
	
	if (group != NULL) {
		len = (*env)->GetArrayLength(env, group);
		array = (*env)->GetIntArrayElements(env, group, NULL);
		for (index = 0; index < len; index++)
			list = g_slist_append(list, (GtkRadioMenuItem*)array[index]);
	}
    label_g = (*env)->GetStringUTFChars(env, label, NULL);
	value = (jint)gtk_radio_menu_item_new_with_label(list, label_g);
	(*env)->ReleaseStringUTFChars(env, label, label_g);
    return value;
}

/*
 * Class:     org.gnu.gtk.RadioMenuItem
 * Method:    gtk_radio_menu_item_new_with_mnemonic
 * Signature: ([ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL 
Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1new_1with_1mnemonic(JNIEnv *env, 
    jclass cls, jintArray group, jstring label) 
{
	GSList* list = NULL;
	jint* array;
	jsize len;
	int index;
	jint value;
	const gchar* label_g;
	
	if (group != NULL) {
		len = (*env)->GetArrayLength(env, group);
		array = (*env)->GetIntArrayElements(env, group, NULL);
		for (index = 0; index < len; index++)
			list = g_slist_append(list, (GtkRadioMenuItem*)array[index]);
	}
    label_g = (*env)->GetStringUTFChars(env, label, NULL);
	value = (jint)gtk_radio_menu_item_new_with_mnemonic(list, label_g);
	(*env)->ReleaseStringUTFChars(env, label, label_g);
    return value;
}

/*
 * Class:     org_gnu_gtk_RadioMenuItem
 * Method:    gtk_radio_menu_item_new_from_widget
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1new_1from_1widget
  (JNIEnv *env, jclass cls, jint group)
{
	return (jint)gtk_radio_menu_item_new_from_widget((GtkRadioMenuItem*)group);
}
                                                                                
/*
 * Class:     org_gnu_gtk_RadioMenuItem
 * Method:    gtk_radio_menu_item_new_with_mnemonic_from_widget
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1new_1with_1mnemonic_1from_1widget
  (JNIEnv *env, jclass cls, jint group, jstring label)
{
	const gchar* l = (*env)->GetStringUTFChars(env, label, NULL);
	jint hndl = (jint)gtk_radio_menu_item_new_with_mnemonic_from_widget((GtkRadioMenuItem*)group, l);
	(*env)->ReleaseStringUTFChars(env, label, l);
	return hndl;
}
                                                                                
/*
 * Class:     org_gnu_gtk_RadioMenuItem
 * Method:    gtk_radio_menu_item_new_with_label_from_widget
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1new_1with_1label_1from_1widget
  (JNIEnv *env, jclass cls, jint group, jstring label)
{
	const gchar* l = (*env)->GetStringUTFChars(env, label, NULL);
	jint hndl = (jint)gtk_radio_menu_item_new_with_label_from_widget((GtkRadioMenuItem*)group, l);
	(*env)->ReleaseStringUTFChars(env, label, l);
	return hndl;
}
                                                                                


/*
 * Class:     org.gnu.gtk.RadioMenuItem
 * Method:    gtk_radio_menu_item_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1get_1type (JNIEnv 
    *env, jclass cls) 
{
    return (jint)gtk_radio_menu_item_get_type ();
}

/*
 * Class:     org_gnu_gtk_RadioMenuItem
 * Method:    gtk_radio_menu_item_new
 * Signature: ({I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1new
  (JNIEnv *env, jclass cls, jintArray group)
{
	GSList* list = NULL;
	jint* array;
	jsize len;
	int index;
	jint value;
	
	if (group != NULL) {
		len = (*env)->GetArrayLength(env, group);
		array = (*env)->GetIntArrayElements(env, group, NULL);
		for (index = 0; index < len; index++)
			list = g_slist_append(list, (GtkRadioMenuItem*)array[index]);
	}
	value = (jint)gtk_radio_menu_item_new(list);
    return value;
}
                                                                                                           
/*
 * Class:     org_gnu_gtk_RadioMenuItem
 * Method:    gtk_radio_menu_item_get_group
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1get_1group
  (JNIEnv *env, jclass cls, jint menu)
{
	return getSList(env,gtk_radio_menu_item_get_group((GtkRadioMenuItem*)menu));
}

/*
 * Class:     org_gnu_gtk_RadioMenuItem
 * Method:    gtk_radio_menu_item_set_group
 * Signature: (I[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1set_1group
  (JNIEnv *env, jclass cls, jint menu, jintArray group)
{
	GSList* list = NULL;
	jint* array;
	jsize len;
	int index;
	
	len = (*env)->GetArrayLength(env, group);
	array = (*env)->GetIntArrayElements(env, group, NULL);
	for (index = 0; index < len; index++){
		list = g_slist_append(list, (GtkRadioMenuItem*)array[index]);
	}
	gtk_radio_menu_item_set_group((GtkRadioMenuItem*)menu, list);
}
                                                                                                           

#ifdef __cplusplus
}

#endif
