/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:36 EDT
 */

package org.gnu.gtk;

import org.gnu.gdk.Color;
import org.gnu.glib.Type;

/**
 * This widget displays color information in such a way that the user
 * can specify, with the mouse, any available color.
 * @see ColorSelectionDialog
 */
public class ColorSelection extends VBox {

	/**
	 * Creates a new gtk.ColorSelection.
	 */
	public ColorSelection() {
		noopInit();
	}
	
	protected void noopInit() {
		if (-1 == handle) {
			handle = gtk_color_selection_new ();
			initializeEventHandlers();
		}
	}
	
	/**
	 * construct a ColorSelection from a handle to a native peer.
	 */
	public ColorSelection(int handle) {
	    super(handle);
	}

	/**
	 * Sets the widget to have an opacity control
	 */
	public void setHasOpacity(boolean hasOpacity) {
		gtk_color_selection_set_has_opacity_control(handle, hasOpacity);
	}

	/**
	 * Sets the current color to be color. The first time this is called, it 
	 * will also set the original color to be color too.
	 * @param color 
	 */
	public void setCurrentColor(Color color) {
		gtk_color_selection_set_current_color(handle, color.getHandle());
	}

	/**
	 * Returns the color which is set in the widget
	 * @return the set colour
	 */
	public Color getCurrentColor() {
	    int colorHandle = gtk_color_selection_get_current_color(handle);
	    return new Color(colorHandle);
	}
	
	/**
	 * Sets the ColorSelection to use or not to use the opacity control.
	 * @param hasOpacity true if this widget can set the opacity.
	 */
	public void setHasOpacityControl(boolean hasOpacity) {
		gtk_color_selection_set_has_opacity_control(handle, hasOpacity);
	}
	
	/**
	 * Determines whether the ColorSelection has an opacity control.
	 * @return true if the widget has the opacity control.
	 */
	public boolean getHasOpacityControl() {
		return gtk_color_selection_get_has_opacity_control(handle);
	}
	
	/**
	 * Shows and hides the palette based upon the value of hasPalette.
	 * @param hasPalette true if the palette should be visible.
	 */
	public void setHasPalette(boolean hasPalette) {
		gtk_color_selection_set_has_palette(handle, hasPalette);
	}
	
	/**
	 * Determines whether the widget's palette is visible.
	 * @return true if the palette is visible.
	 */
	public boolean getHasPalette() {
		return gtk_color_selection_get_has_palette(handle);
	}
	
	/**
	 * Sets the current opacity to be <i>alpha</i>. The first time this
	 * is called it will also set the original opacity to be <i>alpha</i>
	 * too.
	 * @param alpha An integer between 0 and 65535.
	 */
	public void setCurrentAlpha(int alpha) {
		gtk_color_selection_set_current_alpha(handle, alpha);
	}
	
	/**
	 * Returns the current opacity.
	 * @return An integer between 0 and 65535.
	 */
	public int getCurrentAlpha() {
		return gtk_color_selection_get_current_alpha(handle);
	}
	
	/**
	 * Sets the previous alpha value.
	 */
	public void setPreviousAlpha(int alpha) {
		gtk_color_selection_set_previous_alpha(handle, alpha);
	}
	
	/**
	 * Returns the previous alpha value.
	 */
	public int getPreviousAlpha() {
		return gtk_color_selection_get_previous_alpha(handle);
	}
	
	/**
	 * Sets the previous color value.
	 */
	public void setPreviousColor(Color color) {
		gtk_color_selection_set_previous_color(handle, color.getHandle());
	}
	
	/**
	 * Returns the previous color.
	 */
	public Color getPreviousColor() {
		int [] color = new int[1];
		gtk_color_selection_get_previous_color(handle, color);
		return new org.gnu.gdk.Color(color[0]);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_color_selection_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_color_selection_get_type ();
    native static final protected int gtk_color_selection_new ();
    native static final protected boolean gtk_color_selection_get_has_opacity_control (int colorsel);
    native static final protected void gtk_color_selection_set_has_opacity_control (int colorsel, 
        boolean hasOpacity);
    native static final protected boolean gtk_color_selection_get_has_palette (int colorsel);
    native static final protected void gtk_color_selection_set_has_palette (int colorsel, boolean 
        hasPalette);
    native static final protected void gtk_color_selection_set_current_color (int colorsel, int 
        color);
    native static final protected void gtk_color_selection_set_current_alpha (int colorsel, int 
        alpha);
    native static final protected int gtk_color_selection_get_current_color (int colorsel);
    native static final protected int gtk_color_selection_get_current_alpha (int colorsel);
    native static final protected void gtk_color_selection_set_previous_color (int colorsel, int 
        color);
    native static final protected void gtk_color_selection_set_previous_alpha (int colorsel, int 
        alpha);
    native static final protected void gtk_color_selection_get_previous_color (int colorsel, int [] 
        color);
    native static final protected int gtk_color_selection_get_previous_alpha (int colorsel);
    native static final protected boolean gtk_color_selection_is_adjusting (int colorsel);
    native static final protected boolean gtk_color_selection_palette_from_string (String str, int []
        color, int nColors);
    native static final protected String gtk_color_selection_palette_to_string (int color, int 
        nColors);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

