/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * An event represeting action by a {@link org.gnu.gtk.TreeView} widget.
 * @see org.gnu.gtk.TreeView
 */
public class TreeViewEvent extends GtkEvent {

	// todo
	// These need splitting up into a number of different events.
	// 
	/**
	 * 
	 */
	public static final int COLUMNS_CHANGED = 1;

	/**
	 */
	public static final int CURSOR_CHANGED = 2;

	/**
	 */
	public static final int EXPAND_COLLAPSE_CURSOR_ROW = 3;

	/**
	 */
	public static final int MOVE_CURSOR = 4;
	
	/**
	 */
	public static final int ROW_ACTIVATED = 5;
	
	
	/**
	 */
	public static final int ROW_COLLAPSED = 6;
	
	/**
	 */
	public static final int ROW_EXPANDED = 7;
	
	/**
	 */
	public static final int SELECT_ALL = 8;
	
	/**
	 */
	public static final int SELECT_CURSOR_PARENT = 9;
	
	/**
	 */
	public static final int SELECT_CURSOR_ROW = 10;
	
	/**
	 */
	public static final int SET_SCROLL_ADJUSTMENTS = 11;
	
	/**
	 */
	public static final int START_INTERACTIVE_SEARCH = 12;
	
	/**
	 */
	public static final int TEST_COLLAPSE_ROW = 6;
	
	/**
	 */
	public static final int TEST_EXPAND_ROW = 6;

	/**
	 */
	public static final int TOGGLE_CURSOR_ROW = 6;
	
	/**
	 */
	public static final int UNSELECT_ALL= 6;
	
	/**
	 * Creates a new Button Event. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public TreeViewEvent(Object source, GtkEventType id) {
		super(source, id);
	}
}
