/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import java.util.ArrayList;
import java.util.List;

import org.gnu.glib.GObject;

/**
 */
public class UIManager extends GObject {
	
	public UIManager() {
		if (-1 != handle) {
			handle = gtk_ui_manager_new();
		}
	}
	
	public void setAddTearoffs(boolean addTearoffs) {
		gtk_ui_manager_set_add_tearoffs(handle, addTearoffs);
	}
	
	public boolean getAddTearoffs() {
		return gtk_ui_manager_get_add_tearoffs(handle);
	}
	
	public void insertActionGroup(ActionGroup group, int position) {
		gtk_ui_manager_insert_action_group(handle, group.getHandle(), position);
	}
	
	public void removeActionGroup(ActionGroup group) {
		gtk_ui_manager_remove_action_group(handle, group.getHandle());
	}
	
	public List getActionGroups() {
		int[] actions = gtk_ui_manager_get_action_groups(handle);
		List objs = new ArrayList();
		for (int i = 0; i < actions.length; i++) {
			objs.add(new ActionGroup(actions[i]));
		}
		return objs;
	}
	
	public AccelGroup getAccelGroup() {
		return new AccelGroup(gtk_ui_manager_get_accel_group(handle));
	}
	
	public Widget getWidget(String path) {
		return new Widget(gtk_ui_manager_get_widget(handle, path));
	}
	
	public Action getAction(String path) {
		return new Action(gtk_ui_manager_get_action(handle, path));
	}
	
	public int addUIFromString(String ui) {
		int err = -1;
		int ret = gtk_ui_manager_add_ui_from_string(handle, ui, ui.length(), new int[] {err});
		if (-1 < err)
			throw new RuntimeException("An error occurred adding UI from String");
		return ret;
	}
	
	public int addUIFromFile(String filename) {
		int err = -1;
		int ret = gtk_ui_manager_add_ui_from_file(handle, filename, new int[] {err});
		if (-1 < err)
			throw new RuntimeException("An error occurred adding UI from file");
		return ret;
	}
	
	public void addUI(int mergeId, String path, String name, String action, UIManagerItemType type, boolean top) {
		gtk_ui_manager_add_ui(handle, mergeId, path, name, action, type.getValue(), top);
	}
	
	public void removeUI(int mergeId) {
		gtk_ui_manager_remove_ui(handle, mergeId);
	}
	
	public String getUI() {
		return gtk_ui_manager_get_ui(handle);
	}
	
	public void ensureUpdate() {
		gtk_ui_manager_ensure_update(handle);
	}
	
	public int newMergeId() {
		return gtk_ui_manager_new_merge_id(handle);
	}

	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_ui_manager_get_type ();
	native static final protected int gtk_ui_manager_new();
	native static final protected void gtk_ui_manager_set_add_tearoffs(int uim, boolean value);
	native static final protected boolean gtk_ui_manager_get_add_tearoffs(int uim);
	native static final protected void gtk_ui_manager_insert_action_group(int uim, int actionGroup, int pos);
	native static final protected void gtk_ui_manager_remove_action_group(int uim, int actionGroup);
	native static final protected int[] gtk_ui_manager_get_action_groups(int uim);
	native static final protected int gtk_ui_manager_get_accel_group(int uim);
	native static final protected int gtk_ui_manager_get_widget(int uim, String path);
	native static final protected int gtk_ui_manager_get_action(int uim, String path);
	native static final protected int gtk_ui_manager_add_ui_from_string(int uim, String buffer, int length, int[] error);
	native static final protected int gtk_ui_manager_add_ui_from_file(int uim, String filename, int[] error);
	native static final protected void gtk_ui_manager_add_ui(int uim, int mergeId, String path, String name, String action, int type, boolean top);
	native static final protected void gtk_ui_manager_remove_ui(int uim, int mergeId);
	native static final protected String gtk_ui_manager_get_ui(int uim);
	native static final protected void gtk_ui_manager_ensure_update(int uim);
	native static final protected int gtk_ui_manager_new_merge_id(int uim);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
