/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:39 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Type;

/**
 * An AccelGroup represents a group of keyboard accelerators, typically attached
 * to a toplevel Window.  Usually you will not need to create an AccelGroup
 * directoy; instead, when using ItemFactory, GTK+ automatically sets up the 
 * accelerators for your menus in the item factory's AccelGroup.
 * <p>
 * Note that <i>accelerators</i> are different from <i>mnemonics</i>.  Accelerators
 * are shortcuts for activating a menu item; they appear alongside the menu
 * item they're a shortcut for.  For example, "Ctrl+Q" might appear alongside the
 * "Quit" menu item.  Mnemonics are shortcuts for GUI elements such as text entries
 * or buttons; they appear as underlined characters.
 */
public class AccelGroup extends GObject 
{
	/**
	 * Create a new AccelGroup.
	 */
	public AccelGroup() {
		noopInit();
	}
	
	/**
	 * Create a new AccelGroup from a handle to a native resource.
	 */
	public AccelGroup(int handle) {
		this.handle = handle;
	}	
	
	protected void noopInit() {
		if (-1 == handle) {
			handle = gtk_accel_group_new();
		}
	}
	
	/**
	 * Locks the accelerator group.  Locking an acclerator group prevents the
	 * accelerators contained within it to be changed during runtime.  If this
	 * method is called more than once, the AccelGroup remains locked until unlock
	 * is called the equivalent number of times.
	 */
	public void lock() {
		gtk_accel_group_lock(handle);
	}
	
	/**
	 * Undoes the last call to lock.
	 */
	public void unlock() {
		gtk_accel_group_unlock(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_accel_group_get_type());
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_accel_group_get_type ();
    native static final protected int gtk_accel_group_new ();
    native static final protected void gtk_accel_group_lock (int accelGroup);
    native static final protected void gtk_accel_group_unlock (int accelGroup);
    native static final protected boolean gtk_accel_group_disconnect_key (int accelGroup, int 
        accelKey, int accelMods);
    native static final protected boolean gtk_accel_groups_activate (int object, int accelKey, int 
        accelMods);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

