/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome.event;

import org.gnu.gtk.event.GtkEvent;
import org.gnu.gtk.event.GtkEventType;

/**
 * An event represeting action by a {@link org.gnu.gnome.AppBar} widget.
 */
public class AppBarEvent extends GtkEvent {
	/**
	 * Type of a AppBarEvent
	 */
	public static class Type extends GtkEventType {
		private Type(int id, String name) {
			super(id, name);
		}
		/**
		 * Emitted when the user hits enter after a prompt.
		 */
		public static final Type USER_RESPONSE = new Type(1, "USER_RESPONSE");

		/**
		 * Emitted when the prompt is cleared.
		 */
		public static final Type CLEAR_PROMPT = new Type(2, "CLEAR_PROMPT");

	}

	/**
	 * Creates a new AppBarEvent. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public AppBarEvent(Object source, AppBarEvent.Type type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(AppBarEvent.Type aType) {
		return (type.getID() == aType.getID());
	}

}
