/* launcher.c generated by valac 0.9.7, the Vala compiler
 * generated from launcher.vala, do not modify */

/*
 * Copyright (C) 2010 Simon Wenner <simon@wenner.ch>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <champlain/champlain.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_LAUNCHER (launcher_get_type ())
#define LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAUNCHER, Launcher))
#define LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAUNCHER, LauncherClass))
#define IS_LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAUNCHER))
#define IS_LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAUNCHER))
#define LAUNCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAUNCHER, LauncherClass))

typedef struct _Launcher Launcher;
typedef struct _LauncherClass LauncherClass;
typedef struct _LauncherPrivate LauncherPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MARKER_LAYER (marker_layer_get_type ())
#define MARKER_LAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER_LAYER, MarkerLayer))
#define MARKER_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER_LAYER, MarkerLayerClass))
#define IS_MARKER_LAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER_LAYER))
#define IS_MARKER_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER_LAYER))
#define MARKER_LAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER_LAYER, MarkerLayerClass))

typedef struct _MarkerLayer MarkerLayer;
typedef struct _MarkerLayerClass MarkerLayerClass;

struct _Launcher {
	GObject parent_instance;
	LauncherPrivate * priv;
};

struct _LauncherClass {
	GObjectClass parent_class;
};

struct _LauncherPrivate {
	ChamplainView* view;
	ClutterStage* stage;
};


static gpointer launcher_parent_class = NULL;

GType launcher_get_type (void) G_GNUC_CONST;
#define LAUNCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LAUNCHER, LauncherPrivate))
enum  {
	LAUNCHER_DUMMY_PROPERTY
};
#define LAUNCHER_PADDING 10
Launcher* launcher_new (void);
Launcher* launcher_construct (GType object_type);
ClutterActor* launcher_make_button (Launcher* self, const char* text);
static gboolean _lambda0_ (ClutterButtonEvent* event, Launcher* self);
static gboolean __lambda0__clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
static gboolean _lambda1_ (ClutterButtonEvent* event, Launcher* self);
static gboolean __lambda1__clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
MarkerLayer* marker_layer_new (void);
MarkerLayer* marker_layer_construct (GType object_type);
GType marker_layer_get_type (void) G_GNUC_CONST;
static gboolean launcher_button_release_cb (Launcher* self, ClutterButtonEvent* event);
static gboolean _launcher_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
void launcher_show (Launcher* self);
gint launcher_main (char** args, int args_length1);
static void launcher_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lambda0_ (ClutterButtonEvent* event, Launcher* self) {
	gboolean result = FALSE;
	champlain_view_zoom_in (self->priv->view);
	result = TRUE;
	return result;
}


static gboolean __lambda0__clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = _lambda0_ (event, self);
	return result;
}


static gboolean _lambda1_ (ClutterButtonEvent* event, Launcher* self) {
	gboolean result = FALSE;
	champlain_view_zoom_out (self->priv->view);
	result = TRUE;
	return result;
}


static gboolean __lambda1__clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = _lambda1_ (event, self);
	return result;
}


static gboolean _launcher_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = launcher_button_release_cb (self, event);
	return result;
}


Launcher* launcher_construct (GType object_type) {
	Launcher * self;
	float width = 0.0F;
	float total_width;
	ClutterStage* _tmp0_;
	ChamplainView* _tmp1_;
	ClutterGroup* buttons;
	ClutterActor* button;
	ClutterActor* _tmp2_;
	MarkerLayer* layer;
	self = (Launcher*) g_object_new (object_type, NULL);
	total_width = (float) 0;
	self->priv->stage = (_tmp0_ = _g_object_ref0 (clutter_stage_get_default ()), _g_object_unref0 (self->priv->stage), _tmp0_);
	clutter_stage_set_title (self->priv->stage, "Champlain Vala Example");
	clutter_actor_set_size ((ClutterActor*) self->priv->stage, (float) 800, (float) 600);
	self->priv->view = (_tmp1_ = g_object_ref_sink ((ChamplainView*) champlain_view_new ()), _g_object_unref0 (self->priv->view), _tmp1_);
	champlain_view_set_size (self->priv->view, (guint) 800, (guint) 600);
	clutter_container_add_actor ((ClutterContainer*) self->priv->stage, (ClutterActor*) self->priv->view);
	buttons = g_object_ref_sink ((ClutterGroup*) clutter_group_new ());
	clutter_actor_set_position ((ClutterActor*) buttons, (float) LAUNCHER_PADDING, (float) LAUNCHER_PADDING);
	button = launcher_make_button (self, "Zoom in");
	clutter_container_add_actor ((ClutterContainer*) buttons, button);
	clutter_actor_set_reactive (button, TRUE);
	clutter_actor_get_size (button, &width, NULL);
	total_width = total_width + (width + LAUNCHER_PADDING);
	g_signal_connect_object (button, "button-release-event", (GCallback) __lambda0__clutter_actor_button_release_event, self, 0);
	button = (_tmp2_ = launcher_make_button (self, "Zoom out"), _g_object_unref0 (button), _tmp2_);
	clutter_container_add_actor ((ClutterContainer*) buttons, button);
	clutter_actor_set_reactive (button, TRUE);
	clutter_actor_set_position (button, total_width, (float) 0);
	clutter_actor_get_size (button, &width, NULL);
	total_width = total_width + (width + LAUNCHER_PADDING);
	g_signal_connect_object (button, "button-release-event", (GCallback) __lambda1__clutter_actor_button_release_event, self, 0);
	clutter_container_add_actor ((ClutterContainer*) self->priv->stage, (ClutterActor*) buttons);
	layer = g_object_ref_sink (marker_layer_new ());
	champlain_view_add_layer (self->priv->view, (ChamplainLayer*) layer);
	clutter_actor_set_reactive ((ClutterActor*) self->priv->view, TRUE);
	g_signal_connect_object ((ClutterActor*) self->priv->view, "button-release-event", (GCallback) _launcher_button_release_cb_clutter_actor_button_release_event, self, 0);
	champlain_view_set_zoom_level (self->priv->view, 7);
	champlain_view_set_scroll_mode (self->priv->view, CHAMPLAIN_SCROLL_MODE_KINETIC);
	champlain_view_center_on (self->priv->view, 45.466, -73.75);
	_g_object_unref0 (layer);
	_g_object_unref0 (button);
	_g_object_unref0 (buttons);
	return self;
}


Launcher* launcher_new (void) {
	return launcher_construct (TYPE_LAUNCHER);
}


void launcher_show (Launcher* self) {
	g_return_if_fail (self != NULL);
	clutter_actor_show ((ClutterActor*) self->priv->stage);
}


static gboolean launcher_button_release_cb (Launcher* self, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	double lat = 0.0;
	double lon = 0.0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).button != 1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (*event).click_count > 1;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (champlain_view_get_coords_at (self->priv->view, (guint) (*event).x, (guint) (*event).y, &lat, &lon)) {
		g_print ("Map clicked at %f, %f \n", lat, lon);
	}
	result = TRUE;
	return result;
}


ClutterActor* launcher_make_button (Launcher* self, const char* text) {
	ClutterActor* result = NULL;
	ClutterColor _tmp0_ = {0};
	ClutterColor white;
	ClutterColor _tmp1_ = {0};
	ClutterColor black;
	float width = 0.0F;
	float height = 0.0F;
	ClutterGroup* button;
	ClutterRectangle* button_bg;
	ClutterText* button_text;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	white = (_tmp0_.red = (guchar) 0xff, _tmp0_.green = (guchar) 0xff, _tmp0_.blue = (guchar) 0xff, _tmp0_.alpha = (guchar) 0xff, _tmp0_);
	black = (_tmp1_.red = (guchar) 0x00, _tmp1_.green = (guchar) 0x00, _tmp1_.blue = (guchar) 0x00, _tmp1_.alpha = (guchar) 0xff, _tmp1_);
	button = g_object_ref_sink ((ClutterGroup*) clutter_group_new ());
	button_bg = g_object_ref_sink ((ClutterRectangle*) clutter_rectangle_new_with_color (&white));
	clutter_container_add_actor ((ClutterContainer*) button, (ClutterActor*) button_bg);
	clutter_actor_set_opacity ((ClutterActor*) button_bg, (guint) 0xcc);
	button_text = g_object_ref_sink ((ClutterText*) clutter_text_new_full ("Sans 10", text, &black));
	clutter_container_add_actor ((ClutterContainer*) button, (ClutterActor*) button_text);
	clutter_actor_get_size ((ClutterActor*) button_text, &width, &height);
	clutter_actor_set_size ((ClutterActor*) button_bg, width + (LAUNCHER_PADDING * 2), height + (LAUNCHER_PADDING * 2));
	clutter_actor_set_position ((ClutterActor*) button_bg, (float) 0, (float) 0);
	clutter_actor_set_position ((ClutterActor*) button_text, (float) LAUNCHER_PADDING, (float) LAUNCHER_PADDING);
	result = (ClutterActor*) button;
	_g_object_unref0 (button_text);
	_g_object_unref0 (button_bg);
	return result;
}


gint launcher_main (char** args, int args_length1) {
	gint result = 0;
	Launcher* launcher;
	clutter_init (&args_length1, &args);
	launcher = launcher_new ();
	launcher_show (launcher);
	clutter_main ();
	result = 0;
	_g_object_unref0 (launcher);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return launcher_main (argv, argc);
}


static void launcher_class_init (LauncherClass * klass) {
	launcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LauncherPrivate));
	G_OBJECT_CLASS (klass)->finalize = launcher_finalize;
}


static void launcher_instance_init (Launcher * self) {
	self->priv = LAUNCHER_GET_PRIVATE (self);
}


static void launcher_finalize (GObject* obj) {
	Launcher * self;
	self = LAUNCHER (obj);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->stage);
	G_OBJECT_CLASS (launcher_parent_class)->finalize (obj);
}


GType launcher_get_type (void) {
	static volatile gsize launcher_type_id__volatile = 0;
	if (g_once_init_enter (&launcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LauncherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) launcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Launcher), 0, (GInstanceInitFunc) launcher_instance_init, NULL };
		GType launcher_type_id;
		launcher_type_id = g_type_register_static (G_TYPE_OBJECT, "Launcher", &g_define_type_info, 0);
		g_once_init_leave (&launcher_type_id__volatile, launcher_type_id);
	}
	return launcher_type_id__volatile;
}




