import argtypes

arg = argtypes.IntArg()
argtypes.matcher.register('CORBA_long', arg)

arg = argtypes.StringArg()
argtypes.matcher.register('CORBA_char*', arg)
argtypes.matcher.register('const-CORBA_char*', arg)

arg = argtypes.DoubleArg()
argtypes.matcher.register('CORBA_float', arg)

class CorbaEnvArg(argtypes.ArgType):
    init_exception  = '    CORBA_exception_init(&%(name)s);\n'
    check_exception = '    if (%(name)s._major != CORBA_NO_EXCEPTION) {\n' \
                      '        PyErr_SetString(PyExc_RuntimeError,\n' \
                      '                        %(name)s._id != NULL ? %(name)s._id : "(null)");\n' \
                      '        CORBA_exception_free(&%(name)s);\n' \
                      '        return NULL;\n' \
                      '    }\n' \
                      '    CORBA_exception_free(&%(name)s);\n'
    def write_param(self, ptype, pname, pdflt, pnull, info):
        info.varlist.add('CORBA_Environment', pname)
        info.codebefore.append(self.init_exception % { 'name': pname })
        info.arglist.append('&' + pname)
        info.codeafter.append(self.check_exception % { 'name': pname })

argtypes.matcher.register('CORBA_Environment*', CorbaEnvArg())

class CorbaOrbArg(argtypes.ArgType):
    null = '    if (PyORBit_ORB_Check(py_%(name)s))\n' \
           '        %(name)s = PyORBit_ORB_Get(py_%(name)s);\n' \
           '    else if (py_%(name)s != Py_None) {\n' \
           '        PyErr_SetString(PyExc_TypeError, "%(name)s must be a CORBA.ORB or None");\n' \
           '        return NULL;\n' \
           '    }\n'
    def write_param(self, ptype, pname, pdflt, pnull, info):
        if pnull:
            info.varlist.add('CORBA_ORB', pname + ' = CORBA_OBJECT_NIL')
            info.varlist.add('PyObject', '*py_' + pname)
            info.codebefore.append(self.null % { 'name': pname })
            info.arglist.append(pname)
            info.add_parselist('O', ['&py_' + pname], [pname])
        else:
            info.varlist.add('PyObject', '*' + pname)
            info.arglist.append('PyORBit_ORB_Get(%s)' % pname)
            info.add_parselist('O!', ['&PyORBit_ORB_Type', '&'+pname], [pname])
    def write_return(self, ptype, info):
        info.varlist.add('CORBA_ORB', 'ret')
        info.codeafter.write('    if (ret != CORBA_OBJECT_NIL)\n'
                             '        return PyORBit_ORB_New(ret);\n'
                             '    Py_INCREF(Py_None);\n'
                             '    return NULL\n')

arg = CorbaOrbArg()
argtypes.matcher.register('CORBA_ORB', arg)
argtypes.matcher.register('const-CORBA_ORB', arg)

class CorbaAnyArg(argtypes.ArgType):
    null = '    if (PyORBit_Any_Check(py_%(name)s))\n' \
           '        %(name)s = PyORBit_Any_Get((PyORBit_Any *)py_%(name)s);\n' \
           '    else if (py_%(name)s != Py_None) {\n' \
           '        PyErr_SetString(PyExc_TypeError, "%(name)s must be a CORBA.Any or None");\n' \
           '        return NULL;\n' \
           '    }\n'
    def write_param(self, ptype, pname, pdflt, pnull, info):
        if pnull:
            info.varlist.add('CORBA_Any', '*' + pname + ' = NULL')
            info.varlist.add('PyObject', '*py_' + pname)
            info.codebefore.append(self.null % { 'name': pname })
            info.arglist.append(pname)
            info.add_parselist('O', ['&py_' + pname], [pname])
        else:
            info.varlist.add('PyObject', '*' + pname)
            info.arglist.append('PyORBit_Any_Get((PyORBit_Any *)%s)' % pname)
            info.add_parselist('O!', ['&PyORBit_Any_Type', '&'+pname], [pname])
    def write_return(self, ptype, info):
        info.varlist.add('CORBA_Any', '*ret')
        info.codeafter.write('    if (ret != NULL)\n'
                             '        return PyORBit_Any_New(ret);\n'
                             '    Py_INCREF(Py_None);\n'
                             '    return NULL\n')
arg = CorbaAnyArg()
argtypes.matcher.register('CORBA_Any*', arg)
argtypes.matcher.register('const-CORBA_Any*', arg)

class CorbaTypeCodeArg(argtypes.ArgType):
    null = '    if (PyORBit_TypeCode_Check(py_%(name)s))\n' \
           '        %(name)s = PyORBit_TypeCode_Get(py_%(name)s);\n' \
           '    else if (py_%(name)s != Py_None) {\n' \
           '        PyErr_SetString(PyExc_TypeError, "%(name)s must be a CORBA.TypeCode or None");\n' \
           '        return NULL;\n' \
           '    }\n'
    def write_param(self, ptype, pname, pdflt, pnull, info):
        if pnull:
            info.varlist.add('CORBA_TypeCode', pname + ' = CORBA_OBJECT_NIL')
            info.varlist.add('PyObject', '*py_' + pname)
            info.codebefore.append(self.null % { 'name': pname })
            info.arglist.append(pname)
            info.add_parselist('O', ['&py_' + pname], [pname])
        else:
            info.varlist.add('PyObject', '*' + pname)
            info.arglist.append('PyORBit_TypeCode_Get(%s)' % pname)
            info.add_parselist('O!', ['&PyORBit_TypeCode_Type', '&'+pname], [pname])
    def write_return(self, ptype, info):
        info.varlist.add('CORBA_TypeCode', 'ret')
        info.codeafter.write('    if (ret != CORBA_OBJECT_NIL)\n'
                             '        return PyORBit_TypeCode_New(ret);\n'
                             '    Py_INCREF(Py_None);\n'
                             '    return NULL\n')

arg = CorbaTypeCodeArg()
argtypes.matcher.register('CORBA_TypeCode', arg)
argtypes.matcher.register('const-CORBA_TypeCode', arg)

class CorbaPoaArg(argtypes.ArgType):
    null = '    if (PyORBit_POA_Check(py_%(name)s))\n' \
           '        %(name)s = PyORBit_POA_Get((PyORBit_Any *)py_%(name)s);\n' \
           '    else if (py_%(name)s != Py_None) {\n' \
           '        PyErr_SetString(PyExc_TypeError, "%(name)s must be a PortableServer.POA or None");\n' \
           '        return NULL;\n' \
           '    }\n'
    def write_param(self, ptype, pname, pdflt, pnull, info):
        if pnull:
            info.varlist.add('PortableServer_POA', pname+' = CORBA_OBJECT_NIL')
            info.varlist.add('PyObject', '*py_' + pname)
            info.codebefore.append(self.null % { 'name': pname })
            info.arglist.append(pname)
            info.add_parselist('O', ['&py_' + pname], [pname])
        else:
            info.varlist.add('PyObject', '*' + pname)
            info.arglist.append('PyORBit_POA_Get(%s)' % pname)
            info.add_parselist('O!', ['&PyORBit_POA_Type', '&'+pname], [pname])
    def write_return(self, ptype, info):
        info.varlist.add('PortableServer_POA', 'ret')
        info.codeafter.write('    if (ret != CORBA_OBJECT_NIL)\n'
                             '        return PyORBit_POA_New(ret);\n'
                             '    Py_INCREF(Py_None);\n'
                             '    return NULL\n')
arg = CorbaPoaArg()
argtypes.matcher.register('PortableServer_POA', arg)
argtypes.matcher.register('const-PortableServer_POA', arg)

class CorbaPoaManagerArg(argtypes.ArgType):
    null = '    if (PyORBit_POAManager_Check(py_%(name)s))\n' \
           '        %(name)s = PyORBit_POAManager_Get((PyORBit_Any *)py_%(name)s);\n' \
           '    else if (py_%(name)s != Py_None) {\n' \
           '        PyErr_SetString(PyExc_TypeError, "%(name)s must be a PortableServer.POAManager or None");\n' \
           '        return NULL;\n' \
           '    }\n'
    def write_param(self, ptype, pname, pdflt, pnull, info):
        if pnull:
            info.varlist.add('PortableServer_POAManager', pname+' = CORBA_OBJECT_NIL')
            info.varlist.add('PyObject', '*py_' + pname)
            info.codebefore.append(self.null % { 'name': pname })
            info.arglist.append(pname)
            info.add_parselist('O', ['&py_' + pname], [pname])
        else:
            info.varlist.add('PyObject', '*' + pname)
            info.arglist.append('PyORBit_POAManager_Get(%s)' % pname)
            info.add_parselist('O!', ['&PyORBit_POAManager_Type', '&'+pname], [pname])
    def write_return(self, ptype, info):
        info.varlist.add('PortableServer_POAManager', 'ret')
        info.codeafter.write('    if (ret != CORBA_OBJECT_NIL)\n'
                             '        return PyORBit_POAManager_New(ret);\n'
                             '    Py_INCREF(Py_None);\n'
                             '    return NULL\n')
arg = CorbaPoaArg()
argtypes.matcher.register('PortableServer_POA', arg)
argtypes.matcher.register('const-PortableServer_POA', arg)


class CorbaObjectArg(argtypes.ArgType):
    null = '    if (PyORBit_Object_Check(py_%(name)s))\n' \
           '        %(name)s = (%(type)s)PyORBit_Object_Get(py_%(name)s);\n' \
           '    else if (py_%(name)s != Py_None) {\n' \
           '        PyErr_SetString(PyExc_TypeError, "%(name)s must be a CORBA.Object or None");\n' \
           '        return NULL;\n' \
           '    }\n'
    normal = '    if (!PyORBit_Object_Check(%(name)s)) {\n' \
             '        PyErr_SetString(PyExc_TypeError, "%(name)s must be a CORBA.Object");\n' \
             '        return NULL;\n' \
             '    }\n'
    def write_param(self, ptype, pname, pdflt, pnull, info):
        if ptype[:6] == 'const-': ptype = 'const ' + ptype[6:]
        if pnull:
            info.varlist.add(ptype, pname + ' = CORBA_OBJECT_NIL')
            info.varlist.add('PyObject', '*py_' + pname)
            info.codebefore.append(self.null % { 'name': pname,
                                                 'type': ptype })
            info.arglist.append(pname)
            info.add_parselist('O', ['&py_' + pname], [pname])
        else:
            info.varlist.add('PyObject', '*' + pname)
            info.codebefore.append(self.normal % { 'name': pname })
            info.arglist.append('(CORBA_Object)PyORBit_Object_Get(%s)' % (pname))
            info.add_parselist('O', ['&'+pname], [pname])
    def write_return(self, ptype, info):
        if ptype[:6] == 'const-': ptype = 'const ' + ptype[6:]
        info.varlist.add(ptype, 'ret')
        info.codeafter.append('    if (ret != CORBA_OBJECT_NIL)\n'
                              '        return PyORBit_Object_New((CORBA_Object)ret);\n'
                              '    Py_INCREF(Py_None);\n'
                              '    return NULL;\n')

arg = CorbaObjectArg()
argtypes.matcher.register('CORBA_Object', arg)
argtypes.matcher.register('const-CORBA_Object', arg)

argtypes.matcher.register('Bonobo_ConfigDatabase', arg)
argtypes.matcher.register('Bonobo_Listener', arg)
argtypes.matcher.register('Bonobo_Moniker', arg)
argtypes.matcher.register('Bonobo_PropertyBag', arg)
argtypes.matcher.register('Bonobo_Stream', arg)
argtypes.matcher.register('const-Bonobo_Stream', arg)
argtypes.matcher.register('Bonobo_Unknown', arg)
argtypes.matcher.register('const-Bonobo_Unknown', arg)

argtypes.matcher.register('Bonobo_Canvas_ComponentProxy', arg)
argtypes.matcher.register('Bonobo_Control', arg)
argtypes.matcher.register('Bonobo_ControlFrame', arg)
argtypes.matcher.register('Bonobo_UIContainer', arg)
argtypes.matcher.register('Bonobo_Zoomable', arg)
