	/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <cairo.h>
#include <jg_jnu.h>

#ifndef _Included_org_freedesktop_cairo_Context
#define _Included_org_freedesktop_cairo_Context
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_create
 * Signature: ()Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Context_cairo_1create
  (JNIEnv *env, jclass cls, jobject sur)
{
	cairo_surface_t *surface;
	cairo_t *cairo;
	
	surface = (cairo_surface_t*)getPointerFromHandle(env, sur);
	cairo = cairo_create(surface);
	return getHandleFromPointer(env, cairo);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_destroy
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1destroy
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_destroy(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_save
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1save
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_save(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_restore
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1restore
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_restore(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_operator
 * Signature: (Lorg/gnu/glib/Handle;I)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1operator
  (JNIEnv *env, jclass cls, jobject obj, jint op)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_set_operator(cr, (cairo_operator_t)op);	
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_source
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1source
  (JNIEnv *env, jclass cls, jobject obj, jobject pat)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_pattern_t *p = (cairo_pattern_t*)getPointerFromHandle(env, pat);
	cairo_set_source(cr, p);
}


/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_source_rgb
 * Signature: (Lorg/gnu/glib/Handle;DDD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1source_1rgb
  (JNIEnv *env, jclass cls, jobject obj, jdouble red, jdouble green, jdouble blue)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_set_source_rgb(cr, red, green, blue);	
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_source_rgba
 * Signature: (Lorg/gnu/glib/Handle;DDDD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1source_1rgba
  (JNIEnv *env, jclass cls, jobject obj, jdouble red, jdouble green, 
  	jdouble blue, jdouble alpha)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_set_source_rgba(cr, red, green, blue, alpha);	
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_source_surface
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;DD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1source_1surface
  (JNIEnv *env, jclass cls, jobject obj, jobject sur, jdouble sx, jdouble sy)
{
	cairo_t *cr;
	cairo_surface_t *surface;

	cr = (cairo_t*)getPointerFromHandle(env, obj);
	surface = (cairo_surface_t*)getPointerFromHandle(env, surface);
	cairo_set_source_surface(cr, surface, sx, sy);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_tolerance
 * Signature: (Lorg/gnu/glib/Handle;D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1tolerance
  (JNIEnv *env, jclass cls, jobject obj, jdouble tol)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_set_tolerance(cr, tol);
}
  

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_fill_rule
 * Signature: (Lorg/gnu/glib/Handle;I)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1fill_1rule
  (JNIEnv *env, jclass cls, jobject obj, jint fillRule)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_set_fill_rule(cr, (cairo_fill_rule_t)fillRule);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_line_width
 * Signature: (Lorg/gnu/glib/Handle;D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1line_1width
  (JNIEnv *env, jclass cls, jobject obj, jdouble width)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_set_line_width(cr, width);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_line_cap
 * Signature: (Lorg/gnu/glib/Handle;I)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1line_1cap
  (JNIEnv *env, jclass cls, jobject obj, jint lineCap)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_set_line_cap(cr, (cairo_line_cap_t)lineCap);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_line_join
 * Signature: (Lorg/gnu/glib/Handle;I)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1line_1join
  (JNIEnv *env, jclass cls, jobject obj, jint lineJoin)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_set_line_join(cr, (cairo_line_join_t)lineJoin);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_dash
 * Signature: (Lorg/gnu/glib/Handle;[DD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1dash
  (JNIEnv *env, jclass cls, jobject obj, jdoubleArray dashes, jdouble offset)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	double* dashes_g = (double*)(*env)->GetDoubleArrayElements(env, dashes, NULL);
	int len = (*env)->GetArrayLength(env, dashes);
	cairo_set_dash(cr, dashes_g, len, offset);
	(*env)->ReleaseDoubleArrayElements(env, dashes, dashes_g, 0);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_miter_limit
 * Signature: (Lorg/gnu/glib/Handle;D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1miter_1limit
  (JNIEnv *env, jclass cls, jobject obj, jdouble limit)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_set_miter_limit(cr, limit);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_translate
 * Signature: (Lorg/gnu/glib/Handle;DD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1translate
  (JNIEnv *env, jclass cls, jobject obj, jdouble tx, jdouble ty)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_translate(cr, tx, ty);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_scale
 * Signature: (Lorg/gnu/glib/Handle;DD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1scale
  (JNIEnv *env, jclass cls, jobject obj, jdouble sx, jdouble sy)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_scale(cr, sx, sy);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_rotate
 * Signature: (Lorg/gnu/glib/Handle;D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1rotate
  (JNIEnv *env, jclass cls, jobject obj, jdouble angle)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_rotate(cr, angle);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_transform
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1transform
  (JNIEnv *env, jclass cls, jobject obj, jobject matrix)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_matrix_t *matrix_g = (cairo_matrix_t*)getPointerFromHandle(env, matrix);
	cairo_transform(cr, matrix_g);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_matrix
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1matrix
  (JNIEnv *env, jclass cls, jobject obj, jobject matrix)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_matrix_t *matrix_g = (cairo_matrix_t*)getPointerFromHandle(env, matrix);
	cairo_set_matrix(cr, matrix_g);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_identity_matrix
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1identity_1matrix
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_identity_matrix(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_user_to_device
 * Signature: (Lorg/gnu/glib/Handle;[D[D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1user_1to_1device
  (JNIEnv *env, jclass cls, jobject obj, jdoubleArray x, jdoubleArray y)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	double* x_g = (double*)(*env)->GetDoubleArrayElements(env, x, NULL);
	double* y_g = (double*)(*env)->GetDoubleArrayElements(env, y, NULL);
	cairo_user_to_device(cr, x_g, y_g);
	(*env)->ReleaseDoubleArrayElements(env, x, x_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, y, y_g, 0);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_user_to_device_distance
 * Signature: (Lorg/gnu/glib/Handle;[D[D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1user_1to_1device_1distance
  (JNIEnv *env, jclass cls, jobject obj, jdoubleArray dx, jdoubleArray dy)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	double* dx_g = (double*)(*env)->GetDoubleArrayElements(env, dx, NULL);
	double* dy_g = (double*)(*env)->GetDoubleArrayElements(env, dy, NULL);
	cairo_user_to_device_distance(cr, dx_g, dy_g);
	(*env)->ReleaseDoubleArrayElements(env, dx, dx_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, dy, dy_g, 0);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_device_to_user
 * Signature: (Lorg/gnu/glib/Handle;[D[D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1device_1to_1user
  (JNIEnv *env, jclass cls, jobject obj, jdoubleArray x, jdoubleArray y)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	double* x_g = (double*)(*env)->GetDoubleArrayElements(env, x, NULL);
	double* y_g = (double*)(*env)->GetDoubleArrayElements(env, y, NULL);
	cairo_device_to_user(cr, x_g, y_g);
	(*env)->ReleaseDoubleArrayElements(env, x, x_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, y, y_g, 0);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_device_to_user_distance
 * Signature: (Lorg/gnu/glib/Handle;[D[D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1device_1to_1user_1distance
  (JNIEnv *env, jclass cls, jobject obj, jdoubleArray dx, jdoubleArray dy)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	double* dx_g = (double*)(*env)->GetDoubleArrayElements(env, dx, NULL);
	double* dy_g = (double*)(*env)->GetDoubleArrayElements(env, dy, NULL);
	cairo_device_to_user_distance(cr, dx_g, dy_g);
	(*env)->ReleaseDoubleArrayElements(env, dx, dx_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, dy, dy_g, 0);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_new_path
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1new_1path
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_new_path(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_move_to
 * Signature: (Lorg/gnu/glib/Handle;DD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1move_1to
  (JNIEnv *env, jclass cls, jobject obj, jdouble x, jdouble y)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_move_to(cr, x, y);	
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_line_to
 * Signature: (Lorg/gnu/glib/Handle;DD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1line_1to
  (JNIEnv *env, jclass cls, jobject obj, jdouble x, jdouble y)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_line_to(cr, x, y);	
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_curve_to
 * Signature: (Lorg/gnu/glib/Handle;DDDDDD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1curve_1to
  (JNIEnv *env, jclass cls, jobject obj, jdouble x1, jdouble y1, jdouble x2, jdouble y2, jdouble x3, jdouble y3)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_curve_to(cr, x1, y1, x2, y2, x3, y3);	
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_arc
 * Signature: (Lorg/gnu/glib/Handle;DDDDD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1arc
  (JNIEnv *env, jclass cls, jobject obj, jdouble xc, jdouble yc, jdouble radius, jdouble angle1, jdouble angle2)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_arc(cr, xc, yc, radius, angle1, angle2);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_arc_negative
 * Signature: (Lorg/gnu/glib/Handle;DDDDD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1arc_1negative
  (JNIEnv *env, jclass cls, jobject obj, jdouble xc, jdouble yc, jdouble radius, jdouble angle1, jdouble angle2)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_arc_negative(cr, xc, yc, radius, angle1, angle2);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_rel_move_to
 * Signature: (Lorg/gnu/glib/Handle;DD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1rel_1move_1to
  (JNIEnv *env, jclass cls, jobject obj, jdouble dx, jdouble dy)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_rel_move_to(cr, dx, dy);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_rel_line_to
 * Signature: (Lorg/gnu/glib/Handle;DD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1rel_1line_1to
  (JNIEnv *env, jclass cls, jobject obj, jdouble dx, jdouble dy)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_rel_line_to(cr, dx, dy);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_rel_curve_to
 * Signature: (Lorg/gnu/glib/Handle;DDDDDD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1rel_1curve_1to
  (JNIEnv *env, jclass cls, jobject obj, jdouble dx1, jdouble dy1, jdouble dx2, jdouble dy2, jdouble dx3, jdouble dy3)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_rel_curve_to(cr, dx1, dy1, dx2, dy2, dx3, dy3);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_rectangle
 * Signature: (Lorg/gnu/glib/Handle;DDDD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1rectangle
  (JNIEnv *env, jclass cls, jobject obj, jdouble x, jdouble y, jdouble width, jdouble height)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_rectangle(cr, x, y, width, height);	
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_close_path
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1close_1path
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_close_path(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_paint
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1paint
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_paint(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_paint_with_alpha
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1paint_1with_1alpha
  (JNIEnv *env, jclass cls, jobject obj, jdouble alpha)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_paint_with_alpha(cr, alpha);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_mask
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1mask
   (JNIEnv *env, jclass cls, jobject obj, jobject pat)
 {
 	cairo_t *cr;
 	cairo_pattern_t *pattern;
 	
	cr = (cairo_t*)getPointerFromHandle(env, obj);
	pattern = (cairo_pattern_t*)getPointerFromHandle(env, pat);
 	cairo_mask(cr, pattern);
 }

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_mask_surface
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;DD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1mask_1surface
  (JNIEnv *env, jclass cls, jobject obj, jobject sur, jdouble sx, jdouble sy)
{
 	cairo_t *cr;
 	cairo_surface_t *surface;
 	
	cr = (cairo_t*)getPointerFromHandle(env, obj);
	surface = (cairo_surface_t*)getPointerFromHandle(env, sur);
 	cairo_mask_surface(cr, surface, sx, sy);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_stroke
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1stroke
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_stroke(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_stroke_preserve
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1stroke_1preserve
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr;
	
	cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_stroke_preserve(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_fill
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1fill
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_fill(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_fill_preserve
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1fill_1preserve
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr;
	
	cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_fill_preserve(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_copy_page
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1copy_1page
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_copy_page(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_show_page
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1show_1page
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_show_page(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_in_stroke
 * Signature: (Lorg/gnu/glib/Handle;DD)Z
 */
JNIEXPORT jboolean JNICALL Java_org_freedesktop_cairo_Context_cairo_1in_1stroke
  (JNIEnv *env, jclass cls, jobject obj, jdouble x, jdouble y)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return (jboolean)cairo_in_stroke(cr, x, y);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_in_fill
 * Signature: (Lorg/gnu/glib/Handle;DD)Z
 */
JNIEXPORT jboolean JNICALL Java_org_freedesktop_cairo_Context_cairo_1in_1fill
  (JNIEnv *env, jclass cls, jobject obj, jdouble x, jdouble y)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return (jboolean)cairo_in_fill(cr, x, y);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_stroke_extents
 * Signature: (Lorg/gnu/glib/Handle;[D[D[D[D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1stroke_1extents
  (JNIEnv *env, jclass cls, jobject obj, jdoubleArray x1, jdoubleArray y1, jdoubleArray x2, jdoubleArray y2)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	double* x1_g = (double*)(*env)->GetDoubleArrayElements(env, x1, NULL);	
	double* y1_g = (double*)(*env)->GetDoubleArrayElements(env, y1, NULL);	
	double* x2_g = (double*)(*env)->GetDoubleArrayElements(env, x2, NULL);	
	double* y2_g = (double*)(*env)->GetDoubleArrayElements(env, y2, NULL);
	cairo_stroke_extents(cr, x1_g, y1_g, x2_g, y2_g);
	(*env)->ReleaseDoubleArrayElements(env, x1, x1_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, y1, y1_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, x2, x2_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, y2, y2_g, 0);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_fill_extents
 * Signature: (Lorg/gnu/glib/Handle;[D[D[D[D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1fill_1extents
  (JNIEnv *env, jclass cls, jobject obj, jdoubleArray x1, jdoubleArray y1, jdoubleArray x2, jdoubleArray y2)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	double* x1_g = (double*)(*env)->GetDoubleArrayElements(env, x1, NULL);	
	double* y1_g = (double*)(*env)->GetDoubleArrayElements(env, y1, NULL);	
	double* x2_g = (double*)(*env)->GetDoubleArrayElements(env, x2, NULL);	
	double* y2_g = (double*)(*env)->GetDoubleArrayElements(env, y2, NULL);
	cairo_fill_extents(cr, x1_g, y1_g, x2_g, y2_g);
	(*env)->ReleaseDoubleArrayElements(env, x1, x1_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, y1, y1_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, x2, x2_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, y2, y2_g, 0);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_reset_clip
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1reset_1clip
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_reset_clip(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_clip
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1clip
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_clip(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_clip_preserve
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1clip_1preserve
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr;
	
	cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_clip_preserve(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_select_font_face
 * Signature: (Lorg/gnu/glib/Handle;Ljava/lang/String;II)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1select_1font_1face
  (JNIEnv *env, jclass cls, jobject obj, jstring fam, jint slant, jint weight)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	const char* fam_g = (const char*)(*env)->GetStringUTFChars(env, fam, NULL);
	cairo_select_font_face(cr, fam_g, (cairo_font_slant_t)slant, (cairo_font_weight_t)weight);
	(*env)->ReleaseStringUTFChars(env, fam, fam_g);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_font_size
 * Signature: (Lorg/gnu/glib/Handle;D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1font_1size
  (JNIEnv *env, jclass cls, jobject obj, jdouble scale)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_set_font_size(cr, scale);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_font_matrix
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1font_1matrix
  (JNIEnv *env, jclass cls, jobject obj, jobject matrix)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_matrix_t *matrix_g = (cairo_matrix_t*)getPointerFromHandle(env, matrix);
	cairo_set_font_matrix(cr, matrix_g);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_font_matrix
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1font_1matrix
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr;
	cairo_matrix_t matrix;

	cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_get_font_matrix(cr, &matrix);
	return getHandleFromPointer(env, &matrix);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_show_text
 * Signature: (Lorg/gnu/glib/Handle;Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1show_1text
  (JNIEnv *env, jclass cls, jobject obj, jstring text)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	const char* t = (const char*)(*env)->GetStringUTFChars(env, text, NULL);
	cairo_show_text(cr, t);
	(*env)->ReleaseStringUTFChars(env, text, (char*)t);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_show_glyphs
 * Signature: (Lorg/gnu/glib/Handle;[Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1show_1glyphs
  (JNIEnv *env, jclass cls, jobject obj, jobjectArray glyphs)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_glyph_t *glyphs_g = (cairo_glyph_t*)getPointerArrayFromHandles(env, glyphs);
	int len = (*env)->GetArrayLength(env, glyphs);
	cairo_show_glyphs(cr, glyphs_g, len);
	g_free(glyphs_g);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_font_face
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1font_1face
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return getHandleFromPointer(env, cairo_get_font_face(cr));
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_font_extents
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1font_1extents
  (JNIEnv *env, jclass cls, jobject obj, jobject extents)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_font_extents_t *extents_g = g_new(cairo_font_extents_t, 1);
	cairo_font_extents(cr, extents_g);
	updateHandle(env, extents, extents_g);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_font_face
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1font_1face
  (JNIEnv *env, jclass cls, jobject obj, jobject font)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_font_face_t *font_g = (cairo_font_face_t*)getPointerFromHandle(env, font);
	cairo_set_font_face(cr, font_g);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_text_extents
 * Signature: (Lorg/gnu/glib/Handle;Ljava/lang/String;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1text_1extents
  (JNIEnv *env, jclass cls, jobject obj, jstring text, jobject extents)
{
	cairo_t *cr;
	cairo_text_extents_t *extents_g;
	const char *text_g = 
		(const char*)(*env)->GetStringUTFChars(env, text, NULL);
	
	cr = (cairo_t*)getPointerFromHandle(env, obj);
	extents_g = g_new(cairo_text_extents_t, 1);
	cairo_text_extents(cr, text_g, extents_g);
	(*env)->ReleaseStringUTFChars(env, text, (char *)text_g);
	updateHandle(env, extents, extents_g);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_glyph_extents
 * Signature: (Lorg/gnu/glib/Handle;[Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1glyph_1extents
  (JNIEnv *env, jclass cls, jobject obj, jobjectArray glyphs, jobject extents)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_glyph_t *glyphs_g = (cairo_glyph_t*)getPointerArrayFromHandles(env, glyphs);
	cairo_text_extents_t *extents_g = g_new(cairo_text_extents_t, 1);
	int len = (*env)->GetArrayLength(env, glyphs);
	cairo_glyph_extents(cr, glyphs_g, len, extents_g);
	updateHandle(env, extents, extents_g);
	g_free(glyphs_g);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_text_path
 * Signature: (Lorg/gnu/glib/Handle;Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1text_1path
  (JNIEnv *env, jclass cls, jobject obj, jstring text)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	const char* text_g = (const char*)(*env)->GetStringUTFChars(env, text, NULL);
	cairo_text_path(cr, text_g);
	(*env)->ReleaseStringUTFChars(env, text, (char*)text_g);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_glyph_path
 * Signature: (Lorg/gnu/glib/Handle;[Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1glyph_1path
  (JNIEnv *env, jclass cls, jobject obj, jobjectArray glyphs)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_glyph_t *glyphs_g = (cairo_glyph_t*)getPointerArrayFromHandles(env, glyphs);
	int len = (*env)->GetArrayLength(env, glyphs);
	cairo_glyph_path(cr, glyphs_g, len);
	g_free(glyphs_g);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_operator
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1operator
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_get_operator(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_source
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1source
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return getHandleFromPointer(env, cairo_get_source(cr));
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_tolerance
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1tolerance
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return (jdouble)cairo_get_tolerance(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_current_point
 * Signature: (Lorg/gnu/glib/Handle;[D[D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1current_1point
  (JNIEnv *env, jclass cls, jobject obj, jdoubleArray x, jdoubleArray y)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	double *x_g = (double*)(*env)->GetDoubleArrayElements(env, x, NULL);
	double *y_g = (double*)(*env)->GetDoubleArrayElements(env, y, NULL);
	cairo_get_current_point(cr, x_g, y_g);
	(*env)->ReleaseDoubleArrayElements(env, x, x_g, 0);
	(*env)->ReleaseDoubleArrayElements(env, y, y_g, 0);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_fill_rule
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1fill_1rule
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_get_fill_rule(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_line_width
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1line_1width
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return (jdouble)cairo_get_line_width(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_line_cap
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1line_1cap
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_get_line_cap(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_line_join
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1line_1join
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_get_line_join(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_miter_limit
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1miter_1limit
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return (jdouble)cairo_get_miter_limit(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_matrix
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1matrix
  (JNIEnv *env, jclass cls, jobject obj, jobject matrix)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_matrix_t *matrix_g = (cairo_matrix_t*)getPointerFromHandle(env, matrix);
	cairo_get_matrix(cr, matrix_g);
	updateHandle(env, matrix, matrix_g);
 }

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_target
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1target
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr;
	cairo_surface_t *target;
	
	cr = (cairo_t*)getPointerFromHandle(env, obj);
	target = cairo_get_target(cr);
	return getHandleFromPointer(env, target);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_status
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Context_cairo_1status
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_status(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_antialias
 * Signature: (Lorg/gnu/glib/Handle;I)
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1antialias
  (JNIEnv *env, jclass cls, jobject obj, jint antialias)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_set_antialias(cr, antialias);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_antialias
 * Signature: (Lorg/gnu/glib/Handle;I)
 */
JNIEXPORT jint JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1antialias
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	return (jint)cairo_get_antialias(cr);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_set_font_options
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Context_cairo_1set_1font_1options
  (JNIEnv *env, jclass cls, jobject obj, jobject fo)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_font_options_t *options = (cairo_font_options_t*)getPointerFromHandle(env, fo);
	cairo_set_font_options(cr, options);
}

/*
 * Class:     org_freedesktop_cairo_Context
 * Method:    cairo_get_font_options
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Context_cairo_1get_1font_1options
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_t *cr = (cairo_t*)getPointerFromHandle(env, obj);
	cairo_font_options_t *fo;
	
	cairo_get_font_options(cr, fo);
	return getHandleFromPointer(env, fo);
}


#ifdef __cplusplus
}
#endif
#endif
