/*
 * Java-Gnome Bindings Library
*
* Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
*
* The Java-Gnome bindings library is free software distributed under
* the terms of the GNU Library General Public License version 2.
*/
package org.freedesktop.cairo;

import org.gnu.glib.Enum;

public class LineJoin extends Enum {

    static final private int _MITER = 0;
    static final public LineJoin MITER = new LineJoin (_MITER);
    static final private int _ROUND = 1;
    static final public LineJoin ROUND = new LineJoin (_ROUND);
    static final private int _BEVEL = 2;
    static final public LineJoin BEVEL = new LineJoin (_BEVEL);
    static final private LineJoin[] theInterned = new LineJoin[] {
        MITER, ROUND, BEVEL
    };
    static private java.util.Hashtable theInternedExtras;
    static final private LineJoin theSacrificialOne = new LineJoin (0);
    static public LineJoin intern (int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        LineJoin already = (LineJoin) theInternedExtras.get(theSacrificialOne);
        if (already == null) {
            already = new LineJoin(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private LineJoin(int value) {
        value_ = value;
    }

    public boolean test (LineJoin other) {
        return (value_ & other.value_) == other.value_;
    }
}
