/* wptPreferencesDlg.cpp - Dialog for the preferences
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <shlobj.h>

#include "wptNLS.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptDlgs.h"
#include "wptTypes.h"
#include "wptErrors.h"
#include "wptRegistry.h"
#include "wptHotkey.h"
#include "wptW32API.h"
#include "wptVersion.h"
#include "wptAgent.h"
#include "wptKeyserver.h"
#include "../resource.h"


static int hotkeys[] = {
    IDC_PREFS_CLIP_ENCRYPT,
    IDC_PREFS_CLIP_DECRYPT_VERIFY,
    IDC_PREFS_CLIP_SIGN,
    IDC_PREFS_CLIP_SIGNENC,
    IDC_PREFS_CWS_ENCRYPT,
    IDC_PREFS_CWS_DECRYPT_VERIFY,
    IDC_PREFS_CWS_SIGN,
    IDC_PREFS_CWS_SIGNENC,
    0
};


static int
check_hotkey( char * key )
{
    if( *key >= 'A' && *key <= 'Z' )
        return 1;
    else if( *key >= 'a' && *key <= 'z' ) {
        *key = *key - 32;
        return 1;
    }    
    return 0;
} /* check_hotkey */


static void
disable_hotkey_items( HWND dlg, int yes )
{
    int mode = yes ? FALSE : TRUE;
    int i, id;
    
    for( i=0; (id = hotkeys[i]); i++ )
	EnableWindow( GetDlgItem( dlg, id ), mode );
} /* disable_hotkey_items */


static void
enable_backup_items( HWND dlg, int yes )
{
    int mode = yes ? TRUE : FALSE;

    EnableWindow( GetDlgItem( dlg, IDC_PREFS_BAKHOME ), mode );
    EnableWindow( GetDlgItem( dlg, IDC_PREFS_BAKUSER ), mode );
    EnableWindow( GetDlgItem( dlg, IDC_PREFS_BAKSELECT ), mode );
    EnableWindow( GetDlgItem( dlg, IDC_PREFS_BAKPATH ), mode );
} /* enable_backup_items */


static void
set_keylist_mode( HWND dlg )
{
    HWND cb = GetDlgItem( dlg, IDC_PREFS_LISTMODE );
    combox_add_string( cb, (char *)"NORMAL" );
    combox_add_string( cb, (char *)"MINIMAL" );
    SendMessage( cb, CB_SETCURSEL, (WPARAM)reg_prefs.keylist_mode, 0 );
} /* set_keylist_mode */


static void
set_wipe_mode( HWND dlg )
{
    HWND cb = GetDlgItem( dlg, IDC_PREFS_WIPEMODE );
    combox_add_string( cb, (char *)"Simple" );
    combox_add_string( cb, (char *)"DoD" );
    combox_add_string( cb, (char *)"Gutmann" );
    SendMessage( cb, CB_SETCURSEL, (WPARAM)reg_prefs.wipe_mode, 0 );
} /* set_wipe_mode */


BOOL CALLBACK
prefs_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    int rc;
    int i, id;
    char t[2];
    char path[256], * p;
    HWND cb;
    
    switch ( msg ) {
    case WM_INITDIALOG:
#ifndef LANG_DE
        SetWindowText( dlg, _("WinPT Preferences") );
        SetDlgItemText( dlg, IDC_PREFS_SECMODE, _("Do not use any &temporary files") );
        SetDlgItemText( dlg, IDC_PREFS_VIEWER, _("Use clipboard &viewer to display the plaintext") );
        SetDlgItemText( dlg, IDC_PREFS_WWINFO, _("Word wrap cleartext &signatures at column") );
        SetDlgItemText( dlg, IDC_PREFS_DISABLE_HOTKEYS, _("&Disable hotkeys (Not recommended!)") );
#endif
        SetDlgItemInt( dlg, IDC_PREFS_CACHETIME, reg_prefs.cache_time, TRUE );
        SetDlgItemInt( dlg, IDC_PREFS_WORDWRAP, reg_prefs.word_wrap, TRUE );
	if (reg_prefs.backup.path)
	    SetDlgItemText (dlg, IDC_PREFS_BAKPATH, reg_prefs.backup.path);
	if (reg_prefs.kserv_conf)
	    SetDlgItemText (dlg, IDC_PREFS_KSERVER, reg_prefs.kserv_conf);

	for( i=0; (id=hotkeys[i]); i++ )
	    SetDlgItemText( dlg, id, reg_hotkeys[i].key );
        CheckDlgButton( dlg, IDC_PREFS_DISABLE_HOTKEYS, 
                        reg_prefs.no_hotkeys ? BST_CHECKED : BST_UNCHECKED );
        CheckDlgButton( dlg, IDC_PREFS_SECMODE, 
                        reg_prefs.use_tmpfiles ? BST_UNCHECKED : BST_CHECKED );
        CheckDlgButton( dlg, IDC_PREFS_VIEWER,
                        reg_prefs.use_viewer ? BST_CHECKED: BST_UNCHECKED );
	CheckDlgButton( dlg, IDC_PREFS_TRUST,
			reg_prefs.always_trust? BST_CHECKED : BST_UNCHECKED );
	CheckDlgButton( dlg, IDC_PREFS_AUTOBACKUP,
			reg_prefs.auto_backup? BST_CHECKED : BST_UNCHECKED );
	CheckDlgButton( dlg, IDC_PREFS_BAKHOME, 
			reg_prefs.backup.mode==1? BST_CHECKED : BST_UNCHECKED );
	CheckDlgButton( dlg, IDC_PREFS_BAKUSER,
			reg_prefs.backup.mode==2? BST_CHECKED : BST_UNCHECKED );
        if( reg_prefs.no_hotkeys )
            disable_hotkey_items( dlg, 1 );
	if( !reg_prefs.auto_backup )
	    enable_backup_items( dlg, 0 );
	EnableWindow( GetDlgItem( dlg, IDC_PREFS_BAKPATH ), 
		      reg_prefs.backup.mode==1?FALSE : TRUE );
	EnableWindow( GetDlgItem( dlg, IDC_PREFS_BAKSELECT ),
		      reg_prefs.backup.mode==1? FALSE : TRUE );
        set_keylist_mode( dlg );
	set_wipe_mode( dlg );
	center_window( dlg );
        SetForegroundWindow( dlg );
        return TRUE;
        
    case WM_SYSCOMMAND:
        if( LOWORD( wparam ) == SC_CLOSE )
            EndDialog( dlg, TRUE );
        return FALSE;
        
    case WM_COMMAND:
        switch( HIWORD(wparam) ) {
        case BN_CLICKED:
	    switch( (int)LOWORD( wparam ) ) {
	    case IDC_PREFS_DISABLE_HOTKEYS:            
                reg_prefs.no_hotkeys ^= 1;
                disable_hotkey_items( dlg, reg_prefs.no_hotkeys );
		break;

	    case IDC_PREFS_TRUST:	    
		reg_prefs.always_trust ^= 1;
		if( reg_prefs.always_trust ) {
		    msg_box( NULL, 
		_("In most cases it is not a good idea to enable this setting.\n"
		  "If you know what you are doing let this flag enabled, otherwise\n"
		  "it is safe to leave this flag untouched."), 
		  _("Preferences"), MB_ICONWARNING|MB_OK );
		}
		break;

	    case IDC_PREFS_AUTOBACKUP:
		reg_prefs.auto_backup ^= 1;		    
		enable_backup_items( dlg, reg_prefs.auto_backup );
		break;

	    case IDC_PREFS_BAKHOME:		
		EnableWindow( GetDlgItem( dlg, IDC_PREFS_BAKSELECT ), FALSE );
		EnableWindow( GetDlgItem( dlg, IDC_PREFS_BAKPATH ), FALSE );
		break;

	    case IDC_PREFS_BAKUSER:
		EnableWindow( GetDlgItem( dlg, IDC_PREFS_BAKSELECT ), TRUE );
		EnableWindow( GetDlgItem( dlg, IDC_PREFS_BAKPATH ), TRUE );
		break;
	    }
            break;
        }
        switch( LOWORD( wparam ) ) {
	case IDC_PREFS_BAKSELECT:
	    BROWSEINFO bi;
	    ITEMIDLIST * item;

	    memset( &bi, 0, sizeof (bi) );
	    item = SHBrowseForFolder( &bi );
	    if( item ) {
		SHGetPathFromIDList( item, path );
		SetDlgItemText( dlg, IDC_PREFS_BAKPATH, path );
	    }
	    break;

	case IDC_PREFS_KSELFILE: {
	    const char * name;
	    name = get_filename_dlg (dlg, 0, _("Please select a keyserver.conf file"),
				     NULL, NULL);
	    if (name && file_exist_check (name) == 0)
		SetDlgItemText (dlg, IDC_PREFS_KSERVER, name);
	    break; }

        case IDOK:
            rc = GetDlgItemInt( dlg, IDC_PREFS_CACHETIME, NULL, FALSE );
            if( !rc )
                reg_prefs.cache_time = 0;
            else if( rc > 3600 ) {
                msg_box( dlg, _("Please enter a value that is between 1-3600.\nIt is not "
				"a good idea to cache the passphrase more than one hour."),
				_("Preferences"), MB_ERR );
		SetDlgItemInt( dlg, IDC_PREFS_CACHETIME, 0, FALSE );
                return FALSE;
            }
	    if (reg_prefs.cache_time != rc)
		agent_flush_cache ();
            reg_prefs.cache_time = rc;
            rc = GetDlgItemInt( dlg, IDC_PREFS_WORDWRAP, NULL, FALSE );
	    if( !rc )
                reg_prefs.word_wrap = 0;
            else if( rc > 80 ) {
                msg_box( dlg, _("Please enter a value between 1-80."), _("Preferences"), MB_ERR );
                return FALSE;
            }
            reg_prefs.word_wrap = rc;
	    reg_prefs.use_tmpfiles = IsDlgButtonChecked( dlg, IDC_PREFS_SECMODE )? 0 : 1;
	    reg_prefs.use_viewer = IsDlgButtonChecked( dlg, IDC_PREFS_VIEWER )? 1 : 0;
	    reg_prefs.backup.mode = IsDlgButtonChecked( dlg, IDC_PREFS_BAKHOME ) ? 1 :
				    IsDlgButtonChecked( dlg, IDC_PREFS_BAKUSER )? 2 : 0;
	    if( reg_prefs.backup.mode == 2 ) {
		if( !GetDlgItemText( dlg, IDC_PREFS_BAKPATH, path, sizeof (path)-1 )
		    || dir_exist_check( path ) ) {
		    msg_box( dlg, _("The specified backup folder is invalid."), 
			     _("Preferences"), MB_ERR );
		    return FALSE;
		}
		free_if_alloc (reg_prefs.backup.path);
		p = reg_prefs.backup.path = m_strdup (path);
		if (!p)
		    BUG (0);
	    }
	    free_if_alloc (reg_prefs.kserv_conf);
	    if (!GetDlgItemText (dlg, IDC_PREFS_KSERVER, path, sizeof (path)-1)
		|| file_exist_check (path)) {
		rc = msg_box (dlg, _("The specified keyserver config file is invalid.\n\n"
				     "Create new default config file?"),
			 _("Preferences"), MB_ERR|MB_YESNO);
		if (rc == IDNO)
		    return FALSE;
		else
		{
		    char cwd[256], * fn;
		    FILE * fp = fopen ("keyserver.conf", "wb");
		    if (fp)
		    {
			fprintf (fp, "%s\r\n", DEF_HKP_KEYSERVER);
			fclose (fp);
		    }
		    GetCurrentDirectory (DIM (cwd)-1, cwd);
		    fn = make_filename (cwd, "keyserver", "conf");
		    memset (path, 0, sizeof( path));
		    strncpy (path, fn, DIM (path)-1);
		    free_if_alloc (fn);
		}
	    }
	    p = reg_prefs.kserv_conf = m_strdup (path);
	    if (!p)
		BUG (0);

            cb = GetDlgItem( dlg, IDC_PREFS_LISTMODE );
            reg_prefs.keylist_mode = SendMessage( cb, CB_GETCURSEL, 0, 0 );

	    cb = GetDlgItem( dlg, IDC_PREFS_WIPEMODE );
	    reg_prefs.wipe_mode = SendMessage( cb, CB_GETCURSEL, 0, 0 );
            
            if (IsDlgButtonChecked (dlg, IDC_PREFS_DISABLE_HOTKEYS)) {
                hotkeys_unregister (glob_hwnd);
                reg_prefs.no_hotkeys = 1;
            }
            else {
                reg_prefs.no_hotkeys = 0;
		for( i = 0; (id = hotkeys[i]); i++ ) {
		    rc = GetDlgItemText( dlg, id, t, 2 );
		    if( rc && check_hotkey( &t[0] ) )
			hotkey_enable( &reg_hotkeys[i], t );
		    else
			hotkey_disable( &reg_hotkeys[i] );
		}
		set_reg_entry (HKEY_CURRENT_USER, "Software\\WinPT", "DisableHotkeys", "0");
		reg_prefs.no_hotkeys = 0;
	    }

            if ((rc = set_reg_winpt_prefs (&reg_prefs)))
                msg_box (dlg, winpt_strerror (rc), _("Preferences"), MB_ERR);
            
	    if (reg_prefs.no_hotkeys == 0) {
		hotkeys_unregister (glob_hwnd);
		hotkeys_modify ();
		if ((rc = hotkeys_register (glob_hwnd)))
		    msg_box (NULL, winpt_strerror (rc), _("Hotkeys"), MB_ERR);
	    }
            EndDialog (dlg, TRUE);
            return TRUE;
            
        case IDCANCEL:
            EndDialog( dlg, FALSE );
            return FALSE;
        }
        break;
    }
    
    return FALSE;
} /* prefs_dlg_proc */
