/* wptConsole.cpp - Console interface
 *	Copyright (C) 2002 Timo Schulz <twoaday@freakmail.de>
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <stdio.h>

#include "wptTypes.h"
#include "wptErrors.h"

/* FIXME: Do we really need this? */

int
tty_alloc( void )
{	
    return AllocConsole( );
} /* tty_alloc */

void
tty_free( void )
{	
    FreeConsole( );
} /* tty_free */


int
tty_printf( const char *string )
{
    HANDLE _stdout = GetStdHandle(STD_OUTPUT_HANDLE);
    DWORD nwritten = 0;
    int rc = 0;

    rc = WriteFile(_stdout, string, strlen(string), &nwritten, NULL);
    if (rc == TRUE)
	rc = 0;	
    return rc;
} /* tty_printf */

void
tty_argparse_init(char *cmdline, char **r_arg)
{
    if (cmdline)
	*r_arg = strtok( cmdline, " " );
} /* tty_argparse_init */

char*
tty_argparse_next(char **r_arg)
{
	
    char *arg = NULL;

    if( r_arg != NULL ) {
	arg = strdup( *r_arg );
	*r_arg = strtok( NULL, " " );	
    }

    return arg;
} /* tty_argparse_next */

#if 0
void
tty_parse_args(char *cmdline)
{
    char *arg;

    arg = strtok( cmdline, " ");
    while (arg != NULL) {
	my_printf(arg);
	my_printf("\n");
	arg = strtok( NULL, " " );	
    }
}
#endif

int
tty_command_loop(char *cmdline, int cmd)
{
    char *args, *file;
    char err[512];
    int rc = 0;

    tty_alloc();
    tty_argparse_init(cmdline, &args);
    while ( (file = tty_argparse_next(&args)) ) {
	if ( !file )	
	    continue;
	if ( (strlen(file) > 2 && *file == '-')		    
	    || (strlen(file) > 2 && file[0] == '-' && file[1] == '-' ) )		    
	    continue;

	switch ( cmd ) {
	case 0: /* wipe */
	    _snprintf(err, sizeof(err)-1, "Wipe '%s' ", file);
	    tty_printf(err);
	    rc = secure_unlink(file, WIPE_MODE_DOD);
	    if (rc) {
		_snprintf(err, sizeof(err)-1, "%s", winpt_strerror(rc));
		tty_printf(err);	
	    }
	    tty_printf("\n");
	    break;
	}	
    }
	
    Sleep(1000);
    tty_free();
	
    return 0;
}