/* wptFileManager.h - File manager routines
 *	Copyright (C) 2001-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_FILE_MANAGER_H
#define WPT_FILE_MANAGER_H

enum {
    FM_NONE	    = 0,
    FM_ENCRYPT	    = 1,	
    FM_SYMENC	    = 2,	
    FM_DECRYPT	    = 3,	
    FM_SIGN	    = 4,
    FM_SIGNENCRYPT  = 5,
    FM_VERIFY	    = 6,
    FM_IMPORT	    = 7,
    FM_LIST	    = 8,
    FM_WIPE	    = 9,
    FM_ENCRYPT_DIR  = 10,
};

enum {
    FM_SORT_NONE    = 0,
    FM_SORT_STAT    = 1,
    FM_SORT_NAME    = 2,
    FM_SORT_OP	    = 3
};


struct fm_state_s {
    gpgme_ctx_t ctx;
    gpgme_recipients_t recp;
    char * output;
    char * opaque;
    int cancel;
    HWND dlg;
    passphrase_cb_s pass_cb;
    int init_cb;
    int cache_cb;
    gpgme_sigmode_t sigmode;
    unsigned int implist_revcert:1;
    unsigned int wipe:1;
    unsigned int req_signer:1;
};
typedef struct fm_state_s * fm_state_t;

char * fm_quote_file (const char * name);
int fm_parse_command_line (char * cmdl);
int fm_parse_files (listview_ctrl_t lv, HWND dlg, int cmd);
int fm_state_new (fm_state_t *ctx);
void fm_state_release (fm_state_t ctx);
int fm_build (listview_ctrl_t *lv, HWND ctrl);
void fm_delete (listview_ctrl_t lv);
int fm_add_dropped_files (listview_ctrl_t lv, HDROP dd_files);
int fm_add_opened_files (listview_ctrl_t lv, HWND dlg);
const char* fm_get_file_type (const char *fname);
void fm_remove_crit_file_attrs (const char *fname, int force);
int fm_get_current_pos (listview_ctrl_t lv);
int fm_sort (listview_ctrl_t lv, int sortby);
void fm_print_md (listview_ctrl_t lv, HWND dlg, int mdalgo);
int fm_assume_onepass_sig (const char * fname);
int fm_check_file_type (listview_ctrl_t lv, int pos, int fm_cmd);
int fm_send_file (listview_ctrl_t lv);

/*-- commands --*/
int fm_encrypt (fm_state_t c, const char * name, int sign);
int fm_sym_encrypt (fm_state_t c, const char * name);
int fm_decrypt (fm_state_t c, const char * name);
int fm_sign (fm_state_t c, const char * name);
int fm_verify (fm_state_t c, int detached, const char * name);
int fm_import(fm_state_t c, const char *name);
int fm_wipe (const char * name);
int fm_list (const char * name, HWND dlg);
int fm_encrypt_directory (fm_state_t c, const char * name);
int fm_verify_pasted_detsig (listview_ctrl_t lv, HWND dlg);
int fm_assume_onepass_sig (const char * fname);

#endif /* WPT_FILE_MANAGER_H */