/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pad;

import gnu.crypto.pad.BasePad;
import gnu.crypto.pad.WrongPaddingException;
import java.io.PrintWriter;

public final class PKCS7
extends BasePad {
    private static final String NAME = "pkcs7";
    private static final boolean DEBUG = false;
    private static final int debuglevel = 9;
    private static final PrintWriter err = new PrintWriter(System.out, true);

    private static void debug(String s) {
        err.println(">>> pkcs7: " + s);
    }

    PKCS7() {
        super(NAME);
    }

    public void setup() {
        if (this.blockSize < 2 || this.blockSize > 256) {
            throw new IllegalArgumentException();
        }
    }

    public byte[] pad(byte[] in, int offset, int length) {
        int padLength = this.blockSize;
        if (length % this.blockSize != 0) {
            padLength = this.blockSize - length % this.blockSize;
        }
        byte[] result = new byte[padLength];
        int i = 0;
        while (i < padLength) {
            result[i++] = (byte)padLength;
        }
        return result;
    }

    public int unpad(byte[] in, int offset, int length) throws WrongPaddingException {
        int limit = offset + length;
        int result = in[limit - 1] & 0xFF;
        int i = 0;
        while (i < result) {
            if (result != (in[--limit] & 0xFF)) {
                throw new WrongPaddingException();
            }
            ++i;
        }
        return result;
    }
}

