/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.JCEUtil;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;

public class Mac
implements Cloneable {
    MacSpi macSpi;
    Provider provider;
    String algorithm;
    private boolean initialised = false;

    protected Mac(MacSpi macSpi, Provider provider, String algorithm) {
        this.macSpi = macSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final Mac getInstance(String algorithm) throws NoSuchAlgorithmException {
        try {
            JCEUtil.Implementation imp = JCEUtil.getImplementation("Mac", algorithm, null);
            if (imp == null) {
                throw new NoSuchAlgorithmException(algorithm + " not found");
            }
            Mac mac = new Mac((MacSpi)imp.getEngine(), imp.getProvider(), algorithm);
            return mac;
        }
        catch (NoSuchProviderException e) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
    }

    public static final Mac getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("No provider specified to Mac.getInstance()");
        }
        JCEUtil.Implementation imp = JCEUtil.getImplementation("Mac", algorithm, provider);
        if (imp == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        Mac mac = new Mac((MacSpi)imp.getEngine(), imp.getProvider(), algorithm);
        return mac;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final int getMacLength() {
        return this.macSpi.engineGetMacLength();
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.macSpi.engineInit(key, null);
            this.initialised = true;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException("underlying mac waon't work without an AlgorithmParameterSpec");
        }
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.macSpi.engineInit(key, params);
        this.initialised = true;
    }

    public final void update(byte input) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        this.macSpi.engineUpdate(input);
    }

    public final void update(byte[] input) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        if (input == null) {
            return;
        }
        this.macSpi.engineUpdate(input, 0, input.length);
    }

    public final void update(byte[] input, int offset, int len) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        if (input == null) {
            throw new IllegalArgumentException("Null input passed");
        }
        if (len < 0 || offset < 0 || len > input.length - offset) {
            throw new IllegalArgumentException("Bad offset/len");
        }
        if (input.length == 0) {
            return;
        }
        this.macSpi.engineUpdate(input, offset, len);
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        return this.macSpi.engineDoFinal();
    }

    public final void doFinal(byte[] output, int outOffset) throws ShortBufferException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        if (output.length - outOffset < this.macSpi.engineGetMacLength()) {
            throw new ShortBufferException("buffer to short for MAC output");
        }
        byte[] mac = this.macSpi.engineDoFinal();
        System.arraycopy(mac, 0, output, outOffset, mac.length);
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("MAC not initialised");
        }
        this.macSpi.engineUpdate(input, 0, input.length);
        return this.macSpi.engineDoFinal();
    }

    public final void reset() {
        this.macSpi.engineReset();
    }

    public final Object clone() throws CloneNotSupportedException {
        Mac result = new Mac((MacSpi)this.macSpi.clone(), this.provider, this.algorithm);
        result.initialised = this.initialised;
        return result;
    }
}

