/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.jce;

import gnu.crypto.jce.GnuCrypto;
import gnu.crypto.util.Prime;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class TestOfKeyPairGenerator
implements Testlet {
    public void test(TestHarness harness) {
        this.setUp();
        this.testUnknownGenerator(harness);
        this.testDSAKeyPairGenerator(harness);
        this.testRSAKeyPairGenerator(harness);
    }

    public void testUnknownGenerator(TestHarness harness) {
        harness.checkPoint("testUnknownGenerator");
        try {
            KeyPairGenerator.getInstance("ABC", "GNU-CRYPTO");
            harness.fail("testUnknownGenerator()");
        }
        catch (Exception x) {
            harness.check(true);
        }
    }

    public void testDSAKeyPairGenerator(TestHarness harness) {
        harness.checkPoint("testDSAKeyPairGenerator");
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("DSA", "GNU-CRYPTO");
            try {
                kpg.initialize(530);
                harness.fail("L should be <= 1024 and of the form 512 + 64n");
            }
            catch (IllegalArgumentException x) {
                harness.check(true, "L should be <= 1024 and of the form 512 + 64n");
            }
            kpg.initialize(576);
            KeyPair kp = kpg.generateKeyPair();
            BigInteger p1 = ((DSAPublicKey)kp.getPublic()).getParams().getP();
            BigInteger p2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getP();
            harness.check(p1.equals(p2), "p1.equals(p2)");
            BigInteger q1 = ((DSAPublicKey)kp.getPublic()).getParams().getQ();
            BigInteger q2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getQ();
            harness.check(q1.equals(q2), "q1.equals(q2)");
            BigInteger g1 = ((DSAPublicKey)kp.getPublic()).getParams().getG();
            BigInteger g2 = ((DSAPrivateKey)kp.getPrivate()).getParams().getG();
            harness.check(g1.equals(g2), "g1.equals(g2)");
            harness.check(Prime.isProbablePrime((BigInteger)q1, (boolean)true), "q is probable prime");
            harness.check(Prime.isProbablePrime((BigInteger)p1, (boolean)true), "p is probable prime");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("testDSAKeyPairGenerator()");
        }
    }

    public void testRSAKeyPairGenerator(TestHarness harness) {
        harness.checkPoint("testRSAKeyPairGenerator");
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "GNU-CRYPTO");
            try {
                kpg.initialize(1023);
                harness.fail("L should be >= 1024");
            }
            catch (IllegalArgumentException x) {
                harness.check(true, "L should be >= 1024");
            }
            kpg.initialize(1024);
            KeyPair kp = kpg.generateKeyPair();
            BigInteger n1 = ((RSAPublicKey)kp.getPublic()).getModulus();
            BigInteger n2 = ((RSAPrivateKey)kp.getPrivate()).getModulus();
            BigInteger p = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeP();
            BigInteger q = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeQ();
            harness.check(n1.equals(p.multiply(q)), "n1 == pq");
            harness.check(n2.equals(p.multiply(q)), "n2 == pq");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("testRSAKeyPairGenerator()");
        }
    }

    private void setUp() {
        Security.addProvider((Provider)new GnuCrypto());
    }
}

